/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.BevelBorder;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.util.StringSplitter;

public class SlideDataLoader
extends JDialog {
    private static final int BUFFER_SIZE = 131072;
    private int result = 2;
    private ISlideData[] data;
    private ISlideMetaData meta;
    private File[] files;
    private boolean stop = false;
    private Exception exception;
    private LoadingPanel loadingPanel = new LoadingPanel();
    private boolean fillMissingSpots = false;

    public SlideDataLoader(JFrame frame, ISlideMetaData meta, File file, boolean fillMissingSpots) {
        this(frame, meta, new File[]{file}, fillMissingSpots);
    }

    public SlideDataLoader(JFrame frame, ISlideMetaData meta, File[] files, boolean fillMissingSpots) {
        super(frame, "Slide Data Loading", true);
        this.meta = meta;
        this.files = files;
        this.fillMissingSpots = fillMissingSpots;
        Listener listener = new Listener();
        this.loadingPanel.setFilesCount(files.length);
        JPanel btnsPanel = this.createBtnsPanel(listener);
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        content.add((Component)this.loadingPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        content.add((Component)btnsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 8, 4, 8), 0, 0));
        this.addWindowListener(listener);
        this.pack();
    }

    public int showModal() throws Exception {
        return this.showModal(false);
    }

    public int showModal(boolean stanford) throws Exception {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        Thread thread = new Thread(new Loader(stanford));
        thread.setPriority(1);
        thread.start();
        this.show();
        if (this.isException()) {
            throw this.getException();
        }
        return this.result;
    }

    public ISlideData[] getData() {
        return this.data;
    }

    public ISlideData getData(int index) {
        if (this.data == null || index >= this.data.length || index < 0) {
            return null;
        }
        return this.data[index];
    }

    private boolean isException() {
        return this.exception != null;
    }

    private Exception getException() {
        return this.exception;
    }

    private void setException(Exception e) {
        this.exception = e;
    }

    private ISlideData[] loadData() throws IOException {
        if (this.files.length < 1) {
            return null;
        }
        ISlideData[] slideData = new ISlideData[this.files.length];
        int countOfLines = 0;
        for (int i = 0; i < this.files.length; ++i) {
            if (this.stop) {
                return null;
            }
            this.loadingPanel.setFilesProgress(i);
            this.loadingPanel.setRemain(this.files.length - i);
            this.loadingPanel.setFileName(this.files[i].getPath());
            if (i == 0) {
                countOfLines = this.getCountOfLines(this.files[i]);
                this.loadingPanel.setLinesCount(countOfLines);
                if (this.meta == null) {
                    slideData[i] = this.fillMissingSpots ? this.loadSlideDataFillAllSpots(this.files[i]) : this.loadSlideData(this.files[i]);
                    this.meta = slideData[i].getSlideMetaData();
                    continue;
                }
                slideData[i] = this.loadFloatSlideData(this.files[i], countOfLines, this.meta);
                continue;
            }
            slideData[i] = this.loadFloatSlideData(this.files[i], countOfLines, this.meta);
        }
        return slideData;
    }

    private ISlideData loadFloatSlideData(File file, int countOfLines, ISlideMetaData slideMetaData) throws IOException {
        String currentLine;
        int coordinatePairCount = TMEV.getCoordinatePairCount() * 2;
        int intensityCount = TMEV.getIntensityCount();
        int preSpotRows = TMEV.getHeaderRowCount();
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(TMEV.getUniqueIDIndex() - 9);
            TMEV.setNameIndex(TMEV.getNameIndex() - 9);
            TMEV.setIndicesAdjusted(true);
        }
        FloatSlideData slideData = new FloatSlideData(slideMetaData);
        BufferedReader reader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter ss = new StringSplitter('\t');
        float[] intensities = new float[intensityCount];
        int header_row = 0;
        int index = 0;
        while ((currentLine = reader.readLine()) != null) {
            if (header_row < preSpotRows) {
                ++header_row;
                continue;
            }
            this.loadingPanel.setFileProgress(index);
            ss.init(currentLine);
            ss.passTokens(coordinatePairCount);
            for (int j = 0; j < intensityCount; ++j) {
                intensities[j] = ss.nextFloatToken(0.0f);
            }
            slideData.setIntensities(index, intensities[0], intensities[1]);
            ++index;
        }
        reader.close();
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        return slideData;
    }

    private ISlideData loadSlideDataFillAllSpots(File file) throws IOException {
        SlideDataElement slideDataElement;
        String currentLine;
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(TMEV.getUniqueIDIndex() - 9);
            TMEV.setNameIndex(TMEV.getNameIndex() - 9);
            TMEV.setIndicesAdjusted(true);
        }
        int maxRows = 0;
        int maxColumns = 0;
        int coordinatePairCount = TMEV.getCoordinatePairCount();
        int intensityCount = TMEV.getIntensityCount();
        int preSpotRows = TMEV.getHeaderRowCount();
        int[] rows = new int[coordinatePairCount];
        int[] columns = new int[coordinatePairCount];
        float[] intensities = new float[intensityCount];
        Vector<String> moreFields = new Vector<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter ss = new StringSplitter('\t');
        int header_row = 0;
        while ((currentLine = reader.readLine()) != null) {
            if (header_row < preSpotRows) {
                ++header_row;
                continue;
            }
            ss.init(currentLine);
            int currentRow = ss.nextIntToken();
            int currentColumn = ss.nextIntToken();
            if (currentRow > maxRows) {
                maxRows = currentRow;
            }
            if (currentColumn <= maxColumns) continue;
            maxColumns = currentColumn;
        }
        SlideData slideData = new SlideData(maxRows, maxColumns);
        reader.close();
        reader = new BufferedReader(new FileReader(file));
        header_row = 0;
        int curpos = 0;
        boolean[][] realData = new boolean[maxRows][maxColumns];
        while ((currentLine = reader.readLine()) != null) {
            int j;
            if (header_row < preSpotRows) {
                ++header_row;
                continue;
            }
            this.loadingPanel.setFileProgress(curpos++);
            ss.init(currentLine);
            for (j = 0; j < coordinatePairCount; ++j) {
                rows[j] = ss.nextIntToken();
                columns[j] = ss.nextIntToken();
            }
            for (j = 0; j < intensityCount; ++j) {
                intensities[j] = ss.nextFloatToken(0.0f);
            }
            while (ss.hasMoreTokens()) {
                String avoidNullString = ss.nextToken();
                if (avoidNullString.equals("null")) {
                    moreFields.add("");
                    continue;
                }
                moreFields.add(avoidNullString);
            }
            String[] allFields = new String[moreFields.size()];
            for (int i = 0; i < allFields.length; ++i) {
                allFields[i] = (String)moreFields.get(i);
            }
            realData[rows[0] - 1][columns[0] - 1] = true;
            slideDataElement = new SlideDataElement(rows, columns, intensities, allFields);
            slideData.addSlideDataElement(slideDataElement);
        }
        reader.close();
        intensities[0] = 0.0f;
        intensities[1] = 0.0f;
        for (int i = 0; i < maxRows; ++i) {
            for (int j = 0; j < maxColumns; ++j) {
                if (realData[i][j]) continue;
                slideDataElement = new SlideDataElement(new int[]{i + 1, 1, 1}, new int[]{j + 1, 1, 1}, intensities, new String[0]);
                slideData.insertElementAt(slideDataElement, i * maxColumns + j);
            }
        }
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        return slideData;
    }

    public static ISlideData fillBlankSpots(ISlideData slideData) {
        int maxRow = 0;
        int maxCol = 0;
        for (int i = 0; i < slideData.getSize(); ++i) {
            ISlideDataElement element = slideData.getSlideDataElement(i);
            int rowVal = element.getRow(0);
            int colVal = element.getColumn(0);
            maxRow = Math.max(maxRow, rowVal);
            maxCol = Math.max(maxCol, colVal);
        }
        return SlideDataLoader.fillBlankSpots(slideData, maxRow, maxCol);
    }

    public static ISlideData fillBlankSpots(ISlideData slideData, int maxRows, int maxColumns) {
        ISlideDataElement element;
        int i;
        String[] dummyString = new String[slideData.getSlideMetaData().getFieldNames().length];
        float[] intensities = new float[TMEV.getIntensityCount()];
        boolean[][] realData = new boolean[maxRows][maxColumns];
        if (slideData.getSize() == maxRows * maxColumns) {
            return slideData;
        }
        for (i = 0; i < slideData.getSize(); ++i) {
            element = slideData.getSlideDataElement(i);
            realData[element.getRow((int)0) - 1][element.getColumn((int)0) - 1] = true;
        }
        for (i = 0; i < TMEV.getIntensityCount(); ++i) {
            intensities[i] = 0.0f;
        }
        for (i = 0; i < dummyString.length; ++i) {
            dummyString[i] = "";
        }
        if (slideData instanceof SlideData) {
            for (i = 0; i < maxRows; ++i) {
                for (int j = 0; j < maxColumns; ++j) {
                    if (realData[i][j]) continue;
                    element = new SlideDataElement(new int[]{i + 1, 1, 1}, new int[]{j + 1, 1, 1}, intensities, dummyString);
                    ((SlideData)slideData).insertElementAt(element, i * maxColumns + j);
                }
            }
        }
        return slideData;
    }

    private ISlideData loadSlideData(File file) throws IOException {
        String currentLine;
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(TMEV.getUniqueIDIndex() - 9);
            TMEV.setNameIndex(TMEV.getNameIndex() - 9);
            TMEV.setIndicesAdjusted(true);
        }
        int maxRows = 0;
        int maxColumns = 0;
        int coordinatePairCount = TMEV.getCoordinatePairCount();
        int intensityCount = TMEV.getIntensityCount();
        int preSpotRows = TMEV.getHeaderRowCount();
        int[] rows = new int[coordinatePairCount];
        int[] columns = new int[coordinatePairCount];
        float[] intensities = new float[intensityCount];
        BufferedReader reader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter ss = new StringSplitter('\t');
        int header_row = 0;
        while ((currentLine = reader.readLine()) != null) {
            if (header_row < preSpotRows) {
                ++header_row;
                continue;
            }
            ss.init(currentLine);
            int currentRow = ss.nextIntToken();
            int currentColumn = ss.nextIntToken();
            if (currentRow > maxRows) {
                maxRows = currentRow;
            }
            if (currentColumn <= maxColumns) continue;
            maxColumns = currentColumn;
        }
        SlideData slideData = new SlideData(maxRows, maxColumns);
        reader.close();
        reader = new BufferedReader(new FileReader(file));
        header_row = 0;
        int curpos = 0;
        while ((currentLine = reader.readLine()) != null) {
            int j;
            if (header_row < preSpotRows) {
                ++header_row;
                continue;
            }
            this.loadingPanel.setFileProgress(curpos++);
            ss.init(currentLine);
            for (j = 0; j < coordinatePairCount; ++j) {
                rows[j] = ss.nextIntToken();
                columns[j] = ss.nextIntToken();
            }
            for (j = 0; j < intensityCount; ++j) {
                intensities[j] = ss.nextFloatToken(0.0f);
            }
            Vector<String> moreFields = new Vector<String>();
            while (ss.hasMoreTokens()) {
                String avoidNullString = ss.nextToken();
                if (avoidNullString.equals("null")) {
                    moreFields.add("");
                    continue;
                }
                moreFields.add(avoidNullString);
            }
            String[] allFields = new String[moreFields.size()];
            for (int i = 0; i < moreFields.size(); ++i) {
                allFields[i] = (String)moreFields.get(i);
            }
            SlideDataElement slideDataElement = new SlideDataElement(rows, columns, intensities, allFields);
            slideData.addSlideDataElement(slideDataElement);
        }
        reader.close();
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        return slideData;
    }

    public ISlideData[] loadStanford() throws Exception {
        String currentLine;
        if (this.files.length < 1) {
            return null;
        }
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(TMEV.getUniqueIDIndex() - 1);
            TMEV.setNameIndex(TMEV.getNameIndex() - 1);
            TMEV.setIndicesAdjusted(true);
        }
        int preSpotRows = TMEV.getHeaderRowCount();
        int preExperimentColumns = TMEV.getHeaderColumnCount();
        int spotCount = this.getCountOfLines(this.files[0]);
        if (spotCount <= 0) {
            throw new Exception("There are no spot data.");
        }
        this.loadingPanel.setFilesProgress(0);
        this.loadingPanel.setRemain(1);
        this.loadingPanel.setFileName(this.files[0].getPath());
        this.loadingPanel.setLinesCount(spotCount);
        int[] rows = new int[]{0, 1, 0};
        int[] columns = new int[]{0, 1, 0};
        String[] moreFields = new String[preExperimentColumns];
        boolean rColumns = true;
        int rRows = spotCount;
        ISlideData[] slideDataArray = null;
        BufferedReader reader = new BufferedReader(new FileReader(this.files[0]));
        StringSplitter ss = new StringSplitter('\t');
        int counter = 0;
        int column = 1;
        int row = 1;
        while ((currentLine = reader.readLine()) != null) {
            if (this.stop) {
                return null;
            }
            ss.init(currentLine);
            if (counter == 0) {
                int i;
                int experimentCount = ss.countTokens() + 1 - preExperimentColumns;
                slideDataArray = new ISlideData[experimentCount];
                slideDataArray[0] = new SlideData(rRows, 1);
                for (i = 1; i < slideDataArray.length; ++i) {
                    slideDataArray[i] = new FloatSlideData(slideDataArray[0].getSlideMetaData(), spotCount);
                }
                ss.passTokens(preExperimentColumns);
                for (i = 0; i < experimentCount; ++i) {
                    slideDataArray[i].setSlideDataName(ss.nextToken());
                }
            } else if (counter >= preSpotRows) {
                int i;
                rows[0] = rows[2] = row++;
                columns[0] = columns[2] = column;
                column = column == 1 ? 1 : ++column;
                for (i = 0; i < preExperimentColumns; ++i) {
                    moreFields[i] = ss.nextToken();
                }
                SlideDataElement sde = new SlideDataElement(rows, columns, new float[2], moreFields);
                slideDataArray[0].addSlideDataElement(sde);
                for (i = 0; i < slideDataArray.length; ++i) {
                    float cy5;
                    float cy3 = 100000.0f;
                    try {
                        cy5 = (float)(100000.0 * Math.pow(2.0, Float.parseFloat(ss.nextToken())));
                    }
                    catch (Exception e) {
                        cy5 = 0.0f;
                        cy3 = 0.0f;
                    }
                    slideDataArray[i].setIntensities(counter - preSpotRows, cy3, cy5);
                }
            }
            this.loadingPanel.setFileProgress(++counter);
        }
        reader.close();
        return slideDataArray;
    }

    private int getCountOfLines(File file) throws IOException {
        String currentLine;
        int count = 0;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((currentLine = reader.readLine()) != null) {
            ++count;
        }
        reader.close();
        return count - TMEV.getHeaderRowCount();
    }

    private void abort() {
        this.stop = true;
    }

    private void setResult(int option) {
        this.result = option;
    }

    private JPanel createBtnsPanel(ActionListener listener) {
        JPanel panel = new JPanel(new BorderLayout());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("cancel-command");
        cancelButton.addActionListener(listener);
        panel.add((Component)cancelButton, "East");
        this.getRootPane().setDefaultButton(cancelButton);
        return panel;
    }

    static /* synthetic */ ISlideData[] access$302(SlideDataLoader x0, ISlideData[] x1) {
        x0.data = x1;
        return x1;
    }

    private class Loader
    implements Runnable {
        private boolean stanford;

        public Loader(boolean stanford) {
            this.stanford = stanford;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SlideDataLoader.access$302(SlideDataLoader.this, this.stanford ? SlideDataLoader.this.loadStanford() : SlideDataLoader.this.loadData());
                if (SlideDataLoader.this.data == null) {
                    SlideDataLoader.this.setResult(2);
                } else {
                    SlideDataLoader.this.setResult(0);
                }
            }
            catch (Exception e) {
                SlideDataLoader.this.setException(e);
            }
            finally {
                SlideDataLoader.this.dispose();
            }
        }
    }

    private class LoadingPanel
    extends JPanel {
        private JProgressBar filesProgress = new JProgressBar();
        private JProgressBar fileProgress = new JProgressBar();
        private JLabel filesLabel = new JLabel("Remain: ");
        private JLabel fileLabel = new JLabel("File: ");

        public LoadingPanel() {
            this.setPreferredSize(new Dimension(350, 120));
            this.setBorder(new BevelBorder(0));
            this.setLayout(new GridBagLayout());
            this.filesProgress.setStringPainted(true);
            this.fileProgress.setStringPainted(true);
            this.add((Component)this.filesLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.filesProgress, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.fileLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.fileProgress, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }

        public void setFilesCount(int count) {
            this.filesProgress.setMaximum(count);
        }

        public void setLinesCount(int count) {
            this.fileProgress.setMaximum(count);
        }

        public void setFilesProgress(int value) {
            this.filesProgress.setValue(value);
        }

        public void setFileProgress(int value) {
            this.fileProgress.setValue(value);
        }

        public void setFileName(String filename) {
            this.fileLabel.setText("File: " + filename);
        }

        public void setRemain(int count) {
            this.filesLabel.setText("Remains: " + String.valueOf(count) + " file(s)");
        }
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SlideDataLoader.this.abort();
            SlideDataLoader.this.setResult(2);
            SlideDataLoader.this.dispose();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SlideDataLoader.this.abort();
            SlideDataLoader.this.setResult(-1);
            SlideDataLoader.this.dispose();
        }
    }
}

