/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ModalDialog
extends JDialog {
    private int result;

    public ModalDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        Listener listener = new Listener();
        JPanel btnsPanel = this.createBtnsPanel(listener);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)btnsPanel, "South");
        this.addWindowListener(listener);
        this.pack();
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ModalDialog.this.closeDialog(evt);
            }
        });
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private JPanel createBtnsPanel(ActionListener listener) {
        GridLayout gridLayout = new GridLayout();
        JPanel panel = new JPanel(gridLayout);
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("ok-command");
        okButton.addActionListener(listener);
        panel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("cancel-command");
        cancelButton.addActionListener(listener);
        gridLayout.setHgap(4);
        panel.add(cancelButton);
        this.getRootPane().setDefaultButton(okButton);
        return panel;
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                ModalDialog.this.result = 0;
                ModalDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                ModalDialog.this.result = 2;
                ModalDialog.this.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ModalDialog.this.result = -1;
            ModalDialog.this.dispose();
        }
    }
}

