/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.tigr.util.awt.GBA;

public class SetSlideFilenameDialog
extends JDialog {
    private int result;
    private JTextField filenameTextField;

    public SetSlideFilenameDialog(Frame parent, String[] filenames) {
        super(parent, "Select Experiment", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JLabel filenameLabel = new JLabel("Filename: ");
        this.filenameTextField = new JTextField(15);
        this.filenameTextField.addKeyListener(listener);
        JComboBox<String> filenameChoice = new JComboBox<String>(filenames);
        filenameChoice.addItemListener(listener);
        filenameChoice.addKeyListener(listener);
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("ok-command");
        okButton.addActionListener(listener);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("cancel-command");
        cancelButton.addActionListener(listener);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GBA gba = new GBA();
        gba.add(contentPane, (Component)filenameLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(contentPane, (Component)this.filenameTextField, 1, 0, 1, 1, 1, 1, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(contentPane, (Component)okButton, 2, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(contentPane, filenameChoice, 1, 1, 1, 1, 1, 1, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(contentPane, (Component)cancelButton, 2, 1, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.pack();
        this.setResizable(false);
        this.filenameTextField.grabFocus();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public String getFileName() {
        return this.filenameTextField.getText();
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    ItemListener,
    KeyListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                this.onOk();
            } else if (command.equals("cancel-command")) {
                SetSlideFilenameDialog.this.result = 2;
                SetSlideFilenameDialog.this.dispose();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            SetSlideFilenameDialog.this.filenameTextField.setText((String)event.getItem());
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                this.onOk();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SetSlideFilenameDialog.this.result = -1;
            SetSlideFilenameDialog.this.dispose();
        }

        private void onOk() {
            SetSlideFilenameDialog.this.result = 0;
            SetSlideFilenameDialog.this.dispose();
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }
}

