/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.tigr.util.awt.GBA;

public class SetElementSizeDialog
extends JDialog {
    private int result;
    private Dimension size;
    private JLabel widthLabel;
    private JLabel heightLabel;
    private JTextField widthTextField;
    private JTextField heightTextField;
    private GBA gba;

    public SetElementSizeDialog(JFrame parent, Dimension elementSize) {
        super((Frame)parent, true);
        this.setTitle("Set Element Size");
        this.gba = new GBA();
        this.widthLabel = new JLabel("Element Width (" + elementSize.width + "): ");
        this.widthTextField = new JTextField(10);
        this.widthTextField.setText("" + elementSize.width);
        this.heightLabel = new JLabel("Element Height (" + elementSize.height + "): ");
        this.heightTextField = new JTextField(10);
        this.heightTextField.setText("" + elementSize.height);
        JButton okButton = new JButton("Okay");
        okButton.setActionCommand("ok-command");
        okButton.addActionListener(new Listener());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("cancel-command");
        cancelButton.addActionListener(new Listener());
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        this.gba.add(content, (Component)this.widthLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(content, (Component)this.widthTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(content, (Component)this.heightLabel, 0, 1, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(content, (Component)this.heightTextField, 1, 1, 2, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(content, (Component)cancelButton, 0, 2, 1, 1, 0, 0, 0, 17, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(content, (Component)okButton, 1, 2, 1, 1, 0, 0, 0, 13, new Insets(5, 5, 5, 5), 0, 0);
        this.setResizable(false);
        this.widthTextField.grabFocus();
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public Dimension getElementSize() {
        return this.size;
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                String width = SetElementSizeDialog.this.widthTextField.getText();
                String height = SetElementSizeDialog.this.heightTextField.getText();
                try {
                    SetElementSizeDialog.this.size = new Dimension(Integer.parseInt(width), Integer.parseInt(height));
                    SetElementSizeDialog.this.result = 0;
                }
                catch (Exception e) {
                    SetElementSizeDialog.this.result = 2;
                }
                SetElementSizeDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                SetElementSizeDialog.this.result = 2;
                SetElementSizeDialog.this.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SetElementSizeDialog.this.result = -1;
            SetElementSizeDialog.this.dispose();
        }
    }
}

