/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util.awt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorSchemeSelectionDialog
extends JDialog {
    private ButtonGroup chanelSelectionGroup;
    private JPanel channelSelectionPanel;
    private JRadioButton negativeColorButton;
    private JRadioButton positiveColorButton;
    private JPanel actionButtonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JColorChooser colorChooser;
    private JPanel gradientPreviewPanel;
    private Color posColor = Color.red;
    private Color negColor = Color.green;
    private Color neutralColor = Color.black;
    private PreviewPanel previewer;
    private JCheckBox neutralColorCheckBox;
    private JRadioButton doubleGradientButton;
    private JRadioButton singleGradientButton;
    private boolean useDoubleGradient;
    private int result = 0;

    public ColorSchemeSelectionDialog(Frame parent, boolean modal, BufferedImage negImage, BufferedImage posImage, boolean useDouble) {
        super(parent, modal);
        this.useDoubleGradient = useDouble;
        this.setTitle("Color Scheme Selection");
        this.previewer = new PreviewPanel(negImage, posImage);
        this.initComponents();
        this.negativeColorButton.setFocusPainted(false);
        this.positiveColorButton.setFocusPainted(false);
        this.neutralColorCheckBox = new JCheckBox("Use Black as Neutral Color", true);
        this.neutralColorCheckBox.setFocusPainted(false);
        this.neutralColorCheckBox.setOpaque(false);
        this.neutralColorCheckBox.setEnabled(useDouble);
        if (posImage.getRGB(0, 0) == Color.white.getRGB()) {
            this.neutralColorCheckBox.setSelected(false);
            this.neutralColor = Color.white;
        } else {
            this.neutralColor = Color.black;
        }
        this.neutralColorCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ColorSchemeSelectionDialog.this.neutralColorCheckBox.isSelected()) {
                    ColorSchemeSelectionDialog.this.neutralColor = Color.black;
                } else {
                    ColorSchemeSelectionDialog.this.neutralColor = Color.white;
                }
                ColorSchemeSelectionDialog.this.previewer.alterNeutralColor();
            }
        });
        this.channelSelectionPanel.add((Component)this.neutralColorCheckBox, new GridBagConstraints(0, 1, 2, 0, 0.0, 0.0, 10, 2, new Insets(0, 50, 0, 0), 0, 0));
        this.channelSelectionPanel.validate();
        this.colorChooser.setPreviewPanel(new JPanel());
        this.gradientPreviewPanel.add((Component)this.previewer, "Center");
        this.colorChooser.getSelectionModel().addChangeListener(this.previewer);
        this.pack();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorSchemeSelectionDialog.this.result = 0;
                ColorSchemeSelectionDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorSchemeSelectionDialog.this.result = 2;
                ColorSchemeSelectionDialog.this.setVisible(false);
            }
        });
    }

    private void initComponents() {
        Listener listener = new Listener();
        ButtonGroup bg = new ButtonGroup();
        this.doubleGradientButton = new JRadioButton("Double Gradient", this.useDoubleGradient);
        this.doubleGradientButton.setActionCommand("change-gradient-command");
        this.doubleGradientButton.addActionListener(listener);
        this.doubleGradientButton.setFocusPainted(false);
        this.doubleGradientButton.setOpaque(false);
        bg.add(this.doubleGradientButton);
        this.singleGradientButton = new JRadioButton("Single Gradient", !this.useDoubleGradient);
        this.singleGradientButton.setActionCommand("change-gradient-command");
        this.singleGradientButton.addActionListener(listener);
        this.singleGradientButton.setFocusPainted(false);
        this.singleGradientButton.setOpaque(false);
        bg.add(this.singleGradientButton);
        JPanel gradientStylePanel = new JPanel(new GridBagLayout());
        gradientStylePanel.setBackground(Color.white);
        gradientStylePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Gradient Style"));
        gradientStylePanel.add((Component)this.doubleGradientButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 20), 0, 0));
        gradientStylePanel.add((Component)this.singleGradientButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 20, 5, 0), 0, 0));
        this.chanelSelectionGroup = new ButtonGroup();
        this.channelSelectionPanel = new JPanel();
        this.channelSelectionPanel.setBackground(Color.white);
        this.channelSelectionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Gradient Selection"));
        this.negativeColorButton = new JRadioButton();
        this.positiveColorButton = new JRadioButton();
        this.actionButtonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.colorChooser = new JColorChooser();
        this.colorChooser.setPreviewPanel(this.previewer);
        this.gradientPreviewPanel = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ColorSchemeSelectionDialog.this.closeDialog(evt);
            }
        });
        this.channelSelectionPanel.setLayout(new GridBagLayout());
        this.negativeColorButton.setSelected(true);
        this.negativeColorButton.setText("Select Low End Color");
        this.negativeColorButton.setOpaque(false);
        this.chanelSelectionGroup.add(this.negativeColorButton);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.channelSelectionPanel.add((Component)this.negativeColorButton, gridBagConstraints2);
        this.positiveColorButton.setText("Select High End Color");
        this.positiveColorButton.setOpaque(false);
        this.chanelSelectionGroup.add(this.positiveColorButton);
        gridBagConstraints2 = new GridBagConstraints();
        this.channelSelectionPanel.add((Component)this.positiveColorButton, gridBagConstraints2);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.gridheight = 1;
        gridBagConstraints1.fill = 1;
        this.getContentPane().add((Component)gradientStylePanel, gridBagConstraints1);
        this.actionButtonPanel.setLayout(new GridBagLayout());
        this.okButton.setText(" Apply Color Scheme");
        this.okButton.setFocusPainted(false);
        this.okButton.setSelected(true);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(10, 0, 10, 10);
        this.actionButtonPanel.add((Component)this.okButton, gridBagConstraints3);
        this.cancelButton.setText("Cancel");
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(10, 10, 10, 0);
        this.actionButtonPanel.add((Component)this.cancelButton, gridBagConstraints3);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.fill = 1;
        this.getContentPane().add((Component)this.actionButtonPanel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 1;
        this.getContentPane().add((Component)this.channelSelectionPanel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 1;
        this.getContentPane().add((Component)this.colorChooser, gridBagConstraints1);
        this.gradientPreviewPanel.setLayout(new BorderLayout());
        this.gradientPreviewPanel.setBorder(new TitledBorder(new EtchedBorder(), "Gradient Preview"));
        this.gradientPreviewPanel.setPreferredSize(new Dimension(200, 70));
        this.gradientPreviewPanel.setMinimumSize(new Dimension(200, 70));
        this.gradientPreviewPanel.setBackground(Color.white);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = 1;
        this.getContentPane().add((Component)this.gradientPreviewPanel, gridBagConstraints1);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public BufferedImage getPositiveGradient() {
        return this.previewer.getPositiveGradient();
    }

    public BufferedImage getNegativeGradient() {
        return this.previewer.getNegativeGradient();
    }

    public boolean getUseDoubleGradient() {
        return this.doubleGradientButton.isSelected();
    }

    public BufferedImage getPosImage() {
        return this.previewer.getPositiveGradient();
    }

    public class Listener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("change-gradient-command")) {
                ColorSchemeSelectionDialog.this.useDoubleGradient = ColorSchemeSelectionDialog.this.doubleGradientButton.isSelected();
                ColorSchemeSelectionDialog.this.neutralColorCheckBox.setEnabled(ColorSchemeSelectionDialog.this.useDoubleGradient);
                ColorSchemeSelectionDialog.this.previewer.onSwitchGradientStyle();
            }
        }
    }

    public class PreviewPanel
    extends JPanel
    implements ChangeListener {
        BufferedImage currentPosGradient;
        BufferedImage currentNegGradient;

        public PreviewPanel(BufferedImage negImage, BufferedImage posImage) {
            this.currentNegGradient = negImage;
            this.currentPosGradient = posImage;
            ColorSchemeSelectionDialog.this.posColor = new Color(posImage.getRGB(posImage.getWidth() - 1, 0));
            ColorSchemeSelectionDialog.this.negColor = new Color(negImage.getRGB(0, 0));
            super.setBorder(new TitledBorder(new EtchedBorder(1), "Gradient Preview"));
            this.setSize(200, 70);
            this.setPreferredSize(new Dimension(200, 70));
            this.setVisible(true);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Color newColor = ColorSchemeSelectionDialog.this.colorChooser.getColor();
            if (newColor == null) {
                return;
            }
            if (ColorSchemeSelectionDialog.this.positiveColorButton.isSelected()) {
                ColorSchemeSelectionDialog.this.posColor = newColor;
                this.currentPosGradient = ColorSchemeSelectionDialog.this.useDoubleGradient ? this.createGradientImage(ColorSchemeSelectionDialog.this.neutralColor, ColorSchemeSelectionDialog.this.posColor) : this.createGradientImage(ColorSchemeSelectionDialog.this.negColor, ColorSchemeSelectionDialog.this.posColor);
            } else if (ColorSchemeSelectionDialog.this.negativeColorButton.isSelected()) {
                ColorSchemeSelectionDialog.this.negColor = newColor;
                if (ColorSchemeSelectionDialog.this.useDoubleGradient) {
                    this.currentNegGradient = this.createGradientImage(ColorSchemeSelectionDialog.this.negColor, ColorSchemeSelectionDialog.this.neutralColor);
                } else {
                    this.currentPosGradient = this.createGradientImage(ColorSchemeSelectionDialog.this.negColor, ColorSchemeSelectionDialog.this.posColor);
                }
            }
            this.repaint();
        }

        public void alterNeutralColor() {
            if (ColorSchemeSelectionDialog.this.useDoubleGradient) {
                this.currentPosGradient = this.createGradientImage(ColorSchemeSelectionDialog.this.neutralColor, ColorSchemeSelectionDialog.this.posColor);
                this.currentNegGradient = this.createGradientImage(ColorSchemeSelectionDialog.this.negColor, ColorSchemeSelectionDialog.this.neutralColor);
                this.repaint();
            }
        }

        public void onSwitchGradientStyle() {
            if (ColorSchemeSelectionDialog.this.useDoubleGradient) {
                this.refreshPreview();
            } else {
                this.currentPosGradient = this.createGradientImage(ColorSchemeSelectionDialog.this.negColor, ColorSchemeSelectionDialog.this.posColor);
            }
            this.repaint();
        }

        public void refreshPreview() {
            this.currentPosGradient = this.createGradientImage(ColorSchemeSelectionDialog.this.neutralColor, ColorSchemeSelectionDialog.this.posColor);
            this.currentNegGradient = this.createGradientImage(ColorSchemeSelectionDialog.this.negColor, ColorSchemeSelectionDialog.this.neutralColor);
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            super.paintComponent(g);
            if (ColorSchemeSelectionDialog.this.useDoubleGradient) {
                g.drawImage(this.currentNegGradient, 0, 0, this.getWidth() / 2, this.getHeight(), null);
                g.drawImage(this.currentPosGradient, this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight(), null);
            } else {
                g.drawImage(this.currentPosGradient, 0, 0, this.getWidth(), this.getHeight(), null);
            }
        }

        private BufferedImage createGradientImage(Color color1, Color color2) {
            BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
            Graphics2D graphics = image.createGraphics();
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 255.0f, 0.0f, color2);
            graphics.setPaint(gp);
            graphics.drawRect(0, 0, 255, 1);
            return image;
        }

        public BufferedImage getPositiveGradient() {
            return this.currentPosGradient;
        }

        public BufferedImage getNegativeGradient() {
            return this.currentNegGradient;
        }
    }
}

