/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util.awt;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class AccessibleColorPalette
extends AbstractColorChooserPanel
implements ActionListener {
    public Color black = new Color(0, 0, 0);
    public Color blue = new Color(0, 114, 178);
    public Color orange = new Color(230, 159, 0);
    public Color skyBlue = new Color(86, 180, 233);
    public Color bluishGreen = new Color(0, 158, 115);
    public Color yellow = new Color(0, 228, 66);
    public Color vermillion = new Color(213, 94, 0);
    public Color reddishPurple = new Color(204, 121, 167);
    private JToggleButton blackCrayon;
    private JToggleButton blueCrayon;
    private JToggleButton orangeCrayon;
    private JToggleButton yellowCrayon;
    private JToggleButton skyBlueCrayon;
    private JToggleButton bluishGreenCrayon;
    private JToggleButton vermillionCrayon;
    private JToggleButton reddishPurpleCrayon;

    @Override
    public void updateChooser() {
        Color color = this.getColorFromModel();
        if (this.orange.equals(color)) {
            this.orangeCrayon.setSelected(true);
        } else if (this.yellow.equals(color)) {
            this.yellowCrayon.setSelected(true);
        } else if (this.skyBlue.equals(color)) {
            this.skyBlueCrayon.setSelected(true);
        } else if (this.bluishGreen.equals(color)) {
            this.bluishGreenCrayon.setSelected(true);
        } else if (this.vermillion.equals(color)) {
            this.vermillionCrayon.setSelected(true);
        } else if (this.reddishPurple.equals(color)) {
            this.reddishPurpleCrayon.setSelected(true);
        } else if (this.blue.equals(color)) {
            this.blueCrayon.setSelected(true);
        } else if (this.black.equals(color)) {
            this.blackCrayon.setSelected(true);
        }
    }

    protected JToggleButton createCrayon(String name, Border normalBorder) {
        JToggleButton crayon = new JToggleButton();
        crayon.setActionCommand(name);
        crayon.addActionListener(this);
        crayon.setText(name);
        crayon.setSize(4, 4);
        crayon.setFont(crayon.getFont().deriveFont(2));
        crayon.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        return crayon;
    }

    @Override
    protected void buildChooser() {
        ButtonGroup boxOfCrayons = new ButtonGroup();
        Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.blackCrayon = this.createCrayon("black", border);
        this.blackCrayon.setBackground(this.black);
        this.blackCrayon.setForeground(this.black);
        boxOfCrayons.add(this.blackCrayon);
        this.add(this.blackCrayon);
        this.blueCrayon = this.createCrayon("blue", border);
        this.blueCrayon.setBackground(this.blue);
        this.blueCrayon.setForeground(this.blue);
        boxOfCrayons.add(this.blueCrayon);
        this.add(this.blueCrayon);
        this.orangeCrayon = this.createCrayon("orange", border);
        this.orangeCrayon.setBackground(this.orange);
        this.orangeCrayon.setForeground(this.orange);
        boxOfCrayons.add(this.orangeCrayon);
        this.add(this.orangeCrayon);
        this.skyBlueCrayon = this.createCrayon("skyBlue", border);
        this.skyBlueCrayon.setBackground(this.skyBlue);
        this.skyBlueCrayon.setForeground(this.skyBlue);
        boxOfCrayons.add(this.skyBlueCrayon);
        this.add(this.skyBlueCrayon);
        this.bluishGreenCrayon = this.createCrayon("bluishGreen", border);
        this.bluishGreenCrayon.setBackground(this.bluishGreen);
        this.bluishGreenCrayon.setForeground(this.bluishGreen);
        boxOfCrayons.add(this.bluishGreenCrayon);
        this.add(this.bluishGreenCrayon);
        this.yellowCrayon = this.createCrayon("yellow", border);
        this.yellowCrayon.setBackground(this.yellow);
        this.yellowCrayon.setForeground(this.yellow);
        boxOfCrayons.add(this.yellowCrayon);
        this.add(this.yellowCrayon);
        this.vermillionCrayon = this.createCrayon("vermillion", border);
        this.vermillionCrayon.setBackground(this.vermillion);
        this.vermillionCrayon.setForeground(this.vermillion);
        boxOfCrayons.add(this.vermillionCrayon);
        this.add(this.vermillionCrayon);
        this.reddishPurpleCrayon = this.createCrayon("reddishPurple", border);
        this.reddishPurpleCrayon.setBackground(this.reddishPurple);
        this.reddishPurpleCrayon.setForeground(this.reddishPurple);
        boxOfCrayons.add(this.reddishPurpleCrayon);
        this.add(this.reddishPurpleCrayon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color newColor = null;
        String command = ((JToggleButton)e.getSource()).getActionCommand();
        if ("orange".equals(command)) {
            newColor = this.orange;
        } else if ("skyBlue".equals(command)) {
            newColor = this.skyBlue;
        } else if ("yellow".equals(command)) {
            newColor = this.yellow;
        } else if ("bluishGreen".equals(command)) {
            newColor = this.bluishGreen;
        } else if ("reddishPurple".equals(command)) {
            newColor = this.reddishPurple;
        } else if ("vermillion".equals(command)) {
            newColor = this.vermillion;
        } else if ("blue".equals(command)) {
            newColor = this.blue;
        } else if ("black".equals(command)) {
            newColor = this.black;
        }
        this.getColorSelectionModel().setSelectedColor(newColor);
    }

    @Override
    public String getDisplayName() {
        return "ColorBlindPalette";
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void uninstallChooserPanel(JColorChooser panel) {
        super.uninstallChooserPanel(panel);
    }
}

