/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util;

import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;

public class SlideDataSorter {
    public static final int SORT_BY_LOCATION = 9000;
    public static final int SORT_BY_RATIO = 9001;
    private ISlideData slideData;

    public SlideDataSorter() {
    }

    public SlideDataSorter(ISlideData slideData) {
        if (slideData == null) {
            throw new IllegalArgumentException("SlideData is null.");
        }
        this.slideData = slideData;
    }

    public void setSlideData(ISlideData slideData) {
        this.slideData = slideData;
    }

    public int[] sort(int[] indices, int type) {
        SlideDataSorter.sort(indices, new IndicesComparator(type));
        return indices;
    }

    public static void sort(int[] a, IndicesComparator c) {
        int[] aux = SlideDataSorter.cloneArray(a);
        SlideDataSorter.mergeSort(aux, a, 0, a.length, c);
    }

    private static int[] cloneArray(int[] a) {
        int[] clone = new int[a.length];
        int i = a.length;
        while (--i >= 0) {
            clone[i] = a[i];
        }
        return clone;
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void mergeSort(int[] src, int[] dest, int low, int high, IndicesComparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    SlideDataSorter.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        SlideDataSorter.mergeSort(dest, src, low, mid, c);
        SlideDataSorter.mergeSort(dest, src, mid, high, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private class IndicesComparator {
        private int type;

        public IndicesComparator(int type) {
            this.type = type;
        }

        public int compare(int index1, int index2) {
            switch (this.type) {
                case 9000: {
                    ISlideMetaData meta = SlideDataSorter.this.slideData.getSlideMetaData();
                    int columns = meta.getColumns();
                    if (meta.getRow(index1) * columns + meta.getColumn(index1) < meta.getRow(index2) * columns + meta.getColumn(index2)) {
                        return -1;
                    }
                    return 1;
                }
                case 9001: {
                    float value1 = SlideDataSorter.this.slideData.getRatio(index1, 0);
                    float value2 = SlideDataSorter.this.slideData.getRatio(index2, 0);
                    if (Float.isNaN(value1) && Float.isNaN(value2)) {
                        return -1;
                    }
                    if (Float.isNaN(value1) && !Float.isNaN(value2)) {
                        return -1;
                    }
                    if (!Float.isNaN(value1) && Float.isNaN(value2)) {
                        return 1;
                    }
                    if (value1 < value2) {
                        return -1;
                    }
                    return 1;
                }
            }
            ISlideMetaData meta = SlideDataSorter.this.slideData.getSlideMetaData();
            String attrType = meta.getFieldNames()[this.type];
            String value1 = meta.getAnnotationValue(index1, attrType)[0];
            String value2 = meta.getAnnotationValue(index2, attrType)[0];
            return value1.compareTo(value2);
        }
    }
}

