/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util;

import java.util.Random;
import java.util.Vector;
import org.tigr.util.FloatMatrix;

public class JacknifedMatrixByGenes {
    public Vector resampledIndices = new Vector();
    int jackknifedGene;

    float[][] get2DArrFromExpMatrix(FloatMatrix expMatrix) {
        int geneDim = expMatrix.getRowDimension();
        int expDim = expMatrix.getColumnDimension();
        float[][] expArray = new float[geneDim][expDim];
        for (int x = 0; x < geneDim; ++x) {
            for (int y = 0; y < expDim; ++y) {
                expArray[x][y] = expMatrix.get(x, y);
            }
        }
        return expArray;
    }

    float[][] resampleMatrix(FloatMatrix expMatrix) {
        int i;
        float[][] aMatrix = this.get2DArrFromExpMatrix(expMatrix);
        float[][] newMatrix = new float[aMatrix.length - 1][aMatrix[0].length];
        int numGenes = aMatrix.length;
        int numExps = aMatrix[0].length;
        int k = 0;
        Random generator = new Random();
        int randGene = generator.nextInt(numGenes);
        for (i = 0; i < numExps; ++i) {
            k = 0;
            for (int j = 0; j < numGenes; ++j) {
                if (j == randGene) continue;
                newMatrix[k][i] = aMatrix[j][i];
                ++k;
            }
        }
        this.jackknifedGene = randGene;
        for (i = 0; i < numGenes; ++i) {
            if (i == this.jackknifedGene) continue;
            this.resampledIndices.add(new Integer(i));
        }
        return newMatrix;
    }

    public FloatMatrix createResampExpMatrixObject(FloatMatrix ExpMatrix) {
        float[][] resampledArray = this.resampleMatrix(ExpMatrix);
        FloatMatrix resampMatrixObject = new FloatMatrix(resampledArray);
        return resampMatrixObject;
    }

    void printMatrix(float[][] matrix) {
        int j = 0;
        for (int i = 0; i < matrix[0].length; ++i) {
            for (j = 0; j < matrix.length; ++j) {
                System.out.print((int)(matrix[j][i] * 100.0f) / 100 + " ");
            }
            System.out.println();
        }
    }
}

