/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util;

import java.util.Random;
import java.util.Vector;
import org.tigr.util.FloatMatrix;

public class JacknifedMatrixByExps {
    public Vector resampledIndices = new Vector();
    int jacknifedExperiment;

    float[][] get2DArrFromExpMatrix(FloatMatrix expMatrix) {
        int geneDim = expMatrix.getRowDimension();
        int expDim = expMatrix.getColumnDimension();
        float[][] expArray = new float[geneDim][expDim];
        for (int x = 0; x < geneDim; ++x) {
            for (int y = 0; y < expDim; ++y) {
                expArray[x][y] = expMatrix.get(x, y);
            }
        }
        return expArray;
    }

    float[][] resampleMatrix(FloatMatrix expMatrix) {
        int i;
        float[][] aMatrix = this.get2DArrFromExpMatrix(expMatrix);
        float[][] newMatrix = new float[aMatrix.length][aMatrix[0].length - 1];
        int numGenes = aMatrix.length;
        int numExps = aMatrix[0].length;
        int k = 0;
        Random generator = new Random();
        int randExp = generator.nextInt(numExps);
        for (i = 0; i < numGenes; ++i) {
            k = 0;
            for (int j = 0; j < numExps; ++j) {
                if (j == randExp) continue;
                newMatrix[i][k] = aMatrix[i][j];
                ++k;
            }
        }
        this.jacknifedExperiment = randExp;
        for (i = 0; i < numExps; ++i) {
            if (i == this.jacknifedExperiment) continue;
            this.resampledIndices.add(new Integer(i));
        }
        return newMatrix;
    }

    public FloatMatrix createResampExpMatrixObject(FloatMatrix expMatrix) {
        float[][] resampledArray = this.resampleMatrix(expMatrix);
        int numbExps = resampledArray[0].length;
        int numbGenes = resampledArray.length;
        FloatMatrix resampMatrixObject = new FloatMatrix(resampledArray);
        return resampMatrixObject;
    }

    void printMatrix(float[][] matrix) {
        int j = 0;
        for (int i = 0; i < matrix[0].length; ++i) {
            for (j = 0; j < matrix.length; ++j) {
                System.out.print((int)(matrix[j][i] * 100.0f) / 100 + " ");
            }
            System.out.println();
        }
    }
}

