/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util;

import java.io.File;
import java.util.Vector;

public class FileLoaderUtility {
    protected String fPath;
    protected String selectedSingleFile;
    protected Vector selectedFilesVec;

    public Vector getFileNameList(String directoryPath) {
        if (directoryPath == null) {
            return null;
        }
        FileBrowser fBrowser = new FileBrowser(directoryPath);
        Vector retrievedFileNames = fBrowser.getFileNamesVec();
        return retrievedFileNames;
    }

    private class FileBrowser {
        private String workingFullDir;
        private String workingDir;
        private Vector filesVec;
        private File dir;
        private File subDir;
        public char DIRECTORY_DIV;
        public String DIRECTORY_DIV_S;

        public FileBrowser(String directory) {
            this.setDirectory(directory);
            String sep = System.getProperty("file.separator");
            this.DIRECTORY_DIV = sep.toCharArray()[0];
            this.DIRECTORY_DIV_S = sep;
        }

        public void setDirectory(String directory) {
            this.workingFullDir = directory;
            this.dir = new File(directory);
            this.workingDir = this.dir.getAbsolutePath();
            if (!this.dir.isDirectory()) {
                this.workingDir = this.workingDir.substring(0, this.workingDir.lastIndexOf(this.DIRECTORY_DIV));
            } else {
                this.filterFiles();
            }
        }

        public void filterFiles() {
            this.filesVec = new Vector();
            if (this.dir == null) {
                return;
            }
            String[] available = this.dir.list();
            if (this.workingDir == null) {
                this.workingDir = this.dir.getAbsolutePath();
            }
            for (int i = 0; i < available.length; ++i) {
                File checkFile = new File(this.dir, available[i]);
                if (!checkFile.isFile()) continue;
                this.filesVec.addElement(checkFile);
            }
        }

        public Vector getFileNamesVec() {
            return this.filesVec;
        }

        public int getFileCounts() {
            return this.filesVec.size();
        }

        public String getAbsolutePath() {
            return this.workingDir;
        }

        public String creatSubDir(String sub) {
            this.subDir = new File(this.workingFullDir + this.DIRECTORY_DIV + sub + this.DIRECTORY_DIV);
            return this.workingFullDir + this.DIRECTORY_DIV + sub + this.DIRECTORY_DIV;
        }

        public String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }
}

