/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ExpressionFileTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private Color whiteColor = new Color(254, 254, 254);
    private Color alternateColor = new Color(237, 243, 254);
    private Color sampleAnnotationColor = new Color(205, 225, 225);
    private Color colAnnotationColor = new Color(225, 225, 255);
    private Color sampleAnnLabelColor = new Color(255, 255, 200);
    private int selectedRow = 0;
    private int selectedCol = 0;

    public void setSelected(int row, int col) {
        this.selectedRow = row;
        this.selectedCol = col;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int thisRow, int thisColumn) {
        super.getTableCellRendererComponent(table, value, selected, focused, thisRow, thisColumn);
        Color bg = !selected ? (thisRow % 2 == 0 ? this.alternateColor : this.whiteColor) : this.sampleAnnotationColor;
        this.setBackground(bg);
        if (this.selectedRow != 0 || this.selectedCol != 0) {
            if (thisColumn < this.selectedCol && thisRow < this.selectedRow) {
                this.setBackground(Color.WHITE);
                if (thisColumn == this.selectedCol - 1) {
                    this.setBackground(this.sampleAnnLabelColor);
                }
            } else if (thisColumn < this.selectedCol) {
                this.setBackground(this.colAnnotationColor);
            } else if (thisRow < this.selectedRow) {
                this.setBackground(this.sampleAnnotationColor);
            }
        }
        Color fg = selected ? Color.white : Color.black;
        this.setForeground(fg);
        return this;
    }
}

