/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util;

import java.util.Random;
import java.util.Vector;
import org.tigr.util.FloatMatrix;

public class BootstrappedMatrixByExps {
    public Vector resampledIndices = new Vector();

    float[][] get2DArrFromExpMatrix(FloatMatrix expMatrix) {
        int geneDim = expMatrix.getRowDimension();
        int expDim = expMatrix.getColumnDimension();
        float[][] expArray = new float[geneDim][expDim];
        for (int x = 0; x < geneDim; ++x) {
            for (int y = 0; y < expDim; ++y) {
                expArray[x][y] = expMatrix.get(x, y);
            }
        }
        return expArray;
    }

    float[][] resampleMatrix(FloatMatrix expMatrix) {
        float[][] aMatrix = this.get2DArrFromExpMatrix(expMatrix);
        float[][] newMatrix = new float[aMatrix.length][aMatrix[0].length];
        int numGenes = aMatrix.length;
        int numExps = aMatrix[0].length;
        Random generator = new Random();
        for (int s = 0; s < numExps; ++s) {
            int randExp = generator.nextInt(numExps);
            for (int u = 0; u < numGenes; ++u) {
                newMatrix[u][s] = aMatrix[u][randExp];
            }
            this.resampledIndices.add(new Integer(randExp));
        }
        return newMatrix;
    }

    public FloatMatrix createResampExpMatrixObject(FloatMatrix expMatrix) {
        float[][] resampledArray = this.resampleMatrix(expMatrix);
        FloatMatrix resampMatrixObject = new FloatMatrix(resampledArray);
        return resampMatrixObject;
    }

    void printMatrix(float[][] matrix) {
        int j = 0;
        for (int i = 0; i < matrix[0].length; ++i) {
            for (j = 0; j < matrix.length; ++j) {
                System.out.print((int)(matrix[j][i] * 100.0f) / 100 + " ");
            }
            System.out.println();
        }
    }
}

