/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.tigr.util.FloatMatrix;

public class Adjustment {
    public static void log2Transform(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                float value = matrix.get(i, j);
                if (Float.isNaN(value)) continue;
                if (value > 0.0f) {
                    matrix.set(i, j, (float)(Math.log(value) / 0.69314718));
                    continue;
                }
                matrix.set(i, j, Float.NaN);
            }
        }
    }

    public static void unlog2Transform(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                float value = matrix.get(i, j);
                if (Float.isNaN(value)) continue;
                matrix.set(i, j, (float)Math.pow(2.0, value));
            }
        }
    }

    public static void normalizeSpots(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            Adjustment.normalizeGene(matrix, i);
        }
    }

    public static void divideSpotsRMS(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            Adjustment.divideGeneByRMS(matrix, i);
        }
    }

    public static void divideGenesMedian(FloatMatrix matrix) {
        float median = 0.0f;
        float value = 0.0f;
        int num_samples = matrix.getColumnDimension();
        int num_genes = matrix.getRowDimension();
        ArrayList<Float> row = new ArrayList<Float>(num_genes);
        for (int gene = 0; gene < num_genes; ++gene) {
            int sample;
            median = 0.0f;
            for (sample = 0; sample < num_samples; ++sample) {
                row.add(sample, new Float(matrix.get(gene, sample)));
            }
            median = Adjustment.getGeneMedian(row);
            for (sample = 0; sample < num_samples; ++sample) {
                value = matrix.get(gene, sample);
                matrix.set(gene, sample, value / median);
            }
            row.clear();
        }
    }

    public static void divideGenesMean(FloatMatrix matrix) {
        for (int g = 0; g < matrix.getRowDimension(); ++g) {
            float value;
            int i;
            double Mean = 0.0;
            int n = matrix.getColumnDimension();
            int validN = 0;
            for (i = 0; i < n; ++i) {
                value = matrix.get(g, i);
                if (Float.isNaN(value)) continue;
                Mean += (double)value;
                ++validN;
            }
            if (validN > 0) {
                Mean /= (double)validN;
            }
            for (i = 0; i < n; ++i) {
                value = matrix.get(g, i);
                if (Float.isNaN(value)) continue;
                matrix.set(g, i, (float)((double)value / Mean));
            }
        }
    }

    public static void divideSpotsSD(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            Adjustment.divideGeneBySD(matrix, i);
        }
    }

    public static void meanCenterSpots(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            Adjustment.meanCenterGene(matrix, i);
        }
    }

    public static void medianCenterSpots(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            Adjustment.medianCenterGene(matrix, i);
        }
    }

    public static void digitalSpots(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            Adjustment.makeDigitalGene(matrix, i);
        }
    }

    public static void normalizeExperiments(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getColumnDimension(); ++i) {
            Adjustment.normalizeExperiment(matrix, i);
        }
    }

    public static void divideExperimentsRMS(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getColumnDimension(); ++i) {
            Adjustment.divideExperimentByRMS(matrix, i);
        }
    }

    public static void divideExperimentsSD(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getColumnDimension(); ++i) {
            Adjustment.divideExperimentBySD(matrix, i);
        }
    }

    public static void meanCenterExperiments(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getColumnDimension(); ++i) {
            Adjustment.meanCenterExperiment(matrix, i);
        }
    }

    public static void medianCenterExperiments(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getColumnDimension(); ++i) {
            Adjustment.medianCenterExperiment(matrix, i);
        }
    }

    public static void digitalExperiments(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getColumnDimension(); ++i) {
            Adjustment.makeDigitalExperiment(matrix, i);
        }
    }

    public static void log10toLog2(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                float value = matrix.get(i, j);
                if (Float.isNaN(value)) continue;
                matrix.set(i, j, (float)((double)value / 0.301029995));
            }
        }
    }

    public static void log2toLog10(FloatMatrix matrix) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                float value = matrix.get(i, j);
                if (Float.isNaN(value)) continue;
                matrix.set(i, j, (float)((double)value * 0.301029995));
            }
        }
    }

    private static void normalizeGene(FloatMatrix matrix, int GeneNumber) {
        float value;
        int i;
        double Mean = 0.0;
        double StandardDeviation = 0.0;
        int n = matrix.getColumnDimension();
        int validN = 0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(GeneNumber, i);
            if (Float.isNaN(value)) continue;
            Mean += (double)value;
            ++validN;
        }
        if (validN > 0) {
            Mean /= (double)validN;
        }
        for (i = 0; i < n; ++i) {
            value = matrix.get(GeneNumber, i);
            if (Float.isNaN(value)) continue;
            StandardDeviation += Math.pow((double)value - Mean, 2.0);
        }
        StandardDeviation = validN > 1 ? Math.sqrt(StandardDeviation / (double)(validN - 1)) : 0.0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(GeneNumber, i);
            if (Float.isNaN(value)) continue;
            if (StandardDeviation != 0.0) {
                matrix.set(GeneNumber, i, (float)(((double)value - Mean) / StandardDeviation));
                continue;
            }
            matrix.set(GeneNumber, i, (float)(((double)value - Mean) / (double)1.4E-45f));
        }
    }

    private static void divideGeneByRMS(FloatMatrix matrix, int GeneNumber) {
        int i;
        double Mean = 0.0;
        double RMS = 0.0;
        float value = 0.0f;
        int n = matrix.getColumnDimension();
        int validN = 0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(GeneNumber, i);
            if (Float.isNaN(value)) continue;
            RMS += Math.pow(value, 2.0);
            ++validN;
        }
        RMS = validN > 1 ? Math.sqrt(RMS / (double)(validN - 1)) : (validN == 0 ? Math.sqrt(RMS) : 0.0);
        for (i = 0; i < n; ++i) {
            value = matrix.get(GeneNumber, i);
            if (Float.isNaN(value)) continue;
            if (RMS != 0.0) {
                matrix.set(GeneNumber, i, (float)((double)value / RMS));
                continue;
            }
            matrix.set(GeneNumber, i, value / Float.MIN_VALUE);
        }
    }

    private static void divideGeneBySD(FloatMatrix matrix, int GeneNumber) {
        float value;
        int i;
        double Mean = 0.0;
        double StandardDeviation = 0.0;
        int n = matrix.getColumnDimension();
        int validN = 0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(GeneNumber, i);
            if (Float.isNaN(value)) continue;
            Mean += (double)value;
            ++validN;
        }
        if (validN > 0) {
            Mean /= (double)validN;
        }
        for (i = 0; i < n; ++i) {
            value = matrix.get(GeneNumber, i);
            if (Float.isNaN(value)) continue;
            StandardDeviation += Math.pow((double)value - Mean, 2.0);
        }
        StandardDeviation = validN > 1 ? Math.sqrt(StandardDeviation / (double)(validN - 1)) : 0.0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(GeneNumber, i);
            if (Float.isNaN(value)) continue;
            if (StandardDeviation != 0.0) {
                matrix.set(GeneNumber, i, (float)((double)value / StandardDeviation));
                continue;
            }
            matrix.set(GeneNumber, i, value / Float.MIN_VALUE);
        }
    }

    public static void meanCenterGene(FloatMatrix matrix, int GeneNumber) {
        float value;
        int i;
        double Mean = 0.0;
        int n = matrix.getColumnDimension();
        int validN = 0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(GeneNumber, i);
            if (Float.isNaN(value)) continue;
            Mean += (double)value;
            ++validN;
        }
        if (validN > 0) {
            Mean /= (double)validN;
        }
        for (i = 0; i < n; ++i) {
            value = matrix.get(GeneNumber, i);
            if (Float.isNaN(value)) continue;
            matrix.set(GeneNumber, i, (float)((double)value - Mean));
        }
    }

    private static void medianCenterGene(FloatMatrix matrix, int GeneNumber) {
        float value;
        int i;
        int n = matrix.getColumnDimension();
        int k = 0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(GeneNumber, i);
            if (Float.isNaN(value)) continue;
            ++k;
        }
        float[] DummyArray = new float[k];
        k = 0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(GeneNumber, i);
            if (Float.isNaN(value)) continue;
            DummyArray[k] = value;
            ++k;
        }
        Arrays.sort(DummyArray);
        float Median = 0.0f;
        if (k % 2 == 0) {
            if (k > 0) {
                Median = (float)(0.5 * (double)(DummyArray[k / 2 - 1] + DummyArray[k / 2]));
            }
        } else {
            Median = DummyArray[(k + 1) / 2 - 1];
        }
        for (i = 0; i < n; ++i) {
            value = matrix.get(GeneNumber, i);
            if (Float.isNaN(value)) continue;
            matrix.set(GeneNumber, i, value - Median);
        }
    }

    private static void makeDigitalGene(FloatMatrix matrix, int Gene2) {
        int i;
        int n = matrix.getColumnDimension();
        int NumberOfBins = (int)Math.floor(Math.log(n) / Math.log(2.0));
        int Step = 1000000 / NumberOfBins;
        float Minimum = Float.MAX_VALUE;
        float Maximum = 0.0f;
        for (i = 0; i < n; ++i) {
            if (!(matrix.get(Gene2, i) < Minimum)) continue;
            Minimum = matrix.get(Gene2, i);
        }
        for (i = 0; i < n; ++i) {
            matrix.set(Gene2, i, matrix.get(Gene2, i) - Minimum);
        }
        for (i = 0; i < n; ++i) {
            if (!(matrix.get(Gene2, i) > Maximum)) continue;
            Maximum = matrix.get(Gene2, i);
        }
        for (i = 0; i < n; ++i) {
            matrix.set(Gene2, i, matrix.get(Gene2, i) / Maximum);
        }
        for (i = 0; i < n; ++i) {
            if ((double)matrix.get(Gene2, i) == 1.0) {
                matrix.set(Gene2, i, (float)NumberOfBins);
                continue;
            }
            matrix.set(Gene2, i, (float)(Math.floor(matrix.get(Gene2, i) * 1000000.0f / (float)Step) + 1.0));
        }
    }

    private static void normalizeExperiment(FloatMatrix matrix, int ExperimentNumber) {
        float value;
        int i;
        double Mean = 0.0;
        double StandardDeviation = 0.0;
        int n = matrix.getRowDimension();
        int validN = 0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(i, ExperimentNumber);
            if (Float.isNaN(value)) continue;
            Mean += (double)value;
            ++validN;
        }
        if (validN > 0) {
            Mean /= (double)validN;
        }
        for (i = 0; i < n; ++i) {
            value = matrix.get(i, ExperimentNumber);
            if (Float.isNaN(value)) continue;
            StandardDeviation += Math.pow((double)value - Mean, 2.0);
        }
        StandardDeviation = validN > 1 ? Math.sqrt(StandardDeviation / (double)(validN - 1)) : 0.0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(i, ExperimentNumber);
            if (Float.isNaN(value)) continue;
            if (StandardDeviation != 0.0) {
                matrix.set(i, ExperimentNumber, (float)(((double)value - Mean) / StandardDeviation));
                continue;
            }
            matrix.set(i, ExperimentNumber, (float)(((double)value - Mean) / (double)1.4E-45f));
        }
    }

    private static void divideExperimentBySD(FloatMatrix matrix, int ExperimentNumber) {
        float value;
        int i;
        double Mean = 0.0;
        double StandardDeviation = 0.0;
        int n = matrix.getRowDimension();
        int validN = 0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(i, ExperimentNumber);
            if (Float.isNaN(value)) continue;
            Mean += (double)value;
            ++validN;
        }
        if (validN > 0) {
            Mean /= (double)validN;
        }
        for (i = 0; i < n; ++i) {
            value = matrix.get(i, ExperimentNumber);
            if (Float.isNaN(value)) continue;
            StandardDeviation += Math.pow((double)value - Mean, 2.0);
        }
        StandardDeviation = validN > 1 ? Math.sqrt(StandardDeviation / (double)(validN - 1)) : 0.0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(i, ExperimentNumber);
            if (Float.isNaN(value)) continue;
            if (StandardDeviation != 0.0) {
                matrix.set(i, ExperimentNumber, (float)((double)value / StandardDeviation));
                continue;
            }
            matrix.set(i, ExperimentNumber, value / Float.MIN_VALUE);
        }
    }

    private static void divideExperimentByRMS(FloatMatrix matrix, int ExperimentNumber) {
        float value;
        int i;
        double Mean = 0.0;
        double RMS = 0.0;
        int n = matrix.getRowDimension();
        int validN = 0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(i, ExperimentNumber);
            if (Float.isNaN(value)) continue;
            RMS += Math.pow(value, 2.0);
            ++validN;
        }
        if (validN > 0) {
            RMS = Math.sqrt(RMS / (double)validN);
        }
        for (i = 0; i < n; ++i) {
            value = matrix.get(i, ExperimentNumber);
            if (Float.isNaN(value)) continue;
            if (RMS != 0.0) {
                matrix.set(i, ExperimentNumber, (float)((double)value / RMS));
                continue;
            }
            matrix.set(i, ExperimentNumber, value / Float.MIN_VALUE);
        }
    }

    private static void meanCenterExperiment(FloatMatrix matrix, int ExperimentNumber) {
        float value;
        int i;
        double Mean = 0.0;
        int n = matrix.getRowDimension();
        int validN = 0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(i, ExperimentNumber);
            if (Float.isNaN(value)) continue;
            Mean += (double)value;
            ++validN;
        }
        if (validN > 0) {
            Mean /= (double)validN;
        }
        for (i = 0; i < n; ++i) {
            value = matrix.get(i, ExperimentNumber);
            if (Float.isNaN(value)) continue;
            matrix.set(i, ExperimentNumber, (float)((double)value - Mean));
        }
    }

    private static void medianCenterExperiment(FloatMatrix matrix, int ExperimentNumber) {
        float value;
        int i;
        int n = matrix.getRowDimension();
        int k = 0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(i, ExperimentNumber);
            if (Float.isNaN(value)) continue;
            ++k;
        }
        float[] DummyArray = new float[k];
        k = 0;
        for (i = 0; i < n; ++i) {
            value = matrix.get(i, ExperimentNumber);
            if (Float.isNaN(value)) continue;
            DummyArray[k] = value;
            ++k;
        }
        Arrays.sort(DummyArray);
        float Median = 0.0f;
        if (k % 2 == 0) {
            if (k > 0) {
                Median = (float)(0.5 * (double)(DummyArray[k / 2 - 1] + DummyArray[k / 2]));
            }
        } else {
            Median = DummyArray[(k + 1) / 2 - 1];
        }
        for (i = 0; i < n; ++i) {
            value = matrix.get(i, ExperimentNumber);
            if (Float.isNaN(value)) continue;
            matrix.set(i, ExperimentNumber, value - Median);
        }
    }

    private static void makeDigitalExperiment(FloatMatrix matrix, int Experiment2) {
        int i;
        int n = matrix.getRowDimension();
        int NumberOfBins = (int)Math.floor(Math.log(n) / Math.log(2.0));
        int Step = 1000000 / NumberOfBins;
        float Minimum = Float.MAX_VALUE;
        float Maximum = 0.0f;
        for (i = 0; i < n; ++i) {
            if (!(matrix.get(i, Experiment2) < Minimum)) continue;
            Minimum = matrix.get(i, Experiment2);
        }
        for (i = 0; i < n; ++i) {
            matrix.set(i, Experiment2, matrix.get(i, Experiment2) - Minimum);
        }
        for (i = 0; i < n; ++i) {
            if (!(matrix.get(i, Experiment2) > Maximum)) continue;
            Maximum = matrix.get(i, Experiment2);
        }
        if (Maximum != 0.0f) {
            for (i = 0; i < n; ++i) {
                matrix.set(i, Experiment2, matrix.get(i, Experiment2) / Maximum);
            }
        }
        for (i = 0; i < n; ++i) {
            if ((double)matrix.get(i, Experiment2) == 1.0) {
                matrix.set(i, Experiment2, (float)NumberOfBins);
                continue;
            }
            matrix.set(i, Experiment2, (float)(Math.floor(matrix.get(i, Experiment2) * 1000000.0f / (float)Step) + 1.0));
        }
    }

    public static float getGeneMedian(ArrayList float_array) {
        Float median;
        Collections.sort(float_array);
        if (float_array.size() == 1) {
            return ((Float)float_array.get(0)).floatValue();
        }
        int center = float_array.size() / 2;
        if (float_array.size() % 2 == 0) {
            Float a = (Float)float_array.get(center);
            Float b = (Float)float_array.get(center - 1);
            median = new Float((a.floatValue() + b.floatValue()) / 2.0f);
        } else {
            median = (Float)float_array.get(center);
        }
        return median.floatValue();
    }
}

