/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.util;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.script.ScriptDocument;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.mev.script.scriptGUI.ScriptTreeRenderer;
import org.tigr.microarray.mev.script.util.AlgorithmNode;
import org.tigr.microarray.mev.script.util.AlgorithmSet;
import org.tigr.microarray.mev.script.util.DataNode;
import org.tigr.microarray.mev.script.util.ScriptNode;
import org.tigr.util.FloatMatrix;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ScriptTree
extends JTree {
    private ScriptDocument document;
    private ScriptManager manager;
    private ScriptTreeRenderer renderer = new ScriptTreeRenderer();
    private DataNode primaryDataRoot;
    private Hashtable dataNodeHash;
    private boolean resetWidth = true;

    public ScriptTree(ScriptDocument doc, ScriptManager manager) {
        super.setCellRenderer(this.renderer);
        super.setForeground(Color.black);
        super.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        BasicTreeUI basicTreeUI = (BasicTreeUI)this.getUI();
        basicTreeUI.setRightChildIndent(50);
        super.putClientProperty("JTree.lineStyle", "Angled");
        this.document = doc;
        this.manager = manager;
        this.dataNodeHash = new Hashtable();
        this.constructTree(this.document.getDocument());
        this.scrollAllToVisible();
    }

    public ScriptTree(ScriptTree tree) {
        super.setCellRenderer(this.renderer);
        super.setForeground(Color.black);
        super.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        BasicTreeUI basicTreeUI = (BasicTreeUI)this.getUI();
        basicTreeUI.setRightChildIndent(50);
        super.putClientProperty("JTree.lineStyle", "Angled");
        this.document = new ScriptDocument(tree.getDocument());
        this.manager = tree.getScriptManager();
        this.dataNodeHash = new Hashtable();
        this.constructTree(this.document.getDocument());
        this.scrollAllToVisible();
    }

    public ScriptDocument getDocument() {
        return this.document;
    }

    public ScriptManager getScriptManager() {
        return this.manager;
    }

    public ScriptTreeRenderer getScriptTreeRenderer() {
        return this.renderer;
    }

    public void highlightAlgSet(DataNode algSetRoot) {
        this.renderer.highlightAlgSet(algSetRoot);
    }

    public void clearHighlights() {
        this.renderer.clearHighlights();
    }

    public DataNode getPrimaryDataRoot() {
        return this.primaryDataRoot;
    }

    private void constructTree(Document doc) {
        Element root = doc.getDocumentElement();
        NodeList primaryData = doc.getElementsByTagName("primary_data");
        if (primaryData != null) {
            Element primaryDataElement = (Element)primaryData.item(0);
            this.primaryDataRoot = new DataNode(Integer.parseInt(primaryDataElement.getAttribute("id")), "Primary Data", "primary-data", primaryDataElement.getAttribute("type"));
            ((DefaultTreeModel)this.getModel()).setRoot(this.primaryDataRoot);
            this.dataNodeHash.put(primaryDataElement.getAttribute("id"), this.primaryDataRoot);
        }
        NodeList algSetList = doc.getElementsByTagName("alg_set");
        int numberOfSets = algSetList.getLength();
        int addedSets = 0;
        for (int index = 0; addedSets < numberOfSets && index < 100; ++index) {
            Element currAlgSet = this.getAlgSet(algSetList, index);
            if (currAlgSet == null) continue;
            this.addAlgSet(currAlgSet);
            ++addedSets;
        }
    }

    private boolean addAlgSet(Element algSet) {
        NodeList algList = algSet.getElementsByTagName("algorithm");
        int listLength = algList.getLength();
        int addCnt = 0;
        for (int index = 0; addCnt < listLength && index < 100; ++index) {
            Element currAlgorithm = this.getAlgorithmElement(algList, index);
            if (currAlgorithm == null) continue;
            this.addAlgorithm(currAlgorithm, algSet.getAttribute("input_data_ref"));
            ++addCnt;
        }
        return true;
    }

    private boolean addAlgorithm(Element algorithmElement, String dataRef) {
        int input_data_ref;
        int alg_id;
        String name = algorithmElement.getAttribute("alg_name");
        String alg_type = algorithmElement.getAttribute("alg_type");
        try {
            alg_id = Integer.parseInt(algorithmElement.getAttribute("alg_id"));
            input_data_ref = Integer.parseInt(algorithmElement.getAttribute("input_data_ref"));
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return false;
        }
        AlgorithmNode algNode = new AlgorithmNode(name, alg_id, input_data_ref, alg_type);
        AlgorithmData data = this.constructAlgorithmData(algorithmElement);
        algNode.setAlgorithmData(data);
        this.appendOutputNodes(algNode, algorithmElement);
        this.appendAlgorithmNode(algNode, dataRef);
        return true;
    }

    private void appendAlgorithmNode(AlgorithmNode node, String inputDataRef) {
        DataNode dataNode = (DataNode)this.dataNodeHash.get(inputDataRef);
        if (dataNode != null) {
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            model.insertNodeInto(node, dataNode, dataNode.getChildCount());
        } else {
            System.out.println("null data node can't append");
        }
    }

    private Element getAlgSet(NodeList setList, int id) {
        for (int i = 0; i < setList.getLength(); ++i) {
            if (!((Element)setList.item(i)).getAttribute("set_id").equals(String.valueOf(id))) continue;
            return (Element)setList.item(i);
        }
        return null;
    }

    private Element getAlgorithmElement(NodeList setList, int id) {
        for (int i = 0; i < setList.getLength(); ++i) {
            if (!((Element)setList.item(i)).getAttribute("alg_id").equals(String.valueOf(id))) continue;
            return (Element)setList.item(i);
        }
        return null;
    }

    public AlgorithmSet[] getAlgorithmSets() {
        DataNode root = (DataNode)this.getModel().getRoot();
        Experiment experiment = this.manager.getCurrentExperiment();
        Vector<AlgorithmSet> algSets = new Vector<AlgorithmSet>();
        Enumeration<TreeNode> _enum = root.breadthFirstEnumeration();
        while (_enum.hasMoreElements()) {
            ScriptNode node = (ScriptNode)_enum.nextElement();
            if (!(node instanceof DataNode) || node.isLeaf()) continue;
            AlgorithmSet set = new AlgorithmSet();
            if (node.getParent() == null) {
                set.setExperiment(experiment);
            }
            set.setDataNode((DataNode)node);
            for (int i = 0; i < node.getChildCount(); ++i) {
                ScriptNode childNode = (ScriptNode)node.getChildAt(i);
                if (!(childNode instanceof AlgorithmNode)) continue;
                set.addAlgorithmNode((AlgorithmNode)childNode);
            }
            algSets.add(set);
        }
        AlgorithmSet[] sets = new AlgorithmSet[algSets.size()];
        for (int i = 0; i < sets.length; ++i) {
            sets[i] = (AlgorithmSet)algSets.elementAt(i);
        }
        return sets;
    }

    public DataNode getDataNodeNamed(String name) {
        DataNode root = (DataNode)this.getModel().getRoot();
        Enumeration<TreeNode> _enum = root.breadthFirstEnumeration();
        boolean found = false;
        ScriptNode node = null;
        while (!found && _enum.hasMoreElements()) {
            node = (ScriptNode)_enum.nextElement();
            if (!node.toString().equals(name)) continue;
            found = true;
        }
        return (DataNode)node;
    }

    private AlgorithmData constructAlgorithmData(Element algElement) {
        AlgorithmData data = new AlgorithmData();
        NodeList list = algElement.getElementsByTagName("plist");
        if (list != null && list.getLength() > 0) {
            this.appendParameters(data, (Element)list.item(0));
        }
        if ((list = algElement.getElementsByTagName("mlist")) != null && list.getLength() > 0) {
            this.appendMatrices(data, (Element)list.item(0));
        }
        return data;
    }

    private void appendParameters(AlgorithmData data, Element plist) {
        NodeList parameters = plist.getElementsByTagName("param");
        for (int i = 0; i < parameters.getLength(); ++i) {
            Element currParam = (Element)parameters.item(i);
            String key = currParam.getAttribute("key");
            String value = currParam.getAttribute("value");
            data.addParam(key, value);
        }
    }

    private void appendMatrices(AlgorithmData data, Element mlist) {
        NodeList matrices = mlist.getElementsByTagName("matrix");
        for (int i = 0; i < matrices.getLength(); ++i) {
            this.addMatrix(data, (Element)matrices.item(i));
        }
    }

    private void addMatrix(AlgorithmData data, Element matrixElement) {
        int col_dim_int;
        int row_dim_int;
        String name = matrixElement.getAttribute("name");
        String type = matrixElement.getAttribute("type");
        String row_dim = matrixElement.getAttribute("row_dim");
        String col_dim = matrixElement.getAttribute("col_dim");
        try {
            row_dim_int = Integer.parseInt(row_dim);
            col_dim_int = Integer.parseInt(col_dim);
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return;
        }
        NodeList elements = matrixElement.getElementsByTagName("element");
        int n = elements.getLength();
        if (type.equalsIgnoreCase("int-array")) {
            int[] values = new int[n];
            for (int i = 0; i < n; ++i) {
                Element element = (Element)elements.item(i);
                values[Integer.parseInt((String)element.getAttribute((String)"row"))] = Integer.parseInt(element.getAttribute("value"));
            }
            data.addIntArray(name, values);
        } else if (type.equalsIgnoreCase("FloatMatrix")) {
            FloatMatrix fm = new FloatMatrix(row_dim_int, col_dim_int);
            if (n == row_dim_int * col_dim_int) {
                for (int i = 0; i < n; ++i) {
                    Element element = (Element)elements.item(i);
                    int x = Integer.parseInt(element.getAttribute("row"));
                    int y = Integer.parseInt(element.getAttribute("col"));
                    float value = Float.parseFloat(element.getAttribute("value"));
                    fm.set(x, y, value);
                }
                data.addMatrix(name, fm);
            }
        } else if (type.equalsIgnoreCase("String-array")) {
            String[] values = new String[n];
            for (int i = 0; i < n; ++i) {
                Element element = (Element)elements.item(i);
                values[Integer.parseInt((String)element.getAttribute((String)"row"))] = element.getAttribute("value");
            }
            data.addStringArray(name, values);
        }
    }

    private void appendOutputNodes(AlgorithmNode node, Element algElement) {
        NodeList list = algElement.getElementsByTagName("output_data");
        if (list == null || list.getLength() < 1) {
            return;
        }
        Element outputElement = (Element)list.item(0);
        String output_class = outputElement.getAttribute("output_class");
        list = outputElement.getElementsByTagName("data_node");
        for (int i = 0; i < list.getLength(); ++i) {
            outputElement = (Element)list.item(i);
            int dataID = Integer.parseInt(outputElement.getAttribute("data_node_id"));
            DataNode dataNode = new DataNode(dataID, outputElement.getAttribute("name"), output_class);
            this.dataNodeHash.put(String.valueOf(dataID), dataNode);
            node.add(dataNode);
        }
    }

    public boolean setDataRoot(DataNode node) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.setRoot(node);
        return true;
    }

    public ScriptNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        ScriptNode node = (ScriptNode)path.getLastPathComponent();
        return node;
    }

    public void scrollAllToVisible() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        Enumeration<TreeNode> _enum = node.depthFirstEnumeration();
        while (_enum.hasMoreElements()) {
            node = (DefaultMutableTreeNode)_enum.nextElement();
            if (!node.isLeaf()) continue;
            Object[] visPath = node.getPath();
            TreePath path = new TreePath(visPath);
            this.scrollPathToVisible(path);
        }
    }

    public void addNewAlgorithmToDataNode(DataNode parentNode) {
        String outputClass = parentNode.getDataOutputClass();
        AlgorithmData data = this.manager.getAlgorithm(outputClass);
        if (data != null) {
            if (this.document.appendAlgorithm(data, parentNode.getID())) {
                try {
                    this.updateTree();
                    this.scrollAllToVisible();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("doc base didn't append");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAlgorithm(AlgorithmData data, DataNode parentNode) {
        ScriptTree scriptTree = this;
        synchronized (scriptTree) {
            if (data != null) {
                if (this.document.appendAlgorithm(data, parentNode.getID())) {
                    try {
                        this.updateTree();
                        this.scrollAllToVisible();
                        this.validate();
                        this.validateTree();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    System.out.println("doc base didn't append");
                }
            }
        }
    }

    public void updateTree() {
        ((DefaultTreeModel)this.getModel()).setRoot(null);
        this.constructTree(this.document.getDocument());
        this.scrollAllToVisible();
    }

    public void removeAlgorithm(AlgorithmNode node) {
        this.document.removeAlgorithm(node);
    }

    private class Builder
    implements Runnable {
        DataNode parentNode;
        AlgorithmData data;

        public Builder(DataNode p, AlgorithmData d) {
            this.parentNode = p;
            this.data = d;
        }

        @Override
        public void run() {
            if (ScriptTree.this.document.appendAlgorithm(this.data, this.parentNode.getID())) {
                try {
                    ScriptTree.this.updateTree();
                    ScriptTree.this.scrollAllToVisible();
                    ScriptTree.this.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("doc base didn't append");
            }
        }
    }
}

