/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.util;

import java.awt.Frame;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.tigr.microarray.mev.ResultTree;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.action.ActionManager;
import org.tigr.microarray.mev.action.AnalysisAction;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.script.Script;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.microarray.mev.script.scriptGUI.ScriptCentroidViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptCentroidsViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptClusterSelectionInfoViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptExperimentCentroidViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptExperimentCentroidsViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptExperimentClusterViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptExperimentViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptTreeViewer;
import org.tigr.microarray.mev.script.util.AlgorithmNode;
import org.tigr.microarray.mev.script.util.AlgorithmSet;
import org.tigr.microarray.mev.script.util.DataNode;
import org.tigr.microarray.mev.script.util.ScriptDataTransformer;
import org.tigr.microarray.mev.script.util.ScriptTree;
import org.tigr.util.FloatMatrix;

public class ScriptRunner {
    private Script script;
    private ScriptTree scriptTree;
    private Frame parentFrame;
    private ActionManager actionManager;
    private IFramework framework;
    private Hashtable classHash;
    private AlgorithmSet[] algSets;
    private int mode;

    public ScriptRunner(Script script, ActionManager actionManager, IFramework framework) {
        this.script = script;
        this.scriptTree = script.getScriptTree();
        this.actionManager = actionManager;
        this.framework = framework;
        this.mode = 0;
        this.parentFrame = framework.getFrame();
        this.classHash = this.getClassNames();
    }

    public void setOutputMode(int outputMode) {
        this.mode = outputMode;
    }

    public void execute(int outputMode) {
        this.mode = outputMode;
        Thread thread = new Thread(new Runner());
        thread.start();
    }

    public void execute() {
        Thread thread = new Thread(new Runner());
        thread.start();
    }

    private DefaultMutableTreeNode execute(AlgorithmSet set) {
        Experiment experiment = set.getExperiment();
        if (experiment == null) {
            DefaultMutableTreeNode emptyNode = new DefaultMutableTreeNode("No Result (empty input data node)");
            return emptyNode;
        }
        int algCount = set.getAlgorithmCount();
        DefaultMutableTreeNode currNode = null;
        DefaultMutableTreeNode outputNode = null;
        if (this.mode == 1) {
            JFileChooser chooser = new JFileChooser(TMEV.getFile("data/"));
            if (chooser.showOpenDialog(this.parentFrame) == 0) {
                File outputFile = chooser.getSelectedFile();
            } else {
                return null;
            }
        }
        if (algCount > 0) {
            // empty if block
        }
        for (int i = 0; i < algCount; ++i) {
            AlgorithmNode algNode = set.getAlgorithmNodeAt(i);
            AlgorithmData data = algNode.getAlgorithmData();
            String algName = algNode.getAlgorithmName();
            String algType = algNode.getAlgorithmType();
            if (algType.equals("cluster") || algType.equals("cluster-genes") || algType.equals("cluster-experiments") || algType.equals("data-visualization")) {
                String className = (String)this.classHash.get(algName);
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = Class.forName(className, true, cl);
                    IScriptGUI gui = (IScriptGUI)clazz.newInstance();
                    currNode = gui.executeScript(this.framework, data, experiment);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.parentFrame, "Can't execute script " + algName + " algorithm", "Script Parameter Error", 2);
                    e.printStackTrace();
                }
                if (currNode == null) continue;
                if (outputNode == null) {
                    outputNode = new DefaultMutableTreeNode("Results");
                }
                outputNode.add(currNode);
                this.attachResultToChildAlgorithmSets(algNode, experiment, this.extractClusters(currNode));
                continue;
            }
            if (algType.equals("data-adjustment")) {
                data.addParam("name", algName);
                ScriptDataTransformer adjuster = new ScriptDataTransformer(experiment, this.framework);
                Experiment resultExperiment = adjuster.transformData(data);
                int[][] clusters = new int[][]{this.getDefaultGeneIndices(resultExperiment.getNumberOfGenes())};
                this.attachResultToChildAlgorithmSets(algNode, resultExperiment, clusters);
                if (outputNode == null) {
                    outputNode = new DefaultMutableTreeNode("Results");
                }
                DefaultMutableTreeNode resultNode = this.getViewerNodes(resultExperiment);
                resultNode.setUserObject("Data Adjustment: " + algName);
                outputNode.add(resultNode);
                continue;
            }
            if (!algType.equals("cluster-selection")) continue;
            data.addParam("name", algName);
            ScriptDataTransformer selector = new ScriptDataTransformer(experiment, this.framework);
            int[][] selectedClusters = selector.selectClusters(data, set.getClusters());
            this.attachResultToChildAlgorithmSets(algNode, experiment, selectedClusters);
            boolean areGeneClusters = data.getParams().getBoolean("process-gene-clusters");
            DefaultMutableTreeNode node = this.getSelectedClusterViewers(data, experiment, selectedClusters, areGeneClusters);
            if (outputNode == null) {
                outputNode = new DefaultMutableTreeNode("Results");
            }
            outputNode.add(node);
        }
        return outputNode;
    }

    private DefaultMutableTreeNode getViewerNodes(Experiment experiment) {
        DefaultMutableTreeNode viewerNode = new DefaultMutableTreeNode("Input Data Viewers");
        int[][] cluster = new int[][]{this.getDefaultGeneIndices(experiment.getNumberOfGenes())};
        DefaultMutableTreeNode currNode = new DefaultMutableTreeNode(new LeafInfo("Expression Image", (IViewer)new ScriptExperimentViewer(experiment, cluster)));
        viewerNode.add(currNode);
        FloatMatrix matrix = experiment.getMatrix();
        FloatMatrix means = this.getMeans(matrix, cluster);
        FloatMatrix vars = this.getVariances(matrix, means, cluster);
        ScriptCentroidViewer viewer = new ScriptCentroidViewer(experiment, cluster);
        viewer.setMeans(means.A);
        viewer.setVariances(vars.A);
        currNode = new DefaultMutableTreeNode(new LeafInfo("Centroid Graph", (IViewer)viewer, (Object)new CentroidUserObject(0, 0)));
        viewerNode.add(currNode);
        currNode = new DefaultMutableTreeNode(new LeafInfo("Expression Graph", (IViewer)viewer, (Object)new CentroidUserObject(0, 1)));
        viewerNode.add(currNode);
        return viewerNode;
    }

    private Hashtable getClassNames() {
        AnalysisAction action;
        Hashtable<String, String> hash = new Hashtable<String, String>();
        int algCnt = 0;
        while ((action = (AnalysisAction)this.actionManager.getAction("analysis-action" + String.valueOf(algCnt))) != null) {
            String algName = (String)action.getValue("Name");
            String className = (String)action.getValue("command-parameter");
            hash.put(algName, className);
            ++algCnt;
        }
        return hash;
    }

    private FloatMatrix getMeans(FloatMatrix data, int[][] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, data.getColumnDimension());
        for (int i = 0; i < clusters.length; ++i) {
            means.A[i] = this.getMeans(data, clusters[i]);
        }
        return means;
    }

    private float[] getMeans(FloatMatrix data, int[] indices) {
        int nSamples = data.getColumnDimension();
        float[] means = new float[nSamples];
        float sum = 0.0f;
        float n = 0.0f;
        for (int i = 0; i < nSamples; ++i) {
            n = 0.0f;
            sum = 0.0f;
            for (int j = 0; j < indices.length; ++j) {
                float value = data.get(indices[j], i);
                if (Float.isNaN(value)) continue;
                sum += value;
                n += 1.0f;
            }
            means[i] = n > 0.0f ? sum / n : Float.NaN;
        }
        return means;
    }

    private FloatMatrix getVariances(FloatMatrix data, FloatMatrix means, int[][] clusters) {
        int nSamples = data.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(clusters.length, nSamples);
        for (int i = 0; i < clusters.length; ++i) {
            variances.A[i] = this.getVariances(data, means, clusters[i], i);
        }
        return variances;
    }

    private float[] getVariances(FloatMatrix data, FloatMatrix means, int[] indices, int clusterIndex) {
        int nSamples = data.getColumnDimension();
        float[] variances = new float[nSamples];
        float sse = 0.0f;
        int n = 0;
        for (int i = 0; i < nSamples; ++i) {
            float mean = means.get(clusterIndex, i);
            n = 0;
            sse = 0.0f;
            for (int j = 0; j < indices.length; ++j) {
                float value = data.get(indices[j], i);
                if (Float.isNaN(value)) continue;
                sse += (float)Math.pow(value - mean, 2.0);
                ++n;
            }
            variances[i] = n > 1 ? (float)Math.sqrt(sse / (float)(n - 1)) : 0.0f;
        }
        return variances;
    }

    private int[] getDefaultGeneIndices(int length) {
        int[] indices = new int[length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        return indices;
    }

    private void attachResultToChildAlgorithmSets(AlgorithmNode algNode, Experiment experiment, int[][] clusters) {
        int outputCount = algNode.getChildCount();
        for (int i = 0; i < outputCount; ++i) {
            DataNode dataNode = (DataNode)algNode.getChildAt(i);
            for (int j = 0; j < this.algSets.length; ++j) {
                if (dataNode != this.algSets[j].getDataNode()) continue;
                if (!(dataNode.getDataOutputClass().equals("multi-cluster-output") || dataNode.getDataOutputClass().equals("multi-gene-cluster-output") || dataNode.getDataOutputClass().equals("multi-experiment-cluster-output"))) {
                    if (i >= clusters.length) continue;
                    if (algNode.getAlgorithmType().equals("cluster-experiments")) {
                        this.setExperiment(this.algSets[j], experiment, clusters[i], false);
                        continue;
                    }
                    this.setExperiment(this.algSets[j], experiment, clusters[i], true);
                    continue;
                }
                this.setExperimentAndClusters(this.algSets[j], experiment, clusters, algNode);
            }
        }
    }

    private void setExperiment(AlgorithmSet algSet, Experiment experiment, int[] indices, boolean geneReduction) {
        ScriptDataTransformer transformer = new ScriptDataTransformer(experiment, this.framework);
        Experiment trimmedExperiment = transformer.getTrimmedExperiment(indices, geneReduction);
        algSet.setExperiment(trimmedExperiment);
    }

    private void setExperimentAndClusters(AlgorithmSet algSet, Experiment experiment, int[][] clusters, AlgorithmNode algNode) {
        algSet.setExperiment(experiment);
        algSet.setClusters(clusters);
        if (algNode.getAlgorithmType().equals("cluster-genes")) {
            algSet.setClusterType(0);
        } else {
            algSet.setClusterType(1);
        }
    }

    private int[][] extractClusters(DefaultMutableTreeNode analysisNode) {
        Enumeration<TreeNode> _enum = analysisNode.depthFirstEnumeration();
        while (_enum.hasMoreElements()) {
            IViewer viewer;
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)_enum.nextElement();
            if (!(currentNode.getUserObject() instanceof LeafInfo) || (viewer = ((LeafInfo)currentNode.getUserObject()).getViewer()) == null) continue;
            Experiment exp = viewer.getExperiment();
            int[][] clusters = viewer.getClusters();
            if (exp == null || clusters == null) continue;
            return clusters;
        }
        return null;
    }

    private DefaultMutableTreeNode getSelectedClusterViewers(AlgorithmData data, Experiment experiment, int[][] clusters, boolean areGeneClusters) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Selection Results");
        this.addExpressionImages(node, experiment, clusters, areGeneClusters);
        this.addCentroidViews(node, experiment, clusters, areGeneClusters);
        this.addSelectionInfoViewer(node, data);
        return node;
    }

    private void addExpressionImages(DefaultMutableTreeNode root, Experiment experiment, int[][] clusters, boolean clusterGenes) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        Object expViewer = clusterGenes ? new ScriptExperimentViewer(experiment, clusters) : new ScriptExperimentClusterViewer(experiment, clusters);
        for (int i = 0; i < clusters.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    private void addCentroidViews(DefaultMutableTreeNode root, Experiment experiment, int[][] clusters, boolean clusterGenes) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        FloatMatrix matrix = experiment.getMatrix();
        if (!clusterGenes) {
            matrix = matrix.transpose();
        }
        FloatMatrix means = this.getMeans(matrix, clusters);
        FloatMatrix variances = this.getVariances(matrix, means, clusters);
        if (!clusterGenes) {
            matrix = matrix.transpose();
        }
        if (clusterGenes) {
            ScriptCentroidViewer centroidViewer = new ScriptCentroidViewer(experiment, clusters);
            centroidViewer.setMeans(means.A);
            centroidViewer.setVariances(variances.A);
            for (int i = 0; i < clusters.length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            ScriptCentroidsViewer centroidsViewer = new ScriptCentroidsViewer(experiment, clusters);
            centroidsViewer.setMeans(means.A);
            centroidsViewer.setVariances(variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(1))));
        } else {
            ScriptExperimentCentroidViewer expCentroidViewer = new ScriptExperimentCentroidViewer(experiment, clusters);
            expCentroidViewer.setMeans(means.A);
            expCentroidViewer.setVariances(variances.A);
            for (int i = 0; i < clusters.length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            ScriptExperimentCentroidsViewer expCentroidsViewer = new ScriptExperimentCentroidsViewer(experiment, clusters);
            expCentroidsViewer.setMeans(means.A);
            expCentroidsViewer.setVariances(variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(1))));
        }
        root.add(centroidNode);
        root.add(expressionNode);
    }

    private void addSelectionInfoViewer(DefaultMutableTreeNode root, AlgorithmData data) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new LeafInfo("Selection Information", (IViewer)new ScriptClusterSelectionInfoViewer(data)));
        root.add(node);
    }

    static /* synthetic */ AlgorithmSet[] access$102(ScriptRunner x0, AlgorithmSet[] x1) {
        x0.algSets = x1;
        return x1;
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            ScriptRunner.access$102(ScriptRunner.this, ScriptRunner.this.scriptTree.getAlgorithmSets());
            boolean haveResult = false;
            DefaultMutableTreeNode scriptResultNode = new DefaultMutableTreeNode("Script Result");
            if (ScriptRunner.this.algSets.length > 0) {
                // empty if block
            }
            for (int i = 0; i < ScriptRunner.this.algSets.length; ++i) {
                DefaultMutableTreeNode currNode;
                DefaultMutableTreeNode resultNode;
                AlgorithmSet set = ScriptRunner.this.algSets[i];
                if (set.getAlgorithmCount() <= 0 || (resultNode = ScriptRunner.this.execute(set)) == null) continue;
                Experiment experiment = set.getExperiment();
                haveResult = true;
                DefaultMutableTreeNode setNode = new DefaultMutableTreeNode("Algorithm Set");
                DefaultMutableTreeNode dataNode = new DefaultMutableTreeNode("Input Data");
                ScriptTree copyTree = new ScriptTree(ScriptRunner.this.scriptTree);
                DefaultMutableTreeNode algSetViewerNode = new DefaultMutableTreeNode(new LeafInfo("Script Tree", (IViewer)new ScriptTreeViewer(copyTree, ScriptRunner.this.scriptTree.getScriptManager(), set.getDataNode())));
                DataNode inputNode = set.getDataNode();
                AlgorithmNode inputAlgNode = (AlgorithmNode)inputNode.getParent();
                if (inputAlgNode != null) {
                    currNode = new DefaultMutableTreeNode("Algorithm Source: " + inputAlgNode.getAlgorithmName() + " [" + inputAlgNode.getDataNodeRef() + "," + inputAlgNode.getID() + "] ");
                    dataNode.add(currNode);
                }
                currNode = new DefaultMutableTreeNode("Input Data Node: " + inputNode.toString());
                dataNode.add(currNode);
                if (experiment != null) {
                    currNode = new DefaultMutableTreeNode("Number of Experiments: " + experiment.getNumberOfSamples());
                    dataNode.add(currNode);
                    currNode = new DefaultMutableTreeNode("Number of Genes: " + experiment.getNumberOfGenes());
                    dataNode.add(currNode);
                    currNode = ScriptRunner.this.getViewerNodes(set.getExperiment());
                    dataNode.add(currNode);
                } else {
                    currNode = new DefaultMutableTreeNode("Number of Experiments: 0, null input data");
                    dataNode.add(currNode);
                    currNode = new DefaultMutableTreeNode("Number of Genes: 0, null input data");
                    dataNode.add(currNode);
                }
                setNode.add(algSetViewerNode);
                setNode.add(dataNode);
                setNode.add(resultNode);
                scriptResultNode.add(setNode);
            }
            ResultTree tree = ScriptRunner.this.framework.getResultTree();
            ScriptRunner.this.framework.addAnalysisResult(scriptResultNode);
            tree.scrollPathToVisible(new TreePath(((DefaultTreeModel)tree.getModel()).getPathToRoot(scriptResultNode)));
        }
    }
}

