/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class ScriptParser {
    Document doc;
    String lineSeparator = "\n\n";
    String indent = "   ";

    public void printValues(String fileName) throws Exception {
        File file = new File(fileName);
        DOMParser parser = new DOMParser();
        parser.parse(file.toURI().toURL().toString());
        this.doc = parser.getDocument();
        Element analysis = this.doc.getDocumentElement();
        NodeList algSets = analysis.getElementsByTagNameNS("", "alg_set");
        for (int i = 0; i < algSets.getLength(); ++i) {
            Node node;
            Element algSet = (Element)algSets.item(i);
            NodeIterator algorithmIterator = ((DocumentTraversal)((Object)this.doc)).createNodeIterator(algSet, -1, null, true);
            while ((node = algorithmIterator.nextNode()) != null) {
                if (node.getNodeType() == 1) {
                    System.out.println("Node name = " + node.getNodeName());
                } else if (node.getNodeType() == 3) {
                    System.out.println("Value = " + node.getNodeValue());
                }
                System.out.println("=========================");
            }
        }
    }

    public void writeDocument(String fileName) throws IOException {
        FileWriter writer = new FileWriter(fileName);
        this.serialize(this.doc, writer);
        writer.flush();
        writer.close();
    }

    private void serialize(Document doc, Writer writer) throws IOException {
        this.serializeNode(doc, writer, "");
    }

    private void serializeNode(Node node, Writer writer, String indentLevel) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                writer.write("<?xml version=\"1.0\"?>");
                writer.write(this.lineSeparator);
                Document doc = (Document)node;
                this.serializeNode(doc.getDocumentElement(), writer, " ");
                break;
            }
            case 1: {
                String name = node.getNodeName();
                writer.write(indentLevel + "<" + name);
                writer.write(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    if (children.item(0) != null && children.item(0).getNodeType() == 1) {
                        writer.write(this.lineSeparator);
                    }
                    for (int i = 0; i < children.getLength(); ++i) {
                        this.serializeNode(children.item(i), writer, indentLevel + this.indent);
                    }
                    if (children.item(0) != null && children.item(children.getLength() - 1).getNodeType() == 1) {
                        writer.write(indentLevel);
                    }
                }
                writer.write("</" + name + ">");
                writer.write(this.lineSeparator);
                break;
            }
            case 3: {
                writer.write(node.getNodeValue());
                break;
            }
        }
    }

    public static void main(String[] args) {
        ScriptParser sp = new ScriptParser();
        try {
            sp.printValues("c:/Temp/script.xml");
            sp.writeDocument("c:/Temp/result_script.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

