/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.util;

import java.util.Arrays;
import java.util.Vector;
import org.tigr.microarray.mev.DetectionFilter;
import org.tigr.microarray.mev.FoldFilter;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.util.Adjustment;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class ScriptDataTransformer {
    private Experiment experiment;
    private IFramework framework;

    public ScriptDataTransformer(Experiment experiment, IFramework framework) {
        this.experiment = experiment.copy();
        this.framework = framework;
    }

    public Experiment transformData(AlgorithmData data) {
        AlgorithmParameters params = data.getParams();
        String algName = params.getString("name");
        if (algName == null) {
            return null;
        }
        if (algName.equals("Percentage Cutoff")) {
            float percent = params.getFloat("percent-cutoff");
            this.experiment = this.createPercentCutoffExperiment(percent);
        } else if (algName.equals("Lower Cutoff")) {
            float cy3Cutoff = params.getFloat("cy3-lower-cutoff");
            float cy5Cutoff = params.getFloat("cy5-lower-cutoff");
        } else if (algName.equals("Affy Detection Filter")) {
            this.experiment = this.applyAffyDetectionFilter(data);
        } else if (algName.equals("Affy Fold Filter")) {
            this.experiment = this.applyAffyFoldFilter(data);
        } else if (algName.equals("Normalize Spots")) {
            Adjustment.normalizeSpots(this.experiment.getMatrix());
        } else if (algName.equals("Divide Spots by RMS")) {
            Adjustment.divideSpotsRMS(this.experiment.getMatrix());
        } else if (algName.equals("Divide Spots by SD")) {
            Adjustment.divideSpotsSD(this.experiment.getMatrix());
        } else if (algName.equals("Mean Center Spots")) {
            Adjustment.meanCenterSpots(this.experiment.getMatrix());
        } else if (algName.equals("Median Center Spots")) {
            Adjustment.medianCenterSpots(this.experiment.getMatrix());
        } else if (algName.equals("Digital Spots")) {
            Adjustment.digitalSpots(this.experiment.getMatrix());
        } else if (algName.equals("Normalize Experiments")) {
            Adjustment.normalizeExperiments(this.experiment.getMatrix());
        } else if (algName.equals("Divide Experiments by RMS")) {
            Adjustment.divideExperimentsRMS(this.experiment.getMatrix());
        } else if (algName.equals("Divide Experiments by SD")) {
            Adjustment.divideExperimentsSD(this.experiment.getMatrix());
        } else if (algName.equals("Mean Center Experiments")) {
            Adjustment.meanCenterExperiments(this.experiment.getMatrix());
        } else if (algName.equals("Median Center Experiments")) {
            Adjustment.medianCenterExperiments(this.experiment.getMatrix());
        } else if (algName.equals("Digital Experiments")) {
            Adjustment.digitalExperiments(this.experiment.getMatrix());
        }
        return this.experiment;
    }

    private Experiment createPercentCutoffExperiment(float percent) {
        FloatMatrix fm = this.experiment.getMatrix();
        int[] origRowMap = this.experiment.getRowMappingArrayCopy();
        int colCount = fm.getColumnDimension();
        int validExperimentCount = (int)((float)colCount * (percent / 100.0f));
        boolean[] isValid = new boolean[fm.getRowDimension()];
        int validCount = 0;
        block0: for (int i = 0; i < isValid.length; ++i) {
            int cnt = 0;
            for (int j = 0; j < colCount; ++j) {
                if (!Float.isNaN(fm.A[i][j])) {
                    ++cnt;
                }
                if (cnt <= validExperimentCount) continue;
                isValid[i] = true;
                ++validCount;
                continue block0;
            }
        }
        float[][] matrix = new float[validCount][colCount];
        int[] newRowMap = new int[validCount];
        int currRow = 0;
        for (int i = 0; i < fm.A.length; ++i) {
            if (!isValid[i]) continue;
            newRowMap[currRow] = origRowMap[i];
            for (int j = 0; j < colCount; ++j) {
                matrix[currRow][j] = fm.A[i][j];
            }
            ++currRow;
        }
        return new Experiment(new FloatMatrix(matrix), this.experiment.getColumnIndicesCopy(), newRowMap);
    }

    public Experiment getTrimmedExperiment(int[] indices, boolean geneCut) {
        if (geneCut) {
            return this.getReducedExperiment_GeneReduction(indices);
        }
        return this.getReducedExperiment_ExperimentReduction(indices);
    }

    private Experiment getReducedExperiment_GeneReduction(int[] indices) {
        FloatMatrix fm = this.experiment.getMatrix();
        int[] origRowMap = this.experiment.getRowMappingArrayCopy();
        int colCount = fm.getColumnDimension();
        float[][] matrix = new float[indices.length][colCount];
        int[] newRowMap = new int[indices.length];
        boolean currRow = false;
        int dataRow = 0;
        for (int i = 0; i < indices.length; ++i) {
            newRowMap[i] = dataRow = origRowMap[indices[i]];
            for (int j = 0; j < colCount; ++j) {
                matrix[i][j] = fm.A[indices[i]][j];
            }
        }
        return new Experiment(new FloatMatrix(matrix), this.experiment.getColumnIndicesCopy(), newRowMap);
    }

    private Experiment getReducedExperiment_ExperimentReduction(int[] colIndices) {
        FloatMatrix fm = this.experiment.getMatrix();
        int rowCount = fm.getRowDimension();
        float[][] matrix = new float[rowCount][colIndices.length];
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colIndices.length; ++j) {
                matrix[i][j] = fm.A[i][colIndices[j]];
            }
        }
        return new Experiment(new FloatMatrix(matrix), colIndices, this.experiment.getRowMappingArrayCopy());
    }

    public int[][] selectClusters(AlgorithmData algData, int[][] clusters) {
        int[][] selectedClusters;
        AlgorithmParameters params = algData.getParams();
        int numOfDesiredClusters = params.getInt("desired-cluster-count");
        int minClusterSize = params.getInt("minimum-cluster-size");
        boolean areGeneClusters = params.getBoolean("process-gene-clusters");
        String algName = params.getString("name");
        if (algName.equals("Diversity Ranking Cluster Selection")) {
            int i;
            int function = params.getInt("distance-function");
            boolean useAbsolute = params.getBoolean("use-absolute");
            boolean useCentroidBasedDiversity = params.getBoolean("use-centroid-based-variability");
            int[][] orderedClusters = this.getClustersBasedOnDiversityRank(algData, this.experiment.getMatrix(), clusters, areGeneClusters, useCentroidBasedDiversity, function, useAbsolute);
            int clusterCount = 0;
            Vector<int[]> clusterVector = new Vector<int[]>();
            for (i = 0; i < orderedClusters.length && clusterCount < numOfDesiredClusters; ++i) {
                if (orderedClusters[i].length < minClusterSize) continue;
                clusterVector.add(orderedClusters[i]);
                ++clusterCount;
            }
            selectedClusters = new int[clusterVector.size()][];
            for (i = 0; i < selectedClusters.length; ++i) {
                selectedClusters[i] = (int[])clusterVector.elementAt(i);
            }
        } else {
            int i;
            boolean useCentroidVariance;
            FloatMatrix matrix = this.experiment.getMatrix();
            if (!areGeneClusters) {
                matrix = matrix.transpose();
            }
            FloatMatrix means = this.getMeans(matrix, clusters);
            if (!areGeneClusters) {
                matrix = matrix.transpose();
            }
            int[][] orderedClusters = (useCentroidVariance = params.getBoolean("use-centroid-variance")) ? this.getClustersBasedOnVarianceRank(algData, means, clusters, areGeneClusters) : this.getClustersBasedOnEntropyRank(algData, means, clusters, areGeneClusters);
            int clusterCount = 0;
            Vector<int[]> clusterVector = new Vector<int[]>();
            for (i = 0; i < orderedClusters.length && clusterCount < numOfDesiredClusters; ++i) {
                if (orderedClusters[i].length < minClusterSize) continue;
                clusterVector.add(orderedClusters[i]);
                ++clusterCount;
            }
            selectedClusters = new int[clusterVector.size()][];
            for (i = 0; i < selectedClusters.length; ++i) {
                selectedClusters[i] = (int[])clusterVector.elementAt(i);
            }
        }
        return selectedClusters;
    }

    private int[][] getClustersBasedOnDiversityRank(AlgorithmData algData, FloatMatrix data, int[][] inputClusters, boolean geneClusters, boolean useCentroids, int function, boolean absolute) {
        float[] diversities;
        int[][] newClusters = new int[inputClusters.length][];
        if (!geneClusters) {
            data = data.transpose();
        }
        if (useCentroids) {
            FloatMatrix means = this.getMeans(data, inputClusters);
            diversities = this.getCentroidBasedDiversities(data, means, inputClusters, function, absolute);
        } else {
            diversities = this.getGeneBasedDiversities(data, inputClusters, function, absolute);
        }
        QSort sort = new QSort(diversities);
        diversities = sort.getSorted();
        int[] origOrder = sort.getOrigIndx();
        for (int i = 0; i < newClusters.length; ++i) {
            newClusters[i] = inputClusters[origOrder[i]];
        }
        String[] diversityArray = new String[diversities.length];
        String[] clusterPop = new String[diversities.length];
        for (int i = 0; i < diversities.length; ++i) {
            diversityArray[i] = String.valueOf(diversities[i]);
            clusterPop[i] = String.valueOf(newClusters[i].length);
        }
        algData.addStringArray("diversity-value-array", diversityArray);
        algData.addStringArray("cluster-population-array", clusterPop);
        if (!geneClusters) {
            data = data.transpose();
        }
        return newClusters;
    }

    private FloatMatrix getMeans(FloatMatrix data, int[][] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, data.getColumnDimension());
        for (int i = 0; i < clusters.length; ++i) {
            means.A[i] = this.getMeans(data, clusters[i]);
        }
        return means;
    }

    private float[] getMeans(FloatMatrix data, int[] indices) {
        int nSamples = data.getColumnDimension();
        float[] means = new float[nSamples];
        float sum = 0.0f;
        float n = 0.0f;
        for (int i = 0; i < nSamples; ++i) {
            n = 0.0f;
            sum = 0.0f;
            for (int j = 0; j < indices.length; ++j) {
                float value = data.get(indices[j], i);
                if (Float.isNaN(value)) continue;
                sum += value;
                n += 1.0f;
            }
            means[i] = n > 0.0f ? sum / n : Float.NaN;
        }
        return means;
    }

    private float[] getCentroidBasedDiversities(FloatMatrix data, FloatMatrix means, int[][] clusters, int function, boolean absolute) {
        float[] div = new float[clusters.length];
        for (int i = 0; i < div.length; ++i) {
            div[i] = 0.0f;
            for (int j = 0; j < clusters[i].length; ++j) {
                int n = i;
                div[n] = div[n] + ExperimentUtil.geneDistance((FloatMatrix)means, (FloatMatrix)data, (int)i, (int)clusters[i][j], (int)function, (float)1.0f, (boolean)absolute);
            }
            int n = i;
            div[n] = div[n] / (float)clusters[i].length;
        }
        return div;
    }

    private float[] getGeneBasedDiversities(FloatMatrix data, int[][] clusters, int function, boolean absolute) {
        float[] div = new float[clusters.length];
        for (int i = 0; i < div.length; ++i) {
            div[i] = 0.0f;
            for (int j = 0; j < clusters[i].length; ++j) {
                for (int k = 0; k < clusters[i].length / 2; ++k) {
                    int n = i;
                    div[n] = div[n] + ExperimentUtil.geneDistance((FloatMatrix)data, (FloatMatrix)data, (int)clusters[i][j], (int)clusters[i][k], (int)function, (float)1.0f, (boolean)absolute);
                }
            }
            int n = i;
            div[n] = (float)((double)div[n] / (Math.pow(clusters[i].length, 2.0) / 2.0 - (double)(clusters[i].length / 2)));
        }
        return div;
    }

    private int[][] getClustersBasedOnVarianceRank(AlgorithmData algData, FloatMatrix means, int[][] clusters, boolean areGeneClusters) {
        float[] variances = this.getCentroidVariances(means);
        int[][] newClusters = new int[clusters.length][];
        QSort sort = new QSort(variances, 2);
        variances = sort.getSorted();
        int[] origOrder = sort.getOrigIndx();
        for (int i = 0; i < newClusters.length; ++i) {
            newClusters[i] = clusters[origOrder[i]];
        }
        String[] varianceArray = new String[variances.length];
        String[] clusterPop = new String[variances.length];
        for (int i = 0; i < variances.length; ++i) {
            varianceArray[i] = String.valueOf(variances[i]);
            clusterPop[i] = String.valueOf(newClusters[i].length);
        }
        algData.addStringArray("diversity-value-array", varianceArray);
        algData.addStringArray("cluster-population-array", clusterPop);
        return newClusters;
    }

    private float[] getCentroidVariances(FloatMatrix means) {
        float[] vars = new float[means.getRowDimension()];
        int cols = means.getColumnDimension();
        for (int i = 0; i < vars.length; ++i) {
            float sos = 0.0f;
            float mean = this.getMean(means.A[i]);
            for (int j = 0; j < cols; ++j) {
                sos = (float)((double)sos + Math.pow(means.A[i][j] - mean, 2.0));
            }
            vars[i] = sos;
        }
        return vars;
    }

    private float getMean(float[] vals) {
        float mean = 0.0f;
        int n = 0;
        for (int i = 0; i < vals.length; ++i) {
            if (Float.isNaN(vals[i])) continue;
            ++n;
            mean += vals[i];
        }
        return n > 0 ? mean / (float)n : 0.0f;
    }

    private int[][] getClustersBasedOnEntropyRank(AlgorithmData algData, FloatMatrix means, int[][] clusters, boolean areGeneClusters) {
        float[] entropies = new float[means.getRowDimension()];
        for (int i = 0; i < entropies.length; ++i) {
            entropies[i] = (float)this.getEntropy(means.A[i]);
        }
        int[][] newClusters = new int[clusters.length][];
        QSort sort = new QSort(entropies, 2);
        entropies = sort.getSorted();
        int[] origOrder = sort.getOrigIndx();
        for (int i = 0; i < newClusters.length; ++i) {
            newClusters[i] = clusters[origOrder[i]];
        }
        String[] varianceArray = new String[entropies.length];
        String[] clusterPop = new String[entropies.length];
        for (int i = 0; i < entropies.length; ++i) {
            varianceArray[i] = String.valueOf(entropies[i]);
            clusterPop[i] = String.valueOf(newClusters[i].length);
        }
        algData.addStringArray("diversity-value-array", varianceArray);
        algData.addStringArray("cluster-population-array", clusterPop);
        return newClusters;
    }

    private double getEntropy(float[] pVector) {
        int c_DecileCount = 10;
        double fltMin = Double.MAX_VALUE;
        double fltMax = -1.7976931348623157E308;
        int i = 0;
        int[] arrDeciles = new int[c_DecileCount];
        int iSize = pVector.length;
        int iValCount = 0;
        for (i = 0; i < iSize; ++i) {
            if (Double.isNaN(pVector[i])) continue;
            fltMin = Math.min(fltMin, (double)pVector[i]);
            fltMax = Math.max(fltMax, (double)pVector[i]);
            ++iValCount;
        }
        double fltStep = (fltMax - fltMin) / (double)c_DecileCount;
        if (fltStep == 0.0) {
            return -1.0 * Math.log(1.0) / Math.log(2.0);
        }
        if (fltMin == Double.MAX_VALUE) {
            return 0.0;
        }
        Arrays.fill(arrDeciles, 0);
        for (i = 0; i < iSize; ++i) {
            if (Double.isNaN(pVector[i])) continue;
            int iDecileInd = (int)Math.ceil(((double)pVector[i] - fltMin) / fltStep) - 1;
            if (iDecileInd < 0) {
                iDecileInd = 0;
            }
            int n = iDecileInd;
            arrDeciles[n] = arrDeciles[n] + 1;
        }
        if (iValCount == 0) {
            return 0.0;
        }
        double dblEntropy = 0.0;
        for (i = 0; i < c_DecileCount; ++i) {
            if (arrDeciles[i] == 0) continue;
            double dblPx = (double)arrDeciles[i] / (double)iValCount;
            dblEntropy += dblPx * Math.log(dblPx) / Math.log(2.0);
        }
        return -dblEntropy;
    }

    private Experiment applyAffyDetectionFilter(AlgorithmData algData) {
        AlgorithmParameters params = algData.getParams();
        IData data = this.framework.getData();
        int[] rows = this.experiment.getRowMappingArrayCopy();
        int[] cols = this.experiment.getColumnIndicesCopy();
        int numGenes = this.experiment.getNumberOfGenes();
        int expCount = this.experiment.getNumberOfSamples();
        String[] expNames = new String[expCount];
        for (int i = 0; i < expNames.length; ++i) {
            expNames[i] = data.getFullSampleName(cols[i]);
        }
        DetectionFilter filter = new DetectionFilter(expNames);
        filter.set_both(params.getBoolean("is-required-in-both-groups"));
        int[] numReq = algData.getIntArray("number-required");
        for (int i = 0; i < numReq.length; ++i) {
            filter.set_num_required(i, numReq[i]);
        }
        int[] groupMembership = algData.getIntArray("group-memberships");
        for (int i = 0; i < groupMembership.length; ++i) {
            filter.set_group_membership(groupMembership[i], i);
        }
        String[] detectionCalls = new String[expCount];
        boolean[] isPresent = new boolean[numGenes];
        int numPresent = 0;
        for (int probe = 0; probe < numGenes; ++probe) {
            for (int exp = 0; exp < expCount; ++exp) {
                detectionCalls[exp] = data.getFeature(cols[exp]).getDetection(rows[probe]);
            }
            boolean present = filter.keep_gene(detectionCalls);
            if (!present) continue;
            isPresent[probe] = true;
            ++numPresent;
        }
        FloatMatrix matrix = this.experiment.getMatrix();
        float[][] values = new float[numPresent][expCount];
        int[] rowMap = new int[numPresent];
        int cnt = 0;
        for (int i = 0; i < numGenes; ++i) {
            if (!isPresent[i]) continue;
            rowMap[cnt] = rows[i];
            values[cnt] = matrix.A[i];
            ++cnt;
        }
        return new Experiment(new FloatMatrix(values), cols, rowMap);
    }

    private Experiment applyAffyFoldFilter(AlgorithmData algData) {
        AlgorithmParameters params = algData.getParams();
        IData data = this.framework.getData();
        FloatMatrix matrix = this.experiment.getMatrix();
        int[] rows = this.experiment.getRowMappingArrayCopy();
        int[] cols = this.experiment.getColumnIndicesCopy();
        int numGenes = this.experiment.getNumberOfGenes();
        int expCount = this.experiment.getNumberOfSamples();
        String[] expNames = new String[expCount];
        for (int i = 0; i < expNames.length; ++i) {
            expNames[i] = data.getFullSampleName(cols[i]);
        }
        FoldFilter filter = new FoldFilter(expNames);
        float foldChange = params.getFloat("fold-change");
        int[] numReq = algData.getIntArray("number-of-members");
        String divider = params.getString("divider-string");
        filter.set_fold_change(foldChange);
        filter.set_divider(divider);
        int[] groupMembership = algData.getIntArray("group-memberships");
        for (int i = 0; i < groupMembership.length; ++i) {
            filter.set_group_membership(groupMembership[i], i);
        }
        float[] foldHits = new float[expCount];
        boolean[] isPresent = new boolean[numGenes];
        int numPresent = 0;
        float[] vals = new float[numGenes];
        for (int probe = 0; probe < numGenes; ++probe) {
            boolean present = filter.keep_gene(matrix.A[probe]);
            if (!present) continue;
            isPresent[probe] = true;
            ++numPresent;
        }
        float[][] values = new float[numPresent][expCount];
        int[] rowMap = new int[numPresent];
        int cnt = 0;
        for (int i = 0; i < numGenes; ++i) {
            if (!isPresent[i]) continue;
            rowMap[cnt] = rows[i];
            values[cnt] = matrix.A[i];
            ++cnt;
        }
        return new Experiment(new FloatMatrix(values), cols, rowMap);
    }
}

