/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.apache.xerces.parsers.DOMParser;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.mev.script.util.AlgorithmNode;
import org.tigr.microarray.mev.script.util.AlgorithmSet;
import org.tigr.microarray.mev.script.util.ErrorLog;
import org.tigr.microarray.mev.script.util.ParameterAttributes;
import org.tigr.microarray.mev.script.util.ScriptParameterException;
import org.tigr.microarray.mev.script.util.ScriptTree;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ParameterValidator
extends DefaultHandler {
    Element validationRoot;
    boolean haveValidationRoot;

    public boolean loadParameterConstraints() {
        try {
            File paramFile = TMEV.getConfigurationFile("ParameterConstraints.xml");
            DOMParser parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setErrorHandler((ErrorHandler)this);
            parser.parse(paramFile.toURI().toURL().toString());
            this.validationRoot = parser.getDocument().getDocumentElement();
            this.haveValidationRoot = true;
        }
        catch (NullPointerException e) {
            this.haveValidationRoot = false;
            JOptionPane.showMessageDialog(new JFrame(), "The parameter validation feature in support of scripting could not be initialized.\nThe constraint file \"ParameterConstraints.xml\" could not be located.\nScript capabilities will operate without full parameter validation", "Parameter Validation Initialization Error", 0);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.haveValidationRoot = false;
            JOptionPane.showMessageDialog(new JFrame(), "The parameter validation feature in support of scripting could not be initialized properly.\n\"ParameterConstraints.xml\" contained errors reported in the console window.\nScript capabilities will operate without full parameter validation", "Parameter Validation Initialization Error", 0);
            return false;
        }
        return true;
    }

    public boolean isEnabled() {
        return this.haveValidationRoot;
    }

    public boolean validate(ScriptManager manager, ScriptTree tree, ErrorLog log) {
        AlgorithmSet[] sets = tree.getAlgorithmSets();
        boolean isValid = true;
        log.reset();
        NodeList list = this.validationRoot.getElementsByTagName("script_algorithm");
        for (int setIndex = 0; setIndex < sets.length; ++setIndex) {
            for (int algIndex = 0; algIndex < sets[setIndex].getAlgorithmCount(); ++algIndex) {
                AlgorithmNode node = sets[setIndex].getAlgorithmNodeAt(algIndex);
                if (this.validateAlgorithm(node, list, log)) continue;
                isValid = false;
            }
        }
        return isValid;
    }

    private boolean validateAlgorithm(AlgorithmNode algorithmNode, NodeList algList, ErrorLog log) {
        AlgorithmData data = algorithmNode.getAlgorithmData();
        Map map = data.getParams().getMap();
        Iterator iter = map.keySet().iterator();
        String algName = algorithmNode.getAlgorithmName();
        boolean isValid = true;
        if (algName == null) {
            return false;
        }
        if (algorithmNode.getAlgorithmType().equals("data-adjustment")) {
            return true;
        }
        Element algElement = this.getAlgorithmElement(algName, algList);
        if (algElement == null) {
            JOptionPane.showMessageDialog(new JFrame(), "The " + algName + " algorithm does not have information to support parameter validation." + "\nPlease be aware that script loading will proceed without validation of this algorithm.", "Unsupported Parameter Validation", 2);
            return true;
        }
        Vector missingParameterVector = this.validateRequiredParameters(map.keySet(), algElement);
        if (missingParameterVector.size() > 0) {
            for (int i = 0; i < missingParameterVector.size(); ++i) {
                ScriptParameterException spe = new ScriptParameterException(algorithmNode.getAlgorithmName(), algorithmNode.getID(), algorithmNode.getDataNodeRef(), (String)missingParameterVector.elementAt(i), "N/A", "Missing required parameter.");
                log.recordParameterError(spe);
            }
            isValid = false;
        }
        while (iter.hasNext()) {
            String value;
            String key = (String)iter.next();
            if (this.validateParameter(key, value = (String)map.get(key), algElement, algorithmNode, log)) continue;
            isValid = false;
        }
        return isValid;
    }

    private Element getAlgorithmElement(String algName, NodeList algList) {
        Element elem = null;
        Element resultElement = null;
        for (int i = 0; i < algList.getLength(); ++i) {
            elem = (Element)algList.item(i);
            if (!elem.getAttribute("name").equals(algName)) continue;
            resultElement = elem;
            break;
        }
        return resultElement;
    }

    private Vector validateRequiredParameters(Set keys, Element algElement) {
        Vector<String> requiredKeys = new Vector<String>();
        NodeList params = algElement.getElementsByTagName("param");
        for (int i = 0; i < params.getLength(); ++i) {
            if (!((Element)params.item(i)).getAttribute("val_level").equalsIgnoreCase("REQUIRED")) continue;
            requiredKeys.add(((Element)params.item(i)).getAttribute("key"));
        }
        Vector keyVector = new Vector(keys);
        Vector missingKeys = new Vector();
        for (int i = 0; i < requiredKeys.size(); ++i) {
            if (keyVector.contains((String)requiredKeys.elementAt(i))) continue;
            missingKeys.add(requiredKeys.elementAt(i));
        }
        return missingKeys;
    }

    private boolean validateParameter(String key, String value, Element algElement, AlgorithmNode algNode, ErrorLog log) {
        NodeList paramList = algElement.getElementsByTagName("param");
        Element paramElement = this.getParameterElement(paramList, key);
        boolean result = true;
        if (paramElement == null) {
            ScriptParameterException spe = this.createScriptParameterException(algNode, paramElement, value, "Invalid key. Key name not recognized.");
            log.recordParameterError(spe);
            return false;
        }
        if (!this.validateValueType(value, paramElement, algElement, log)) {
            ScriptParameterException spe = this.createScriptParameterException(algNode, paramElement, value, "Incorrect value type.");
            log.recordParameterError(spe);
            result = false;
        }
        if (!this.validateValueConstraints(algNode.getAlgorithmName(), key, value)) {
            // empty if block
        }
        return result;
    }

    private ScriptParameterException createScriptParameterException(AlgorithmNode algNode, Element paramElement, String currValue, String message) {
        ScriptParameterException spe = new ScriptParameterException(algNode.getAlgorithmName(), algNode.getID(), algNode.getDataNodeRef(), paramElement.getAttribute("key"), currValue, message);
        return spe;
    }

    private ScriptParameterException createScriptParameterException(AlgorithmNode algNode, String message) {
        ScriptParameterException spe = new ScriptParameterException(algNode.getAlgorithmName(), algNode.getID(), algNode.getDataNodeRef(), "N/A", "N/A", message);
        return spe;
    }

    private Element getParameterElement(NodeList list, String key) {
        Element elem = null;
        for (int i = 0; i < list.getLength() && !(elem = (Element)list.item(i)).getAttribute("key").equals(key); ++i) {
        }
        return elem;
    }

    private boolean validateValueType(String value, Element paramElement, Element algElement, ErrorLog log) {
        String type = paramElement.getAttribute("value_type");
        boolean isValid = true;
        try {
            if (type.equals("boolean")) {
                if (!value.equals("true") && !value.equals("false")) {
                    isValid = true;
                }
            } else if (type.equals("int")) {
                Integer.parseInt(value);
            } else if (type.equals("long")) {
                Long.parseLong(value);
            } else if (type.equals("float")) {
                Float.parseFloat(value);
            } else if (type.equals("double")) {
                Double.parseDouble(value);
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return isValid;
    }

    private boolean validateValueConstraints(String algName, String key, String value) {
        ParameterAttributes atts = this.getParameterAttributes(algName, key);
        if (atts == null || !atts.hasConstraints()) {
            return true;
        }
        return this.checkConstraints(value, atts.getValueType(), atts.getMin(), atts.getMax());
    }

    private boolean checkConstraints(String val, String type, String min, String max) {
        if (type.equals("int")) {
            int value = Integer.parseInt(val);
            if (!min.equals("") && !max.equals("")) {
                return value >= Integer.parseInt(min) && value <= Integer.parseInt(max);
            }
            if (!max.equals("")) {
                return value <= Integer.parseInt(max);
            }
            if (!min.equals("")) {
                return value >= Integer.parseInt(min);
            }
            return true;
        }
        if (type.equals("float")) {
            float value = Float.parseFloat(val);
            if (!min.equals("") && !max.equals("")) {
                return value >= Float.parseFloat(min) && value <= Float.parseFloat(max);
            }
            if (!max.equals("")) {
                return value <= Float.parseFloat(max);
            }
            if (!min.equals("")) {
                return value >= Float.parseFloat(min);
            }
            return true;
        }
        if (type.equals("long")) {
            long value = Long.parseLong(val);
            if (!min.equals("") && !max.equals("")) {
                return value >= Long.parseLong(min) && value <= Long.parseLong(max);
            }
            if (!max.equals("")) {
                return value <= Long.parseLong(max);
            }
            if (!min.equals("")) {
                return value >= Long.parseLong(min);
            }
            return true;
        }
        if (type.equals("double")) {
            double value = Double.parseDouble(val);
            if (!min.equals("") && !max.equals("")) {
                return value >= Double.parseDouble(min) && value <= Double.parseDouble(max);
            }
            if (!max.equals("")) {
                return value <= Double.parseDouble(max);
            }
            if (!min.equals("")) {
                return value >= Double.parseDouble(min);
            }
            return true;
        }
        return true;
    }

    public String getValidParameterTable(String algName) {
        if (!this.isEnabled()) {
            return null;
        }
        String table = null;
        Element algElement = this.findAlgorithmElement(algName);
        if (algElement != null) {
            Element paramList = (Element)algElement.getElementsByTagName("param_list").item(0);
            if (paramList == null) {
                return null;
            }
            NodeList params = paramList.getElementsByTagName("param");
            table = "";
            table = "<h2>Valid Script Parameters for " + algName + "</h2>";
            table = table + "<p>Note: Parameters that are not listed as \"Always\" required usually depend on the value of other entered parameters to determine if they are required.</p>";
            table = table + "<table border=3><th>Key</th><th>Value Type</th><th>Min</th><th>Max</th><th>Required</th>";
            for (int i = 0; i < params.getLength(); ++i) {
                Element paramElement = (Element)params.item(i);
                NodeList constraintList = paramElement.getElementsByTagName("constraint");
                String key = paramElement.getAttribute("key");
                String valueType = paramElement.getAttribute("value_type");
                String valStatus = paramElement.getAttribute("val_level");
                String min = " ";
                String max = " ";
                if (constraintList != null && constraintList.getLength() > 0) {
                    Element constraint = (Element)constraintList.item(0);
                    min = constraint.getAttribute("min");
                    max = constraint.getAttribute("max");
                }
                table = table + "<tr><td>" + key + "</td><td>" + valueType + "</td><td>" + min + "</td><td>" + max + "</td><td>" + (valStatus.equalsIgnoreCase("REQUIRED") ? "Always" : "Dependent") + "</td></tr>";
            }
            table = table + "</table>";
        }
        return table;
    }

    public Hashtable getParameterHash(String algName) {
        Element algElement = this.findAlgorithmElement(algName);
        if (algElement == null) {
            return null;
        }
        Element paramList = (Element)algElement.getElementsByTagName("param_list").item(0);
        Hashtable<String, ParameterAttributes> paramHash = new Hashtable<String, ParameterAttributes>();
        NodeList list = paramList.getElementsByTagName("param");
        for (int i = 0; i < list.getLength(); ++i) {
            ParameterAttributes attr;
            Element paramElement = (Element)list.item(i);
            String key = paramElement.getAttribute("key");
            String valueType = paramElement.getAttribute("value_type");
            String valueRequirements = paramElement.getAttribute("val_level");
            NodeList constrList = null;
            constrList = paramElement.getElementsByTagName("constraint");
            if (constrList == null || constrList.getLength() == 0) {
                attr = new ParameterAttributes(key, valueType, valueRequirements);
            } else {
                Element constrElement = (Element)constrList.item(0);
                String min = constrElement.getAttribute("min");
                String max = constrElement.getAttribute("max");
                attr = new ParameterAttributes(key, valueType, valueRequirements, min, max);
            }
            paramHash.put(key, attr);
        }
        return paramHash;
    }

    public ParameterAttributes getParameterAttributes(String algName, String key) {
        Hashtable hash = this.getParameterHash(algName);
        if (hash == null) {
            return null;
        }
        return (ParameterAttributes)hash.get(key);
    }

    public void checkAlgorithmsForDataDependance(ScriptTree tree, ScriptManager manager) {
        AlgorithmSet[] algSet = tree.getAlgorithmSets();
        Vector<String> algNames = new Vector<String>();
        for (int i = 0; i < algSet.length; ++i) {
            for (int j = 0; j < algSet[i].getAlgorithmCount(); ++j) {
                String algName = algSet[i].getAlgorithmNodeAt(j).getAlgorithmName();
                Element algElement = this.findAlgorithmElement(algName);
                if (algElement == null || !algElement.getAttribute("input_data_dep").equals("true") || algNames.contains(algName)) continue;
                algNames.addElement(algName);
            }
        }
        if (algNames.size() > 0) {
            JTextPane pane = new JTextPane();
            pane.setContentType("text/html");
            pane.setEditable(false);
            pane.setMargin(new Insets(10, 10, 10, 5));
            String text = "<html><center><h2>Data Dependent Script Algorithms</h2></center>";
            text = text + "<hr size=3>The processing of the following algorithm";
            text = algNames.size() == 1 ? text + " is " : text + "s are ";
            text = text + "dependent on the number and order of the loaded experiments.<br>";
            text = text + "<center><b>";
            for (int i = 0; i < algNames.size(); ++i) {
                text = text + (String)algNames.elementAt(i) + "<br>";
            }
            text = text + "</b><br></center>";
            text = text + "Please verify that the data set (number of loaded experiments and their order) is appropriate for the listed algorithms.</html>";
            pane.setText(text);
            JScrollPane scroll = new JScrollPane(pane);
            scroll.setViewportBorder(BorderFactory.createLineBorder(Color.black));
            scroll.getViewport().setViewSize(new Dimension(450, 275));
            scroll.setPreferredSize(new Dimension(450, 275));
            JOptionPane.showMessageDialog(manager.getFrame(), scroll, "Data Set Dependent Algorithms", -1);
        }
    }

    private Element findAlgorithmElement(String algName) {
        NodeList list = this.validationRoot.getElementsByTagName("script_algorithm");
        Element algElement = null;
        for (int i = 0; i < list.getLength(); ++i) {
            String algElementName = null;
            algElement = (Element)list.item(i);
            algElementName = algElement.getAttribute("name");
            if (algElementName == null || !algElementName.equals(algName)) continue;
            return algElement;
        }
        return null;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
    }
}

