/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.mev.script.scriptGUI.ScriptXMLViewer;
import org.tigr.microarray.mev.script.util.ScriptParameterException;
import org.xml.sax.SAXParseException;

public class ErrorLog {
    Vector fatalErrors;
    Vector errors;
    Vector warnings;
    Vector parameterErrors;
    ScriptManager manager;
    ErrorLogDialog eDialog;
    File scriptFile;
    int result = 2;

    public ErrorLog(ScriptManager manager) {
        this.manager = manager;
        this.reset();
        this.eDialog = new ErrorLogDialog();
    }

    public void reset() {
        this.fatalErrors = new Vector();
        this.errors = new Vector();
        this.warnings = new Vector();
        this.parameterErrors = new Vector();
    }

    public void setFile(File file) {
        this.scriptFile = file;
    }

    public boolean isValid() {
        return this.fatalErrors.size() == 0 && this.errors.size() == 0;
    }

    public boolean hasWarnings() {
        return this.warnings.size() != 0;
    }

    public boolean hasErrors() {
        return this.errors.size() != 0;
    }

    public boolean hasFatalErrors() {
        return this.fatalErrors.size() != 0;
    }

    public boolean hasParameterErrors() {
        return this.parameterErrors.size() != 0;
    }

    public boolean isEmpty() {
        return this.isValid() && !this.hasWarnings();
    }

    public void recordWarning(SAXParseException e) {
        this.warnings.add(e);
    }

    public void recordError(SAXParseException e) {
        this.errors.add(e);
    }

    public void recordFatalError(SAXParseException e) {
        this.fatalErrors.add(e);
    }

    public void recordParameterError(ScriptParameterException e) {
        this.parameterErrors.add(e);
    }

    public void reportAllListings() {
        this.eDialog.updateContent();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.eDialog.setLocation((screenSize.width - this.eDialog.getSize().width) / 2, (screenSize.height - this.eDialog.getSize().height) / 2);
        this.eDialog.show();
    }

    public void reportFatalErrors() {
        this.eDialog.updateContent();
        this.eDialog.show();
    }

    public void reportErrors() {
        this.eDialog.updateContent();
        this.eDialog.show();
    }

    public void reportWarnings() {
        this.eDialog.updateContent();
        this.eDialog.show();
    }

    public String[] getFataErrors() {
        return null;
    }

    public String[] getErrors() {
        return null;
    }

    public String[] getWarnings() {
        return null;
    }

    private class ErrorLogDialog
    extends AlgorithmDialog {
        JTextPane pane;
        String text;
        JScrollPane sPane;
        boolean isEditing;

        public ErrorLogDialog() {
            super(new JFrame(), "Script Error Log", true);
            this.isEditing = false;
            this.buttonPanel.remove(this.okButton);
            this.buttonPanel.remove(this.cancelButton);
            this.buttonPanel.remove(this.resetButton);
            this.cancelButton.setText("Edit Script");
            this.cancelButton.setActionCommand("edit-command");
            this.cancelButton.setSize(120, 30);
            this.cancelButton.setPreferredSize(new Dimension(120, 30));
            this.okButton.setText("Close Log");
            this.okButton.setActionCommand("close-command");
            this.okButton.setSize(120, 30);
            this.okButton.setPreferredSize(new Dimension(120, 30));
            this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.buttonPanel.add((Component)this.okButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.buttonPanel.validate();
            this.pane = new JTextPane();
            this.pane.setEditable(false);
            this.pane.setMargin(new Insets(0, 10, 5, 15));
            this.pane.setBackground(new Color(252, 253, 196));
            this.pane.setContentType("text/html");
            this.sPane = new JScrollPane(this.pane);
            this.addContent(this.sPane);
            this.setActionListeners((ActionListener)((Object)new Listener()));
            this.setSize(550, 600);
        }

        public void updateContent() {
            String msg;
            String lineNumStr;
            int lineNum;
            SAXParseException e;
            int i;
            boolean showSep = false;
            this.text = new String();
            this.text = this.text + "<html><body>";
            if (ErrorLog.this.fatalErrors.size() > 0) {
                showSep = true;
                this.text = this.text + "<h2>Fatal Errors</h2><h3>The following Fatal Error";
                if (ErrorLog.this.fatalErrors.size() > 1) {
                    this.text = this.text + "s";
                }
                this.text = this.text + " occured during parsing and validation.</h2>";
                this.text = this.text + "<p>Note: Fatal Errors indicate that the input script had fundamental problems in script construction such as unpaired tags.  Loading will be terminated so that the reported errors can be corrected.  MeV does not have to be closed while corrections are made to the input script.</p>";
                this.text = this.text + "<table border=3><th>Line</th><th>Error</th></tr>";
                for (i = 0; i < ErrorLog.this.fatalErrors.size(); ++i) {
                    e = (SAXParseException)ErrorLog.this.fatalErrors.elementAt(i);
                    lineNum = e.getLineNumber();
                    lineNumStr = lineNum >= 0 ? String.valueOf(lineNum) : "N/A";
                    msg = e.getMessage();
                    this.text = this.text + "<tr><td align=center>" + lineNumStr + "</td><td>" + msg + "</td></tr>";
                }
                this.text = this.text + "</table>";
            }
            if (ErrorLog.this.errors.size() > 0) {
                if (showSep) {
                    this.text = this.text + "<br><hr size=3>";
                }
                this.text = this.text + "<h2>Validation Errors</h2><h3>The following Validation Error";
                if (ErrorLog.this.errors.size() > 1) {
                    this.text = this.text + "s";
                }
                this.text = this.text + " occured during parsing and validation.</h2>";
                this.text = this.text + "<p>Note: Validation Errors indicate that the input script did not conform to the conventions of the document type definition.  Loading will be terminated so that the reported errors can be corrected.  MeV does not have to be closed while corrections are made to the input script.</p>";
                this.text = this.text + "<table border=3><tr><th>Line</th><th>Error</th></tr>";
                for (i = 0; i < ErrorLog.this.errors.size(); ++i) {
                    e = (SAXParseException)ErrorLog.this.errors.elementAt(i);
                    lineNum = e.getLineNumber();
                    lineNumStr = lineNum >= 0 ? String.valueOf(lineNum) : "N/A";
                    msg = e.getMessage();
                    this.text = this.text + "<tr><td align=center>" + lineNumStr + "</td><td>" + msg + "</td></tr>";
                }
                this.text = this.text + "</table>";
            }
            if (ErrorLog.this.warnings.size() > 0) {
                if (showSep) {
                    this.text = this.text + "<br><hr size=3>";
                }
                this.text = this.text + "<h2>Warnings</h2><h3>The following Warning";
                if (ErrorLog.this.warnings.size() > 1) {
                    this.text = this.text + "s";
                }
                this.text = this.text + " occured during parsing and validation.</h2>";
                if (!showSep) {
                    this.text = this.text + "<p>Note: The script has loaded with some reported warnings If you would like to stop the script load hit stop otherwise hit continue to complete the loading.</p>";
                }
                this.text = this.text + "<table border=3><th>Line</th><th>Error</th></tr>";
                for (i = 0; i < ErrorLog.this.warnings.size(); ++i) {
                    e = (SAXParseException)ErrorLog.this.warnings.elementAt(i);
                    lineNum = e.getLineNumber();
                    lineNumStr = lineNum >= 0 ? String.valueOf(lineNum) : "N/A";
                    msg = e.getMessage();
                    this.text = this.text + "<tr><td align=center>" + lineNumStr + "</td><td>" + msg + "</td></tr>";
                }
                this.text = this.text + "</table>";
            }
            if (ErrorLog.this.parameterErrors.size() > 0) {
                String algName;
                Vector algVector = new Vector();
                Hashtable errorHash = new Hashtable();
                for (int i2 = 0; i2 < ErrorLog.this.parameterErrors.size(); ++i2) {
                    ScriptParameterException spe = (ScriptParameterException)ErrorLog.this.parameterErrors.elementAt(i2);
                    algName = spe.getAlgoritmName();
                    if (errorHash.containsKey(algName)) {
                        ((Vector)errorHash.get(algName)).add(spe);
                        continue;
                    }
                    Vector<ScriptParameterException> v = new Vector<ScriptParameterException>();
                    v.add(spe);
                    errorHash.put(algName, v);
                }
                if (showSep) {
                    this.text = this.text + "<br><hr size=3>";
                }
                this.text = this.text + "<h2>Script Parameter Validation Errors</h2><h3>The following Error";
                if (ErrorLog.this.parameterErrors.size() > 1) {
                    this.text = this.text + "s";
                }
                this.text = this.text + " occurred during parameter validation.</h3>";
                this.text = this.text + "<p>Note: The parameter warnings are reported so that you are aware of possible script errors that could abort processing during script execution.</p>";
                this.text = this.text + "<br><hr size=3>";
                Enumeration keys = errorHash.keys();
                int errorCount = 0;
                while (keys.hasMoreElements()) {
                    if (errorCount > 0) {
                        this.text = this.text + "<br><hr size=3>";
                    }
                    ++errorCount;
                    algName = (String)keys.nextElement();
                    Vector eVector = (Vector)errorHash.get(algName);
                    this.text = this.text + "<table border=3><th>Algorithm</th><th>Alg. Index</th><th>Data Ref.</th><th>Key</th><th>Error</th>";
                    for (int i3 = 0; i3 < eVector.size(); ++i3) {
                        ScriptParameterException spe = (ScriptParameterException)eVector.elementAt(i3);
                        this.text = this.text + "<tr><td>" + algName + "</td><td>" + String.valueOf(spe.getAlgorithmIndex()) + "</td><td>" + String.valueOf(spe.getDataReference()) + "</td><td>" + spe.getKey() + "</td><td><b>" + spe.getMessage() + "</b></td></tr>";
                    }
                    this.text = this.text + "</table>";
                    String table = ErrorLog.this.manager.getValidParametersTable(algName);
                    if (table == null) continue;
                    this.text = this.text + table;
                }
            }
            this.text = this.text + "</body></html>";
            this.setText(this.text);
        }

        public void setText(String t) {
            this.text = t;
            this.pane.setText(this.text);
            this.pane.setCaretPosition(0);
            this.pane.repaint();
        }

        private class Listener
        extends DialogListener {
            private Listener() {
            }

            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                String cmd = e.getActionCommand();
                if (cmd.equals("close-command")) {
                    ErrorLogDialog.this.dispose();
                } else if (cmd.equals("edit-command")) {
                    if (ErrorLogDialog.this.isEditing) {
                        return;
                    }
                    ErrorLogDialog.this.isEditing = true;
                    ErrorLogDialog.this.cancelButton.setEnabled(false);
                    ScriptXMLViewer viewer = new ScriptXMLViewer(ErrorLog.this.scriptFile);
                    if (viewer.getText().length() > 10) {
                        Point p = ErrorLogDialog.this.getLocation();
                        int width = ErrorLogDialog.this.getWidth();
                        int h = ErrorLogDialog.this.sPane.getHeight();
                        JScrollPane pane = new JScrollPane(viewer.getContentComponent());
                        pane.setRowHeaderView(viewer.getRowHeaderComponent());
                        JSplitPane splitPane = new JSplitPane(1, ErrorLogDialog.this.sPane, pane);
                        splitPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                        splitPane.setDividerLocation((int)((double)width * 0.65));
                        splitPane.setPreferredSize(new Dimension(width + width / 2, h));
                        splitPane.setSize(width + width / 2, h);
                        ErrorLogDialog.this.addContent(splitPane);
                        ErrorLogDialog.this.pack();
                        if (p != null) {
                            ErrorLogDialog.this.setLocation(p.x - width / 4, p.y);
                        }
                    } else {
                        JOptionPane.showMessageDialog((Component)((Object)ErrorLogDialog.this), "Couldn't load script file into script editor.", "Script Editor Loading Error", 2);
                    }
                } else if (cmd.equals("info-command")) {
                    HelpWindow.launchBrowser((Window)((Object)ErrorLogDialog.this), (String)"Error Log");
                }
            }

            public void windowClosing(WindowEvent e) {
                ErrorLog.this.result = -1;
                ErrorLogDialog.this.dispose();
            }
        }
    }
}

