/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.parsers.DOMParser;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.mev.script.event.ScriptDocumentEvent;
import org.tigr.microarray.mev.script.event.ScriptEventListener;
import org.tigr.microarray.mev.script.util.AlgorithmNode;
import org.tigr.microarray.mev.script.util.ErrorLog;
import org.tigr.util.FloatMatrix;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentBase
extends DefaultHandler
implements Serializable {
    public static final long serialVersionUID = 1000102010302010001L;
    protected String tm4ScriptVersion = "1.0";
    protected String mevScriptVersion = "1.0";
    protected ScriptManager manager;
    protected Document document;
    protected String scriptText;
    protected Element root;
    protected Element mevElement;
    protected Element primaryDataElement;
    protected Element commentElement;
    protected Element analysisElement;
    protected int currDataID = 1;
    protected int currAlgSetID = 1;
    protected String lineSeparator = System.getProperty("line.separator");
    protected String indent = "   ";
    protected int parseErrors = 0;
    protected ErrorLog errorLog;
    private Vector listeners;
    protected boolean parsedScript = false;
    protected boolean isTextCurrent = false;

    public DocumentBase(ScriptManager manager) {
        this.manager = manager;
        this.errorLog = new ErrorLog(manager);
        this.listeners = new Vector();
        DOMImplementationImpl impl = new DOMImplementationImpl();
        DocumentType docType = impl.createDocumentType("TM4ML", null, TMEV.getConfigurationFile("mev_script_dtd.dtd").getAbsolutePath());
        this.document = impl.createDocument(null, "TM4ML", docType);
        this.root = this.document.getDocumentElement();
        this.root.setAttribute("version", this.tm4ScriptVersion);
        this.mevElement = this.document.createElement("mev");
        this.mevElement.setAttribute("version", this.mevScriptVersion);
        this.root.appendChild(this.mevElement);
        this.analysisElement = this.document.createElement("analysis");
        this.primaryDataElement = this.document.createElement("primary_data");
        this.primaryDataElement.setAttribute("id", "1");
        this.createAlgorithmSet(1);
        this.mevElement.appendChild(this.primaryDataElement);
        this.mevElement.appendChild(this.analysisElement);
        this.scriptText = new String("");
        this.updateScript();
    }

    public DocumentBase(String date, String name, String description, ScriptManager manager) {
        this.manager = manager;
        this.errorLog = new ErrorLog(manager);
        this.listeners = new Vector();
        DOMImplementationImpl impl = new DOMImplementationImpl();
        DocumentType docType = impl.createDocumentType("TM4ML", null, TMEV.getConfigurationFile("mev_script_dtd.dtd").getAbsolutePath());
        this.document = impl.createDocument(null, "TM4ML", docType);
        this.root = this.document.getDocumentElement();
        this.root.setAttribute("version", this.tm4ScriptVersion);
        this.mevElement = this.document.createElement("mev");
        this.mevElement.setAttribute("version", this.mevScriptVersion);
        this.root.appendChild(this.mevElement);
        if (date != null) {
            this.setDateComment(date);
        }
        if (name != null) {
            this.setNameComment(name);
        }
        if (description != null) {
            this.setDescriptionComment(description);
        }
        this.analysisElement = this.document.createElement("analysis");
        this.primaryDataElement = this.document.createElement("primary_data");
        this.primaryDataElement.setAttribute("id", "1");
        this.createAlgorithmSet(1);
        this.mevElement.appendChild(this.primaryDataElement);
        this.mevElement.appendChild(this.analysisElement);
        this.scriptText = new String("");
        this.updateScript();
    }

    public DocumentBase(DocumentBase base) {
        this.manager = base.getManager();
        this.document = this.copyDocument(base.getDocument());
    }

    private Document copyDocument(Document doc) {
        DOMImplementationImpl impl = new DOMImplementationImpl();
        DocumentType docType = impl.createDocumentType("TM4ML", null, TMEV.getConfigurationFile("mev_script_dtd.dtd").getAbsolutePath());
        Document newDoc = impl.createDocument(null, "TM4ML", docType);
        this.copyChildren(doc.getDocumentElement(), newDoc.getDocumentElement(), newDoc);
        this.isTextCurrent = false;
        return newDoc;
    }

    private void copyChildren(Node docElement, Node newElement, Document newDoc) {
        NodeList nodes = docElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node oldNode = nodes.item(i);
            Node newNode = newDoc.importNode(oldNode, false);
            newElement.appendChild(newNode);
            if (!oldNode.hasChildNodes()) continue;
            this.copyChildren(oldNode, newNode, newDoc);
        }
        this.isTextCurrent = false;
    }

    public void setDocument(Document doc) {
        this.document = doc;
        this.updateScript();
    }

    public Document getDocument() {
        return this.document;
    }

    public ScriptManager getManager() {
        return this.manager;
    }

    public void setDateComment(String comment) {
        Comment nameElement = this.document.createComment(" Original Script Creation Date: " + comment + " ");
        this.mevElement.appendChild(nameElement);
        this.updateScript();
    }

    public void setNameComment(String comment) {
        Comment nameElement = this.document.createComment(" Script Name: " + comment + " ");
        this.mevElement.appendChild(nameElement);
        this.updateScript();
    }

    public void setDescriptionComment(String comment) {
        Comment dElement = this.document.createComment(" Script Description: " + comment + " ");
        this.mevElement.appendChild(dElement);
        this.updateScript();
    }

    private Element createAlgorithmSet(int dataRef) {
        Element algSetElement = this.document.createElement("alg_set");
        algSetElement.setAttribute("set_id", String.valueOf(this.currAlgSetID));
        algSetElement.setAttribute("input_data_ref", String.valueOf(dataRef));
        this.analysisElement.appendChild(algSetElement);
        ++this.currAlgSetID;
        this.isTextCurrent = false;
        return algSetElement;
    }

    private Element getAlgorithmSetByID(int setID) {
        String id = String.valueOf(setID);
        NodeList elements = this.analysisElement.getElementsByTagName("alg_set");
        for (int i = 0; i < elements.getLength(); ++i) {
            if (!id.equals(((Element)elements.item(i)).getAttribute("set_id"))) continue;
            return (Element)elements.item(i);
        }
        return null;
    }

    private Element getAlgorithmSetByDataRef(int dataRef) {
        int setID = -1;
        String dataID = String.valueOf(dataRef);
        if (dataRef == 1) {
            return this.getAlgorithmSetByID(1);
        }
        NodeList list = this.document.getElementsByTagName("algorithm");
        Node algNode = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!dataID.equals(((Element)node).getAttribute("input_data_ref"))) continue;
            algNode = node;
            break;
        }
        if (algNode == null) {
            return this.createAlgorithmSet(dataRef);
        }
        return (Element)algNode.getParentNode();
    }

    public boolean appendAlgorithm(AlgorithmData data, int inputDataRef) {
        Element algElement = this.document.createElement("algorithm");
        boolean added = false;
        Element algSetElement = this.getAlgorithmSetByDataRef(inputDataRef);
        if (algSetElement == null) {
            return false;
        }
        AlgorithmParameters params = data.getParams();
        String name = params.getString("name");
        String alg_type = params.getString("alg-type");
        int algID = algSetElement.getElementsByTagName("algorithm").getLength() + 1;
        if (name != null) {
            String[] outputNodes;
            algElement.setAttribute("alg_name", name);
            algElement.setAttribute("input_data_ref", String.valueOf(inputDataRef));
            algElement.setAttribute("alg_id", String.valueOf(algID));
            algElement.setAttribute("alg_type", String.valueOf(alg_type));
            this.addParameterList(algElement, params);
            Element matrices = this.document.createElement("mlist");
            Map map = data.getIntArrays();
            if (map.size() > 0) {
                this.addIntArrays(map, matrices);
            }
            if ((map = data.getStringArrays()).size() > 0) {
                this.addStringArrays(map, matrices);
            }
            if ((map = data.getMatrixes()).size() > 0) {
                this.addMatrices(map, matrices);
            }
            if (matrices.getChildNodes().getLength() > 0) {
                algElement.appendChild(matrices);
            }
            if ((outputNodes = data.getStringArray("output-nodes")) != null) {
                Element outputNodeElement = this.document.createElement("output_data");
                String outputClass = data.getParams().getString("output-class");
                if (outputClass != null) {
                    outputNodeElement.setAttribute("output_class", outputClass);
                }
                for (int i = 0; i < outputNodes.length; ++i) {
                    ++this.currDataID;
                    Element dataElement = this.document.createElement("data_node");
                    dataElement.setAttribute("data_node_id", String.valueOf(this.currDataID));
                    dataElement.setAttribute("name", outputNodes[i]);
                    outputNodeElement.appendChild(dataElement);
                }
                algElement.appendChild(outputNodeElement);
            }
        }
        algSetElement.appendChild(algElement);
        added = true;
        this.isTextCurrent = false;
        this.fireScriptEvent();
        return added;
    }

    private void addParameterList(Element algElement, AlgorithmParameters params) {
        Map paramMap = params.getMap();
        String key = "";
        String value = "";
        if (paramMap.size() > 1) {
            Set keySet = paramMap.keySet();
            Iterator iter = keySet.iterator();
            Element paramsElement = this.document.createElement("plist");
            while (iter.hasNext()) {
                key = (String)iter.next();
                value = (String)paramMap.get(key);
                if (key.equals("name") || key.equals("output-class") || key.equals("alg-type")) continue;
                Element paramElement = this.document.createElement("param");
                paramElement.setAttribute("key", key);
                paramElement.setAttribute("value", value);
                paramsElement.appendChild(paramElement);
            }
            algElement.appendChild(paramsElement);
        }
    }

    private void addIntArrays(Map map, Element mlist) {
        int i;
        Object[] arrayObjectNames = map.keySet().toArray();
        String[] arrayNames = new String[arrayObjectNames.length];
        for (i = 0; i < arrayNames.length; ++i) {
            arrayNames[i] = (String)arrayObjectNames[i];
        }
        for (i = 0; i < arrayNames.length; ++i) {
            int[] currentArray = (int[])map.get(arrayNames[i]);
            Element matrixElement = this.document.createElement("matrix");
            matrixElement.setAttribute("name", arrayNames[i]);
            matrixElement.setAttribute("type", "int-array");
            matrixElement.setAttribute("row_dim", String.valueOf(currentArray.length));
            matrixElement.setAttribute("col_dim", "1");
            for (int j = 0; j < currentArray.length; ++j) {
                Element elementElement = this.document.createElement("element");
                elementElement.setAttribute("row", String.valueOf(j));
                elementElement.setAttribute("col", "0");
                elementElement.setAttribute("value", String.valueOf(currentArray[j]));
                matrixElement.appendChild(elementElement);
            }
            mlist.appendChild(matrixElement);
        }
    }

    private void addStringArrays(Map map, Element mlist) {
        int i;
        Object[] arrayObjectNames = map.keySet().toArray();
        Vector<String> arrayNames = new Vector<String>();
        for (i = 0; i < arrayObjectNames.length; ++i) {
            String key = (String)arrayObjectNames[i];
            if (key.equals("output-nodes")) continue;
            arrayNames.add(key);
        }
        if (arrayNames.size() < 1) {
            return;
        }
        for (i = 0; i < arrayNames.size(); ++i) {
            String[] currentArray = (String[])map.get((String)arrayNames.elementAt(i));
            Element matrixElement = this.document.createElement("matrix");
            matrixElement.setAttribute("name", (String)arrayNames.elementAt(i));
            matrixElement.setAttribute("type", "string-array");
            matrixElement.setAttribute("row_dim", String.valueOf(currentArray.length));
            matrixElement.setAttribute("col_dim", "1");
            for (int j = 0; j < currentArray.length; ++j) {
                Element elementElement = this.document.createElement("element");
                elementElement.setAttribute("row", String.valueOf(j));
                elementElement.setAttribute("col", "0");
                elementElement.setAttribute("value", currentArray[j]);
                matrixElement.appendChild(elementElement);
            }
            mlist.appendChild(matrixElement);
        }
    }

    private void addMatrices(Map map, Element mlist) {
        int i;
        Object[] matrixObjectNames = map.keySet().toArray();
        String[] matrixNames = new String[matrixObjectNames.length];
        for (i = 0; i < matrixNames.length; ++i) {
            matrixNames[i] = (String)matrixObjectNames[i];
        }
        for (i = 0; i < matrixNames.length; ++i) {
            FloatMatrix currentFM = (FloatMatrix)map.get(matrixNames[i]);
            Element matrixElement = this.document.createElement("matrix");
            matrixElement.setAttribute("name", matrixNames[i]);
            matrixElement.setAttribute("type", "FloatMatrix");
            matrixElement.setAttribute("row_dim", String.valueOf(currentFM.getRowDimension()));
            matrixElement.setAttribute("col_dim", String.valueOf(currentFM.getColumnDimension()));
            this.addMatrixElements(currentFM, matrixElement);
            mlist.appendChild(matrixElement);
        }
    }

    private void addMatrixElements(FloatMatrix matrix, Element matrixElement) {
        float[][] data = matrix.A;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                Element elementElement = this.document.createElement("element");
                elementElement.setAttribute("row", String.valueOf(i));
                elementElement.setAttribute("col", String.valueOf(j));
                elementElement.setAttribute("value", String.valueOf(data[i][j]));
                matrixElement.appendChild(elementElement);
            }
        }
    }

    public void writeDocument(String fileName) throws IOException {
        FileWriter writer = new FileWriter(fileName);
        this.serialize(writer);
        writer.flush();
        writer.close();
    }

    private void writeDocument(Writer writer) throws IOException {
        this.serialize(writer);
    }

    private void serialize(Writer writer) throws IOException {
        this.serializeNode(this.document, writer, "");
    }

    private void serializeNode(Node node, Writer writer, String indentLevel) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                writer.write("<?xml version=\"1.0\"?>");
                writer.write(this.lineSeparator);
                writer.write("<!DOCTYPE TM4ML SYSTEM \"http://www.tm4.org/mev/mev_script_dtd.dtd\" \"mev_script_dtd.dtd\">");
                writer.write(this.lineSeparator);
                Document doc = (Document)node;
                this.serializeNode(doc.getDocumentElement(), writer, " ");
                break;
            }
            case 1: {
                boolean haveContent = false;
                String name = node.getNodeName();
                writer.write(indentLevel + "<" + name);
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    writer.write(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
                }
                NodeList children = node.getChildNodes();
                if (children.getLength() > 0) {
                    writer.write(">");
                    if (children.item(0) != null && children.item(0).getNodeType() == 1) {
                        writer.write(this.lineSeparator);
                    }
                    for (int i = 0; i < children.getLength(); ++i) {
                        this.serializeNode(children.item(i), writer, indentLevel + this.indent);
                    }
                    if (children.item(0) != null && children.item(children.getLength() - 1).getNodeType() == 1) {
                        writer.write(indentLevel);
                    }
                    writer.write("</" + name + ">");
                } else {
                    writer.write("/>");
                }
                writer.write(this.lineSeparator);
                break;
            }
            case 3: {
                writer.write(node.getNodeValue());
                break;
            }
            case 8: {
                String text = node.getNodeValue();
                writer.write("<!--");
                StringTokenizer stok = new StringTokenizer(text, " ");
                while (stok.hasMoreElements()) {
                    int charCnt = 0;
                    while (charCnt < 50) {
                        String word = stok.nextToken();
                        writer.write(word);
                        charCnt = word.length();
                    }
                    writer.write(this.lineSeparator);
                }
                writer.write("-->");
            }
        }
    }

    public void updateScript() {
        if (!this.isTextCurrent) {
            try {
                this.scriptText = "";
                this.writeScriptText(this.document, "");
                this.isTextCurrent = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeScriptText(Node node, String indentLevel) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                this.scriptText = this.scriptText + "<?xml version=\"1.0\"?>";
                this.scriptText = this.scriptText + this.lineSeparator;
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    this.writeScriptText(nodes.item(i), "");
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                this.scriptText = this.scriptText + indentLevel + "<" + name;
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    this.scriptText = this.scriptText + " " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"";
                }
                NodeList children = node.getChildNodes();
                if (children.getLength() > 0) {
                    this.scriptText = this.scriptText + ">";
                    if (children.item(0) != null) {
                        this.scriptText = this.scriptText + this.lineSeparator;
                    }
                    for (int i = 0; i < children.getLength(); ++i) {
                        if (children.item(i).getNodeType() == 3) continue;
                        this.writeScriptText(children.item(i), indentLevel + this.indent);
                    }
                    if (children.item(0) != null) {
                        this.scriptText = this.scriptText + indentLevel;
                    }
                    this.scriptText = this.scriptText + "</" + name + ">";
                } else {
                    this.scriptText = this.scriptText + "/>";
                }
                this.scriptText = this.scriptText + this.lineSeparator;
                break;
            }
            case 3: {
                int pt;
                String newText = node.getNodeValue();
                String preText = "";
                if (newText.indexOf("\n") != -1 && this.scriptText.lastIndexOf(10) == this.scriptText.length() - 1 && (pt = newText.lastIndexOf("\n") + 1) < newText.length()) {
                    preText = newText.substring(pt);
                    newText = preText = preText + newText.substring(0, pt - 1);
                }
                this.scriptText = this.scriptText + newText;
                break;
            }
            case 8: {
                String text = node.getNodeValue();
                this.scriptText = this.scriptText + indentLevel + "<!--";
                this.scriptText = this.scriptText + text;
                this.scriptText = this.scriptText + "-->" + this.lineSeparator + this.lineSeparator;
                break;
            }
            case 10: {
                DocumentType docType = (DocumentType)node;
                this.scriptText = this.scriptText + "<!DOCTYPE " + docType.getName();
                this.scriptText = this.scriptText + " SYSTEM ";
                this.scriptText = this.scriptText + "\"" + docType.getSystemId() + "\">";
                this.scriptText = this.scriptText + this.lineSeparator;
            }
        }
    }

    public String toString() {
        return this.scriptText;
    }

    public ErrorLog getErrorLog() {
        return this.errorLog;
    }

    public void showErrorLog() {
    }

    public int getErrorCount() {
        return this.parseErrors;
    }

    public boolean loadXMLFile(File inputFile, Progress progress) throws Exception {
        int i;
        int maxID;
        if (!inputFile.exists()) {
            return false;
        }
        progress.setUnits(4);
        progress.setValue(1);
        progress.setDescription("Parsing File");
        this.errorLog.setFile(inputFile);
        DOMParser parser = new DOMParser();
        try {
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setErrorHandler((ErrorHandler)this);
            parser.parse(inputFile.toURI().toURL().toString());
        }
        catch (Exception e) {
            return false;
        }
        this.document = parser.getDocument();
        this.isTextCurrent = false;
        this.root = this.document.getDocumentElement();
        NodeList list = this.root.getElementsByTagName("mev");
        if (list != null && list.getLength() > 0) {
            this.mevElement = (Element)list.item(0);
        }
        if ((list = this.root.getElementsByTagName("primary_data")) != null && list.getLength() > 0) {
            this.primaryDataElement = (Element)list.item(0);
        }
        if ((list = this.root.getElementsByTagName("analysis")) != null && list.getLength() > 0) {
            this.analysisElement = (Element)list.item(0);
        }
        progress.setValue(2);
        progress.setDescription("Checking Algorithm Sets");
        list = this.root.getElementsByTagName("alg_set");
        if (list != null && list.getLength() > 0) {
            maxID = -1;
            for (i = 0; i < list.getLength(); ++i) {
                this.currAlgSetID = Integer.parseInt(((Element)list.item(i)).getAttribute("set_id"));
                if (this.currAlgSetID <= maxID) continue;
                maxID = this.currAlgSetID;
            }
            this.currAlgSetID = this.currAlgSetID < 0 ? 0 : maxID;
            ++this.currAlgSetID;
        }
        progress.setValue(2);
        progress.setDescription("Setting Output ID");
        list = this.root.getElementsByTagName("data_node");
        if (list != null && list.getLength() > 0) {
            maxID = -1;
            for (i = 0; i < list.getLength(); ++i) {
                this.currDataID = Integer.parseInt(((Element)list.item(i)).getAttribute("data_node_id"));
                if (this.currDataID <= maxID) continue;
                maxID = this.currDataID;
            }
            this.currDataID = this.currDataID < 0 ? 0 : maxID;
        }
        progress.setValue(3);
        progress.setDescription("Internal Serialization");
        this.parsedScript = true;
        this.updateScript();
        progress.setValue(4);
        progress.setDescription("Done");
        progress.dispose();
        return this.validateDocument();
    }

    public boolean validateDocument() {
        return true;
    }

    public boolean modifyParameter(Hashtable attributes, String modLine, String value) {
        NodeList list = this.document.getElementsByTagName("algorithm");
        for (int i = 0; i < list.getLength(); ++i) {
            Element algElement = (Element)list.item(i);
            if (!this.algorithmMatches(attributes, algElement)) continue;
            return this.modifyAlgorithmParameter(algElement, modLine, value);
        }
        return false;
    }

    private boolean modifyAlgorithmParameter(Element elem, String modLine, String value) {
        NodeList list = elem.getElementsByTagName("param");
        this.isTextCurrent = false;
        for (int i = 0; i < list.getLength(); ++i) {
            Element param = (Element)list.item(i);
            String key = param.getAttribute("key");
            if (modLine.indexOf(key) <= -1) continue;
            param.setAttribute("value", value);
            this.fireScriptEvent();
            return true;
        }
        return false;
    }

    private boolean algorithmMatches(Hashtable attributes, Element algorithm) {
        Enumeration _enum = attributes.keys();
        boolean match = true;
        while (_enum.hasMoreElements()) {
            String key = (String)_enum.nextElement();
            String value = (String)attributes.get(key);
            String algValue = algorithm.getAttribute(key);
            if (algValue.equals(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        System.err.println("Warning:  " + e);
        ++this.parseErrors;
        this.errorLog.recordWarning(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        System.err.println("Error:  " + e);
        this.errorLog.recordError(e);
        ++this.parseErrors;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        System.err.println("Fatal Error:  " + e);
        this.errorLog.recordFatalError(e);
        ++this.parseErrors;
    }

    public void addDocumentListener(ScriptEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private void fireScriptEvent() {
        ScriptDocumentEvent event = new ScriptDocumentEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ScriptEventListener)this.listeners.elementAt(i)).documentChanged(event);
        }
    }

    public void removeScriptListener(ScriptEventListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAlgorithm(AlgorithmNode node) {
        int algID = node.getID();
        int dataRef = node.getDataNodeRef();
        String name = node.getAlgorithmName();
        Element algSetElement = this.getAlgorithmSetByDataRef(dataRef);
        Element algorithmElement = null;
        boolean found = false;
        if (algSetElement != null) {
            NodeList list = algSetElement.getElementsByTagName("algorithm");
            for (int i = 0; i < list.getLength(); ++i) {
                algorithmElement = (Element)list.item(i);
                if (!String.valueOf(algID).equals(algorithmElement.getAttribute("alg_id")) || !name.equals(algorithmElement.getAttribute("alg_name"))) continue;
                found = true;
                break;
            }
            if (found) {
                if (algorithmElement == null) {
                    return;
                }
                Node parentNode = algorithmElement.getParentNode();
                if (parentNode != null) {
                    Node grandparent;
                    int i;
                    list = algorithmElement.getElementsByTagName("data_node");
                    String[] data_refs = new String[list.getLength()];
                    for (int i2 = 0; i2 < list.getLength(); ++i2) {
                        Node dataNode = list.item(i2);
                        data_refs[i2] = ((Element)dataNode).getAttribute("data_node_id");
                    }
                    Vector algSetIDs = this.getDependentDataIDs(algorithmElement, list);
                    list = this.analysisElement.getElementsByTagName("alg_set");
                    Vector<Node> setsToRemove = new Vector<Node>();
                    int listLength = list.getLength();
                    for (i = 0; i < listLength; ++i) {
                        Node algSetNode = list.item(i);
                        String ref = ((Element)algSetNode).getAttribute("set_id");
                        for (int j = 0; j < algSetIDs.size(); ++j) {
                            if (!ref.equals((String)algSetIDs.elementAt(j))) continue;
                            setsToRemove.addElement(algSetNode);
                        }
                    }
                    for (i = 0; i < setsToRemove.size(); ++i) {
                        this.analysisElement.removeChild((Element)setsToRemove.elementAt(i));
                    }
                    parentNode.removeChild(algorithmElement);
                    if (parentNode.getChildNodes().getLength() == 0 && (grandparent = parentNode.getParentNode()) != null && parentNode.getNodeName().equals("alg_set") && !((Element)parentNode).getAttribute("set_id").equals("1")) {
                        grandparent.removeChild(parentNode);
                    }
                }
                this.isTextCurrent = false;
                this.fireScriptEvent();
            }
        }
    }

    private Vector getDependentDataIDs(Element algElement, NodeList dataElements) {
        Vector<String> indices = new Vector<String>();
        for (int i = 0; i < dataElements.getLength(); ++i) {
            Element dataElement = (Element)dataElements.item(i);
            indices.addElement(dataElement.getAttribute("data_node_id"));
        }
        this.getDependentDataIDs(indices, 0, this.analysisElement.getElementsByTagName("alg_set"));
        return indices;
    }

    private void getDependentDataIDs(Vector indices, int start, NodeList algSets) {
        if (indices.size() <= start) {
            return;
        }
        int initSize = indices.size();
        int newHits = 0;
        for (int i = start; i < indices.size(); ++i) {
            String index = (String)indices.elementAt(i);
            for (int j = 0; j < algSets.getLength(); ++j) {
                Element algSet = (Element)algSets.item(j);
                String algSetID = algSet.getAttribute("set_id");
                if (!algSetID.equals(index)) continue;
                NodeList dataList = algSet.getElementsByTagName("data_node");
                for (int k = 0; k < dataList.getLength(); ++k) {
                    String newIndex = ((Element)dataList.item(k)).getAttribute("data_node_id");
                    if (indices.contains(newIndex)) continue;
                    ++newHits;
                    indices.addElement(newIndex);
                }
            }
        }
        this.getDependentDataIDs(indices, initSize, algSets);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.tm4ScriptVersion);
        oos.writeObject(this.mevScriptVersion);
        oos.writeObject(this.manager);
        oos.writeObject(this.document);
        oos.writeObject(this.scriptText);
        oos.writeObject(this.root);
        oos.writeObject(this.mevElement);
        oos.writeObject(this.primaryDataElement);
        oos.writeObject(this.commentElement);
        oos.writeObject(this.analysisElement);
        oos.writeInt(this.currDataID);
        oos.writeInt(this.currAlgSetID);
        oos.writeObject(this.lineSeparator);
        oos.writeObject(this.indent);
        oos.writeBoolean(this.errorLog != null);
        oos.writeBoolean(this.parsedScript);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.tm4ScriptVersion = (String)ois.readObject();
        this.mevScriptVersion = (String)ois.readObject();
        this.manager = (ScriptManager)ois.readObject();
        this.document = (Document)ois.readObject();
        this.scriptText = (String)ois.readObject();
        this.root = (Element)ois.readObject();
        this.mevElement = (Element)ois.readObject();
        this.primaryDataElement = (Element)ois.readObject();
        this.commentElement = (Element)ois.readObject();
        this.analysisElement = (Element)ois.readObject();
        this.currDataID = ois.readInt();
        this.currAlgSetID = ois.readInt();
        this.lineSeparator = (String)ois.readObject();
        this.indent = (String)ois.readObject();
        this.parsedScript = ois.readBoolean();
    }
}

