/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.script.ScriptDocument;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.mev.script.event.ScriptDocumentEvent;
import org.tigr.microarray.mev.script.event.ScriptEventListener;
import org.tigr.microarray.mev.script.scriptGUI.ScriptValueChangeDialog;
import org.tigr.microarray.mev.script.util.AlgorithmNode;

public class ScriptXMLViewer
extends ViewerAdapter {
    private ScriptDocument doc;
    private ScriptManager manager;
    private JTextArea pane;
    private HighlightPanel highlightPanel;
    private LineNumberPanel numPanel;
    private JPopupMenu popup;
    private Font vFont;
    int numLines;
    int prevNumLines;
    private boolean editOnly;
    private File scriptFile;
    private IFramework framework;

    public ScriptXMLViewer(ScriptManager manager) {
        this.manager = manager;
        this.editOnly = false;
        PaneListener listener = new PaneListener();
        this.pane = new JTextArea();
        this.pane.setEditable(false);
        this.pane.setSelectedTextColor(Color.red);
        this.pane.setSelectionColor(Color.blue);
        this.pane.setOpaque(false);
        this.pane.setMargin(new Insets(0, 10, 5, 10));
        this.vFont = new Font("Monospaced", 0, 12);
        this.pane.setFont(this.vFont);
        this.numPanel = new LineNumberPanel();
        this.numPanel.addMouseListener(listener);
        this.highlightPanel = new HighlightPanel();
        this.highlightPanel.setLayout(new GridBagLayout());
        this.highlightPanel.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pane.addMouseListener(listener);
        this.popup = this.createPopupMenu(new MenuListener());
        this.updateSize();
    }

    public ScriptXMLViewer(ScriptDocument Doc, ScriptManager manager) {
        this.doc = Doc;
        this.manager = manager;
        this.doc.addDocumentListener(new ScriptListener());
        this.editOnly = false;
        this.pane = new JTextArea();
        this.pane.setText(this.doc.toString());
        this.pane.setEditable(false);
        this.pane.setLineWrap(false);
        this.pane.setSelectionColor(new Color(120, 160, 210));
        this.pane.setOpaque(false);
        this.pane.setMargin(new Insets(0, 0, 5, 10));
        this.vFont = new Font("Monospaced", 0, 12);
        this.pane.setFont(this.vFont);
        this.numPanel = new LineNumberPanel();
        this.highlightPanel = new HighlightPanel();
        this.highlightPanel.setLayout(new GridBagLayout());
        this.highlightPanel.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pane.addMouseListener(new PaneListener());
        this.popup = this.createPopupMenu(new MenuListener());
        this.updateSize();
    }

    public ScriptXMLViewer(File inputFile) {
        this.editOnly = true;
        this.scriptFile = inputFile;
        this.pane = new JTextArea();
        try {
            String text = this.readScript(inputFile);
            this.pane.setText(text);
        }
        catch (IOException e) {
            this.pane.setText(" ");
        }
        this.pane.setCaretPosition(0);
        this.pane.setLineWrap(false);
        this.pane.setSelectionColor(new Color(120, 160, 210));
        this.pane.setOpaque(false);
        this.pane.setMargin(new Insets(0, 0, 5, 10));
        this.vFont = new Font("Monospaced", 0, 12);
        this.pane.setFont(this.vFont);
        this.numPanel = new LineNumberPanel();
        this.numPanel.setHeight(this.pane.getLineCount());
        this.highlightPanel = new HighlightPanel();
        this.highlightPanel.setLayout(new GridBagLayout());
        this.highlightPanel.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pane.addKeyListener(new PaneEditorListener());
        this.pane.addMouseListener(new PaneListener());
        this.popup = this.createPopupMenu(new MenuListener());
        this.updateSize();
    }

    public void setDoc(ScriptDocument Doc) {
        this.doc = Doc;
        this.doc.addDocumentListener(new ScriptListener());
        this.updateSize();
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.doc.updateScript();
        this.numPanel.clearSelection();
        this.updateSize();
    }

    private void updateSize() {
        if (this.doc == null) {
            return;
        }
        this.pane.setText(this.doc.toString());
        String text = " ";
        try {
            text = this.pane.getDocument().getText(0, this.pane.getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.prevNumLines = this.numLines;
        this.numLines = this.pane.getLineCount();
        this.numPanel.setHeight(this.numLines);
        this.prevNumLines = this.numLines;
        this.pane.setCaretPosition(0);
    }

    public String getText() {
        return this.pane.getText();
    }

    public void update() {
        this.updateSize();
    }

    public JComponent getContentComponent() {
        return this.highlightPanel;
    }

    public JComponent getRowHeaderComponent() {
        return this.numPanel;
    }

    public void highlightAlgorithmNode(AlgorithmNode node) {
        String algName = node.getAlgorithmName();
        String algID = String.valueOf(node.getID());
        String dataRef = String.valueOf(node.getDataNodeRef());
        int startLine = this.getAlgMatch(algName, algID, dataRef);
        int lineCount = this.pane.getLineCount();
        int endLine = -1;
        for (int i = startLine; i < lineCount; ++i) {
            String endString;
            try {
                int start = this.pane.getLineStartOffset(i);
                int end = this.pane.getLineEndOffset(i);
                endString = this.pane.getText(start, end - start);
            }
            catch (BadLocationException ble) {
                return;
            }
            if (endString.indexOf("/algorithm") == -1) continue;
            endLine = i + 1;
            break;
        }
        if (endLine > startLine) {
            this.mark(startLine, endLine);
        }
    }

    private int getAlgMatch(String algName, String algID, String dataRef) {
        int lineCount = this.pane.getLineCount();
        Document doc = this.pane.getDocument();
        Vector indices = new Vector();
        boolean match = false;
        for (int i = 0; i < lineCount; ++i) {
            String line;
            try {
                int start = this.pane.getLineStartOffset(i);
                int end = this.pane.getLineEndOffset(i);
                line = this.pane.getText(start, end - start);
            }
            catch (BadLocationException ble) {
                return -1;
            }
            match = false;
            if (line.indexOf(algName) != -1 && line.indexOf("algorithm") != -1) {
                match = true;
                int keyIndex = line.indexOf("alg_id");
                String newLine = line.substring(keyIndex, line.length() - 1);
                StringTokenizer stok = new StringTokenizer(newLine, "\"");
                if (stok.hasMoreTokens()) {
                    stok.nextToken();
                }
                if (stok.hasMoreTokens()) {
                    newLine = stok.nextToken();
                }
                if (match = newLine.equals(algID)) {
                    keyIndex = line.indexOf("data_ref");
                    newLine = line.substring(keyIndex, line.length() - 1);
                    stok = new StringTokenizer(newLine, "\"");
                    if (stok.hasMoreTokens()) {
                        stok.nextToken();
                    }
                    if (stok.hasMoreTokens()) {
                        newLine = stok.nextToken();
                    }
                    match = newLine.equals(dataRef);
                }
            }
            if (!match) continue;
            return i;
        }
        return -1;
    }

    private void mark(int start, int end) {
        this.highlightPanel.setSelection(start, end);
        this.highlightPanel.repaint();
        if (end > start) {
            this.setEnableMenuItem("Clear Overlay", true);
        } else {
            this.setEnableMenuItem("Clear Overlay", false);
        }
    }

    private JPopupMenu createPopupMenu(MenuListener listener) {
        JPopupMenu menu = new JPopupMenu();
        if (!this.editOnly) {
            menu.add(this.createItem("Edit", "edit-cmd", "Enabled when parameter key/value or algorithm is selected", listener, false));
            menu.addSeparator();
            menu.add(this.createItem("Clear Overlay", "clear-overlay-cmd", "Clears the algorithm overlay area if present", listener, false));
            menu.addSeparator();
        }
        menu.add(this.createItem("Save Script", "save-cmd", "Save script to file", listener, true));
        return menu;
    }

    private JMenuItem createItem(String title, String cmd, String tip, MenuListener listener, boolean enabled) {
        JMenuItem item = new JMenuItem(title);
        item.setEnabled(enabled);
        item.setFocusPainted(false);
        item.setActionCommand(cmd);
        item.addActionListener(listener);
        return item;
    }

    private void setEnableMenuItem(String title, boolean enable) {
        int cnt = this.popup.getComponentCount();
        for (int i = 0; i < cnt; ++i) {
            Component item = this.popup.getComponent(i);
            if (!(item instanceof JMenuItem) || !((JMenuItem)item).getText().equals(title)) continue;
            ((JMenuItem)item).setEnabled(enable);
            break;
        }
    }

    private String readScript(File file) throws IOException {
        BufferedReader bfr = new BufferedReader(new FileReader(file));
        String text = new String();
        String line = new String();
        while ((line = bfr.readLine()) != null) {
            text = text + line + "\n";
        }
        return text;
    }

    private void saveScript() {
        JFileChooser chooser;
        if (this.scriptFile != null) {
            chooser = new JFileChooser(this.scriptFile.getPath());
            chooser.setSelectedFile(new File(this.scriptFile.getName()));
        } else {
            chooser = new JFileChooser(new File(TMEV.getSettingForOption("current-script-path")));
            if (this.doc.getDocumentName() != null) {
                chooser.setSelectedFile(new File(this.doc.getDocumentName()));
            }
        }
        if (chooser.showSaveDialog(new JPanel()) == 0) {
            try {
                this.writeScript(chooser.getSelectedFile());
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.pane, "An error occured while saving the script to file", "Save Error", 2);
            }
        }
    }

    private void writeScript(File file) throws IOException {
        BufferedWriter bfr = new BufferedWriter(new FileWriter(file));
        bfr.write(this.pane.getText());
        bfr.flush();
        bfr.close();
    }

    private Hashtable getAlgorithmAttributes(int cursorLoc) {
        int index;
        String text = this.pane.getText();
        text = text.substring(0, cursorLoc);
        cursorLoc = text.lastIndexOf("algorithm");
        Hashtable hash = null;
        if (cursorLoc > -1 && (index = (text = text.substring(cursorLoc)).indexOf(">")) != -1) {
            text = text.substring(0, index);
            hash = this.getAlgorithmAttributes(text);
        }
        return hash;
    }

    private Hashtable getAlgorithmAttributes(String text) {
        StringTokenizer stok = new StringTokenizer(text, "\"");
        Hashtable<String, String> hash = new Hashtable<String, String>();
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken();
            if (tok.indexOf("alg_id") != -1) {
                hash.put("alg_id", stok.hasMoreTokens() ? stok.nextToken() : " ");
                continue;
            }
            if (tok.indexOf("alg_name") != -1) {
                hash.put("alg_name", stok.hasMoreTokens() ? stok.nextToken() : " ");
                continue;
            }
            if (tok.indexOf("input_data_ref") != -1) {
                hash.put("input_data_ref", stok.hasMoreTokens() ? stok.nextToken() : " ");
                continue;
            }
            if (tok.indexOf("alg_type") == -1) continue;
            hash.put("alg_type", stok.hasMoreTokens() ? stok.nextToken() : " ");
        }
        return hash;
    }

    public class ScriptListener
    implements ScriptEventListener {
        @Override
        public void documentChanged(ScriptDocumentEvent event) {
            ScriptXMLViewer.this.updateSize();
        }
    }

    public class HighlightPanel
    extends JPanel {
        int start;
        int end;
        int top;
        int bottom;
        boolean algOverlay;

        public HighlightPanel() {
            super.setBackground(Color.white);
            this.setBackground(Color.white);
            this.algOverlay = false;
            this.end = -1;
            this.start = -1;
        }

        public void setSelection(int s, int e) {
            this.start = s;
            this.end = e;
            this.algOverlay = e > s;
        }

        public boolean haveOverlay() {
            return this.algOverlay;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.start > 0) {
                Color color = g.getColor();
                Graphics2D g2 = (Graphics2D)g;
                Composite composite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                g.setColor(Color.green);
                g.fillRect(0, this.start * ((ScriptXMLViewer)ScriptXMLViewer.this).numPanel.lineHeight, this.getWidth(), (this.end - this.start) * ((ScriptXMLViewer)ScriptXMLViewer.this).numPanel.lineHeight);
                g.setColor(color);
                g2.setComposite(composite);
            }
        }
    }

    public class LineNumberPanel
    extends JPanel {
        boolean newHeight;
        JList list;
        DefaultListModel model;
        int lineHeight;

        public LineNumberPanel() {
            super(new GridBagLayout());
            this.newHeight = false;
            this.list = new JList();
            this.list.setAlignmentX(1.0f);
            this.model = new DefaultListModel();
            this.list.setModel(this.model);
            this.list.setCellRenderer(new NumberPanelCellRenderer());
            this.list.setForeground(Color.red);
            this.list.setFont(ScriptXMLViewer.this.vFont);
            this.setFont(ScriptXMLViewer.this.vFont);
            this.list.setBackground(Color.lightGray);
            this.list.setVisibleRowCount(0);
            this.list.setVisible(true);
            FontMetrics fm = ScriptXMLViewer.this.pane.getFontMetrics(ScriptXMLViewer.this.pane.getFont());
            this.list.setFixedCellHeight(fm.getHeight());
            this.lineHeight = this.list.getFixedCellHeight();
            this.setPreferredSize(new Dimension(10, 10));
            this.add((Component)this.list, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (!ScriptXMLViewer.this.editOnly) {
                this.list.addMouseListener(new LineNumberListener());
                this.addMouseListener(new LineNumberListener());
            }
        }

        public void setHeight(int h) {
            boolean bigger = false;
            this.newHeight = true;
            if (h > this.model.size() + 1) {
                bigger = true;
                this.newHeight = true;
                for (int i = this.model.size() + 1; i < h; ++i) {
                    JLabel label = new JLabel(String.valueOf(i));
                    label.setFont(ScriptXMLViewer.this.vFont);
                    label.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
                    label.setHorizontalAlignment(4);
                    label.setHorizontalTextPosition(4);
                    this.model.addElement(label);
                }
            }
            this.list.setVisibleRowCount(h);
        }

        public void clearSelection() {
            this.list.clearSelection();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.newHeight) {
                this.newHeight = false;
                String s = ((JLabel)this.model.elementAt(this.model.size() - 1)).getText();
                int space = 8;
                if (g != null) {
                    FontMetrics metrics = g.getFontMetrics();
                    metrics.stringWidth(s);
                    this.list.setSize(metrics.stringWidth(s) + space, ScriptXMLViewer.this.pane.getHeight());
                    this.list.setPreferredSize(new Dimension(metrics.stringWidth(s) + space, ScriptXMLViewer.this.pane.getHeight()));
                    this.setSize(metrics.stringWidth(s) + space, ScriptXMLViewer.this.pane.getHeight());
                    this.setPreferredSize(new Dimension(metrics.stringWidth(s) + space, ScriptXMLViewer.this.pane.getHeight()));
                }
            }
        }

        public class LineNumberListener
        extends MouseAdapter {
            @Override
            public void mouseClicked(MouseEvent me) {
                int[] indices = LineNumberPanel.this.list.getSelectedIndices();
                if (indices != null) {
                    int curEnd;
                    int curStart;
                    try {
                        curStart = ScriptXMLViewer.this.pane.getLineStartOffset(indices[0]);
                        curEnd = ScriptXMLViewer.this.pane.getLineEndOffset(indices[indices.length - 1]);
                        ScriptXMLViewer.this.pane.getHighlighter().removeAllHighlights();
                        ScriptXMLViewer.this.pane.getHighlighter().addHighlight(curStart, curEnd, new DefaultHighlighter.DefaultHighlightPainter(new Color(120, 160, 210)));
                    }
                    catch (BadLocationException ble) {
                        return;
                    }
                    ScriptXMLViewer.this.pane.select(curStart, curEnd);
                    ScriptXMLViewer.this.pane.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                int[] indices = LineNumberPanel.this.list.getSelectedIndices();
                if (indices != null) {
                    int curEnd;
                    int curStart;
                    try {
                        curStart = ScriptXMLViewer.this.pane.getLineStartOffset(indices[0]);
                        curEnd = ScriptXMLViewer.this.pane.getLineEndOffset(indices[indices.length - 1]);
                        ScriptXMLViewer.this.pane.getHighlighter().removeAllHighlights();
                        ScriptXMLViewer.this.pane.getHighlighter().addHighlight(curStart, curEnd, new DefaultHighlighter.DefaultHighlightPainter(new Color(120, 160, 210)));
                    }
                    catch (BadLocationException ble) {
                        return;
                    }
                    ScriptXMLViewer.this.pane.select(curStart, curEnd);
                    ScriptXMLViewer.this.pane.repaint();
                }
            }
        }

        public class NumberPanelCellRenderer
        implements ListCellRenderer {
            Icon selIcon = GUIFactory.getIcon((String)"TreeBallLeaf.gif");
            JLabel selectedLabel = new JLabel(this.selIcon);

            public NumberPanelCellRenderer() {
                this.selectedLabel.setBackground(Color.gray);
                this.selectedLabel.setOpaque(true);
                this.selectedLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
                this.selectedLabel.setIconTextGap(0);
                this.selectedLabel.setHorizontalAlignment(4);
                this.selectedLabel.setHorizontalTextPosition(4);
            }

            public Component getListCellRendererComponent(JList jList, Object obj, int param, boolean selected, boolean param4) {
                if (selected && !ScriptXMLViewer.this.editOnly) {
                    return this.selectedLabel;
                }
                return (JLabel)obj;
            }
        }
    }

    private class MenuListener
    implements ActionListener {
        private MenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            if (cmd.equals("edit-cmd")) {
                String text = ScriptXMLViewer.this.pane.getSelectedText();
                if (text == null) {
                    return;
                }
                String newText = new String(text);
                int start = ScriptXMLViewer.this.pane.getSelectionStart();
                Hashtable attributes = ScriptXMLViewer.this.getAlgorithmAttributes(start);
                String algName = (String)attributes.get("alg_name");
                ScriptValueChangeDialog dialog = new ScriptValueChangeDialog(newText, algName, ScriptXMLViewer.this.manager);
                if (dialog.showModal() == 0) {
                    newText = dialog.getLine();
                    String value = dialog.getValue();
                    if (value != null && ScriptXMLViewer.this.doc.modifyParameter(attributes, dialog.getLine(), dialog.getValue())) {
                        ScriptXMLViewer.this.doc.updateScript();
                        ScriptXMLViewer.this.pane.setText(ScriptXMLViewer.this.doc.toString());
                        ScriptXMLViewer.this.pane.setCaretPosition(start);
                    }
                    try {
                        ScriptXMLViewer.this.pane.getHighlighter().addHighlight(start, start + newText.length(), new DefaultHighlighter.DefaultHighlightPainter(new Color(120, 160, 210)));
                    }
                    catch (BadLocationException ble) {
                        // empty catch block
                    }
                    ScriptXMLViewer.this.pane.select(start, start + newText.length());
                }
            } else if (cmd.equals("clear-overlay-cmd")) {
                ScriptXMLViewer.this.mark(-1, -1);
            } else if (!cmd.equals("mark-algorithm-cmd") && cmd.equals("save-cmd")) {
                ScriptXMLViewer.this.saveScript();
            }
        }
    }

    public class PaneListener
    extends MouseAdapter {
        int start;
        int end;
        String text;

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.getModifiers() == 16) {
                if (!ScriptXMLViewer.this.editOnly) {
                    ((ScriptXMLViewer)ScriptXMLViewer.this).numPanel.list.clearSelection();
                    ScriptXMLViewer.this.pane.getHighlighter().removeAllHighlights();
                }
            } else if (me.isPopupTrigger()) {
                this.start = ScriptXMLViewer.this.pane.getSelectionStart();
                this.end = ScriptXMLViewer.this.pane.getSelectionEnd();
                if (this.end > this.start) {
                    this.text = ScriptXMLViewer.this.pane.getSelectedText();
                    ScriptXMLViewer.this.setEnableMenuItem("Edit", this.text.indexOf("value") != -1);
                } else {
                    ScriptXMLViewer.this.setEnableMenuItem("Edit", false);
                }
                ScriptXMLViewer.this.setEnableMenuItem("Clear Overlay", ScriptXMLViewer.this.highlightPanel.haveOverlay());
                ScriptXMLViewer.this.popup.show(ScriptXMLViewer.this.pane, me.getX(), me.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.getModifiers() == 16) {
                if (!ScriptXMLViewer.this.editOnly) {
                    ((ScriptXMLViewer)ScriptXMLViewer.this).numPanel.list.clearSelection();
                    ScriptXMLViewer.this.pane.getHighlighter().removeAllHighlights();
                }
            } else if (me.isPopupTrigger()) {
                this.start = ScriptXMLViewer.this.pane.getSelectionStart();
                this.end = ScriptXMLViewer.this.pane.getSelectionEnd();
                if (this.end > this.start) {
                    this.text = ScriptXMLViewer.this.pane.getSelectedText();
                    ScriptXMLViewer.this.setEnableMenuItem("Edit", this.text.indexOf("value") != -1);
                } else {
                    ScriptXMLViewer.this.setEnableMenuItem("Edit", false);
                }
                ScriptXMLViewer.this.setEnableMenuItem("Clear Overlay", ScriptXMLViewer.this.highlightPanel.haveOverlay());
                ScriptXMLViewer.this.popup.show(ScriptXMLViewer.this.pane, me.getX(), me.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.getModifiers() == 16) {
                if (!ScriptXMLViewer.this.editOnly) {
                    ((ScriptXMLViewer)ScriptXMLViewer.this).numPanel.list.clearSelection();
                    ScriptXMLViewer.this.pane.getHighlighter().removeAllHighlights();
                }
            } else if (me.isPopupTrigger()) {
                this.start = ScriptXMLViewer.this.pane.getSelectionStart();
                this.end = ScriptXMLViewer.this.pane.getSelectionEnd();
                if (this.end > this.start) {
                    this.text = ScriptXMLViewer.this.pane.getSelectedText();
                    ScriptXMLViewer.this.setEnableMenuItem("Edit", this.text.indexOf("value") != -1);
                } else {
                    ScriptXMLViewer.this.setEnableMenuItem("Edit", false);
                }
                ScriptXMLViewer.this.setEnableMenuItem("Clear Overlay", ScriptXMLViewer.this.highlightPanel.haveOverlay());
                ScriptXMLViewer.this.popup.show(ScriptXMLViewer.this.pane, me.getX(), me.getY());
            }
        }
    }

    public class PaneEditorListener
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                ScriptXMLViewer.this.numPanel.setHeight(ScriptXMLViewer.this.pane.getLineCount());
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                ScriptXMLViewer.this.numPanel.setHeight(ScriptXMLViewer.this.pane.getLineCount());
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                ScriptXMLViewer.this.numPanel.setHeight(ScriptXMLViewer.this.pane.getLineCount());
            }
        }
    }
}

