/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.mev.script.util.ParameterAttributes;

public class ScriptValueChangeDialog
extends AlgorithmDialog {
    private int result = 2;
    private ScriptManager manager;
    private String algName;
    private String origLine;
    private String line;
    private String key;
    private String origValue;
    private String valueType;
    private String leadingSpaces;
    private JLabel prefix;
    private String value;
    private JLabel suffix;
    private JComponent valueComponent;
    private Hashtable parameterHash;

    public ScriptValueChangeDialog(String origLine, String algName, ScriptManager manager) {
        super(new JFrame(), "Value Editor", true);
        this.manager = manager;
        this.algName = algName;
        this.origLine = origLine;
        this.leadingSpaces = new String();
        this.initializeValues();
        ParameterPanel paramPanel = new ParameterPanel("Script Line");
        paramPanel.setLayout((LayoutManager)new GridBagLayout());
        Component hintLabel = null;
        int lineBottomInset = 0;
        paramPanel.add((Component)this.prefix, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, lineBottomInset, 0), 0, 0));
        paramPanel.add((Component)this.valueComponent, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 2, lineBottomInset, 2), 0, 0));
        paramPanel.add((Component)this.suffix, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, lineBottomInset, 0), 0, 0));
        if (hintLabel != null) {
            paramPanel.add(hintLabel, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 5, 0), 0, 0));
        }
        JButton paramButton = new JButton("View Valid Parameters");
        paramButton.setBorder(BorderFactory.createBevelBorder(0));
        paramButton.setFocusPainted(false);
        paramButton.addActionListener(new ParameterListener());
        paramButton.setPreferredSize(new Dimension(180, 30));
        paramButton.setSize(180, 30);
        paramPanel.add((Component)paramButton, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 5, 0), 0, 0));
        this.parameterHash = manager.getParameterHash(algName);
        ButtonPanel bp = new ButtonPanel();
        this.supplantButtonPanel(bp);
        this.addContent((Component)paramPanel);
        this.pack();
    }

    private void initializeValues() {
        String strPost;
        int pnt = this.origLine.indexOf("value");
        if (pnt >= 0) {
            String strPre = this.origLine.substring(0, pnt);
            this.leadingSpaces = "";
            char[] array = strPre.toCharArray();
            for (int i = 0; i < array.length && array[i] == ' '; ++i) {
                this.leadingSpaces = this.leadingSpaces + " ";
            }
            strPre = strPre.trim();
            strPost = this.origLine.substring(pnt);
            pnt = strPost.indexOf("\"");
            this.value = strPost.substring(pnt + 1);
            strPost = new String(this.value);
            pnt = this.value.indexOf("\"");
            this.value = this.value.substring(0, pnt);
            this.value.trim();
            strPost = strPost.substring(pnt + 1);
            this.prefix = this.createJLabel(strPre + " value=\"");
            this.suffix = this.createJLabel("\"" + strPost);
            this.valueComponent = this.getValueComponent(this.value);
        } else {
            this.prefix = this.createJLabel(" ");
            this.suffix = this.createJLabel(" ");
            this.valueComponent = new JLabel("Incorrect construction");
        }
        pnt = this.origLine.indexOf("key");
        if (pnt >= 0) {
            strPost = this.origLine.substring(pnt);
            pnt = strPost.indexOf("\"");
            strPost = strPost.substring(pnt + 1);
            pnt = strPost.indexOf("\"");
            this.key = strPost.substring(0, pnt);
            this.key = this.key.trim();
        }
    }

    private JLabel createJLabel(String text) {
        JLabel label = new JLabel(text);
        label.setBackground(Color.white);
        return label;
    }

    private JComponent getValueComponent(String val) {
        String type = "unknown";
        if (val.equals("true") || val.equals("false")) {
            String[] vals = new String[]{"true", "false"};
            JComboBox<String> box = new JComboBox<String>(vals);
            if (val.equals("true")) {
                box.setSelectedIndex(0);
            } else {
                box.setSelectedIndex(1);
            }
            this.valueType = type = "boolean";
            return box;
        }
        boolean haveType = false;
        char[] array = val.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            if (!Character.isLetter(array[i]) || array[i] == '.') continue;
            type = "a character string";
            haveType = true;
            break;
        }
        int dotCnt = 0;
        if (!haveType) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != '.') continue;
                ++dotCnt;
            }
            if (dotCnt == 1) {
                type = "a floating point number";
                haveType = true;
            } else if (dotCnt > 1) {
                type = "a character string";
                haveType = true;
            } else if (dotCnt == 0) {
                type = "an integer number";
                haveType = true;
            }
        }
        JTextField valField = new JTextField(val, val.length() + 3);
        this.valueType = type;
        return valField;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public void onReset() {
    }

    public String getLine() {
        return this.line;
    }

    public String getValue() {
        if (this.valueComponent != null) {
            if (this.valueComponent instanceof JTextField) {
                return ((JTextField)this.valueComponent).getText();
            }
            if (this.valueComponent instanceof JComboBox) {
                return (String)((JComboBox)this.valueComponent).getSelectedItem();
            }
        }
        return null;
    }

    private boolean validateValue(String val) {
        String maxStr;
        String minStr;
        ParameterAttributes atts = this.manager.getParameterAttributes(this.algName, this.key);
        if (atts == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Parameter value, type, and constraints could not be verified.\nValue will be committed but please consider it's validity.", "Parameter Validataion Warning", 2);
            return true;
        }
        String type = atts.getValueType();
        if (!this.checkType(val, type)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Parameter type seems incorrect ( requires: " + type + " )", "Parameter Validataion Error", 0);
            return false;
        }
        if (atts.hasConstraints() && !this.checkConstraints(val, type, minStr = atts.getMin(), maxStr = atts.getMax())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Parameter falls outside the constraints.", "Parameter Validataion Error", 0);
            return false;
        }
        return true;
    }

    private boolean checkConstraints(String val, String type, String min, String max) {
        if (type.equals("int")) {
            int value = Integer.parseInt(val);
            if (!min.equals("") && !max.equals("")) {
                return value >= Integer.parseInt(min) && value <= Integer.parseInt(max);
            }
            if (!max.equals("")) {
                return value <= Integer.parseInt(max);
            }
            if (!min.equals("")) {
                return value >= Integer.parseInt(min);
            }
            return true;
        }
        if (type.equals("float")) {
            float value = Float.parseFloat(val);
            if (!min.equals("") && !max.equals("")) {
                return value >= Float.parseFloat(min) && value <= Float.parseFloat(max);
            }
            if (!max.equals("")) {
                return value <= Float.parseFloat(max);
            }
            if (!min.equals("")) {
                return value >= Float.parseFloat(min);
            }
            return true;
        }
        if (type.equals("long")) {
            long value = Long.parseLong(val);
            if (!min.equals("") && !max.equals("")) {
                return value >= Long.parseLong(min) && value <= Long.parseLong(max);
            }
            if (!max.equals("")) {
                return value <= Long.parseLong(max);
            }
            if (!min.equals("")) {
                return value >= Long.parseLong(min);
            }
            return true;
        }
        if (type.equals("double")) {
            double value = Double.parseDouble(val);
            if (!min.equals("") && !max.equals("")) {
                return value >= Double.parseDouble(min) && value <= Double.parseDouble(max);
            }
            if (!max.equals("")) {
                return value <= Double.parseDouble(max);
            }
            if (!min.equals("")) {
                return value >= Double.parseDouble(min);
            }
            return true;
        }
        return true;
    }

    private boolean checkType(String val, String type) {
        try {
            if (type.equals("int")) {
                Integer.parseInt(val);
            } else if (type.equals("float")) {
                Float.parseFloat(val);
            } else if (type.equals("long")) {
                Long.parseLong(val);
            } else if (type.equals("double")) {
                Double.parseDouble(val);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private class ButtonPanel
    extends JPanel {
        private JButton refreshBut;
        private JButton resetBut;
        private JButton cancelBut;
        private JButton okBut;
        private JButton infoButton;

        public ButtonPanel() {
            super(new GridBagLayout());
            ButtonListener listener = new ButtonListener();
            JPanel buttonsPanel = new JPanel(new GridLayout(1, 3, 10, 10));
            this.resetBut = new JButton("Reset");
            this.resetBut.setBorder(BorderFactory.createBevelBorder(0));
            this.resetBut.setFocusPainted(false);
            this.resetBut.setActionCommand("reset-cmd");
            this.resetBut.addActionListener(listener);
            buttonsPanel.add(this.resetBut);
            this.cancelBut = new JButton("Cancel");
            this.cancelBut.setBorder(BorderFactory.createBevelBorder(0));
            this.cancelBut.setSize(60, 30);
            this.cancelBut.setPreferredSize(new Dimension(60, 30));
            this.cancelBut.setFocusPainted(false);
            this.cancelBut.setActionCommand("cancel-cmd");
            this.cancelBut.addActionListener(listener);
            buttonsPanel.add(this.cancelBut);
            this.okBut = new JButton("Commit");
            this.okBut.setBorder(BorderFactory.createBevelBorder(0, new Color(240, 240, 240), new Color(180, 180, 180), new Color(10, 0, 0), new Color(10, 10, 10)));
            this.okBut.setSize(60, 30);
            this.okBut.setPreferredSize(new Dimension(60, 30));
            this.okBut.setFocusPainted(false);
            this.okBut.setActionCommand("commit-cmd");
            this.okBut.addActionListener(listener);
            buttonsPanel.add(this.okBut);
            this.infoButton = new JButton(null, GUIFactory.getIcon((String)"Information24.gif"));
            this.infoButton.setActionCommand("info-cmd");
            this.infoButton.setBorder(BorderFactory.createBevelBorder(0));
            this.infoButton.setSize(30, 30);
            this.infoButton.setPreferredSize(new Dimension(30, 30));
            this.infoButton.setFocusPainted(false);
            this.infoButton.addActionListener(listener);
            this.add((Component)this.infoButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)buttonsPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public class ButtonListener
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (!cmd.equals("apply-cmd")) {
                    if (cmd.equals("cancel-cmd")) {
                        ScriptValueChangeDialog.this.dispose();
                    } else if (cmd.equals("commit-cmd")) {
                        ScriptValueChangeDialog.this.result = 0;
                        if (ScriptValueChangeDialog.this.valueType != null && ScriptValueChangeDialog.this.valueType.equals("boolean")) {
                            ScriptValueChangeDialog.this.value = (String)((JComboBox)ScriptValueChangeDialog.this.valueComponent).getSelectedItem();
                            ScriptValueChangeDialog.this.line = ScriptValueChangeDialog.this.leadingSpaces + ScriptValueChangeDialog.this.prefix.getText() + ScriptValueChangeDialog.this.value + ScriptValueChangeDialog.this.suffix.getText();
                            ScriptValueChangeDialog.this.dispose();
                        } else {
                            ScriptValueChangeDialog.this.value = ((JTextField)ScriptValueChangeDialog.this.valueComponent).getText();
                            if (ScriptValueChangeDialog.this.validateValue(ScriptValueChangeDialog.this.value)) {
                                ScriptValueChangeDialog.this.line = ScriptValueChangeDialog.this.leadingSpaces + ScriptValueChangeDialog.this.prefix.getText() + ScriptValueChangeDialog.this.value + ScriptValueChangeDialog.this.suffix.getText();
                                ScriptValueChangeDialog.this.dispose();
                            }
                        }
                    } else if (!cmd.equals("reset-cmd") && cmd.equals("info-cmd")) {
                        HelpWindow.launchBrowser((Window)((Object)ScriptValueChangeDialog.this), (String)"Script Value Input Dialog");
                    }
                }
            }

            public void windowClosing(WindowEvent e) {
                ScriptValueChangeDialog.this.result = -1;
                ScriptValueChangeDialog.this.dispose();
            }
        }
    }

    private class ParameterListener
    implements ActionListener {
        private ParameterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String table;
            if (ScriptValueChangeDialog.this.manager != null && ScriptValueChangeDialog.this.algName != null && (table = ScriptValueChangeDialog.this.manager.getValidParametersTable(ScriptValueChangeDialog.this.algName)) != null && table.length() > 0) {
                JFrame frame = new JFrame("Valid Parameters for " + ScriptValueChangeDialog.this.algName);
                JDialog d = new JDialog((Dialog)((Object)ScriptValueChangeDialog.this), "Valid Parameters for " + ScriptValueChangeDialog.this.algName);
                JTextPane pane = new JTextPane();
                pane.setContentType("text/html");
                pane.setText(table);
                pane.setEditable(false);
                pane.setBackground(new Color(Integer.parseInt("FFFFCC", 16)));
                pane.setMargin(new Insets(5, 10, 5, 10));
                JScrollPane spane = new JScrollPane(pane);
                d.getContentPane().add(spane);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                d.setSize(screenSize.width / 3, (int)((double)screenSize.height / 1.5));
                d.setLocation((screenSize.width - d.getSize().width) / 2, (screenSize.height - d.getSize().height) / 2);
                d.setVisible(true);
            }
        }
    }
}

