/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.script.ScriptDocument;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.mev.script.event.ScriptDocumentEvent;
import org.tigr.microarray.mev.script.event.ScriptEventListener;
import org.tigr.microarray.mev.script.util.AlgorithmNode;
import org.tigr.microarray.mev.script.util.AlgorithmSet;
import org.tigr.microarray.mev.script.util.DataNode;
import org.tigr.microarray.mev.script.util.ScriptNode;
import org.tigr.microarray.mev.script.util.ScriptTree;

public class ScriptTreeViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 1000102010301040001L;
    ScriptTree scriptTree;
    JPopupMenu dataPopup;
    JPopupMenu algPopup;
    JPopupMenu defaultMenu;
    ScriptTreeListener listener;
    ScriptManager manager;
    private boolean isAlgSetViewer = false;
    private DataNode algSetRoot;
    boolean selected = false;

    public ScriptTreeViewer(ScriptTree tree, ScriptManager manager) {
        this.scriptTree = tree;
        this.manager = manager;
        this.listener = new ScriptTreeListener();
        this.scriptTree.addMouseListener(this.listener);
        this.scriptTree.getDocument().addDocumentListener(new ScriptListener());
        this.dataPopup = this.createPopupMenu(this.listener, "data");
        this.algPopup = this.createPopupMenu(this.listener, "alg");
        this.defaultMenu = this.createPopupMenu(this.listener, "default");
        this.isAlgSetViewer = false;
    }

    public ScriptTreeViewer(ScriptTree tree, ScriptManager manager, DataNode algSetRoot) {
        this.scriptTree = tree;
        this.manager = manager;
        this.algSetRoot = this.findLocalAlgSetRoot(algSetRoot.toString());
        if (this.algSetRoot != null) {
            this.scriptTree.highlightAlgSet(this.algSetRoot);
            this.isAlgSetViewer = true;
        } else {
            this.isAlgSetViewer = false;
        }
    }

    private DataNode findLocalAlgSetRoot(String rootName) {
        AlgorithmSet[] sets = this.scriptTree.getAlgorithmSets();
        DataNode dataNode = null;
        for (int i = 0; i < sets.length; ++i) {
            if (!sets[i].getDataNode().toString().equals(rootName)) continue;
            dataNode = sets[i].getDataNode();
            break;
        }
        return dataNode;
    }

    public void onSelected(IFramework framework) {
        this.selected = true;
        if (this.isAlgSetViewer) {
            this.scriptTree.highlightAlgSet(this.algSetRoot);
        } else {
            this.scriptTree.clearHighlights();
        }
        this.scriptTree.validate();
    }

    public void onClosed() {
        this.selected = false;
    }

    public JComponent getContentComponent() {
        return this.scriptTree;
    }

    public JPopupMenu createPopupMenu(ScriptTreeListener listener, String type) {
        JMenuItem item;
        JPopupMenu menu = new JPopupMenu();
        if (type.equals("alg")) {
            item = new JMenuItem("Change Algorithm");
            item.setActionCommand("replace-algorithm-cmd");
            item.addActionListener(listener);
            item = new JMenuItem("Delete Algorithm");
            item.setActionCommand("delete-algorithm-cmd");
            item.addActionListener(listener);
            menu.add(item);
            item = new JMenuItem("Modify Paramaters");
            item.setActionCommand("modify-algorithm-cmd");
            item.addActionListener(listener);
            menu.addSeparator();
            item = new JMenuItem("View XML Section");
            item.setActionCommand("view-xml-cmd");
            item.addActionListener(listener);
            menu.add(item);
            menu.addSeparator();
        } else {
            item = new JMenuItem("Add Algorithm Node");
            item.setActionCommand("add-new-algorithm-cmd");
            item.addActionListener(listener);
            menu.add(item);
            menu.addSeparator();
        }
        item = new JMenuItem("Execute Script");
        item.setActionCommand("execute-script-cmd");
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Save Script");
        item.setActionCommand("save-script-cmd");
        item.addActionListener(listener);
        menu.add(item);
        return menu;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.manager);
        oos.writeObject(this.scriptTree.getDocument());
        oos.writeBoolean(this.isAlgSetViewer);
        if (this.isAlgSetViewer) {
            oos.writeObject(this.algSetRoot);
        }
        oos.writeBoolean(this.selected);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.manager = (ScriptManager)ois.readObject();
        this.scriptTree = new ScriptTree((ScriptDocument)ois.readObject(), this.manager);
        this.isAlgSetViewer = ois.readBoolean();
        if (this.isAlgSetViewer) {
            this.algSetRoot = (DataNode)ois.readObject();
            this.algSetRoot = this.scriptTree.getDataNodeNamed(this.algSetRoot.toString());
            if (this.algSetRoot != null) {
                this.scriptTree.highlightAlgSet(this.algSetRoot);
            }
        }
        this.selected = ois.readBoolean();
    }

    public class ScriptListener
    implements ScriptEventListener {
        @Override
        public void documentChanged(ScriptDocumentEvent event) {
            ScriptTreeViewer.this.scriptTree.updateTree();
        }
    }

    public class ScriptTreeListener
    extends MouseAdapter
    implements ActionListener {
        ScriptNode node;

        @Override
        public void mouseClicked(MouseEvent me) {
            if (ScriptTreeViewer.this.isAlgSetViewer) {
                return;
            }
            if (me.isPopupTrigger()) {
                this.node = ScriptTreeViewer.this.scriptTree.getSelectedNode();
                if (this.node == null) {
                    ScriptTreeViewer.this.defaultMenu.show(ScriptTreeViewer.this.scriptTree, me.getX(), me.getY());
                } else if (this.node instanceof AlgorithmNode) {
                    ScriptTreeViewer.this.algPopup.show(ScriptTreeViewer.this.scriptTree, me.getX(), me.getY());
                } else {
                    ScriptNode parent = (ScriptNode)this.node.getParent();
                    if (parent != null) {
                        if (((AlgorithmNode)parent).getAlgorithmType().equals("data-visualization")) {
                            ScriptTreeViewer.this.dataPopup.getComponent(0).setEnabled(false);
                        } else {
                            ScriptTreeViewer.this.dataPopup.getComponent(0).setEnabled(true);
                        }
                    }
                    ScriptTreeViewer.this.dataPopup.show(ScriptTreeViewer.this.scriptTree, me.getX(), me.getY());
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (ScriptTreeViewer.this.isAlgSetViewer) {
                return;
            }
            if (me.isPopupTrigger()) {
                this.node = ScriptTreeViewer.this.scriptTree.getSelectedNode();
                if (this.node == null) {
                    return;
                }
                if (this.node instanceof AlgorithmNode) {
                    ScriptTreeViewer.this.algPopup.show(ScriptTreeViewer.this.scriptTree, me.getX(), me.getY());
                } else {
                    ScriptNode parent = (ScriptNode)this.node.getParent();
                    if (parent != null) {
                        if (((AlgorithmNode)parent).getAlgorithmType().equals("data-visualization")) {
                            ScriptTreeViewer.this.dataPopup.getComponent(0).setEnabled(false);
                        } else {
                            ScriptTreeViewer.this.dataPopup.getComponent(0).setEnabled(true);
                        }
                    }
                    ScriptTreeViewer.this.dataPopup.show(ScriptTreeViewer.this.scriptTree, me.getX(), me.getY());
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (ScriptTreeViewer.this.isAlgSetViewer) {
                return;
            }
            if (me.isPopupTrigger()) {
                this.node = ScriptTreeViewer.this.scriptTree.getSelectedNode();
                if (this.node == null) {
                    return;
                }
                if (this.node instanceof AlgorithmNode) {
                    ScriptTreeViewer.this.algPopup.show(ScriptTreeViewer.this.scriptTree, me.getX(), me.getY());
                } else {
                    ScriptNode parent = (ScriptNode)this.node.getParent();
                    if (parent != null) {
                        if (((AlgorithmNode)parent).getAlgorithmType().equals("data-visualization")) {
                            ScriptTreeViewer.this.dataPopup.getComponent(0).setEnabled(false);
                        } else {
                            ScriptTreeViewer.this.dataPopup.getComponent(0).setEnabled(true);
                        }
                    }
                    ScriptTreeViewer.this.dataPopup.show(ScriptTreeViewer.this.scriptTree, me.getX(), me.getY());
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ScriptTreeViewer.this.isAlgSetViewer) {
                return;
            }
            String command = actionEvent.getActionCommand();
            if (command.equals("add-new-algorithm-cmd") || command.equals("replace-algorithm-cmd")) {
                this.node = ScriptTreeViewer.this.scriptTree.getSelectedNode();
                if (this.node == null) {
                    return;
                }
                if (this.node instanceof DataNode) {
                    ScriptTreeViewer.this.scriptTree.addNewAlgorithmToDataNode((DataNode)this.node);
                }
            } else if (command.equals("delete-algorithm-cmd")) {
                this.node = ScriptTreeViewer.this.scriptTree.getSelectedNode();
                if (this.node != null && this.node instanceof AlgorithmNode) {
                    ScriptTreeViewer.this.scriptTree.removeAlgorithm((AlgorithmNode)this.node);
                }
            } else if (!command.equals("modify-algorithm-cmd")) {
                if (command.equals("view-xml-cmd")) {
                    this.node = ScriptTreeViewer.this.scriptTree.getSelectedNode();
                    if (this.node != null) {
                        ScriptTreeViewer.this.manager.viewSelectedNodeXML(ScriptTreeViewer.this, this.node);
                    }
                } else if (command.equals("save-script-cmd")) {
                    ScriptTreeViewer.this.manager.saveScript(ScriptTreeViewer.this.scriptTree.getDocument());
                } else if (command.equals("execute-script-cmd")) {
                    ScriptTreeViewer.this.manager.runScript(ScriptTreeViewer.this.scriptTree.getDocument());
                }
            }
        }
    }
}

