/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.script.util.AlgorithmNode;
import org.tigr.microarray.mev.script.util.DataNode;
import org.tigr.microarray.mev.script.util.ScriptNode;

public class ScriptTreeRenderer
implements TreeCellRenderer {
    private ScriptNodeLabel label;
    private JPanel labelPanel;
    private DataNode algSetRoot = null;
    private boolean highlightAlgSet = false;
    boolean showToolTips = true;
    private Icon scriptAnalysisIcon = GUIFactory.getIcon((String)"ScriptAnalysis.gif");
    private Icon scriptGeneAnalysisIcon = GUIFactory.getIcon((String)"ScriptGeneAlgorithm.gif");
    private Icon scriptExperimentAnalysisIcon = GUIFactory.getIcon((String)"ScriptExperimentAlgorithm.gif");
    private Icon scriptClusterSelectionAnalysisIcon = GUIFactory.getIcon((String)"ScriptClusterSelectionAlgorithm.gif");
    private Icon scriptAdjustmentAlgIcon = GUIFactory.getIcon((String)"adjustment_algorithm.gif");
    private Icon scriptEmptyAnalysisIcon = GUIFactory.getIcon((String)"TreeBallLeaf.gif");
    private Icon scriptVisAlgNodeIcon = GUIFactory.getIcon((String)"ScriptVisAlgorithmNode.gif");
    private Icon scriptDataNodeIcon = GUIFactory.getIcon((String)"ScriptDataNode.gif");
    private Icon scriptPrimaryDataNodeIcon = GUIFactory.getIcon((String)"ScriptPrimaryDataNode.gif");
    private Icon scriptMultiDataNodeIcon = GUIFactory.getIcon((String)"ScriptMultiDataNodeShaded.gif");
    private Color dataNodeColor;
    private Color algNodeColor;

    public ScriptTreeRenderer() {
        this.label = new ScriptNodeLabel();
        this.dataNodeColor = new Color(209, 248, 203);
        this.algNodeColor = new Color(255, 255, 195);
        this.labelPanel = new JPanel(new GridBagLayout());
        this.labelPanel.setBackground(Color.white);
        this.labelPanel.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 0, 0, 0), 5, 0));
    }

    public void clearHighlights() {
        this.highlightAlgSet = false;
        this.label.setScriptNodeHighlighted(false);
    }

    public void highlightAlgSet(DataNode algSetRoot) {
        this.highlightAlgSet = true;
        this.algSetRoot = algSetRoot;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean hasFocus) {
        if (!this.highlightAlgSet) {
            this.label.setScriptNodeSelected(selected);
        } else {
            this.label.setScriptNodeSelected(false);
            this.checkHighlight((ScriptNode)value);
        }
        if (value instanceof DataNode) {
            this.label.setBackgroundColor(this.dataNodeColor);
            this.label.setRounded(false);
            DataNode dataNode = (DataNode)value;
            String text = dataNode.toString();
            if (text.indexOf("Primary") != -1) {
                this.label.setIcon(this.scriptPrimaryDataNodeIcon);
            } else if (text.indexOf("Multi") != -1) {
                this.label.setIcon(this.scriptMultiDataNodeIcon);
            } else {
                this.label.setIcon(this.scriptDataNodeIcon);
            }
            this.label.setText(text);
        } else if (value instanceof AlgorithmNode) {
            this.label.setBackgroundColor(this.algNodeColor);
            this.label.setRounded(true);
            AlgorithmNode algNode = (AlgorithmNode)value;
            String text = algNode.toString();
            if (text != null && !text.equals("") || !text.equals(" ")) {
                if (algNode.getAlgorithmType().equals("cluster")) {
                    this.label.setIcon(this.scriptAnalysisIcon);
                } else if (algNode.getAlgorithmType().equals("cluster-genes")) {
                    this.label.setIcon(this.scriptGeneAnalysisIcon);
                } else if (algNode.getAlgorithmType().equals("cluster-experiments")) {
                    this.label.setIcon(this.scriptExperimentAnalysisIcon);
                } else if (algNode.getAlgorithmType().equals("data-adjustment")) {
                    this.label.setIcon(this.scriptAdjustmentAlgIcon);
                } else if (algNode.getAlgorithmType().equals("data-visualization")) {
                    this.label.setIcon(this.scriptVisAlgNodeIcon);
                } else if (algNode.getAlgorithmType().equals("cluster-selection")) {
                    this.label.setIcon(this.scriptClusterSelectionAnalysisIcon);
                }
                this.label.setText(text + " [" + algNode.getDataNodeRef() + "," + algNode.getID() + "] ");
            } else {
                this.label.setText("Empty Algorithm ");
                this.label.setBorder(BorderFactory.createLineBorder(Color.blue, 3));
                this.label.setIcon(this.scriptEmptyAnalysisIcon);
            }
        }
        this.label.validate();
        this.labelPanel.validate();
        return this.labelPanel;
    }

    private void checkHighlight(ScriptNode node) {
        ScriptNode parent = (ScriptNode)node.getParent();
        if (this.algSetRoot == null) {
            return;
        }
        if (node == this.algSetRoot || parent != null && parent == this.algSetRoot || parent != null && parent.getParent() != null && parent.getParent() == this.algSetRoot) {
            this.label.setScriptNodeHighlighted(true);
        } else {
            this.label.setScriptNodeHighlighted(false);
        }
    }

    private class ScriptNodeLabel
    extends JLabel {
        boolean showRound;
        boolean sel;
        boolean highlighted;
        Color backgroundColor;

        public ScriptNodeLabel() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 8));
            this.backgroundColor = new Color(249, 249, 112);
        }

        public void setBackgroundColor(Color bkg) {
            this.backgroundColor = bkg;
        }

        public void setScriptNodeSelected(boolean selected) {
            this.sel = selected;
        }

        public void setScriptNodeHighlighted(boolean isLit) {
            this.highlighted = isLit;
            if (isLit && this.sel) {
                this.sel = false;
            }
        }

        public void setRounded(boolean isRounded) {
            this.showRound = isRounded;
        }

        @Override
        public void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            g.setColor(this.backgroundColor);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.showRound) {
                if (this.sel) {
                    g2.fillRoundRect(2, 2, width - 4, height - 4, 19, 19);
                    g2.setColor(Color.blue);
                    g2.drawRoundRect(1, 1, width - 3, height - 3, 19, 19);
                    g2.drawRoundRect(0, 0, width - 1, height - 1, 20, 20);
                    g2.setColor(Color.black);
                    super.paintComponent(g);
                } else if (this.highlighted) {
                    g2.fillRoundRect(2, 2, width - 4, height - 4, 19, 19);
                    g2.setColor(new Color(176, 23, 54));
                    g2.drawRoundRect(1, 1, width - 3, height - 3, 19, 19);
                    g2.drawRoundRect(0, 0, width - 1, height - 1, 20, 20);
                    g2.setColor(Color.black);
                    super.paintComponent(g);
                } else if (!ScriptTreeRenderer.this.highlightAlgSet) {
                    g2.fillRoundRect(1, 1, width - 2, height - 2, 19, 19);
                    g2.setColor(Color.black);
                    g2.drawRoundRect(0, 0, width - 1, height - 1, 20, 20);
                    g2.setColor(Color.black);
                    super.paintComponent(g);
                } else {
                    Color color = g.getColor();
                    Composite composite = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(3, 0.25f));
                    g2.fillRoundRect(1, 1, width - 2, height - 2, 19, 19);
                    g2.setColor(Color.black);
                    g2.drawRoundRect(0, 0, width - 1, height - 1, 20, 20);
                    g2.setColor(Color.black);
                    super.paintComponent(g);
                    g.setColor(color);
                    g2.setComposite(composite);
                }
            } else {
                g2.fillRect(0, 0, width, height);
                if (this.sel) {
                    g2.setColor(Color.blue);
                    g2.drawRect(1, 1, width - 3, height - 3);
                    g2.drawRect(0, 0, width - 1, height - 1);
                    g2.setColor(Color.black);
                    super.paintComponent(g);
                } else if (this.highlighted) {
                    g2.setColor(new Color(176, 23, 54));
                    g2.drawRect(1, 1, width - 3, height - 3);
                    g2.drawRect(0, 0, width - 1, height - 1);
                    g2.setColor(Color.black);
                    super.paintComponent(g);
                } else if (!ScriptTreeRenderer.this.highlightAlgSet) {
                    g2.setColor(Color.black);
                    g2.drawRect(0, 0, width - 1, height - 1);
                    g2.setColor(Color.black);
                    super.paintComponent(g);
                } else {
                    Color color = g.getColor();
                    Composite composite = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(3, 0.25f));
                    g2.setColor(Color.black);
                    g2.drawRect(0, 0, width - 1, height - 1);
                    g2.setColor(Color.black);
                    super.paintComponent(g);
                    g.setColor(color);
                    g2.setComposite(composite);
                }
            }
        }
    }
}

