/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.script.Script;
import org.tigr.microarray.mev.script.ScriptDocument;
import org.tigr.microarray.mev.script.ScriptManager;

public class ScriptTable
extends ViewerAdapter {
    public static final long serialVersionUID = 1000102010301030001L;
    private JTable table;
    private Vector data;
    private ScriptDataModel dataModel;
    private ScriptManager manager;
    private JPopupMenu menu;

    public ScriptTable(ScriptManager manager, Vector data) {
        this.manager = manager;
        this.dataModel = new ScriptDataModel(data, this.constructHeaderNames());
        this.table = new JTable(this.dataModel);
        this.table.setBackground(Color.white);
        TableListener listener = new TableListener();
        this.menu = this.createPopupMenu(listener);
        this.table.addMouseListener(listener);
        this.table.setVisible(true);
    }

    private Vector constructHeaderNames() {
        Vector<String> names = new Vector<String>();
        names.add("Row");
        names.add("Script ID");
        names.add("File Name");
        names.add("Script Name");
        names.add("Script Description");
        return names;
    }

    private JPopupMenu createPopupMenu(TableListener listener) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Exectute Script");
        item.setActionCommand("run-script-cmd");
        item.addActionListener(listener);
        menu.add(item);
        return menu;
    }

    public void addScriptDoc(ScriptDocument doc) {
        this.data.add(doc);
    }

    public void update() {
    }

    public JComponent getContentComponent() {
        return this.table;
    }

    public JComponent getHeaderComponent() {
        return this.table.getTableHeader();
    }

    public class TableListener
    extends MouseAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            int row;
            String command = ae.getActionCommand();
            if (command.equals("run-script-cmd") && (row = ScriptTable.this.table.getSelectedRow()) > -1) {
                ScriptTable.this.manager.runScript(row);
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                ScriptTable.this.menu.show(ScriptTable.this.table, me.getX(), me.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                ScriptTable.this.menu.show(ScriptTable.this.table, me.getX(), me.getY());
            }
        }
    }

    public class ScriptDataModel
    extends AbstractTableModel
    implements Serializable {
        Vector data;
        ScriptDocument currentDoc;
        Vector headerNames;

        public ScriptDataModel(Vector data, Vector header) {
            this.data = data;
            this.headerNames = header;
        }

        @Override
        public Object getValueAt(int row, int column) {
            this.currentDoc = ((Script)this.data.elementAt(row)).getScriptDocument();
            String obj = new String(" ");
            switch (column) {
                case 0: {
                    obj = String.valueOf(row + 1);
                    break;
                }
                case 1: {
                    obj = new String("Script(" + this.currentDoc.getDocumentID() + ")");
                    break;
                }
                case 2: {
                    String temp = this.currentDoc.getDocumentFileName();
                    if (temp == null) {
                        obj = new String("New Script");
                        break;
                    }
                    obj = temp;
                    break;
                }
                case 3: {
                    obj = this.currentDoc.getDocumentName();
                    break;
                }
                case 4: {
                    obj = this.currentDoc.getDescription();
                }
            }
            return obj;
        }

        @Override
        public String getColumnName(int column) {
            return (String)this.headerNames.elementAt(column);
        }

        @Override
        public int getColumnCount() {
            return this.headerNames.size();
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }
    }
}

