/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class ScriptClusterSelectionInfoViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 1000102010301020001L;
    private JComponent header = this.createHeader();
    private JTextPane content;
    private boolean clusterGenes;

    public ScriptClusterSelectionInfoViewer(AlgorithmData algData) {
        this.clusterGenes = algData.getParams().getBoolean("process-gene-clusters");
        this.content = this.createContent(algData);
        this.setMaxWidth(this.content, this.header);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeBoolean(this.clusterGenes);
        oos.writeObject(this.content.getText());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.header = this.createHeader();
        this.clusterGenes = ois.readBoolean();
        String contentString = (String)ois.readObject();
        this.content = new JTextPane();
        this.content.setContentType("text/html");
        this.content.setEditable(false);
        this.content.setMargin(new Insets(0, 10, 0, 0));
        this.content.setText(contentString);
        this.content.setCaretPosition(0);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        panel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Cluster Selection Information</b></font></body></html>"), gbc);
        return panel;
    }

    private JTextPane createContent(AlgorithmData algData) {
        String text;
        String algName = algData.getParams().getString("name");
        int numOfDesiredClusters = algData.getParams().getInt("desired-cluster-count");
        String[] div = algData.getStringArray("diversity-value-array");
        String[] pop = algData.getStringArray("cluster-population-array");
        int popLimit = algData.getParams().getInt("minimum-cluster-size");
        JTextPane area = new JTextPane();
        area.setContentType("text/html");
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        if (algName.equals("Diversity Ranking Cluster Selection")) {
            boolean useCentroid = algData.getParams().getBoolean("use-centroid-based-variability");
            text = "<html><body bgcolor='#FFFFFF'><font face='serif' size='5'>";
            text = text + "<br>Number of Desired Clusters: " + numOfDesiredClusters + "<br>";
            text = text + "Minimum Cluster Size (population): " + popLimit + "<br>";
            text = useCentroid ? text + "Diversity Measurement: Centroid Based Diversity (mean gene-to-centroid dist.)<br>" : text + "Diversity Measurement: Intra-gene Based Diversity (mean gene-to-gene dist.)<br>";
            text = text + "<br><br>Note: Clusters are sorted by diversity.  Selected clusters are in <b>bold</b> type.<br>";
            text = text + "<table cellpadding=10><th><u>Div. Rank</u></th><th><u>Diversity</u></th><th><u>Population</u></td>";
            int clusterCount = 0;
            for (int i = 0; i < div.length; ++i) {
                int population = Integer.parseInt(pop[i]);
                if (population >= popLimit && clusterCount < numOfDesiredClusters) {
                    text = text + "<tr align=center><td><b>" + (i + 1) + "</b></td><td><b>" + div[i] + "</b></td><td><b>" + pop[i] + "</b></td></tr>";
                    ++clusterCount;
                    continue;
                }
                text = text + "<tr align=center><td>" + (i + 1) + "</td><td>" + div[i] + "</td><td>" + pop[i] + "</td></tr>";
            }
            text = text + "</table></body></html>";
        } else {
            boolean useVariance = algData.getParams().getBoolean("use-centroid-variance");
            text = "<html><body bgcolor='#FFFFFF'><font face='serif' size='5'>";
            text = text + "<br>Number of Desired Clusters: " + numOfDesiredClusters + "<br>";
            text = text + "Minimum Cluster Size (population): " + popLimit + "<br>";
            if (useVariance) {
                text = text + "Selection Criteria: Centroid Variance<br>";
                text = text + "<br><br>Note: Clusters are sorted by decreasing variance.  Selected clusters are in <b>bold</b> type.<br>";
                text = text + "<table cellpadding=10><th><u>Var. Rank</u></th><th><u>Variance</u></th><th><u>Population</u></td>";
            } else {
                text = text + "Selection Criteria: Centroid Entropy<br>";
                text = text + "<br><br>Note: Clusters are sorted by decreasing entropy.  Selected clusters are in <b>bold</b> type.<br>";
                text = text + "<table cellpadding=10><th><u>Entropy Rank</u></th><th><u>Entropy</u></th><th><u>Population</u></td>";
            }
            int clusterCount = 0;
            for (int i = 0; i < div.length; ++i) {
                int population = Integer.parseInt(pop[i]);
                if (population >= popLimit && clusterCount < numOfDesiredClusters) {
                    text = text + "<tr align=center><td><b>" + (i + 1) + "</b></td><td><b>" + div[i] + "</b></td><td><b>" + pop[i] + "</b></td></tr>";
                    ++clusterCount;
                    continue;
                }
                text = text + "<tr align=center><td>" + (i + 1) + "</td><td>" + div[i] + "</td><td>" + pop[i] + "</td></tr>";
            }
            text = text + "</table></body></html>";
        }
        area.setText(text);
        area.setCaretPosition(0);
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }
}

