/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class ScriptAttributeDialog
extends AlgorithmDialog {
    private int result = 2;
    private JTextField dateField;
    private JTextField nameField;
    private JTextArea descriptionArea;
    private String dateString;

    public ScriptAttributeDialog() {
        super(new JFrame(), "Script Attribute Input", true);
        JLabel dateLabel = new JLabel("Creation Date: ");
        Date date = new Date(System.currentTimeMillis());
        TimeZone tz = TimeZone.getDefault();
        DateFormat format = DateFormat.getDateTimeInstance();
        format.setTimeZone(tz);
        this.dateString = format.format(date);
        dateLabel.setHorizontalAlignment(4);
        this.dateField = new JTextField(this.dateString, 20);
        JLabel nameLabel = new JLabel("Script Name: ");
        nameLabel.setHorizontalAlignment(4);
        this.nameField = new JTextField(20);
        JLabel descLabel = new JLabel("Description: ");
        descLabel.setVerticalAlignment(1);
        descLabel.setHorizontalAlignment(4);
        this.descriptionArea = new JTextArea(10, 25);
        JScrollPane pane = new JScrollPane(this.descriptionArea);
        pane.setHorizontalScrollBarPolicy(31);
        this.descriptionArea.setWrapStyleWord(true);
        ParameterPanel parameterPanel = new ParameterPanel("Script Attributes");
        parameterPanel.setLayout((LayoutManager)new GridBagLayout());
        parameterPanel.add((Component)dateLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        parameterPanel.add((Component)nameLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        parameterPanel.add((Component)descLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameterPanel.add((Component)this.dateField, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 10, 0), 0, 0));
        parameterPanel.add((Component)this.nameField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 10, 0), 0, 0));
        parameterPanel.add((Component)pane, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel dialogPanel = new JPanel(new GridBagLayout());
        dialogPanel.setBackground(Color.white);
        dialogPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        dialogPanel.add((Component)parameterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.addContent(dialogPanel);
        this.setActionListeners((ActionListener)((Object)new Listener()));
        this.pack();
        this.nameField.requestFocus();
        this.nameField.selectAll();
    }

    public ScriptAttributeDialog(int id, String name, String description) {
        super(new JFrame(), "Script Attribute Modification", true);
        this.dateField = new JTextField(String.valueOf(id));
        this.dateField.setEditable(false);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
        this.dateField.setText(this.dateString);
        this.nameField.setText("");
        this.descriptionArea.setText("");
        this.nameField.requestFocus();
        this.nameField.selectAll();
    }

    public String getDate() {
        return this.dateField.getText();
    }

    public String getName() {
        return this.nameField.getText();
    }

    public String getFormattedDescription() {
        String text = this.descriptionArea.getText();
        String formatText = "";
        int lineCount = this.descriptionArea.getLineCount();
        if (lineCount < 1) {
            return null;
        }
        Document doc = this.descriptionArea.getDocument();
        try {
            for (int i = 0; i < lineCount; ++i) {
                int startOffset = this.descriptionArea.getLineStartOffset(i);
                int endOffset = this.descriptionArea.getLineEndOffset(i);
                String line = doc.getText(startOffset, endOffset - startOffset);
                if (i > 0) {
                    formatText = formatText + "            ";
                }
                formatText = formatText + line;
            }
        }
        catch (BadLocationException ble) {
            return null;
        }
        return formatText;
    }

    public String getDescription() {
        return this.descriptionArea.getText();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                ScriptAttributeDialog.this.result = 0;
                ScriptAttributeDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                ScriptAttributeDialog.this.result = 2;
                ScriptAttributeDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                ScriptAttributeDialog.this.resetControls();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser((Window)((Object)ScriptAttributeDialog.this), (String)"Script Attribute Dialog");
            }
        }

        public void windowClosing(WindowEvent e) {
            ScriptAttributeDialog.this.result = -1;
            ScriptAttributeDialog.this.dispose();
        }
    }
}

