/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.tigr.microarray.mev.action.ActionManager;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;

public class ScriptAlgorithmInitDialog
extends AlgorithmDialog {
    private int result;
    private int algorithmIndex = -1;
    private String algorithmType;
    private String currentAlgorithmName;
    private JPanel mainPanel;
    private ActionManager actionManager;
    private PreviewPanel previewPanel;
    private AlgorithmSelectionPanel algSelPanel;
    private AdjustmentSelectionPanel adjSelPanel;
    private ClusterSelectionPanel clusterSelectionPanel;

    public ScriptAlgorithmInitDialog(ActionManager manager, String nodeType, boolean isAffyData) {
        super(new JFrame(), "Script Algorithm Initialization Dialog", true);
        this.actionManager = manager;
        this.algorithmType = "cluster";
        this.result = 2;
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setBackground(Color.white);
        this.previewPanel = new PreviewPanel();
        this.algSelPanel = new AlgorithmSelectionPanel(this.actionManager);
        this.adjSelPanel = new AdjustmentSelectionPanel(isAffyData);
        this.clusterSelectionPanel = new ClusterSelectionPanel();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Analysis Algorithms", (Component)((Object)this.algSelPanel));
        tabbedPane.addTab("Adjustment Algorithms", (Component)((Object)this.adjSelPanel));
        tabbedPane.addTab("Cluster Selection Algorithms", this.clusterSelectionPanel);
        if (nodeType.equals("multi-gene-cluster-output") || nodeType.equals("multi-experiment-cluster-output") || nodeType.equals("multi-cluster-output")) {
            tabbedPane.setEnabledAt(0, false);
            tabbedPane.setEnabledAt(1, false);
            tabbedPane.setSelectedIndex(2);
        } else {
            tabbedPane.setEnabledAt(2, false);
        }
        this.mainPanel.add((Component)((Object)this.previewPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)tabbedPane, new GridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        Listener listener = new Listener();
        this.addWindowListener((WindowListener)((Object)listener));
        this.addContent(this.mainPanel);
        this.setActionListeners((ActionListener)((Object)listener));
        this.pack();
        if (!isAffyData) {
            this.setSize(new Dimension(510, 587));
        } else {
            this.setSize(new Dimension(510, 665));
        }
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public void onReset() {
        this.previewPanel.reset();
        this.algSelPanel.reset();
        this.adjSelPanel.reset();
        this.clusterSelectionPanel.reset();
        this.algorithmIndex = -1;
        this.algorithmType = "";
        this.currentAlgorithmName = "";
    }

    public String getAlgorithmType() {
        return this.algorithmType;
    }

    public String getAlgorithmName() {
        return this.currentAlgorithmName;
    }

    public int getAlgorithmIndex() {
        String number;
        if (this.currentAlgorithmName != null && (number = (String)this.algSelPanel.indexHash.get(this.currentAlgorithmName)) != null) {
            return Integer.parseInt(number);
        }
        return -1;
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == ScriptAlgorithmInitDialog.this.okButton) {
                ScriptAlgorithmInitDialog.this.result = 0;
                ScriptAlgorithmInitDialog.this.dispose();
            } else if (source == ScriptAlgorithmInitDialog.this.cancelButton) {
                ScriptAlgorithmInitDialog.this.result = 2;
                ScriptAlgorithmInitDialog.this.dispose();
            } else if (source == ScriptAlgorithmInitDialog.this.resetButton) {
                ScriptAlgorithmInitDialog.this.onReset();
            } else if (source == ScriptAlgorithmInitDialog.this.infoButton) {
                HelpWindow.launchBrowser((Window)((Object)ScriptAlgorithmInitDialog.this), (String)"Script Algorithm Initialization Dialog");
            }
        }

        public void windowClosing(WindowEvent e) {
            ScriptAlgorithmInitDialog.this.result = -1;
            ScriptAlgorithmInitDialog.this.dispose();
        }
    }

    private class ClusterSelectionPanel
    extends JPanel {
        JRadioButton diversityButton;
        JRadioButton centroidEntropyButton;
        JRadioButton noButton;

        public ClusterSelectionPanel() {
            this.setLayout(new GridBagLayout());
            ButtonListener listener = new ButtonListener();
            ParameterPanel panel = new ParameterPanel();
            panel.setLayout((LayoutManager)new GridBagLayout());
            this.diversityButton = new JRadioButton("Diversity Ranking Cluster Selection", false);
            this.diversityButton.setFocusPainted(false);
            this.diversityButton.setOpaque(false);
            this.diversityButton.addActionListener(listener);
            this.centroidEntropyButton = new JRadioButton("Centroid Variance or Entropy Cluster Selection", false);
            this.centroidEntropyButton.setFocusPainted(false);
            this.centroidEntropyButton.setOpaque(false);
            this.centroidEntropyButton.addActionListener(listener);
            this.noButton = new JRadioButton("hidden", true);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.diversityButton);
            bg.add(this.centroidEntropyButton);
            bg.add(this.noButton);
            panel.add((Component)this.centroidEntropyButton, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
            panel.add((Component)this.diversityButton, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 0, 0), 0, 0));
            this.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void reset() {
            this.noButton.setSelected(true);
        }

        private class ButtonListener
        implements ActionListener {
            private ButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ClusterSelectionPanel.this.diversityButton.isSelected()) {
                    ScriptAlgorithmInitDialog.this.previewPanel.setValues("Cluster Selection", "Diversity Ranking Cluster Selection");
                    ScriptAlgorithmInitDialog.this.algorithmType = "cluster-selection";
                    ScriptAlgorithmInitDialog.this.currentAlgorithmName = "Diversity Ranking Cluster Selection";
                } else if (ClusterSelectionPanel.this.centroidEntropyButton.isSelected()) {
                    ScriptAlgorithmInitDialog.this.previewPanel.setValues("Cluster Selection", "Centroid Entropy Ranking Cluster Selection");
                    ScriptAlgorithmInitDialog.this.algorithmType = "cluster-selection";
                    ScriptAlgorithmInitDialog.this.currentAlgorithmName = "Centroid Entropy/Variance Ranking Cluster Selection";
                }
            }
        }
    }

    private class NormalizationSelectionPanel
    extends JPanel {
        private NormalizationSelectionPanel() {
        }
    }

    private class AdjustmentSelectionPanel
    extends ParameterPanel {
        ButtonGroup bg;
        JCheckBox noneBox;

        public AdjustmentSelectionPanel(boolean isAffyData) {
            super("Adjustment Selection");
            this.setLayout(new GridBagLayout());
            AdjustmentBoxListener listener = new AdjustmentBoxListener();
            this.bg = new ButtonGroup();
            this.noneBox = new JCheckBox("none", true);
            this.bg.add(this.noneBox);
            ParameterPanel filterPanel = new ParameterPanel("Gene/Row Filters");
            filterPanel.setLayout((LayoutManager)new GridBagLayout());
            JCheckBox percBox = this.createCheckBox("Percentage Cutoff", "Requires x% valid expression values to retain a gene", listener);
            JCheckBox lowerBox = this.createCheckBox("Lower Cutoffs", "Cy3 and Cy5 must have a minium value \n to retain gene. (see info page)", listener);
            filterPanel.add((Component)percBox, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 0, 10, 25), 0, 0));
            filterPanel.add((Component)lowerBox, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 25, 10, 0), 0, 0));
            ParameterPanel genePanel = new ParameterPanel("Gene/Row Based Adjustments");
            genePanel.setLayout((LayoutManager)new GridBagLayout());
            JCheckBox gNormBox = this.createCheckBox("Normalize Genes/Rows", "Adjust Vector ||v||=1", listener);
            JCheckBox gRMSBox = this.createCheckBox("Divide Genes/Rows by RMS", "Divide values by spot's RMS", listener);
            JCheckBox gSDBox = this.createCheckBox("Divide Genes/Rows by SD", "Divide values by spot's SD", listener);
            JCheckBox gMCBox = this.createCheckBox("Mean Center Genes/Rows", "Divide values by spot's Mean", listener);
            JCheckBox gMedCBox = this.createCheckBox("Median Center Genes/Rows", "Divide values by spot's Median", listener);
            JCheckBox gDigBox = this.createCheckBox("Digital Genes/Rows", "Bins spot's values into log2(#Spots) int value bins ", listener);
            genePanel.add((Component)gNormBox, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 10, 0), 0, 0));
            genePanel.add((Component)gRMSBox, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            genePanel.add((Component)gSDBox, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            genePanel.add((Component)gMCBox, (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            genePanel.add((Component)gMedCBox, (Object)new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            genePanel.add((Component)gDigBox, (Object)new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            ParameterPanel expPanel = new ParameterPanel("Sample/Column Based Adjustments");
            expPanel.setLayout((LayoutManager)new GridBagLayout());
            JCheckBox eNormBox = this.createCheckBox("Normalize Samples/Columns", "Adjust Vector ||v||=1", listener);
            JCheckBox eRMSBox = this.createCheckBox("Divide Samples/Columns by RMS", "Divide values by sample's RMS", listener);
            JCheckBox eSDBox = this.createCheckBox("Divide Samples/Columns by SD", "Divide values by sample's SD", listener);
            JCheckBox eMCBox = this.createCheckBox("Mean Center Samples/Columns", "Divide values by sample's Mean", listener);
            JCheckBox eMedCBox = this.createCheckBox("Median Center Samples/Columns", "Divide values by sample's Median", listener);
            JCheckBox eDigBox = this.createCheckBox("Digital Samples/Columns", "Bins values into log2(#Exps) int value bins ", listener);
            expPanel.add((Component)eNormBox, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 10, 0), 0, 0));
            expPanel.add((Component)eRMSBox, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            expPanel.add((Component)eSDBox, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            expPanel.add((Component)eMCBox, (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            expPanel.add((Component)eMedCBox, (Object)new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            expPanel.add((Component)eDigBox, (Object)new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            this.add((Component)filterPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)genePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)expPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            if (isAffyData) {
                ParameterPanel affyPanel = new ParameterPanel("Affimetrix Filtering Options");
                affyPanel.setLayout((LayoutManager)new GridBagLayout());
                JCheckBox affyDetectionBox = this.createCheckBox("Detection Filter", "Filters by detection flag.", listener);
                JCheckBox affyFoldBox = this.createCheckBox("Fold Filter", "Filters by fold change.", listener);
                affyPanel.add((Component)affyDetectionBox, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 0, 10, 25), 0, 0));
                affyPanel.add((Component)affyFoldBox, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 25, 10, 0), 0, 0));
                this.add((Component)affyPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            }
        }

        private JCheckBox createCheckBox(String label, String toolTip, ActionListener listener) {
            JCheckBox box = new JCheckBox(label);
            box.setBackground(Color.white);
            box.setFocusPainted(false);
            box.setActionCommand(label);
            box.setToolTipText(toolTip);
            box.addActionListener(listener);
            this.bg.add(box);
            return box;
        }

        public void reset() {
            this.noneBox.setSelected(true);
        }

        private class AdjustmentBoxListener
        implements ActionListener {
            private AdjustmentBoxListener() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                String algorithmName = ae.getActionCommand();
                ScriptAlgorithmInitDialog.this.currentAlgorithmName = algorithmName;
                ScriptAlgorithmInitDialog.this.previewPanel.setValues("Adjustment Algorithm", algorithmName);
                ScriptAlgorithmInitDialog.this.algorithmType = "data-adjustment";
            }
        }
    }

    private class AlgorithmSelectionPanel
    extends ParameterPanel {
        ButtonPanel buttonPanel;
        ButtonListener listener;
        Hashtable descriptions;
        Hashtable indexHash;

        AlgorithmSelectionPanel(ActionManager actionManager) {
            super("Algorithm Selection");
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.listener = new ButtonListener();
            this.buttonPanel = new ButtonPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.setBackground(Color.white);
            this.descriptions = new Hashtable();
            this.indexHash = new Hashtable();
            this.addAlgorithmButtons(actionManager);
            this.add(this.buttonPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void addAlgorithmButtons(ActionManager manager) {
            Action action;
            int algCnt = 0;
            while ((action = manager.getAction("analysis-action" + String.valueOf(algCnt))) != null) {
                ++algCnt;
            }
            int x = 1;
            int y = algCnt;
            while ((y += ++x * (y = (int)Math.floor(algCnt / x)) < algCnt ? 1 : 0) > x) {
            }
            algCnt = 0;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(4, 4, 4, 4);
            int cnt = 0;
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    action = manager.getAction("analysis-action" + String.valueOf(cnt));
                    if (action != null) {
                        JButton button = new JButton();
                        button.setFocusPainted(false);
                        button.setActionCommand((String)action.getValue("Name"));
                        button.addActionListener(this.listener);
                        button.setIcon((Icon)action.getValue("LargeIcon"));
                        button.setText("");
                        button.setToolTipText((String)action.getValue("ShortDescription"));
                        button.setPreferredSize(new Dimension(45, 45));
                        button.setBorder(BorderFactory.createBevelBorder(0));
                        gbc.gridx = j;
                        gbc.gridy = i;
                        this.buttonPanel.add((Component)button, gbc);
                        this.descriptions.put(action.getValue("Name"), action.getValue("ShortDescription"));
                        this.indexHash.put(action.getValue("Name"), String.valueOf(cnt));
                        try {
                            ClassLoader cl = Thread.currentThread().getContextClassLoader();
                            Class<?> clazz = Class.forName((String)action.getValue("command-parameter"), true, cl);
                            IClusterGUI gui = (IClusterGUI)clazz.newInstance();
                            button.setEnabled(gui instanceof IScriptGUI);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ++cnt;
                }
            }
        }

        public void reset() {
            this.buttonPanel.setSelected(false);
            this.buttonPanel.repaint();
        }

        private class ButtonListener
        implements ActionListener {
            private ButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                String algorithmName = ae.getActionCommand();
                ScriptAlgorithmInitDialog.this.currentAlgorithmName = algorithmName;
                Object button = ae.getSource();
                if (button != null && button instanceof JButton) {
                    AlgorithmSelectionPanel.this.buttonPanel.setSelection((JButton)button);
                    ScriptAlgorithmInitDialog.this.algorithmType = "cluster";
                    ScriptAlgorithmInitDialog.this.previewPanel.setValues("Analysis Algorithm", algorithmName + ": " + (String)AlgorithmSelectionPanel.this.descriptions.get(algorithmName));
                }
            }
        }

        private class ButtonPanel
        extends JPanel {
            boolean isSelected = false;
            Point selectedSector;
            JButton selectedButton;

            public void setSelection(JButton button) {
                this.isSelected = true;
                this.selectedButton = button;
                this.repaint();
            }

            public void setSelected(boolean value) {
                this.isSelected = value;
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (this.isSelected && this.selectedButton != null) {
                    this.selectedSector = this.selectedButton.getLocation();
                    g.setColor(Color.blue);
                    g.drawRect(this.selectedSector.x - 5, this.selectedSector.y - 5, 54, 54);
                    g.drawRect(this.selectedSector.x - 4, this.selectedSector.y - 4, 52, 52);
                }
            }
        }
    }

    private class PreviewPanel
    extends ParameterPanel {
        JTextField categoryValueField;
        JTextField algValueField;

        public PreviewPanel() {
            super("Selection Preview");
            super.setLayout((LayoutManager)new GridBagLayout());
            JLabel categoryLabel = new JLabel("Algorithm Category: ");
            this.categoryValueField = new JTextField("Not Selected", 25);
            this.categoryValueField.setEditable(false);
            JLabel algNameLabel = new JLabel("Algorithm: ");
            this.algValueField = new JTextField("Not Selected", 25);
            this.algValueField.setEditable(false);
            this.add(categoryLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 20, 0, 0), 0, 0));
            this.add(this.categoryValueField, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 10, 0, 0), 0, 0));
            this.add(algNameLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 20, 5, 0), 0, 0));
            this.add(this.algValueField, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(10, 10, 5, 0), 0, 0));
        }

        public void reset() {
            this.algValueField.setText("Not Selected");
            this.categoryValueField.setText("Not Selected");
        }

        public void setValues(String cat, String name) {
            this.algValueField.setText(name);
            this.categoryValueField.setText(cat);
        }
    }
}

