/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class DiversityRankingInitDialog
extends AlgorithmDialog {
    private int result;
    private JTextField numClustersField;
    private JTextField minClusterSizeField;
    private JRadioButton centroidDiversityButton;
    private JRadioButton geneDiversityButton;

    public DiversityRankingInitDialog(JFrame parent) {
        super(parent, "Diversity Ranking Cluster Selection", true);
        ParameterPanel paramPanel = new ParameterPanel("Selection Parameters");
        paramPanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel clusterLabel = new JLabel("Desired Number of Clusters");
        this.numClustersField = new JTextField("3", 5);
        JLabel sizeLabel = new JLabel("Minimum Cluster Size (# genes)");
        this.minClusterSizeField = new JTextField("10");
        ButtonGroup bg = new ButtonGroup();
        this.centroidDiversityButton = new JRadioButton("Rank Clusters on Centroid Based Diversity", true);
        this.centroidDiversityButton.setOpaque(false);
        bg.add(this.centroidDiversityButton);
        this.centroidDiversityButton.setFocusPainted(false);
        this.geneDiversityButton = new JRadioButton("Rank Clusters on Intra-gene Based Diversity");
        this.geneDiversityButton.setOpaque(false);
        bg.add(this.geneDiversityButton);
        this.geneDiversityButton.setFocusPainted(false);
        paramPanel.add((Component)clusterLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        paramPanel.add((Component)this.numClustersField, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        paramPanel.add((Component)sizeLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 10), 0, 0));
        paramPanel.add((Component)this.minClusterSizeField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 0, 0), 0, 0));
        paramPanel.add((Component)this.centroidDiversityButton, (Object)new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(15, 0, 0, 0), 0, 0));
        paramPanel.add((Component)this.geneDiversityButton, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 10, 0), 0, 0));
        this.addContent((Component)paramPanel);
        this.setActionListeners((ActionListener)((Object)new Listener()));
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public int getClusterNumber() {
        return Integer.parseInt(this.numClustersField.getText());
    }

    public int getClusterSize() {
        return Integer.parseInt(this.minClusterSizeField.getText());
    }

    public boolean isCentroidBased() {
        return this.centroidDiversityButton.isSelected();
    }

    private void resetControls() {
        this.numClustersField.setText("3");
        this.minClusterSizeField.setText("10");
        this.centroidDiversityButton.setSelected(true);
    }

    private boolean validateParameters() {
        int c;
        int n;
        int level = 0;
        try {
            n = Integer.parseInt(this.numClustersField.getText());
            ++level;
            c = Integer.parseInt(this.minClusterSizeField.getText());
            ++level;
        }
        catch (Exception e) {
            if (level == 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The cluster number should be an integer > 0.\nPlease enter a new value.", "Parameter Type Mismatch", 0);
                this.numClustersField.selectAll();
                this.numClustersField.grabFocus();
                return false;
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "The minimum cluster population should be an integer > 0.\nPlease enter a new value.", "Parameter Type Mismatch", 0);
            this.minClusterSizeField.selectAll();
            this.minClusterSizeField.grabFocus();
            return false;
        }
        if (n < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The cluster number should be an integer > 0.\nPlease enter a new value greater than zero.", "Parameter Value Error", 0);
            this.numClustersField.selectAll();
            this.numClustersField.grabFocus();
            return false;
        }
        if (c < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The minimum cluster size should be an integer > 0.\nPlease enter a new value greater than zero.", "Parameter Value Error", 0);
            this.numClustersField.selectAll();
            this.numClustersField.grabFocus();
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        DiversityRankingInitDialog dialog = new DiversityRankingInitDialog(new JFrame());
        dialog.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                if (DiversityRankingInitDialog.this.validateParameters()) {
                    DiversityRankingInitDialog.this.dispose();
                    DiversityRankingInitDialog.this.result = 0;
                }
                return;
            }
            if (command.equals("cancel-command")) {
                DiversityRankingInitDialog.this.result = 2;
                DiversityRankingInitDialog.this.dispose();
                return;
            }
            if (command.equals("reset-command")) {
                DiversityRankingInitDialog.this.resetControls();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser((Window)((Object)DiversityRankingInitDialog.this), (String)"Diversity Ranking Cluster Selection");
            }
        }

        public void windowClosing(WindowEvent e) {
            DiversityRankingInitDialog.this.result = -1;
            DiversityRankingInitDialog.this.dispose();
        }
    }
}

