/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script;

import java.awt.Frame;
import java.awt.Insets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tigr.microarray.mev.DetectionFilter;
import org.tigr.microarray.mev.FoldFilter;
import org.tigr.microarray.mev.SetDetectionFilterDialog;
import org.tigr.microarray.mev.SetFoldFilterDialog;
import org.tigr.microarray.mev.SetLowerCutoffsDialog;
import org.tigr.microarray.mev.SetPercentageCutoffsDialog;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.action.ActionManager;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.script.Script;
import org.tigr.microarray.mev.script.ScriptDocument;
import org.tigr.microarray.mev.script.scriptGUI.CentroidEntropyRankingInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.DiversityRankingInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.microarray.mev.script.scriptGUI.ScriptAlgorithmInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.ScriptAttributeDialog;
import org.tigr.microarray.mev.script.scriptGUI.ScriptTable;
import org.tigr.microarray.mev.script.scriptGUI.ScriptTreeViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptXMLViewer;
import org.tigr.microarray.mev.script.util.AlgorithmNode;
import org.tigr.microarray.mev.script.util.ErrorLog;
import org.tigr.microarray.mev.script.util.ParameterAttributes;
import org.tigr.microarray.mev.script.util.ParameterValidator;
import org.tigr.microarray.mev.script.util.ScriptNode;
import org.tigr.microarray.mev.script.util.ScriptRunner;
import org.tigr.microarray.mev.script.util.ScriptTree;

public class ScriptManager
implements Serializable {
    public static final String CURRENT_SCRIPT_PATH = "current-script-path";
    public static final long serialVersionUID = 10001020103010001L;
    private DefaultMutableTreeNode scriptManagerNode;
    private ActionManager actionManager;
    private ScriptTable table;
    private int scriptNum;
    private IFramework framework;
    private ParameterValidator validator;
    private Progress progress;
    private Vector scripts;

    public ScriptManager(IFramework framework, DefaultMutableTreeNode scriptNode, ActionManager manager) {
        this.framework = framework;
        this.actionManager = manager;
        this.scriptManagerNode = scriptNode;
        this.scripts = new Vector();
        this.scriptNum = 1;
    }

    public ScriptManager() {
    }

    public void loadScript() {
        JFileChooser chooser = new JFileChooser(TMEV.getSettingForOption(CURRENT_SCRIPT_PATH));
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showOpenDialog(this.framework.getFrame()) == 0) {
            this.loadXML(chooser.getSelectedFile());
        }
    }

    public void loadXML(File file) {
        Thread thread = new Thread(new ThreadHandler(file));
        thread.setPriority(1);
        this.progress = new Progress(this.framework.getFrame(), "Script Loading and Validation", null);
        this.progress.show();
        thread.start();
    }

    private boolean loadScript(File inputFile) {
        ScriptTree tree;
        ScriptDocument newScriptDoc = new ScriptDocument(this.scriptNum, inputFile.getPath(), this);
        ErrorLog errorLog = newScriptDoc.getErrorLog();
        boolean validationErrors = false;
        try {
            newScriptDoc.loadXMLFile(inputFile, this.progress);
            if (newScriptDoc.getErrorCount() > 0) {
                if (errorLog.hasErrors() || errorLog.hasFatalErrors()) {
                    validationErrors = true;
                    this.progress.dispose();
                }
                errorLog.reportAllListings();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Script loading has been aborted due to parse errors.", "Script Parse Error", 1);
            this.progress.dispose();
            return false;
        }
        if (validationErrors) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Script loading has been aborted.  If the script has been \nrepaired to correct the errors you can attempt to load it again.", "Script Validation Error", 1);
            return false;
        }
        newScriptDoc.setDocumentFileName(inputFile.getPath());
        newScriptDoc.setName(inputFile.getName());
        if (this.validator == null) {
            this.validator = new ParameterValidator();
            this.validator.loadParameterConstraints();
        }
        if (!this.validateParameters(tree = new ScriptTree(newScriptDoc, this), errorLog)) {
            this.progress.dispose();
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Script loading has been aborted.  If the script has been \nrepaired to correct the errors you can attempt to load it again.", "Parmameter Validataion Error", 1);
            return false;
        }
        if (this.table == null) {
            this.table = new ScriptTable(this, this.scripts);
            DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(new LeafInfo("Script Table", (IViewer)this.table));
            this.framework.addNode(this.scriptManagerNode, tableNode);
        }
        ScriptTreeViewer treeViewer = new ScriptTreeViewer(tree, this);
        ScriptXMLViewer xmlViewer = new ScriptXMLViewer(newScriptDoc, this);
        DefaultMutableTreeNode scriptNode = new DefaultMutableTreeNode(new LeafInfo("Script (" + this.scriptNum + ")"));
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(new LeafInfo("Script Tree Viewer", (IViewer)treeViewer));
        DefaultMutableTreeNode xmlNode = new DefaultMutableTreeNode(new LeafInfo("Script XML Viewer", (IViewer)xmlViewer));
        scriptNode.add(treeNode);
        scriptNode.add(xmlNode);
        this.scripts.add(new Script(newScriptDoc, tree, xmlViewer));
        this.framework.addNode(this.scriptManagerNode, scriptNode);
        this.framework.setTreeNode(treeNode);
        ++this.scriptNum;
        this.validator.checkAlgorithmsForDataDependance(tree, this);
        return true;
    }

    public void addNewScript() {
        ScriptAttributeDialog dialog = new ScriptAttributeDialog();
        if (dialog.showModal() == 0) {
            ScriptDocument newScriptDoc = new ScriptDocument(this.scriptNum, dialog.getName(), dialog.getFormattedDescription(), dialog.getDate(), this);
            if (this.table == null) {
                this.table = new ScriptTable(this, this.scripts);
                DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(new LeafInfo("Script Table", (IViewer)this.table));
                this.framework.addNode(this.scriptManagerNode, tableNode);
                this.validator = new ParameterValidator();
                this.validator.loadParameterConstraints();
            }
            ScriptTree tree = new ScriptTree(newScriptDoc, this);
            ScriptTreeViewer treeViewer = new ScriptTreeViewer(tree, this);
            ScriptXMLViewer xmlViewer = new ScriptXMLViewer(newScriptDoc, this);
            DefaultMutableTreeNode scriptNode = new DefaultMutableTreeNode(new LeafInfo("Script (" + this.scriptNum + ")"));
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(new LeafInfo("Script Tree Viewer", (IViewer)treeViewer));
            DefaultMutableTreeNode xmlNode = new DefaultMutableTreeNode(new LeafInfo("Script XML Viewer", (IViewer)xmlViewer));
            this.scripts.add(new Script(newScriptDoc, tree, xmlViewer));
            scriptNode.add(treeNode);
            scriptNode.add(xmlNode);
            this.framework.addNode(this.scriptManagerNode, scriptNode);
            this.framework.setTreeNode(treeNode);
            ++this.scriptNum;
        }
    }

    public int getNextScriptID() {
        ++this.scriptNum;
        return this.scriptNum;
    }

    public void saveScript(ScriptDocument doc) {
        JFileChooser chooser = new JFileChooser(TMEV.getSettingForOption(CURRENT_SCRIPT_PATH));
        if (doc.getDocumentName() != null) {
            chooser.setSelectedFile(new File(doc.getDocumentName()));
        }
        if (chooser.showSaveDialog(new JFrame()) == 0) {
            try {
                this.writeScript(chooser.getSelectedFile(), doc);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(new JFrame(), "An error occured while saving the script to file", "Save Error", 2);
            }
        }
    }

    private void writeScript(File file, ScriptDocument doc) throws IOException {
        BufferedWriter bfr = new BufferedWriter(new FileWriter(file));
        bfr.write(doc.toString());
        bfr.flush();
        bfr.close();
    }

    public AlgorithmData getAlgorithm(String parentNodeOutputClass) {
        ScriptAlgorithmInitDialog dialog;
        AlgorithmData data = null;
        if (this.framework.getData().getFeaturesCount() == 0) {
            JTextPane pane = new JTextPane();
            pane.setContentType("text/html");
            pane.setMargin(new Insets(5, 15, 15, 15));
            String text = "<html><center><h2>Expression Data Unavailable</h2></center><hr size=3>";
            text = text + "<center>Expression data has not been loaded.  Some algorithms require information about the <br> number and order of loaded experiments in order to set parameters such as group assignments. <br><br><b>Please load data before proceeding with script construction.</b></center></html>";
            pane.setText(text);
            JOptionPane.showMessageDialog(this.framework.getFrame(), pane, "Data Unavailable", 1);
            return null;
        }
        int dataType = this.framework.getData().getDataType();
        boolean isAffy = false;
        if (dataType == 2 || dataType == 3 || dataType == 4 || dataType == 5) {
            isAffy = true;
        }
        if ((dialog = new ScriptAlgorithmInitDialog(this.actionManager, parentNodeOutputClass, isAffy)).showModal() == 0) {
            String algName = dialog.getAlgorithmName();
            String algType = dialog.getAlgorithmType();
            if (algType.equals("cluster")) {
                int algIndex = dialog.getAlgorithmIndex();
                Action action = this.actionManager.getAction("analysis-action" + String.valueOf(algIndex));
                if (action == null) {
                    return null;
                }
                String className = (String)action.getValue("command-parameter");
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = Class.forName(className, true, cl);
                    IScriptGUI gui = (IScriptGUI)clazz.newInstance();
                    data = gui.getScriptParameters(this.framework);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.framework.getFrame(), "Can't retrieve script parameters for the " + algName + " algorithm", "Script Parameter Error", 2);
                    e.printStackTrace();
                }
            } else if (algType.equals("data-adjustment")) {
                if (algName.equals("Percentage Cutoff")) {
                    SetPercentageCutoffsDialog percDialog = new SetPercentageCutoffsDialog(new JFrame(), 0.0f);
                    if (percDialog.showModal() == 0) {
                        data = new AlgorithmData();
                        data.addParam("name", algName);
                        float percentage = percDialog.getPercentageCutoff();
                        data.addParam("percent-cutoff", String.valueOf(percentage));
                        this.setAdjustmentOutput(data);
                    }
                } else if (algName.equals("Lower Cutoffs")) {
                    SetLowerCutoffsDialog lowerDialog = new SetLowerCutoffsDialog(new JFrame(), 0.0f, 0.0f);
                    if (lowerDialog.showModal() == 0) {
                        data = new AlgorithmData();
                        data.addParam("name", algName);
                        data.addParam("cy3-lower-cutoff", String.valueOf(lowerDialog.getLowerCY3Cutoff()));
                        data.addParam("cy5-lower-cutoff", String.valueOf(lowerDialog.getLowerCY5Cutoff()));
                        this.setAdjustmentOutput(data);
                    }
                } else if (algName.equals("Detection Filter")) {
                    data = new AlgorithmData();
                    IData idata = this.framework.getData();
                    int featuresCount = idata.getFeaturesCount();
                    String[] expNames = new String[featuresCount];
                    for (int i = 0; i < expNames.length; ++i) {
                        expNames[i] = idata.getSampleName(i);
                    }
                    SetDetectionFilterDialog sdfd = new SetDetectionFilterDialog(new JFrame(), expNames, new DetectionFilter(expNames));
                    if (sdfd.showModal() == 0) {
                        DetectionFilter detFilter = sdfd.getDetectionFilter();
                        int[] groupMemb = new int[featuresCount];
                        int[] numReq = new int[featuresCount];
                        for (int i = 0; i < groupMemb.length; ++i) {
                            groupMemb[i] = detFilter.get_group_membership(i);
                            numReq[i] = detFilter.get_num_required(i);
                        }
                        data.addParam("name", "Affy Detection Filter");
                        data.addIntArray("group-memberships", groupMemb);
                        data.addIntArray("number-required", numReq);
                        data.addParam("is-required-in-both-groups", String.valueOf(detFilter.get_both()));
                        this.setAdjustmentOutput(data);
                    }
                } else if (algName.equals("Fold Filter")) {
                    data = new AlgorithmData();
                    IData idata = this.framework.getData();
                    int featuresCount = idata.getFeaturesCount();
                    String[] expNames = new String[featuresCount];
                    for (int i = 0; i < expNames.length; ++i) {
                        expNames[i] = idata.getSampleName(i);
                    }
                    SetFoldFilterDialog sffd = new SetFoldFilterDialog(new JFrame(), expNames, new FoldFilter(expNames));
                    if (sffd.showModal() == 0) {
                        FoldFilter foldFilter = sffd.getFoldFilter();
                        int[] groupMemb = new int[featuresCount];
                        int[] numMembers = new int[featuresCount];
                        for (int i = 0; i < groupMemb.length; ++i) {
                            groupMemb[i] = foldFilter.get_group_membership(i);
                            numMembers[i] = foldFilter.get_num_members(i);
                        }
                        data.addParam("name", "Affy Fold Filter");
                        data.addIntArray("group-memberships", groupMemb);
                        data.addIntArray("number-of-members", numMembers);
                        data.addParam("fold-change", String.valueOf(foldFilter.get_fold_change()));
                        data.addParam("divider-string", foldFilter.get_divider());
                        this.setAdjustmentOutput(data);
                    }
                } else {
                    data = new AlgorithmData();
                    data.addParam("name", algName);
                    this.setAdjustmentOutput(data);
                }
            } else if (algType.equals("cluster-selection")) {
                CentroidEntropyRankingInitDialog entropyDialog;
                if (algName.equals("Diversity Ranking Cluster Selection")) {
                    DiversityRankingInitDialog selectDialog = new DiversityRankingInitDialog(new JFrame());
                    if (selectDialog.showModal() == 0) {
                        data = new AlgorithmData();
                        data.addParam("name", algName);
                        data.addParam("desired-cluster-count", String.valueOf(selectDialog.getClusterNumber()));
                        data.addParam("minimum-cluster-size", String.valueOf(selectDialog.getClusterSize()));
                        data.addParam("use-centroid-variance", String.valueOf(selectDialog.isCentroidBased()));
                        int function = this.framework.getDistanceMenu().getDistanceFunction();
                        if (function == 0) {
                            function = 1;
                        }
                        data.addParam("distance-function", String.valueOf(function));
                        data.addParam("use-absolute", String.valueOf(this.framework.getDistanceMenu().isAbsoluteDistance()));
                        if (parentNodeOutputClass.equals("multi-gene-cluster-output")) {
                            data.addParam("process-gene-clusters", String.valueOf(true));
                        } else {
                            data.addParam("process-gene-clusters", String.valueOf(false));
                        }
                        this.setSelectionOutput(data);
                    }
                } else if (algName.equals("Centroid Entropy/Variance Ranking Cluster Selection") && (entropyDialog = new CentroidEntropyRankingInitDialog(new JFrame())).showModal() == 0) {
                    data = new AlgorithmData();
                    data.addParam("name", algName);
                    data.addParam("desired-cluster-count", String.valueOf(entropyDialog.getClusterNumber()));
                    data.addParam("minimum-cluster-size", String.valueOf(entropyDialog.getClusterSize()));
                    data.addParam("use-centroid-variance", String.valueOf(entropyDialog.isVarianceBased()));
                    int function = this.framework.getDistanceMenu().getDistanceFunction();
                    if (function == 0) {
                        function = 1;
                    }
                    data.addParam("distance-function", String.valueOf(function));
                    data.addParam("use-absolute", String.valueOf(this.framework.getDistanceMenu().isAbsoluteDistance()));
                    if (parentNodeOutputClass.equals("multi-gene-cluster-output")) {
                        data.addParam("process-gene-clusters", String.valueOf(true));
                    } else {
                        data.addParam("process-gene-clusters", String.valueOf(false));
                    }
                    this.setSelectionOutput(data);
                }
            }
        }
        return data;
    }

    private void setAdjustmentOutput(AlgorithmData data) {
        String[] output_nodes = new String[]{"Single Adjusted Ouput"};
        data.addStringArray("output-nodes", output_nodes);
        data.addParam("output-class", "single-output");
        data.addParam("alg-type", "data-adjustment");
    }

    private void setSelectionOutput(AlgorithmData data) {
        int clusterCount = data.getParams().getInt("desired-cluster-count");
        String[] output_nodes = new String[clusterCount];
        for (int i = 0; i < clusterCount; ++i) {
            output_nodes[i] = "Selected Cluster (" + String.valueOf(i + 1) + ") ";
        }
        data.addStringArray("output-nodes", output_nodes);
        data.addParam("output-class", "cluster-selection-output");
        data.addParam("alg-type", "cluster-selection");
    }

    public void viewSelectedNodeXML(ScriptTreeViewer viewer, ScriptNode node) {
        DefaultMutableTreeNode viewerNode = this.getSiblingXMLNode(viewer);
        if (viewerNode != null) {
            IViewer iviewer = ((LeafInfo)viewerNode.getUserObject()).getViewer();
            if (!(iviewer instanceof ScriptXMLViewer)) {
                return;
            }
            ScriptXMLViewer xmlViewer = (ScriptXMLViewer)iviewer;
            xmlViewer.update();
            if (node instanceof AlgorithmNode) {
                xmlViewer.highlightAlgorithmNode((AlgorithmNode)node);
            }
            this.framework.setTreeNode(viewerNode);
        }
    }

    public DefaultMutableTreeNode getSiblingXMLNode(ScriptTreeViewer treeViewer) {
        DefaultMutableTreeNode node;
        Enumeration<TreeNode> _enum = this.scriptManagerNode.depthFirstEnumeration();
        DefaultMutableTreeNode treeNode = null;
        while (_enum.hasMoreElements()) {
            IViewer viewer;
            LeafInfo leaf;
            node = (DefaultMutableTreeNode)_enum.nextElement();
            if (!node.isLeaf() || (leaf = (LeafInfo)node.getUserObject()) == null || leaf.getViewer() == null || (viewer = leaf.getViewer()) != treeViewer) continue;
            treeNode = node;
        }
        if (treeNode != null && (node = (DefaultMutableTreeNode)treeNode.getParent()).getChildCount() > 1) {
            node = (DefaultMutableTreeNode)node.getChildAt(1);
            return node;
        }
        return null;
    }

    public void runScript(int index) {
        if (index >= this.scripts.size()) {
            return;
        }
        Script script = (Script)this.scripts.elementAt(index);
        ScriptRunner runner = new ScriptRunner(script, this.actionManager, this.framework);
        runner.setOutputMode(0);
        runner.execute();
    }

    public void runScript(ScriptDocument scriptDoc) {
        Script script = this.getScriptObjectForDocument(scriptDoc);
        if (script == null) {
            return;
        }
        ScriptRunner runner = new ScriptRunner(script, this.actionManager, this.framework);
        runner.setOutputMode(0);
        runner.execute();
    }

    public Script getScriptObjectForDocument(ScriptDocument doc) {
        for (int i = 0; i < this.scripts.size(); ++i) {
            Script script = (Script)this.scripts.elementAt(i);
            if (script.getScriptDocument() != doc) continue;
            return script;
        }
        return null;
    }

    public Frame getFrame() {
        return this.framework.getFrame();
    }

    public Experiment getCurrentExperiment() {
        return this.framework.getData().getExperiment();
    }

    public boolean validateParameters(ScriptTree tree, ErrorLog log) {
        boolean isValid = true;
        if (this.validator != null && this.validator.isEnabled()) {
            if (!this.validator.validate(this, tree, log)) {
                log.reportAllListings();
                isValid = false;
            }
        } else {
            isValid = false;
        }
        return isValid;
    }

    public String getValidParametersTable(String algName) {
        if (this.validator == null) {
            return null;
        }
        return this.validator.getValidParameterTable(algName);
    }

    public Hashtable getParameterHash(String algName) {
        if (this.validator == null) {
            return null;
        }
        return this.validator.getParameterHash(algName);
    }

    public ParameterAttributes getParameterAttributes(String algName, String key) {
        if (this.validator == null) {
            return null;
        }
        return this.validator.getParameterAttributes(algName, key);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.scriptNum);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.scriptNum = ois.readInt();
    }

    public class ThreadHandler
    implements Runnable {
        private final File file;

        public ThreadHandler(File f) {
            this.file = f;
        }

        @Override
        public void run() {
            ScriptManager.this.loadScript(this.file);
        }
    }
}

