/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.util.FloatMatrix;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScriptHandler {
    String tm4ScriptVersion = "1.0";
    String mevScriptVersion = "1.0";
    Document document;
    Element root;
    Element mevElement;
    Element primaryDataElement;
    Element analysisElement;
    int currAnalysisID = 1;
    int currDataID = 1;
    String lineSeparator = "\n";
    String indent = "   ";

    public ScriptHandler() {
        DOMImplementationImpl impl = new DOMImplementationImpl();
        this.document = impl.createDocument(null, "tm4", null);
        this.root = this.document.getDocumentElement();
        this.root.setAttribute("version", this.tm4ScriptVersion);
        this.mevElement = this.document.createElement("mev");
        this.mevElement.setAttribute("version", this.mevScriptVersion);
        this.root.appendChild(this.mevElement);
        this.analysisElement = this.document.createElement("analysis");
        this.primaryDataElement = this.document.createElement("primary_data");
        Element fileListElement = this.document.createElement("file_list");
        this.primaryDataElement.appendChild(fileListElement);
        this.mevElement.appendChild(this.primaryDataElement);
        this.mevElement.appendChild(this.analysisElement);
    }

    public Document getDocument() {
        return this.document;
    }

    public void createAlgorithmSet(int setID, int dataRef) {
        Element algSetElement = this.document.createElement("alg_set");
        algSetElement.setAttribute("set_id", String.valueOf(setID));
        algSetElement.setAttribute("input_data_ref", String.valueOf(dataRef));
        this.analysisElement.appendChild(algSetElement);
    }

    public Element getAlgorithmSetByID(int setID) {
        String id = String.valueOf(setID);
        NodeList elements = this.analysisElement.getElementsByTagName("alg_set");
        for (int i = 0; i < elements.getLength(); ++i) {
            if (!id.equals(((Element)elements.item(i)).getAttribute("set_id"))) continue;
            return (Element)elements.item(i);
        }
        return null;
    }

    public boolean appendAlgorithm(AlgorithmData data, int algID, int algSetRef, int inputDataRef) {
        Element algElement = this.document.createElement("algorithm");
        Element algSetElement = this.getAlgorithmSetByID(algSetRef);
        if (algSetElement == null) {
            return false;
        }
        AlgorithmParameters params = data.getParams();
        String name = params.getString("name");
        if (name != null) {
            String[] outputNodes;
            algElement.setAttribute("name", name);
            algElement.setAttribute("input_data_ref", String.valueOf(inputDataRef));
            algElement.setAttribute("alg_id", String.valueOf(algID));
            this.addParameterList(algElement, params);
            Element matrices = this.document.createElement("mlist");
            Map map = data.getIntArrays();
            if (map.size() > 0) {
                this.addIntArrays(map, matrices);
            }
            if ((map = data.getStringArrays()).size() > 0) {
                this.addStringArrays(map, matrices);
            }
            if ((map = data.getMatrixes()).size() > 0) {
                this.addMatrices(map, matrices);
            }
            if (matrices.getChildNodes().getLength() > 0) {
                algElement.appendChild(matrices);
            }
            if ((outputNodes = data.getStringArray("output-nodes")) != null) {
                Element outputNodeElement = this.document.createElement("output_data");
                for (int i = 0; i < outputNodes.length; ++i) {
                    Element dataElement = this.document.createElement("data_node");
                    dataElement.setAttribute("data_node_id", String.valueOf(this.currDataID));
                    dataElement.setAttribute("name", outputNodes[i]);
                    outputNodeElement.appendChild(dataElement);
                    ++this.currDataID;
                }
                algElement.appendChild(outputNodeElement);
            }
        }
        algSetElement.appendChild(algElement);
        return true;
    }

    public void addParameterList(Element algElement, AlgorithmParameters params) {
        Map paramMap = params.getMap();
        String key = "";
        String value = "";
        if (paramMap.size() > 1) {
            Set keySet = paramMap.keySet();
            Iterator iter = keySet.iterator();
            Element paramsElement = this.document.createElement("plist");
            while (iter.hasNext()) {
                key = (String)iter.next();
                value = (String)paramMap.get(key);
                if (key.equals("name")) continue;
                Element paramElement = this.document.createElement("param");
                paramElement.setAttribute("key", key);
                paramElement.setAttribute("val", value);
                paramsElement.appendChild(paramElement);
            }
            algElement.appendChild(paramsElement);
        }
    }

    public void addIntArrays(Map map, Element mlist) {
        int i;
        Object[] arrayObjectNames = map.keySet().toArray();
        String[] arrayNames = new String[arrayObjectNames.length];
        for (i = 0; i < arrayNames.length; ++i) {
            arrayNames[i] = (String)arrayObjectNames[i];
        }
        for (i = 0; i < arrayNames.length; ++i) {
            int[] currentArray = (int[])map.get(arrayNames[i]);
            Element matrixElement = this.document.createElement("matrix");
            matrixElement.setAttribute("name", arrayNames[i]);
            matrixElement.setAttribute("type", "int");
            matrixElement.setAttribute("row_dim", String.valueOf(currentArray.length));
            for (int j = 0; j < currentArray.length; ++j) {
                Element elementElement = this.document.createElement("element");
                elementElement.setAttribute("row", String.valueOf(j));
                elementElement.setAttribute("col", "0");
                elementElement.setAttribute("val", String.valueOf(currentArray[i]));
                matrixElement.appendChild(elementElement);
            }
            mlist.appendChild(matrixElement);
        }
    }

    public void addStringArrays(Map map, Element mlist) {
        int i;
        Object[] arrayObjectNames = map.keySet().toArray();
        String[] arrayNames = new String[arrayObjectNames.length];
        for (i = 0; i < arrayNames.length; ++i) {
            arrayNames[i] = (String)arrayObjectNames[i];
        }
        for (i = 0; i < arrayNames.length; ++i) {
            String[] currentArray = (String[])map.get(arrayNames[i]);
            Element matrixElement = this.document.createElement("matrix");
            matrixElement.setAttribute("name", arrayNames[i]);
            matrixElement.setAttribute("type", "String");
            matrixElement.setAttribute("row_dim", String.valueOf(currentArray.length));
            for (int j = 0; j < currentArray.length; ++j) {
                Element elementElement = this.document.createElement("element");
                elementElement.setAttribute("row", String.valueOf(j));
                elementElement.setAttribute("col", "0");
                elementElement.setAttribute("val", currentArray[i]);
                matrixElement.appendChild(elementElement);
            }
            mlist.appendChild(matrixElement);
        }
    }

    public void addMatrices(Map map, Element mlist) {
        int i;
        Object[] matrixObjectNames = map.keySet().toArray();
        String[] matrixNames = new String[matrixObjectNames.length];
        for (i = 0; i < matrixNames.length; ++i) {
            matrixNames[i] = (String)matrixObjectNames[i];
        }
        for (i = 0; i < matrixNames.length; ++i) {
            FloatMatrix currentFM = (FloatMatrix)map.get(matrixNames[i]);
            Element matrixElement = this.document.createElement("matrix");
            matrixElement.setAttribute("name", matrixNames[i]);
            matrixElement.setAttribute("type", "FloatMatrix");
            matrixElement.setAttribute("row_dim", String.valueOf(currentFM.getRowDimension()));
            this.addMatrixElements(currentFM, matrixElement);
            mlist.appendChild(matrixElement);
        }
    }

    public void addMatrixElements(FloatMatrix matrix, Element matrixElement) {
        float[][] data = matrix.A;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                Element elementElement = this.document.createElement("element");
                elementElement.setAttribute("row", String.valueOf(i));
                elementElement.setAttribute("col", String.valueOf(j));
                elementElement.setAttribute("val", String.valueOf(data[i][j]));
                matrixElement.appendChild(elementElement);
            }
        }
    }

    public void writeDocument(String fileName) throws IOException {
        FileWriter writer = new FileWriter(fileName);
        this.serialize(this.document, writer);
        writer.flush();
        writer.close();
    }

    public void writeDocument(Document doc, Writer writer) throws IOException {
        this.serialize(doc, writer);
    }

    private void serialize(Document doc, Writer writer) throws IOException {
        this.serializeNode(doc, writer, "");
    }

    private void serializeNode(Node node, Writer writer, String indentLevel) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                writer.write("<?xml version=\"1.0\"?>");
                writer.write(this.lineSeparator);
                Document doc = (Document)node;
                this.serializeNode(doc.getDocumentElement(), writer, " ");
                break;
            }
            case 1: {
                String name = node.getNodeName();
                writer.write(indentLevel + "<" + name);
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    writer.write(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
                }
                NodeList children = node.getChildNodes();
                if (children.getLength() > 0) {
                    writer.write(">");
                    if (children.item(0) != null && children.item(0).getNodeType() == 1) {
                        writer.write(this.lineSeparator);
                    }
                    for (int i = 0; i < children.getLength(); ++i) {
                        this.serializeNode(children.item(i), writer, indentLevel + this.indent);
                    }
                    if (children.item(0) != null && children.item(children.getLength() - 1).getNodeType() == 1) {
                        writer.write(indentLevel);
                    }
                    writer.write("</" + name + ">");
                } else {
                    writer.write("/>");
                }
                writer.write(this.lineSeparator);
                break;
            }
            case 3: {
                writer.write(node.getNodeValue());
                break;
            }
        }
    }
}

