/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.resources;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;

public class SelectMultiFilesDialog
extends AlgorithmDialog {
    String[] availableFileNames;
    int[] selectedFiles;
    JTable filelisttable;
    JLabel tableLabel;
    JLabel sourceLabel;
    JLabel statusLabel;

    public SelectMultiFilesDialog(JFrame frame, String title, String source, String[] filenames) {
        super(frame, title, true);
        this.availableFileNames = filenames;
        String[][] data = new String[this.availableFileNames.length][];
        for (int i = 0; i < this.availableFileNames.length; ++i) {
            data[i] = new String[1];
            data[i][0] = this.availableFileNames[i];
        }
        this.tableLabel = new JLabel("Choose the support files to use:");
        this.sourceLabel = new JLabel("Source Server: " + source);
        this.filelisttable = new JTable(new MyTableModel(data));
        this.setActionListeners((ActionListener)((Object)new Listener()));
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.setBackground(Color.white);
        tablePanel.add((Component)this.sourceLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        tablePanel.add((Component)this.tableLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        tablePanel.add((Component)this.filelisttable, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        Border tableborder = BorderFactory.createLineBorder(Color.black);
        Font font = new Font("Dialog", 1, 12);
        tablePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Select Files", 0, 0, font, Color.black));
        this.filelisttable.setBorder(tableborder);
        this.filelisttable.setColumnSelectionAllowed(false);
        this.filelisttable.setCellSelectionEnabled(false);
        this.filelisttable.setRowSelectionAllowed(true);
        this.filelisttable.setSelectionMode(2);
        this.filelisttable.setDragEnabled(false);
        this.addContent(tablePanel);
        this.setSize(570, 750);
    }

    public int[] getSelectedFilesIndices() {
        return this.filelisttable.getSelectedRows();
    }

    public static void main(String[] args) {
        String[] test = new String[]{"filename1", "filename 2 is really really really really really long.......", "shortname"};
        SelectMultiFilesDialog smfd = new SelectMultiFilesDialog(new JFrame(), "test title", "ftp://occams.dfci.harvard.edu/", test);
        smfd.setVisible(true);
        System.out.println("selected file indices: ");
        int[] selectedRows = smfd.getSelectedFilesIndices();
        for (int i = 0; i < selectedRows.length; ++i) {
            System.out.println("row " + selectedRows[i] + " file: " + test[selectedRows[i]]);
        }
        System.exit(0);
    }

    protected class Listener
    extends DialogListener
    implements ItemListener {
        protected Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                SelectMultiFilesDialog.this.selectedFiles = SelectMultiFilesDialog.this.filelisttable.getSelectedRows();
                SelectMultiFilesDialog.this.dispose();
                SelectMultiFilesDialog.this.disposeDialog();
            } else if (command.equals("cancel-command")) {
                SelectMultiFilesDialog.this.selectedFiles = new int[0];
                SelectMultiFilesDialog.this.dispose();
                SelectMultiFilesDialog.this.disposeDialog();
            } else if (command.equals("reset-command")) {
                SelectMultiFilesDialog.this.selectedFiles = new int[0];
                SelectMultiFilesDialog.this.filelisttable.clearSelection();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
        }
    }

    protected class MyTableModel
    extends AbstractTableModel {
        private String[][] data;

        public MyTableModel(String[][] data) {
            this.data = data;
        }

        @Override
        public int getColumnCount() {
            return this.data[0].length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][columnIndex];
        }
    }
}

