/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.resources;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.tigr.microarray.mev.resources.FileDownloader;
import org.tigr.microarray.mev.resources.RMProgress;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class SFTPFileDownloader
extends FileDownloader {
    JSch jsch = new JSch();
    Session session;
    String host;
    String user;
    UserInfo ui;
    int port;
    Channel channel;
    ChannelSftp c;

    protected SFTPFileDownloader(URL host) {
        super(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect() throws IOException {
        try {
            this.user = "test";
            this.host = this.hostURL.getHost();
            this.port = 22;
            this.session = this.jsch.getSession(this.user, this.host, this.port);
            this.ui = new MyUserInfo();
            this.session.setUserInfo(this.ui);
            this.session.connect();
            this.channel = this.session.openChannel("sftp");
            this.channel.connect();
            this.c = (ChannelSftp)this.channel;
            boolean bl = true;
            return bl;
        }
        catch (JSchException jse) {
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public void disconnect() {
        this.c.quit();
        this.session.disconnect();
    }

    @Override
    public String[] getFileList(String path) {
        return null;
    }

    @Override
    public Date getLastModifiedDate(String path) {
        Vector myfile;
        try {
            myfile = this.c.ls(this.hostURL.getFile());
        }
        catch (SftpException e) {
            e.printStackTrace();
            return null;
        }
        if (myfile != null) {
            ChannelSftp.LsEntry obj = (ChannelSftp.LsEntry)myfile.get(0);
            SftpATTRS attrs = obj.getAttrs();
            Date serverDateLastModified = new Date(attrs.getMTime());
            return serverDateLastModified;
        }
        return null;
    }

    @Override
    public File getTempFile(String path) throws SupportFileAccessError {
        return null;
    }

    private File getJschFTPFile(URL url, Date cachedDateLastModified) throws IOException, JSchException, SftpException, SupportFileAccessError {
        File newFile;
        Date serverDateLastModified;
        JSch jsch = new JSch();
        String user = "eleanora";
        String host = url.getHost();
        int port = 22;
        Session session = jsch.getSession(user, host, port);
        MyUserInfo ui = new MyUserInfo();
        session.setUserInfo((UserInfo)ui);
        session.connect();
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp c = (ChannelSftp)channel;
        c.cd(url.getPath().substring(0, url.getPath().lastIndexOf(47) + 1));
        RMProgress monitor = this.progress;
        Vector myfile = c.ls(url.getFile());
        if (myfile != null) {
            ChannelSftp.LsEntry obj = (ChannelSftp.LsEntry)myfile.get(0);
            SftpATTRS attrs = obj.getAttrs();
            serverDateLastModified = new Date(attrs.getMTime());
        } else {
            serverDateLastModified = new Date(0L);
        }
        boolean downloadFile = cachedDateLastModified == null || cachedDateLastModified.before(serverDateLastModified);
        if (downloadFile) {
            newFile = File.createTempFile("mev_resource", "");
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(newFile));
            c.get(url.getFile(), (OutputStream)bos, (SftpProgressMonitor)monitor);
            bos.close();
        } else {
            newFile = null;
        }
        c.quit();
        session.disconnect();
        if (this.progress.wasCancelled) {
            SupportFileAccessError sfae = new SupportFileAccessError("Connection was cancelled by user.");
            sfae.setCancelledConnection(true);
            throw sfae;
        }
        return newFile;
    }

    public static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        String passwd;
        JTextField passwordField = new JPasswordField(20);
        final GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        private Container panel;

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptYesNo(String str) {
            Object[] options = new Object[]{"yes", "no"};
            int foo = JOptionPane.showOptionDialog(null, str, "Warning", -1, 2, null, options, options[0]);
            return foo == 0;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            Object[] ob = new Object[]{this.passwordField};
            int result = JOptionPane.showConfirmDialog(null, ob, message, 2);
            if (result == 0) {
                this.passwd = this.passwordField.getText();
                return true;
            }
            return false;
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.gridx = 0;
            this.panel.add((Component)new JLabel(instruction), this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = -1;
            JTextField[] texts = new JTextField[prompt.length];
            for (int i = 0; i < prompt.length; ++i) {
                this.gbc.fill = 0;
                this.gbc.gridx = 0;
                this.gbc.weightx = 1.0;
                this.panel.add((Component)new JLabel(prompt[i]), this.gbc);
                this.gbc.gridx = 1;
                this.gbc.fill = 2;
                this.gbc.weighty = 1.0;
                texts[i] = echo[i] ? new JTextField(20) : new JPasswordField(20);
                this.panel.add((Component)texts[i], this.gbc);
                ++this.gbc.gridy;
            }
            if (JOptionPane.showConfirmDialog(null, this.panel, destination + ": " + name, 2, 3) == 0) {
                String[] response = new String[prompt.length];
                for (int i = 0; i < prompt.length; ++i) {
                    response[i] = texts[i].getText();
                }
                return response;
            }
            return null;
        }
    }
}

