/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.resources;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;

public class ResourcererAnnotationFileDefinition
extends ISupportFileDefinition {
    private static String resourcererAnnotationRoot = ResourcererAnnotationFileDefinition.getBaseResourceURL("resourcerer_annotation");
    private String speciesName;
    private String arrayName;
    private boolean isZipped = true;

    public ResourcererAnnotationFileDefinition(String speciesname, String array) {
        this.speciesName = speciesname;
        this.arrayName = array;
    }

    @Override
    public URL getURL() throws MalformedURLException {
        return new URL(resourcererAnnotationRoot + this.speciesName + "/" + this.arrayName + ".zip");
    }

    @Override
    public String getUniqueName() {
        return this.speciesName + "-" + this.arrayName + ".txt";
    }

    @Override
    public boolean isValid(File f) {
        return ResourcererAnnotationFileDefinition.isValidFile(f);
    }

    @Override
    public boolean fileNeedsUnzipping() {
        return this.isZipped;
    }

    public static boolean isValidFile(File f) {
        return f.exists() && f.canRead();
    }

    @Override
    public boolean isVersioned() {
        return true;
    }
}

