/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;
import org.tigr.util.StringSplitter;

public class PipelinedAnnotationsFileDefinition
extends ISupportFileDefinition {
    private String urlString = PipelinedAnnotationsFileDefinition.getBaseResourceURL("resourcerer_supported_annotations_list");

    public static boolean isValidFile(File f) {
        try {
            String currentLine;
            BufferedReader breader = new BufferedReader(new FileReader(f));
            Hashtable orgToChipMap = new Hashtable();
            StringSplitter ss = new StringSplitter('\t');
            while ((currentLine = breader.readLine()) != null) {
                ss.init(currentLine);
                while (ss.hasMoreTokens()) {
                    ss.nextToken();
                    String orgName = ss.nextToken();
                    String chipType = ss.nextToken();
                    if (!orgToChipMap.containsKey(orgName)) {
                        Vector<String> chipTypes = new Vector<String>();
                        chipTypes.add(chipType);
                        orgToChipMap.put(orgName, chipTypes);
                        continue;
                    }
                    ((Vector)orgToChipMap.get(orgName)).add(chipType);
                }
            }
            return true;
        }
        catch (NoSuchElementException nsee) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public URL getURL() throws MalformedURLException {
        return new URL(this.urlString);
    }

    @Override
    public String getUniqueName() {
        return "bioconductor_annotations.txt";
    }

    @Override
    public boolean isValid(File f) {
        return PipelinedAnnotationsFileDefinition.isValidFile(f);
    }

    @Override
    public boolean isVersioned() {
        return true;
    }

    public Hashtable<String, Vector<String>> parseAnnotationListFile(File taxonfile) throws IOException {
        BufferedReader breader = new BufferedReader(new FileReader(taxonfile));
        Hashtable<String, Vector<String>> orgToChipMap = new Hashtable<String, Vector<String>>();
        StringSplitter ss = new StringSplitter('\t');
        try {
            String currentLine;
            while ((currentLine = breader.readLine()) != null) {
                ss.init(currentLine);
                while (ss.hasMoreTokens()) {
                    ss.nextToken();
                    String orgName = ss.nextToken();
                    String chipType = ss.nextToken();
                    if (!orgToChipMap.containsKey(orgName)) {
                        Vector<String> chipTypes = new Vector<String>();
                        chipTypes.add(chipType);
                        orgToChipMap.put(orgName, chipTypes);
                        continue;
                    }
                    orgToChipMap.get(orgName).add(chipType);
                }
            }
            return orgToChipMap;
        }
        catch (NoSuchElementException nsee) {
            throw new IOException(nsee.getMessage());
        }
    }
}

