/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.resources;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.resources.FileResourceManager;

public abstract class ISupportFileDefinition
implements FilenameFilter {
    private static Hashtable<String, String> baseResourceUrls = ISupportFileDefinition.initializeBaseResourceUrls();

    private static Hashtable<String, String> initializeBaseResourceUrls() {
        baseResourceUrls = new Hashtable();
        Properties mevUrls = new Properties();
        try {
            InputStream in = TMEV.class.getClassLoader().getResourceAsStream("org/tigr/microarray/mev/resources/support_file_url.properties");
            if (in != null) {
                mevUrls.load(in);
            }
        }
        catch (IOException ioe) {
            System.out.println("Could not load default properties from org/tigr/microarray/mev/resources/support_file_url.properties");
        }
        Enumeration<Object> keys = mevUrls.keys();
        Hashtable<String, String> temp = new Hashtable<String, String>();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            temp.put(key, (String)mevUrls.get(key));
        }
        return temp;
    }

    public static void addBaseUrls(Hashtable<String, String> hash) {
        baseResourceUrls.putAll(hash);
    }

    public static String getBaseResourceURL(String key) {
        return baseResourceUrls.get(key);
    }

    public abstract boolean isValid(File var1);

    public abstract URL getURL() throws MalformedURLException;

    public abstract String getUniqueName();

    public boolean fileNeedsUnzipping() {
        return false;
    }

    public boolean isSingleFile() {
        return true;
    }

    public boolean isVersioned() {
        return false;
    }

    @Override
    public boolean accept(File dir, String candidateName) {
        String rootReferenceName;
        String referenceName = this.getUniqueName();
        int lastIndex = referenceName.lastIndexOf(46);
        if (lastIndex <= 0) {
            lastIndex = referenceName.length();
            rootReferenceName = referenceName;
        } else {
            rootReferenceName = referenceName.substring(0, lastIndex);
        }
        if (candidateName.contains(new String(".").subSequence(0, 1))) {
            String suffix = candidateName.substring(candidateName.lastIndexOf(46), candidateName.length());
            if (!referenceName.endsWith(suffix)) {
                return false;
            }
            candidateName = candidateName.substring(0, candidateName.lastIndexOf(46));
        }
        String rootCandidateName = "";
        int last = candidateName.lastIndexOf("_");
        if (last > 0) {
            rootCandidateName = candidateName.substring(0, candidateName.lastIndexOf("_"));
        }
        if (!rootCandidateName.equals(rootReferenceName)) {
            return false;
        }
        try {
            Date temp = FileResourceManager.getDateFromFilename(new File(candidateName), this);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
        catch (StringIndexOutOfBoundsException aioobe) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean isAllowed() {
        String filename = "";
        try {
            filename = this.getURL().toString();
        }
        catch (MalformedURLException mue) {
            return false;
        }
        return !filename.endsWith(".msi") && !filename.endsWith(".exe") && !filename.endsWith(".bat") && !filename.endsWith(".sh") && !filename.endsWith(".exe");
    }

    public boolean matches(ISupportFileDefinition otherDef) {
        return otherDef.getClass().equals(this.getClass()) && otherDef.getUniqueName().equals(this.getUniqueName());
    }
}

