/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.resources;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.tigr.microarray.mev.resources.FileDownloader;
import org.tigr.microarray.mev.resources.RMProgress;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class HTTPDownloader
extends FileDownloader {
    URLConnection conn = null;

    protected HTTPDownloader(URL host) {
        super(host);
    }

    @Override
    public boolean connect() throws IOException {
        try {
            this.conn = this.hostURL.openConnection();
            this.conn.setConnectTimeout(10000);
            this.conn.setReadTimeout(100000);
            boolean bl = true;
            return bl;
        }
        catch (NullPointerException npe) {
            throw new IOException(npe.getMessage());
        }
    }

    @Override
    public void disconnect() {
    }

    @Override
    public String[] getFileList(String path) {
        return null;
    }

    @Override
    public Date getLastModifiedDate(String path) {
        try {
            URLConnection conn1 = new URL(this.hostURL, path).openConnection();
            conn1.setConnectTimeout(10000);
            conn1.setReadTimeout(10000);
            long remoteFileLastModified = conn1.getLastModified();
            if (remoteFileLastModified < 0L) {
                remoteFileLastModified = 0L;
            }
            return new Date(remoteFileLastModified);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public File getTempFile(String path) throws SupportFileAccessError {
        SupportFileAccessError sfae;
        URL fileURL = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int numRead;
            fileURL = new URL(this.hostURL, path);
            URLConnection conn1 = fileURL.openConnection();
            conn1.setConnectTimeout(10000);
            conn1.setReadTimeout(100000);
            File tempFile = File.createTempFile("mev_resource", "");
            tempFile.deleteOnExit();
            bis = new BufferedInputStream(conn1.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(tempFile));
            RMProgress monitor = this.progress = new RMProgress(new Frame(), "Downloading " + this.hostURL, new FileDownloader.DownloadProgressListener());
            int length = 0;
            try {
                length = conn1.getContentLength();
            }
            catch (NullPointerException npe) {
                length = 0;
            }
            monitor.init(0, fileURL.getPath(), "??", new Long(length));
            byte[] buffer = new byte[1024];
            long numWritten = 0L;
            while ((numRead = bis.read(buffer)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, numRead);
                numWritten += (long)numRead;
                monitor.count(numRead);
            }
            monitor.end();
            bis.close();
            bos.close();
            if (this.progress.wasCancelled) {
                File file = null;
                return file;
            }
            File file = tempFile;
            return file;
        }
        catch (MalformedURLException mue) {
            sfae = new SupportFileAccessError("bad URL", mue);
            throw sfae;
        }
        catch (NoRouteToHostException nrthe) {
            sfae = new SupportFileAccessError("Couldn't find host " + fileURL.toString(), nrthe);
            throw sfae;
        }
        catch (InterruptedIOException iioe) {
            sfae = new SupportFileAccessError("Network timeout.", iioe);
            throw sfae;
        }
        catch (IOException ioe) {
            sfae = new SupportFileAccessError("Couldn't save file to local disk.", ioe);
            throw sfae;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException ioe) {}
        }
    }
}

