/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.resources;

import java.awt.Frame;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.tigr.microarray.mev.ShowThrowableDialog;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.BroadGeneSet;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.BroadGeneSetList;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GeneSigDbGeneSets;
import org.tigr.microarray.mev.resources.AllowConnectionsDialog;
import org.tigr.microarray.mev.resources.FileDownloader;
import org.tigr.microarray.mev.resources.IMultiSupportFileDefinition;
import org.tigr.microarray.mev.resources.IResourceManager;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;
import org.tigr.microarray.mev.resources.PipelinedUrlsPropertiesDefinition;
import org.tigr.microarray.mev.resources.RepositoryInitializationError;
import org.tigr.microarray.mev.resources.ResourcererAnnotationFileDefinition;
import org.tigr.microarray.mev.resources.SelectMultiFilesDialog;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class FileResourceManager
implements IResourceManager {
    File localRepository;
    private boolean promptToGetOnline = true;
    private boolean allowedOnline = true;
    private Vector<ISupportFileDefinition> filesCheckedThisSession = new Vector();

    private synchronized boolean fileHasBeenCheckedRecently(ISupportFileDefinition def) {
        Enumeration<ISupportFileDefinition> _checkedDefs = this.filesCheckedThisSession.elements();
        while (_checkedDefs.hasMoreElements()) {
            if (!_checkedDefs.nextElement().matches(def)) continue;
            return true;
        }
        return false;
    }

    public FileResourceManager(File repository) throws RepositoryInitializationError {
        this.localRepository = repository;
        if (!this.localRepository.exists() && !this.localRepository.mkdir()) {
            throw new RepositoryInitializationError("Could not create new Repository in location " + this.localRepository.getAbsolutePath());
        }
        if (!this.localRepository.isDirectory() || !this.localRepository.canRead()) {
            throw new RepositoryInitializationError("Cannot write to repository at " + this.localRepository.getAbsolutePath());
        }
        try {
            this.initializeProperties();
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        Properties mevUrls = new Properties();
        try {
            File urlPropertiesFile = this.getSupportFile(new PipelinedUrlsPropertiesDefinition(), true);
            try {
                FileInputStream in = new FileInputStream(urlPropertiesFile);
                if (in != null) {
                    mevUrls.load(in);
                }
            }
            catch (IOException ioe) {
                System.out.println("Couldn't get props file from web.");
            }
        }
        catch (SupportFileAccessError sfae) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ISupportFileDefinition.addBaseUrls(mevUrls);
    }

    @Override
    public synchronized File getSupportFile(ISupportFileDefinition def, boolean getOnline) throws SupportFileAccessError {
        Vector<ISupportFileDefinition> v = new Vector<ISupportFileDefinition>();
        v.add(def);
        File f = this.getSupportFiles(v, getOnline).get(def);
        if (f == null) {
            try {
                throw new SupportFileAccessError("Unable to download support file." + def.getURL());
            }
            catch (MalformedURLException mue) {
                throw new SupportFileAccessError("Unable to download support file: \n" + def.getUniqueName() + ": " + mue.getStackTrace().toString());
            }
        }
        return f;
    }

    @Override
    public synchronized Hashtable<ISupportFileDefinition, File> getSupportFiles(Collection<ISupportFileDefinition> defs, boolean getOnline) throws SupportFileAccessError {
        boolean getOnlineFlag = getOnline;
        Hashtable<ISupportFileDefinition, File> returnMap = new Hashtable<ISupportFileDefinition, File>();
        Iterator<ISupportFileDefinition> it = defs.iterator();
        ArrayList<ISupportFileDefinition> toremove = new ArrayList<ISupportFileDefinition>();
        while (it.hasNext()) {
            ISupportFileDefinition isdf = it.next();
            if (isdf.isAllowed()) continue;
            toremove.add(isdf);
        }
        it = toremove.iterator();
        while (it.hasNext()) {
            defs.remove(it.next());
        }
        File[] cachedFiles = new File[defs.size()];
        Hashtable<ISupportFileDefinition, File> defsToCachedFiles = new Hashtable<ISupportFileDefinition, File>();
        ISupportFileDefinition[] defsarray = defs.toArray(new ISupportFileDefinition[defs.size()]);
        for (int i = 0; i < defsarray.length; ++i) {
            ISupportFileDefinition def = defsarray[i];
            File cachedFile = null;
            if (!this.fileIsInRepository(def)) continue;
            try {
                cachedFile = this.getLatestVersionFromRepository(def);
                defsToCachedFiles.put(def, cachedFile);
                if (!def.isValid(cachedFile)) {
                    cachedFile.delete();
                    continue;
                }
                if (!def.isVersioned() || this.fileHasBeenCheckedRecently(def)) {
                    cachedFiles[i] = cachedFile;
                    continue;
                }
                getOnlineFlag = true;
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        Hashtable<Object, Object> downloadedFileMap = new Hashtable();
        if (getOnlineFlag) {
            if (this.shouldAskToGetOnline()) {
                AllowConnectionsDialog dialog = new AllowConnectionsDialog(new JFrame());
                this.setAllowedOnline(dialog.showModal() == 0);
                this.setAskToGetOnline(dialog.askAgain());
            }
            if (this.isAllowedOnline()) {
                try {
                    downloadedFileMap = this.getUpdatesIfAvailable(new Vector<ISupportFileDefinition>(defs), defsToCachedFiles);
                }
                catch (SupportFileAccessError sfae) {
                    // empty catch block
                }
            }
        }
        Enumeration<ISupportFileDefinition> allDefs = new Vector<ISupportFileDefinition>(defs).elements();
        while (allDefs.hasMoreElements()) {
            File thisDefFile;
            ISupportFileDefinition thisDef = allDefs.nextElement();
            if (downloadedFileMap.containsKey(thisDef)) {
                thisDefFile = (File)downloadedFileMap.get(thisDef);
                returnMap.put(thisDef, thisDefFile);
                continue;
            }
            if (!defsToCachedFiles.containsKey(thisDef)) continue;
            thisDefFile = defsToCachedFiles.get(thisDef);
            returnMap.put(thisDef, thisDefFile);
        }
        return returnMap;
    }

    private boolean shouldCheckForUpdate(ISupportFileDefinition def) {
        return false;
    }

    private synchronized Hashtable<ISupportFileDefinition, File> getUpdatesIfAvailable(Vector<ISupportFileDefinition> defs, Hashtable<ISupportFileDefinition, File> defToCachedFileMap) throws SupportFileAccessError {
        Hashtable<ISupportFileDefinition, File> tempMap = new Hashtable<ISupportFileDefinition, File>();
        Hashtable hostsHash = new Hashtable();
        Enumeration<ISupportFileDefinition> allDefs = defs.elements();
        while (allDefs.hasMoreElements()) {
            ISupportFileDefinition thisDef = allDefs.nextElement();
            if (this.fileHasBeenCheckedRecently(thisDef)) continue;
            try {
                URL tempURL = thisDef.getURL();
                URL host = new URL(tempURL.getProtocol(), tempURL.getHost(), tempURL.getPort(), "");
                if (hostsHash.containsKey(host)) {
                    ((Vector)hostsHash.get(host)).add(thisDef);
                    continue;
                }
                Vector<ISupportFileDefinition> temp = new Vector<ISupportFileDefinition>();
                temp.add(thisDef);
                hostsHash.put(host, temp);
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        Enumeration allHosts = hostsHash.keys();
        while (allHosts.hasMoreElements()) {
            File cachedFile;
            ISupportFileDefinition thisDef;
            URL thisDefURL;
            int i;
            Vector filesForThisHost;
            URL thishost = (URL)allHosts.nextElement();
            FileDownloader fd = FileDownloader.getInstance(thishost);
            boolean connected = false;
            try {
                connected = fd.connect();
            }
            catch (IOException ioe) {
                connected = false;
            }
            catch (NullPointerException npe) {
                connected = false;
            }
            if (connected) {
                filesForThisHost = (Vector)hostsHash.get(thishost);
                for (i = 0; i < filesForThisHost.size(); ++i) {
                    Date cachedDateForThisDef;
                    thisDefURL = null;
                    thisDef = (ISupportFileDefinition)filesForThisHost.get(i);
                    cachedFile = defToCachedFileMap.get(thisDef);
                    if (cachedFile == null || !cachedFile.exists()) {
                        cachedDateForThisDef = null;
                    } else {
                        try {
                            cachedDateForThisDef = FileResourceManager.getDateFromFilename(cachedFile, thisDef);
                        }
                        catch (ParseException pe) {
                            cachedDateForThisDef = new Date(0L);
                        }
                    }
                    try {
                        thisDefURL = thisDef.getURL();
                        Date lastModifiedDate = fd.getLastModifiedDate(thisDefURL.getPath());
                        if (cachedDateForThisDef == null || this.roundedCompare(cachedDateForThisDef, lastModifiedDate)) {
                            String path = thisDefURL.getPath();
                            String query = thisDefURL.getQuery();
                            if (query != null && query.length() > 0) {
                                path = path + "?" + query;
                            }
                            File f = fd.getTempFile(path);
                            if (fd.wasCancelled()) {
                                f = null;
                            }
                            if (f != null && f.exists()) {
                                File finalFile = this.validateAndCopyToRepository(f, thisDef, lastModifiedDate);
                                if (finalFile == null) continue;
                                tempMap.put(thisDef, finalFile);
                                this.filesCheckedThisSession.add(thisDef);
                                continue;
                            }
                            SupportFileAccessError sfae = new SupportFileAccessError("File was not downloaded.");
                            ShowThrowableDialog.show(null, "File not found", sfae);
                            continue;
                        }
                        this.filesCheckedThisSession.add(thisDef);
                        continue;
                    }
                    catch (MalformedURLException mue) {
                        thisDefURL = null;
                    }
                }
                continue;
            }
            filesForThisHost = (Vector)hostsHash.get(thishost);
            for (i = 0; i < filesForThisHost.size(); ++i) {
                thisDefURL = null;
                thisDef = (ISupportFileDefinition)filesForThisHost.get(i);
                cachedFile = defToCachedFileMap.get(thisDef);
                if (cachedFile == null || !cachedFile.exists()) {
                    JFileChooser chooser = new JFileChooser("");
                    try {
                        if (chooser.showOpenDialog(new JFrame()) == 0) {
                            File selectedFile = chooser.getSelectedFile();
                            thisDefURL = new URL("file://" + selectedFile.getAbsolutePath());
                            FileDownloader fed = FileDownloader.getInstance(thisDefURL);
                            Date lastModifiedDate = fed.getLastModifiedDate(selectedFile.getAbsolutePath());
                            File f = fed.getTempFile(selectedFile.getCanonicalPath());
                            if (f != null && f.exists()) {
                                File finalFile = this.validateAndCopyToRepository(f, thisDef, lastModifiedDate);
                                if (finalFile != null) {
                                    tempMap.put(thisDef, finalFile);
                                    this.filesCheckedThisSession.add(thisDef);
                                }
                                continue;
                            }
                            SupportFileAccessError sfae = new SupportFileAccessError("File was not downloaded.");
                            ShowThrowableDialog.show(null, "File not found", sfae);
                            continue;
                        }
                        SupportFileAccessError sfae = new SupportFileAccessError("File not selected ");
                        throw sfae;
                    }
                    catch (IOException ioe) {
                        SupportFileAccessError sfae = new SupportFileAccessError(ioe);
                        throw sfae;
                    }
                }
                SupportFileAccessError sfae = new SupportFileAccessError("Couldn't connect to server " + fd.hostURL);
                throw sfae;
            }
        }
        return tempMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized File validateAndCopyToRepository(File temporaryDownloadedFile, ISupportFileDefinition def, Date serverLastModifiedDate) throws SupportFileAccessError {
        try {
            File temporaryUncompressedFile = null;
            temporaryUncompressedFile = def.fileNeedsUnzipping() ? this.unzipFile(temporaryDownloadedFile) : temporaryDownloadedFile;
            if (!def.isValid(temporaryUncompressedFile)) {
                String friendlyMessage = "The downloaded file was corrupted. This could be a one-time problem or could represent a problem with the file on the webserver. If this problem continues, please contact the MeV development team at http://www.tm4.org/forum.";
                SupportFileAccessError sfae = new SupportFileAccessError("Downloaded file was corrupt.");
                ShowThrowableDialog.show(new Frame(), "Corrupted File", true, 0, sfae, friendlyMessage);
                throw sfae;
            }
            try {
                File newlyCachedFile;
                File temp = this.createFileHandleInRepository(def, new Date(0L));
                if (!temp.exists()) return newlyCachedFile;
                temp.delete();
                newlyCachedFile = this.copyFileToRepository(temporaryUncompressedFile, def, serverLastModifiedDate);
                return newlyCachedFile;
            }
            catch (Exception e) {
                String friendlyMessage = "There was a problem storing your downloaded file to the local hard drive.The file is stored in a temporary location and can be used normally, \nbut was unable to be copied to MeV's permanent repository for later use. ";
                SupportFileAccessError sfae = new SupportFileAccessError("File could not be stored.", e);
                ShowThrowableDialog.show(new Frame(), "", true, 2, sfae, friendlyMessage);
                return temporaryUncompressedFile;
            }
        }
        catch (IOException ioe) {
            String friendlyMessage = "The selected file was not found. The internet connection may have been interrupted during download.";
            SupportFileAccessError sfae = new SupportFileAccessError("There was a problem with the downloaded file", ioe);
            ShowThrowableDialog.show(new Frame(), "Internet Connectivity Problem", true, 0, sfae, friendlyMessage);
            throw sfae;
        }
    }

    protected boolean roundedCompare(Date firstDate, Date secondDate) {
        if (firstDate == null || secondDate == null) {
            return false;
        }
        Calendar dateOne = Calendar.getInstance();
        Calendar dateTwo = Calendar.getInstance();
        dateOne.setTime(firstDate);
        dateTwo.setTime(secondDate);
        if (dateOne.get(1) < dateTwo.get(1)) {
            return true;
        }
        if (dateOne.get(2) < dateTwo.get(2)) {
            return true;
        }
        return dateOne.get(5) < dateTwo.get(5);
    }

    @Override
    public synchronized Hashtable<ISupportFileDefinition, File> getMultipleSupportFiles(IMultiSupportFileDefinition def) throws SupportFileAccessError {
        try {
            URL url = def.getURL();
            FileDownloader fd = FileDownloader.getInstance(url);
            if (!fd.connect()) {
                SupportFileAccessError sfae = new SupportFileAccessError("Could not connect to " + url.toString());
                ShowThrowableDialog.show(new Frame(), "Could not connect to " + url.toString(), true, 0, sfae);
                throw sfae;
            }
            String[] filenames = fd.getFileList(url.getPath());
            fd.disconnect();
            if (filenames != null && filenames.length > 0) {
                SelectMultiFilesDialog dialog = new SelectMultiFilesDialog(new JFrame(), "Select files to download", def.getURL().getHost(), filenames);
                dialog.setVisible(true);
                int[] indices = dialog.getSelectedFilesIndices();
                String[] selectedFiles = new String[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    selectedFiles[i] = filenames[indices[i]];
                }
                Collection<ISupportFileDefinition> defs = def.getFileDefinitions(selectedFiles);
                return this.getSupportFiles(defs, true);
            }
            SupportFileAccessError sfae = new SupportFileAccessError("Unable to get a list of files from the location " + url.toString());
            ShowThrowableDialog.show(new Frame(), "Unable to get a list of files from the location " + url.toString(), true, 0, sfae);
            throw sfae;
        }
        catch (MalformedURLException mue) {
            SupportFileAccessError sfae = new SupportFileAccessError("Malformed url in requested file", mue);
            ShowThrowableDialog.show(new Frame(), "Malformed url in requested file", true, 0, sfae);
            throw sfae;
        }
        catch (IOException ioe) {
            SupportFileAccessError sfae = new SupportFileAccessError(ioe);
            ShowThrowableDialog.show(new Frame(), ioe.getMessage(), true, 0, sfae);
            throw sfae;
        }
    }

    @Override
    public synchronized boolean fileIsInRepository(ISupportFileDefinition def) {
        try {
            if (this.getLatestVersionFromRepository(def) == null) {
                return false;
            }
            return this.getLatestVersionFromRepository(def).exists() && this.getLatestVersionFromRepository(def).canRead();
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private synchronized File unzipFile(File zippedFile) throws ZipException, IOException {
        ZipEntry entry;
        if (zippedFile == null || !zippedFile.exists()) {
            System.out.println("couldn't find file to unzip");
            throw new IOException("Could not find file to unzip.");
        }
        File unzipDir = File.createTempFile("mev_resource_unzip", "");
        unzipDir.deleteOnExit();
        if (!unzipDir.delete()) {
            throw new IOException();
        }
        if (!unzipDir.mkdir()) {
            throw new IOException();
        }
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zippedFile));
        byte[] buf = new byte[1024];
        while ((entry = zis.getNextEntry()) != null) {
            int len;
            File entryDirectory;
            if (entry.isDirectory()) continue;
            String entryName = entry.getName();
            String entryFolder = new File(entryName).getParent();
            if (entryFolder == null) {
                entryFolder = "";
            }
            if (!(entryDirectory = new File(unzipDir, entryFolder)).exists()) {
                entryDirectory.mkdirs();
            }
            File outFile = new File(unzipDir, entry.getName());
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(outFile));
            while ((len = zis.read(buf)) > 0) {
                dos.write(buf, 0, len);
            }
            dos.close();
            zis.closeEntry();
        }
        zis.close();
        return unzipDir;
    }

    private synchronized File getLatestVersionFromRepository(ISupportFileDefinition def) throws IOException {
        if (!def.isVersioned()) {
            return this.createFileHandleInRepository(def, new Date(0L));
        }
        File supportFileDirectory = new File(this.localRepository, def.getClass().getName());
        if (!supportFileDirectory.exists()) {
            supportFileDirectory.mkdir();
        } else if (!supportFileDirectory.isDirectory() || !supportFileDirectory.canRead()) {
            throw new IOException("Couldn't write to support file directory " + supportFileDirectory.getAbsolutePath());
        }
        File[] versions = supportFileDirectory.listFiles(def);
        File latestFile = null;
        Date newest = new Date(0L);
        for (int i = 0; i < versions.length; ++i) {
            Date d;
            try {
                d = FileResourceManager.getDateFromFilename(versions[i], def);
            }
            catch (ParseException pe) {
                d = new Date(0L);
            }
            if (d.after(newest)) {
                newest = d;
            }
            latestFile = versions[i];
        }
        return latestFile;
    }

    protected static Date getDateFromFilename(File f, ISupportFileDefinition def) throws ParseException {
        String filename = f.getName();
        String uniqueName = def.getUniqueName();
        String prefix = "";
        String dateString = "";
        prefix = uniqueName.lastIndexOf(46) > 0 ? uniqueName.substring(0, uniqueName.lastIndexOf(46)) : uniqueName;
        dateString = filename.lastIndexOf(46) > 0 ? filename.substring(prefix.length(), filename.lastIndexOf(46)) : filename.substring(prefix.length());
        return FileResourceManager.stringToDate(dateString);
    }

    private String createDatedFileName(ISupportFileDefinition def, Date d) {
        String uniqueName = def.getUniqueName();
        String prefix = "";
        String suffix = "";
        if (uniqueName.lastIndexOf(46) > 0) {
            prefix = uniqueName.substring(0, uniqueName.lastIndexOf(46));
            suffix = uniqueName.substring(uniqueName.lastIndexOf(46));
        } else {
            prefix = uniqueName;
            suffix = "";
        }
        return prefix + this.dateToString(d) + suffix;
    }

    private static Date stringToDate(String s) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("_yyyy-MM-dd", new Locale("en"));
        return df.parse(s);
    }

    private String dateToString(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("_yyyy-MM-dd", new Locale("en"));
        String temp = df.format(d);
        return temp;
    }

    private synchronized File createFileHandleInRepository(ISupportFileDefinition def, Date d) throws IOException {
        File supportFileDirectory;
        if (d == null) {
            d = new Date(0L);
        }
        if (!(supportFileDirectory = new File(this.localRepository, def.getClass().getName())).exists()) {
            supportFileDirectory.mkdir();
        } else if (!supportFileDirectory.isDirectory() || !supportFileDirectory.canRead()) {
            throw new IOException("Couldn't write to support file directory " + supportFileDirectory.getAbsolutePath());
        }
        File supportFile = def.isVersioned() ? new File(supportFileDirectory, this.createDatedFileName(def, d)) : new File(supportFileDirectory, def.getUniqueName());
        return supportFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized File copyFileToRepository(File unzippedDir, ISupportFileDefinition def, Date d) throws IOException {
        File f = this.createFileHandleInRepository(def, d);
        assert (!f.exists()) : "File " + f.getAbsolutePath() + " should not exist.";
        if (!def.fileNeedsUnzipping()) {
            FileResourceManager.copyFiles(unzippedDir, f);
            return f;
        }
        if (def.isSingleFile()) {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                int len;
                File singleFile = unzippedDir.listFiles()[0];
                fis = new FileInputStream(singleFile);
                fos = new FileOutputStream(f);
                byte[] buf = new byte[1024];
                while ((len = fis.read(buf)) > 0) {
                    fos.write(buf, 0, len);
                }
                fis.close();
                fos.close();
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ioe) {}
            }
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            f.mkdir();
            FileResourceManager.copyFiles(unzippedDir, f);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ioe) {}
        }
        return f;
    }

    private static synchronized void copyFiles(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new IOException("copyFiles: Can not find source: " + src.getAbsolutePath() + ".");
        }
        if (!src.canRead()) {
            throw new IOException("copyFiles: No right to source: " + src.getAbsolutePath() + ".");
        }
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdirs()) {
                throw new IOException("copyFiles: Could not create direcotry: " + dest.getAbsolutePath() + ".");
            }
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                File dest1 = new File(dest, list[i]);
                File src1 = new File(src, list[i]);
                FileResourceManager.copyFiles(src1, dest1);
            }
        } else {
            FileInputStream fin = null;
            FileOutputStream fout = null;
            byte[] buffer = new byte[4096];
            try {
                int bytesRead;
                fin = new FileInputStream(src);
                fout = new FileOutputStream(dest);
                while ((bytesRead = fin.read(buffer)) >= 0) {
                    fout.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                IOException wrapper = new IOException("unable to copy file from " + src.getAbsolutePath() + " to " + dest.getAbsolutePath() + ".");
                wrapper.initCause(e);
                wrapper.setStackTrace(e.getStackTrace());
                throw wrapper;
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
                if (fout != null) {
                    fin.close();
                }
            }
        }
    }

    @Override
    public boolean checkForUpdate(ISupportFileDefinition def) {
        return false;
    }

    private void initializeProperties() {
        this.setAllowedOnline(new Boolean(TMEV.getSettingForOption("allow-internet-connections", "true")));
        this.setAskToGetOnline(new Boolean(TMEV.getSettingForOption("prompt-to-get-online", "true")));
    }

    private boolean isAllowedOnline() {
        return this.allowedOnline;
    }

    private boolean shouldAskToGetOnline() {
        return this.promptToGetOnline;
    }

    private void setAllowedOnline(boolean b) {
        this.allowedOnline = b;
        try {
            TMEV.storeProperty("allow-internet-connections", new Boolean(this.allowedOnline).toString());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void setAskToGetOnline(boolean b) {
        this.promptToGetOnline = b;
        try {
            TMEV.storeProperty("prompt-to-get-online", new Boolean(this.promptToGetOnline).toString());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
    }

    private void testGSEADownloads() {
        try {
            File geneSetList = this.getSupportFile((ISupportFileDefinition)new BroadGeneSetList(), true);
            try {
                ArrayList genesetFilenames = BroadGeneSetList.getFileNames((File)geneSetList);
                String email = "whatever@wherever.com";
                ArrayList<ISupportFileDefinition> defs = new ArrayList<ISupportFileDefinition>();
                for (String genesetFileName : genesetFilenames) {
                    defs.add((ISupportFileDefinition)new BroadGeneSet(genesetFileName, email));
                }
                Hashtable<ISupportFileDefinition, File> results = this.getSupportFiles(defs, true);
                Enumeration<ISupportFileDefinition> e = results.keys();
                while (e.hasMoreElements()) {
                    File temp;
                    ISupportFileDefinition thisDef = e.nextElement();
                    if (thisDef.isValid(temp = results.get(thisDef))) {
                        System.out.println("support file downloaded correctly: " + temp.getAbsolutePath());
                        continue;
                    }
                    System.out.println("support file not downloaded " + temp.getAbsolutePath());
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (SupportFileAccessError sfae) {
            sfae.printStackTrace();
        }
        try {
            GeneSigDbGeneSets temp = new GeneSigDbGeneSets();
            File geneSigs = this.getSupportFile((ISupportFileDefinition)temp, true);
            if (temp.isValid(geneSigs)) {
                System.out.println("GeneSigDb download file is valid.");
            }
        }
        catch (SupportFileAccessError sfae) {
            System.out.println("Could not download GeneSigDbGeneSets file.");
        }
    }

    public static void main(String[] args) {
        FileResourceManager frm;
        try {
            frm = new FileResourceManager(new File(new File(System.getProperty("user.home"), ".mev"), "repository"));
        }
        catch (RepositoryInitializationError rie) {
            rie.printStackTrace();
            return;
        }
        Vector<ISupportFileDefinition> defs = new Vector<ISupportFileDefinition>();
        defs.add(new ResourcererAnnotationFileDefinition("Human", "APPLERA_ABI1700"));
        Hashtable<ISupportFileDefinition, File> results = null;
        try {
            results = frm.getSupportFiles(defs, true);
        }
        catch (SupportFileAccessError sfae) {
            sfae.printStackTrace();
        }
        if (results == null) {
            System.out.println("No results returned from getSupportFiles(defs, true)");
            System.exit(0);
        }
        Enumeration<ISupportFileDefinition> e = defs.elements();
        while (e.hasMoreElements()) {
            ISupportFileDefinition thisDef = e.nextElement();
            if (thisDef == null) {
                System.out.println("null support definition");
                continue;
            }
            File f = results.get(thisDef);
            if (f == null) {
                System.out.println("file for def " + thisDef.getUniqueName() + " was not found");
                continue;
            }
            System.out.println("Found file " + thisDef.getUniqueName());
        }
        frm.testGSEADownloads();
        Enumeration<ISupportFileDefinition> temp = defs.elements();
        while (temp.hasMoreElements()) {
            ISupportFileDefinition def = temp.nextElement();
            try {
                File f;
                try {
                    f = frm.getLatestVersionFromRepository(def);
                    if (f != null) {
                        System.out.println(f.getAbsolutePath());
                    } else {
                        System.out.println("File not found in repository.");
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return;
                }
                f = frm.getSupportFile(def, true);
                if (!f.exists()) {
                    System.out.println(f.getAbsolutePath() + " does not exist.");
                }
                if (f.canRead()) continue;
                System.out.println(f.getAbsolutePath() + " cannot be read.");
            }
            catch (SupportFileAccessError sfae) {
                sfae.printStackTrace();
            }
        }
        System.out.println("FileResourceManager finished.");
        System.exit(0);
    }
}

