/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.resources;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.resources.FTPFileDownloader;
import org.tigr.microarray.mev.resources.HTTPDownloader;
import org.tigr.microarray.mev.resources.RMProgress;
import org.tigr.microarray.mev.resources.SFTPFileDownloader;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public abstract class FileDownloader {
    protected URL hostURL;
    RMProgress progress;
    int result = 0;

    protected FileDownloader(URL host) {
        try {
            this.hostURL = new URL(host.getProtocol(), host.getHost(), host.getPort(), "");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static FileDownloader getInstance(URL host) {
        if (host.getProtocol().startsWith("ftp")) {
            return new FTPFileDownloader(host);
        }
        if (host.getProtocol().startsWith("sftp")) {
            return new SFTPFileDownloader(host);
        }
        if (host.getProtocol().startsWith("http")) {
            return new HTTPDownloader(host);
        }
        return null;
    }

    public abstract boolean connect() throws IOException;

    public abstract void disconnect();

    public abstract Date getLastModifiedDate(String var1);

    public abstract File getTempFile(String var1) throws SupportFileAccessError;

    public abstract String[] getFileList(String var1);

    public void destroy() {
        this.disconnect();
    }

    public boolean wasCancelled() {
        return this.progress.wasCancelled;
    }

    public class DownloadProgressListener
    extends DialogListener
    implements WindowListener {
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                FileDownloader.this.progress.wasCancelled = true;
                FileDownloader.this.result = 2;
                FileDownloader.this.progress.dispose();
            }
            if (command.equals("window-close-command")) {
                FileDownloader.this.progress.wasCancelled = true;
                FileDownloader.this.result = 2;
                FileDownloader.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            FileDownloader.this.progress.wasCancelled = true;
            FileDownloader.this.result = 2;
            FileDownloader.this.progress.dispose();
        }
    }
}

