/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.resources;

import ftp.FtpBean;
import ftp.FtpException;
import ftp.FtpListResult;
import ftp.FtpObserver;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import org.tigr.microarray.mev.resources.FileDownloader;
import org.tigr.microarray.mev.resources.RMProgress;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class FTPFileDownloader
extends FileDownloader {
    FtpBean ftp = null;
    boolean disposeProgress1 = false;
    boolean disposeProgress2 = false;
    boolean disposeProgress3 = false;
    int overallLength;
    URL url;

    public FTPFileDownloader(URL host) {
        super(host);
    }

    @Override
    public boolean connect() throws IOException {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (FTPFileDownloader.this.disposeProgress1) {
                    FTPFileDownloader.this.disposeProgress1 = false;
                    return;
                }
                FTPFileDownloader.this.progress = new RMProgress(new Frame(), "Connecting to Host", new FileDownloader.DownloadProgressListener(FTPFileDownloader.this));
                FTPFileDownloader.this.progress.setModal(true);
                FTPFileDownloader.this.progress.setIndeterminate(true);
                FTPFileDownloader.this.progress.setAlwaysOnTop(true);
                FTPFileDownloader.this.progress.setIndeterminantString("Connecting...");
                FTPFileDownloader.this.progress.setFocusable(true);
                FTPFileDownloader.this.progress.init(1, "Connecting to " + FTPFileDownloader.this.hostURL, "??", 0L);
            }
        });
        thread.setPriority(10);
        thread.start();
        this.ftp = new FtpBean();
        try {
            this.ftp.ftpConnect(this.hostURL.getHost(), "anonymous");
            if (this.progress != null && this.progress.wasCancelled) {
                boolean bl = false;
                return bl;
            }
        }
        catch (FtpException ftpe) {
            throw new IOException(ftpe.getMessage());
        }
        catch (NullPointerException npe) {
            throw new IOException(npe.getMessage());
        }
        finally {
            this.disposeProgress1 = true;
            if (this.progress != null) {
                this.progress.dispose();
                this.disposeProgress1 = false;
            }
        }
        return true;
    }

    @Override
    public void disconnect() {
        assert (this.ftp != null) : "FtpFileDownloader is not connected in disconnect()";
        try {
            if (this.ftp != null) {
                this.ftp.close();
            }
        }
        catch (FtpException ftpe) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Date getLastModifiedDate(String path) {
        assert (this.ftp != null) : "FtpFileDownloader is not connected when queried by getLastModifiedDate";
        Date serverDateLastModified = null;
        try {
            String ftpDir = path.substring(0, path.lastIndexOf(47) + 1);
            URL url = null;
            try {
                url = new URL(this.hostURL + path);
            }
            catch (MalformedURLException mue) {
                return null;
            }
            this.ftp.setDirectory(ftpDir);
            FtpListResult list = this.ftp.getDirectoryContent();
            String filename = url.getFile();
            Calendar currentDate = Calendar.getInstance();
            if (list != null) {
                while (list.next()) {
                    if (!list.getName().equals(filename.substring(filename.lastIndexOf(47) + 1))) continue;
                    try {
                        SimpleDateFormat df;
                        String dateString = list.getDate();
                        if (dateString.contains(":")) {
                            df = new SimpleDateFormat("MMM dd kk:mm", Locale.US);
                            Calendar c = Calendar.getInstance();
                            c.setTime(df.parse(dateString));
                            c.set(1, currentDate.get(1));
                            serverDateLastModified = c.getTime();
                            continue;
                        }
                        df = new SimpleDateFormat("MMM dd yyyy", Locale.US);
                        serverDateLastModified = df.parse(dateString);
                    }
                    catch (Exception e) {
                        serverDateLastModified = new Date(0L);
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException ioe) {
            serverDateLastModified = null;
        }
        catch (FtpException ftpe) {
            serverDateLastModified = null;
        }
        return serverDateLastModified;
    }

    private int getSize(String path) throws FtpException, IOException {
        if (this.ftp == null) {
            return 0;
        }
        String ftpDir = path.substring(0, path.lastIndexOf(47) + 1);
        URL url = null;
        try {
            url = new URL(this.hostURL + path);
        }
        catch (MalformedURLException mue) {
            return 0;
        }
        this.ftp.setDirectory(ftpDir);
        FtpListResult list = this.ftp.getDirectoryContent();
        String filename = url.getFile();
        Calendar currentDate = Calendar.getInstance();
        if (list != null) {
            while (list.next()) {
                if (!list.getName().equals(filename.substring(filename.lastIndexOf(47) + 1))) continue;
                return (int)list.getSize();
            }
        }
        return 0;
    }

    @Override
    public File getTempFile(String path) throws SupportFileAccessError {
        this.disposeProgress2 = false;
        this.url = null;
        try {
            this.url = new URL(this.hostURL + path);
        }
        catch (MalformedURLException mue) {
            return null;
        }
        File newFile = null;
        try {
            this.overallLength = this.getSize(path);
            this.progress = new RMProgress(new Frame(), "Downloading " + this.url.getPath(), new FileDownloader.DownloadProgressListener(this));
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (FTPFileDownloader.this.disposeProgress2) {
                            return;
                        }
                        FTPFileDownloader.this.progress.setModal(true);
                        FTPFileDownloader.this.progress.setAlwaysOnTop(true);
                        FTPFileDownloader.this.progress.init(1, FTPFileDownloader.this.url.toString(), "??", new Long(FTPFileDownloader.this.overallLength));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            thread.setPriority(10);
            thread.start();
            BufferedOutputStream bos = null;
            newFile = File.createTempFile("mev_resource", "");
            bos = new BufferedOutputStream(new FileOutputStream(newFile));
            if (this.overallLength > 0) {
                bos.write(this.ftp.getBinaryFile(this.url.getFile(), (FtpObserver)this.progress), 0, this.overallLength);
            } else {
                bos.write(this.ftp.getBinaryFile(this.url.getFile(), (FtpObserver)this.progress));
            }
            bos.flush();
            if (this.progress != null && this.progress.wasCancelled) {
                SupportFileAccessError sfae = new SupportFileAccessError("Connection was cancelled by user.");
                sfae.setCancelledConnection(true);
                throw sfae;
            }
        }
        catch (IOException ioe) {
            SupportFileAccessError sfae = new SupportFileAccessError("File not found", ioe);
            throw sfae;
        }
        catch (FtpException ftpe) {
            SupportFileAccessError sfae = new SupportFileAccessError("File not found", ftpe);
            throw sfae;
        }
        finally {
            this.disposeProgress2 = true;
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getFileList(String path) {
        Vector<String> fileList;
        block12: {
            fileList = null;
            try {
                URL url = new URL(this.hostURL + path);
                this.progress = new RMProgress(new Frame(), "Getting file list", new FileDownloader.DownloadProgressListener(this));
                this.progress.init(1, "Getting file list " + url.getHost(), "??", 0L);
                this.progress.setIndeterminate(true);
                this.progress.show();
                String ftpPath = url.getPath();
                String ftpDir = ftpPath.substring(0, ftpPath.lastIndexOf(47) + 1);
                this.ftp.setDirectory(ftpDir);
                FtpListResult list = this.ftp.getDirectoryContent();
                fileList = new Vector<String>();
                if (list != null) {
                    while (list.next()) {
                        fileList.add(list.getName());
                    }
                    break block12;
                }
                String[] stringArray = null;
                return stringArray;
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
                String[] stringArray = null;
                return stringArray;
            }
            catch (FtpException ftpe) {
                ftpe.printStackTrace();
                String[] stringArray = null;
                return stringArray;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                String[] stringArray = null;
                return stringArray;
            }
            finally {
                if (this.progress != null) {
                    this.progress.end();
                    this.progress.dispose();
                }
            }
        }
        return fileList.toArray(new String[fileList.size()]);
    }
}

