/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.r;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.tigr.microarray.mev.r.REXP;
import org.tigr.microarray.mev.r.RFileInputStream;
import org.tigr.microarray.mev.r.RFileOutputStream;
import org.tigr.microarray.mev.r.RSrvException;
import org.tigr.microarray.mev.r.Rpacket;
import org.tigr.microarray.mev.r.Rtalk;
import org.tigr.microarray.mev.r.jcrypt;

public class Rconnection {
    String lastError = null;
    Socket s;
    boolean connected = false;
    InputStream is;
    OutputStream os;
    boolean authReq = false;
    int authType = 0;
    String Key = null;
    Rtalk rt = null;
    public static String transferCharset = "UTF-8";
    public static final int AT_plain = 0;
    public static final int AT_crypt = 1;
    protected int rsrvVersion;

    public Rconnection() throws RSrvException {
        this("127.0.0.1", 6311);
    }

    public Rconnection(String host) throws RSrvException {
        this(host, 6311);
    }

    public Rconnection(String host, int port) throws RSrvException {
        try {
            if (this.connected) {
                this.s.close();
            }
            this.s = null;
        }
        catch (Exception e) {
            throw new RSrvException(this, "Cannot connect: " + e.getMessage());
        }
        this.connected = false;
        try {
            this.s = new Socket(host, port);
            this.s.setTcpNoDelay(true);
        }
        catch (Exception sce) {
            throw new RSrvException(this, "Cannot connect: " + sce.getMessage());
        }
        try {
            this.is = this.s.getInputStream();
            this.os = this.s.getOutputStream();
        }
        catch (Exception gse) {
            throw new RSrvException(this, "Cannot get io stream: " + gse.getMessage());
        }
        this.rt = new Rtalk(this.is, this.os);
        byte[] IDs = new byte[32];
        int n = -1;
        try {
            n = this.is.read(IDs);
        }
        catch (Exception sre) {
            throw new RSrvException(this, "Error while receiving data: " + sre.getMessage());
        }
        try {
            if (n != 32) {
                this.lastError = "Handshake failed: expected 32 bytes header, got " + n;
                throw new RSrvException(this, this.lastError);
            }
            String ids = new String(IDs);
            if (ids.substring(0, 4).compareTo("Rsrv") != 0) {
                this.lastError = "Handshake failed: Rsrv signature expected, but received \"" + ids + "\" instead.";
                throw new RSrvException(this, this.lastError);
            }
            try {
                this.rsrvVersion = Integer.parseInt(ids.substring(4, 8));
            }
            catch (Exception px) {
                // empty catch block
            }
            if (this.rsrvVersion > 102) {
                this.lastError = "Handshake failed: The server uses more recent protocol than this client.";
                throw new RSrvException(this, this.lastError);
            }
            if (ids.substring(8, 12).compareTo("QAP1") != 0) {
                this.lastError = "Handshake failed: unupported transfer protocol (" + ids.substring(8, 12) + "), I talk only QAP1.";
                throw new RSrvException(this, this.lastError);
            }
            for (int i = 12; i < 32; i += 4) {
                String attr = ids.substring(i, i + 4);
                if (attr.compareTo("ARpt") == 0 && !this.authReq) {
                    this.authReq = true;
                    this.authType = 0;
                }
                if (attr.compareTo("ARuc") == 0) {
                    this.authReq = true;
                    this.authType = 1;
                }
                if (attr.charAt(0) != 'K') continue;
                this.Key = attr.substring(1, 3);
            }
            this.connected = true;
            this.lastError = "OK";
        }
        catch (RSrvException innerX) {
            try {
                this.s.close();
            }
            catch (Exception ex01) {
                // empty catch block
            }
            this.is = null;
            this.os = null;
            this.s = null;
            throw innerX;
        }
    }

    public void finalize() {
        this.close();
        this.is = null;
        this.is = null;
    }

    public int getServerVersion() {
        return this.rsrvVersion;
    }

    public void close() {
        try {
            if (this.s != null) {
                this.s.close();
            }
            this.connected = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void voidEval(String cmd) throws RSrvException {
        if (!this.connected || this.rt == null) {
            this.lastError = "Error: not connected!";
            throw new RSrvException(this, this.lastError);
        }
        Rpacket rp = this.rt.request(2, cmd + "\n");
        if (rp != null && rp.isOk()) {
            return;
        }
        this.lastError = rp != null ? "Request return code: " + rp.getStat() : "Communication error (Rtalk returned null)";
        throw new RSrvException(this, this.lastError, rp.getStat());
    }

    public REXP eval(String cmd) throws RSrvException {
        if (!this.connected || this.rt == null) {
            this.lastError = "Error: not connected!";
            throw new RSrvException(this, this.lastError);
        }
        Rpacket rp = this.rt.request(3, cmd + "\n");
        if (rp != null && rp.isOk()) {
            int rxo = 0;
            byte[] pc = rp.getCont();
            if (this.rsrvVersion > 100) {
                rxo = 4;
                if (pc[0] != 10 && pc[0] != 74) {
                    this.lastError = "Error while processing eval output: SEXP (type 10) expected but found result type " + pc[0] + ".";
                    throw new RSrvException(this, this.lastError);
                }
                if (pc[0] == 74) {
                    rxo = 8;
                }
            }
            REXP rx = null;
            if (pc.length > rxo) {
                rx = new REXP();
                REXP.parseREXP(rx, pc, rxo);
            }
            return rx;
        }
        this.lastError = rp != null ? "Request return code: " + rp.getStat() : "Communication error (Rtalk returned null)";
        throw new RSrvException(this, this.lastError, rp != null ? rp.getStat() : -1);
    }

    public void assign(String sym, String ct) throws RSrvException {
        int ic;
        if (!this.connected || this.rt == null) {
            this.lastError = "Error: not connected!";
            throw new RSrvException(this, this.lastError);
        }
        byte[] symn = sym.getBytes();
        byte[] ctn = ct.getBytes();
        int sl = symn.length + 1;
        int cl = ctn.length + 1;
        if ((sl & 3) > 0) {
            sl = (sl & 0xFFFFFC) + 4;
        }
        if ((cl & 3) > 0) {
            cl = (cl & 0xFFFFFC) + 4;
        }
        byte[] rq = new byte[sl + 4 + cl + 4];
        for (ic = 0; ic < symn.length; ++ic) {
            rq[ic + 4] = symn[ic];
        }
        while (ic < sl) {
            rq[ic + 4] = 0;
            ++ic;
        }
        for (ic = 0; ic < ctn.length; ++ic) {
            rq[ic + sl + 8] = ctn[ic];
        }
        while (ic < cl) {
            rq[ic + sl + 8] = 0;
            ++ic;
        }
        Rtalk.setHdr(4, sl, rq, 0);
        Rtalk.setHdr(4, cl, rq, sl + 4);
        Rpacket rp = this.rt.request(32, rq);
        if (rp != null && rp.isOk()) {
            return;
        }
        this.lastError = rp != null ? "Request return code: " + rp.getStat() : "Communication error (Rtalk returned null)";
        throw new RSrvException(this, this.lastError, rp != null ? rp.getStat() : -1);
    }

    public void assign(String sym, REXP r) throws RSrvException {
        int ic;
        if (!this.connected || this.rt == null) {
            this.lastError = "Error: not connected!";
            throw new RSrvException(this, this.lastError);
        }
        int rl = r.getBinaryLength();
        byte[] symn = sym.getBytes();
        int sl = symn.length + 1;
        if ((sl & 3) > 0) {
            sl = (sl & 0xFFFFFC) + 4;
        }
        byte[] rq = new byte[sl + rl + (rl > 0xFFFFF0 ? 12 : 8)];
        for (ic = 0; ic < symn.length; ++ic) {
            rq[ic + 4] = symn[ic];
        }
        while (ic < sl) {
            rq[ic + 4] = 0;
            ++ic;
        }
        Rtalk.setHdr(4, sl, rq, 0);
        Rtalk.setHdr(10, rl, rq, sl + 4);
        r.getBinaryRepresentation(rq, sl + (rl > 0xFFFFF0 ? 12 : 8));
        Rpacket rp = this.rt.request(32, rq);
        if (rp != null && rp.isOk()) {
            return;
        }
        this.lastError = rp != null ? "Request return code: " + rp.getStat() : "Communication error (Rtalk returned null)";
        throw new RSrvException(this, this.lastError, rp != null ? rp.getStat() : -1);
    }

    public void assign(String sym, double[] val) throws RSrvException {
        this.assign(sym, new REXP(val));
    }

    public void assign(String sym, int[] val) throws RSrvException {
        this.assign(sym, new REXP(val));
    }

    public RFileInputStream openFile(String fn) throws IOException {
        return new RFileInputStream(this.rt, fn);
    }

    public RFileOutputStream createFile(String fn) throws IOException {
        return new RFileOutputStream(this.rt, fn);
    }

    public void removeFile(String fn) throws RSrvException {
        if (!this.connected || this.rt == null) {
            this.lastError = "Error: not connected";
            throw new RSrvException(this, this.lastError);
        }
        Rpacket rp = this.rt.request(21, fn);
        if (rp != null && rp.isOk()) {
            return;
        }
        this.lastError = rp != null ? "Request return code: " + rp.getStat() : "Communication error (Rtalk returned null)";
        throw new RSrvException(this, this.lastError, rp != null ? rp.getStat() : -1);
    }

    public void shutdown() throws RSrvException {
        if (!this.connected || this.rt == null) {
            this.lastError = "Error: not connected";
            throw new RSrvException(this, this.lastError);
        }
        Rpacket rp = this.rt.request(4);
        if (rp != null && rp.isOk()) {
            return;
        }
        this.lastError = rp != null ? "Request return code: " + rp.getStat() : "Communication error (Rtalk returned null)";
        throw new RSrvException(this, this.lastError, rp != null ? rp.getStat() : -1);
    }

    public void setSendBufferSize(long sbs) throws RSrvException {
        if (!this.connected || this.rt == null) {
            this.lastError = "Error: not connected";
            throw new RSrvException(this, this.lastError);
        }
        Rpacket rp = this.rt.request(129, (int)sbs);
        if (rp != null && rp.isOk()) {
            return;
        }
        this.lastError = rp != null ? "Request return code: " + rp.getStat() : "Communication error (Rtalk returned null)";
        throw new RSrvException(this, this.lastError, rp != null ? rp.getStat() : -1);
    }

    public void login(String user, String pwd) throws RSrvException {
        if (!this.authReq) {
            return;
        }
        if (this.authType == 1) {
            Rpacket rp;
            if (this.Key == null) {
                this.Key = "rs";
            }
            if ((rp = this.rt.request(1, user + "\n" + jcrypt.crypt(this.Key, pwd))) != null && rp.isOk()) {
                return;
            }
            this.lastError = rp != null ? "Request return code: " + rp.getStat() : "Communication error (Rtalk returned null)";
            try {
                this.s.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.is = null;
            this.os = null;
            this.s = null;
            this.connected = false;
            throw new RSrvException(this, this.lastError);
        }
        Rpacket rp = this.rt.request(1, user + "\n" + pwd);
        if (rp != null && rp.isOk()) {
            return;
        }
        this.lastError = rp != null ? "Request return code: " + rp.getStat() : "Communication error (Rtalk returned null)";
        try {
            this.s.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.is = null;
        this.os = null;
        this.s = null;
        this.connected = false;
        throw new RSrvException(this, this.lastError, rp != null ? rp.getStat() : -1);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean needLogin() {
        return this.authReq;
    }

    public String getLastError() {
        return this.lastError;
    }
}

