/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.r;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.r.RSrvException;
import org.tigr.microarray.mev.r.RamaResult;
import org.tigr.microarray.mev.r.Rconnection;
import org.tigr.microarray.mev.r.TableSorter;

public class RamaSummaryViewer
extends JPanel
implements IViewer,
ActionListener {
    private Rconnection rc;
    private JButton shutdownButton;
    private JButton saveResult;
    private JFrame jf;
    private RamaResult result;

    public RamaSummaryViewer(RamaResult resultP) {
        this.result = resultP;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.fill = 2;
        c1.anchor = 23;
        JPanel leftPanel = this.createLeftPanel();
        c1.gridx = 0;
        c1.gridy = 0;
        this.add((Component)leftPanel, c1);
        JPanel tablePanel = this.createTablePanel(this.result);
        c1.gridx = 1;
        c1.gridy = 0;
        this.add((Component)tablePanel, c1);
    }

    private JPanel createTablePanel(RamaResult result) {
        JPanel returnPanel = new JPanel();
        returnPanel.setSize(600, 400);
        DefaultTableModel dm = new DefaultTableModel();
        dm.setDataVector(result.getResultTable(), result.getResultHeader());
        TableSorter sorter = new TableSorter(dm);
        JTable jt = new JTable(sorter){

            @Override
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                this.repaint();
            }
        };
        sorter.setTableHeader(jt.getTableHeader());
        jt.setPreferredScrollableViewportSize(new Dimension(600, 400));
        jt.setAutoResizeMode(0);
        TableColumn column = null;
        for (int i = 0; i < result.getResultHeader().length; ++i) {
            column = jt.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(200);
                continue;
            }
            column.setPreferredWidth(100);
        }
        JScrollPane jsp = new JScrollPane(jt);
        returnPanel.add(jsp);
        return returnPanel;
    }

    private JPanel createLeftPanel() {
        JPanel leftPanel = new JPanel();
        leftPanel.setSize(200, 400);
        leftPanel.setBackground(Color.RED);
        leftPanel.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.gridx = 0;
        c2.gridy = 0;
        leftPanel.add((Component)this.createParamPanel(this.result.getShift(), this.result.getB(), this.result.getMinIter()), c2);
        c2.gridx = 0;
        c2.gridy = 1;
        leftPanel.add((Component)this.createButtonPanel(), c2);
        return leftPanel;
    }

    private JPanel createParamPanel(double shift, int B, int minIter) {
        JPanel toReturn = new JPanel();
        Border loweredBorder = BorderFactory.createEtchedBorder();
        Dimension d = new Dimension(150, 80);
        toReturn.setPreferredSize(d);
        toReturn.setMaximumSize(d);
        toReturn.setMinimumSize(d);
        Font font = new Font("Arial", 0, 12);
        toReturn.setBorder(BorderFactory.createTitledBorder(loweredBorder, "Parameters Used", 1, 0, font, Color.GRAY));
        BoxLayout bl = new BoxLayout(toReturn, 1);
        toReturn.setLayout(bl);
        String sShift = new Float(shift).toString();
        JLabel sLabel = new JLabel(new String("  Shift = " + sShift + "  "));
        JLabel bLabel = new JLabel(new String("  B = " + B + "  "));
        JLabel minIterLabel = new JLabel("  minIter = " + minIter + "  ");
        toReturn.add(sLabel);
        toReturn.add(bLabel);
        toReturn.add(minIterLabel);
        return toReturn;
    }

    private JPanel createButtonPanel() {
        JPanel toReturn = new JPanel();
        toReturn.setLayout(new BoxLayout(toReturn, 1));
        toReturn.setSize(300, 400);
        Dimension dButton = new Dimension(150, 25);
        this.shutdownButton = new JButton("Shutdown Rserve");
        this.shutdownButton.setPreferredSize(dButton);
        this.shutdownButton.setMinimumSize(dButton);
        this.shutdownButton.setMaximumSize(dButton);
        this.shutdownButton.addActionListener(this);
        this.saveResult = new JButton("Save Results");
        this.saveResult.setPreferredSize(dButton);
        this.saveResult.setMinimumSize(dButton);
        this.saveResult.setMaximumSize(dButton);
        this.saveResult.addActionListener(this);
        toReturn.add(this.saveResult);
        toReturn.add(this.shutdownButton);
        return toReturn;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.shutdownButton) {
            try {
                int i = JOptionPane.showConfirmDialog(this.jf, "Really Shutdown Rserve?", "Confirm", 0, 2);
                if (i == 0) {
                    if (this.rc != null) {
                        this.rc.shutdown();
                    }
                    this.shutdownButton.setEnabled(false);
                }
            }
            catch (RSrvException e1) {
                e1.printStackTrace();
            }
        } else if (e.getSource() == this.saveResult) {
            this.result.saveRamaResult(this.jf);
        }
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public void onSelected(IFramework framework) {
    }

    public void onDataChanged(IData data) {
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    public static void main(String[] args) {
        String[] genes = new String[1];
        double[] g1 = new double[1];
        double[] g2 = new double[1];
        double shift = 0.2;
        String start = "12:30";
        String end = "1:30";
        genes[0] = "test1";
        g1[0] = 0.5;
        g2[0] = 1.1;
        RamaResult result = new RamaResult(g1, g2, shift, start, end);
        result.setGenes(genes);
        result.setB(2);
        result.setMinIter(3);
        RamaSummaryViewer v = new RamaSummaryViewer(result);
        JFrame jf = new JFrame();
        jf.setSize(800, 600);
        jf.getContentPane().add(v);
        jf.setVisible(true);
        jf.setDefaultCloseOperation(3);
    }

    public void setExperiment(Experiment e) {
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperimentID(int id) {
    }

    public Expression getExpression() {
        return null;
    }
}

