/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.r;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.r.Rama;
import org.tigr.microarray.mev.r.RamaTextFileFilter;

public class RamaResult {
    private double[] gamma1;
    private double[] gamma2;
    private double[] qLo;
    private double[] qUp;
    private double shift;
    private int minIter;
    private int B;
    private boolean allOut;
    private boolean hasGenes;
    private String[] genes;
    private String startTime;
    private String endTime;

    public RamaResult(double[] g1, double[] g2, double[] qLoP, double[] qUpP, double shiftP, String startTimeP, String endTimeP) {
        this.gamma1 = g1;
        this.gamma2 = g2;
        this.qLo = qLoP;
        this.qUp = qUpP;
        this.allOut = true;
        this.shift = shiftP;
        this.hasGenes = false;
        this.startTime = startTimeP;
        this.endTime = endTimeP;
    }

    public RamaResult(double[] g1, double[] g2, double shiftP, String startTimeP, String endTimeP) {
        this.gamma1 = g1;
        this.gamma2 = g2;
        this.allOut = false;
        this.shift = shiftP;
        this.hasGenes = false;
        this.startTime = startTimeP;
        this.endTime = endTimeP;
    }

    public void saveRamaResult(JFrame frame) {
        String currentPath = TMEV.getDataPath();
        RamaTextFileFilter textFilter = new RamaTextFileFilter();
        JFileChooser chooser = new JFileChooser(currentPath);
        chooser.addChoosableFileFilter(textFilter);
        if (chooser.showSaveDialog(frame) == 0) {
            File saveFile;
            if (chooser.getFileFilter() == textFilter) {
                String path = chooser.getSelectedFile().getPath();
                if (path.toLowerCase().endsWith("txt")) {
                    saveFile = new File(path);
                } else {
                    int period = path.lastIndexOf(".txt");
                    String subPath = period != -1 ? path.substring(0, period) : path;
                    String newPath = subPath + ".txt";
                    saveFile = new File(newPath);
                }
            } else {
                saveFile = chooser.getSelectedFile();
            }
            StringBuffer sb = new StringBuffer();
            if (this.hasGenes) {
                sb.append("GeneName");
            }
            if (this.allOut) {
                sb.append(Rama.TAB);
                sb.append("qLow");
                sb.append(Rama.TAB);
                sb.append("qUp");
            }
            sb.append(Rama.TAB);
            sb.append("IntensityA");
            sb.append(Rama.TAB);
            sb.append("IntensityB");
            sb.append(Rama.END_LINE);
            for (int i = 0; i < this.gamma1.length; ++i) {
                if (this.allOut) {
                    sb.append(this.qLo[i]);
                    sb.append(Rama.TAB);
                    sb.append(this.qUp[i]);
                    sb.append(Rama.TAB);
                }
                if (this.hasGenes) {
                    sb.append(this.genes[i]);
                }
                sb.append(Rama.TAB);
                sb.append(this.gamma1[i]);
                sb.append(Rama.TAB);
                sb.append(this.gamma2[i]);
                sb.append(Rama.END_LINE);
            }
            this.writeFile(saveFile, sb.toString());
        }
    }

    private void writeFile(File f, String s) {
        try {
            FileWriter fw = new FileWriter(f);
            fw.write(s);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setGenes(String[] genesP) {
        this.genes = genesP;
        this.hasGenes = genesP != null && genesP.length == this.gamma1.length;
    }

    public void setB(int BP) {
        this.B = BP;
    }

    public void setMinIter(int minIterP) {
        this.minIter = minIterP;
    }

    public int getB() {
        return this.B;
    }

    public int getMinIter() {
        return this.minIter;
    }

    public double[] getGamma1() {
        return this.gamma1;
    }

    public double[] getGamma2() {
        return this.gamma2;
    }

    public double[] getQLo() {
        return this.qLo;
    }

    public double[] getQUp() {
        return this.qUp;
    }

    public String[] getGenes() {
        return this.genes;
    }

    public double getShift() {
        return this.shift;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String[] getResultHeader() {
        String[] toReturn = this.allOut && this.hasGenes ? new String[]{"GeneName", "qLo", "qUp", "Gamma1", "Gamma2"} : (this.allOut && !this.hasGenes ? new String[]{"qLo", "qUp", "Gamma1", "Gamma2"} : (!this.allOut && this.hasGenes ? new String[]{"GeneName", "Gamma1", "Gamma2"} : new String[]{"Gamma1", "Gamma2"}));
        return toReturn;
    }

    public Object[][] getResultTable() {
        int iCol = this.allOut && this.hasGenes ? 5 : (this.allOut && !this.hasGenes ? 4 : (!this.allOut && this.hasGenes ? 3 : 2));
        Object[][] toReturn = new Object[this.gamma1.length][iCol];
        for (int i = 0; i < this.gamma1.length; ++i) {
            int jIndex = 0;
            if (this.hasGenes) {
                toReturn[i][jIndex] = this.genes[i];
                ++jIndex;
            }
            if (this.allOut) {
                toReturn[i][jIndex] = Double.toString(this.qLo[i]);
                toReturn[i][++jIndex] = Double.toString(this.qUp[i]);
                ++jIndex;
            }
            toReturn[i][jIndex] = Double.toString(this.gamma1[i]);
            toReturn[i][++jIndex] = Double.toString(this.gamma2[i]);
            ++jIndex;
        }
        return toReturn;
    }
}

