/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.r;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.r.RHyb;
import org.tigr.microarray.mev.r.RHybSet;
import org.tigr.microarray.mev.r.SpringUtilities;

public class RamaInitDialog
extends AlgorithmDialog {
    private int result;
    private int dataType;
    private boolean connAdded = false;
    private RHyb[] ramaHybs;
    private Vector vCy3Radio;
    private Vector vRamaHyb;
    private JCheckBox advCheckBox;
    private JSpinner burnInSpinner;
    private JSpinner numIterSpinner;
    private JLabel burnInLabel;
    private JLabel numIterLabel;
    private JButton addConnButton;
    private JComboBox connCombo;
    private JTextField newConn;
    private JCheckBox allOutBox;
    private JLabel allOutLabel;
    public static String DEFAULT_ADD_TEXT = "or enter a new server";

    public RamaInitDialog(Frame parent, String[] hybNames, int dataTypeP) {
        super(parent, "RamaInitDialog", true);
        this.setResizable(true);
        this.setSize(600, 500);
        this.dataType = dataTypeP;
        Listener listener = new Listener();
        super.addWindowListener((WindowListener)((Object)listener));
        super.setActionListeners((ActionListener)((Object)listener));
        this.vCy3Radio = new Vector();
        this.vRamaHyb = new Vector();
        this.ramaHybs = new RHyb[hybNames.length];
        JPanel mainPanel = new JPanel();
        mainPanel.add((Component)this.createTwoColorPanel(hybNames, this.dataType), "Center");
        mainPanel.add((Component)this.createParamPanel(), "South");
        this.addContent(mainPanel);
    }

    private JPanel createParamPanel() {
        Font font11 = new Font("Arial", 0, 11);
        Font font = new Font("Arial", 0, 12);
        Dimension dSpinner = new Dimension(70, 25);
        Dimension dArea = new Dimension(140, 80);
        Dimension dCombo = new Dimension(170, 25);
        Dimension dSpace = new Dimension(100, 5);
        Dimension dButton = new Dimension(60, 20);
        Dimension dAddConn = new Dimension(120, 20);
        this.advCheckBox = new JCheckBox("Advanced Parameters");
        this.advCheckBox.setFont(font11);
        AdvListener al = new AdvListener();
        this.advCheckBox.addActionListener(al);
        JPanel checkPanel = new JPanel();
        checkPanel.add(this.advCheckBox);
        SpinnerNumberModel burnInModel = new SpinnerNumberModel(1000, 1, 100000, 1);
        SpinnerNumberModel numIterModel = new SpinnerNumberModel(21000, 1, 100000, 1);
        this.burnInSpinner = new JSpinner(burnInModel);
        this.numIterSpinner = new JSpinner(numIterModel);
        this.burnInSpinner.setPreferredSize(dSpinner);
        this.numIterSpinner.setPreferredSize(dSpinner);
        this.burnInSpinner.setMaximumSize(dSpinner);
        this.numIterSpinner.setMaximumSize(dSpinner);
        this.burnInLabel = new JLabel("Burn In Period");
        this.numIterLabel = new JLabel("# Iterations");
        this.burnInLabel.setFont(font11);
        this.numIterLabel.setFont(font11);
        this.allOutBox = new JCheckBox();
        this.allOutLabel = new JLabel("log credible intervals");
        this.allOutLabel.setFont(font11);
        this.allOutBox.setSelected(true);
        String[] connStrings = this.getConnString();
        this.connCombo = new JComboBox<String>(connStrings);
        this.connCombo.setPreferredSize(dCombo);
        this.newConn = new JTextField(DEFAULT_ADD_TEXT);
        this.newConn.setPreferredSize(dAddConn);
        this.newConn.setFont(font11);
        this.addConnButton = new JButton("Add");
        this.addConnButton.addActionListener(al);
        this.addConnButton.setPreferredSize(dButton);
        this.addConnButton.setFont(font11);
        JPanel addPanel = new JPanel();
        addPanel.add(this.newConn);
        addPanel.add(this.addConnButton);
        JPanel comboPanel = new JPanel();
        BoxLayout box = new BoxLayout(comboPanel, 1);
        comboPanel.setLayout(box);
        comboPanel.add(Box.createRigidArea(dSpace));
        comboPanel.add(this.connCombo);
        comboPanel.add(Box.createRigidArea(dSpace));
        comboPanel.add(addPanel);
        Border greyLine = BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1);
        TitledBorder border = BorderFactory.createTitledBorder(greyLine, "Rserve Connection", 2, 2, font11);
        comboPanel.setBorder(border);
        this.burnInSpinner.setEnabled(false);
        this.numIterSpinner.setEnabled(false);
        this.allOutBox.setEnabled(false);
        this.burnInLabel.setForeground(Color.GRAY);
        this.numIterLabel.setForeground(Color.GRAY);
        this.allOutLabel.setForeground(Color.GRAY);
        JPanel paramPanel = new JPanel();
        SpringLayout sl = new SpringLayout();
        paramPanel.setLayout(sl);
        paramPanel.add(this.burnInLabel);
        paramPanel.add(this.burnInSpinner);
        paramPanel.add(this.numIterLabel);
        paramPanel.add(this.numIterSpinner);
        SpringUtilities.makeCompactGrid(paramPanel, 2, 2, 5, 5, 5, 5);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.add((Component)checkPanel, "North");
        leftPanel.add((Component)paramPanel, "Center");
        leftPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        JPanel labelPanel = new JPanel();
        Color color = labelPanel.getBackground();
        JTextArea area = new JTextArea();
        area.setBackground(color);
        area.setForeground(Color.BLUE);
        area.setEditable(false);
        area.setPreferredSize(dArea);
        area.setFont(font);
        area.setText("Now would be a good\ntime to start Rserve\n\nClick the info button\nfor help (lower left)");
        labelPanel.add(area);
        JPanel returnPanel = new JPanel();
        returnPanel.add(leftPanel);
        returnPanel.add(labelPanel);
        returnPanel.add(comboPanel);
        return returnPanel;
    }

    private JScrollPane createTwoColorPanel(String[] hybNames, int dataTypeP) {
        JLabel cy5Label;
        JLabel cy3Label;
        JLabel hybColLabel;
        JPanel listPanel = new JPanel();
        BoxLayout hybBox = new BoxLayout(listPanel, 1);
        listPanel.setLayout(hybBox);
        Dimension dLabel = new Dimension(330, 15);
        Dimension dCheck = new Dimension(50, 15);
        Dimension dRow = new Dimension(450, 25);
        Font font = new Font("Arial", 0, 11);
        JLabel spacer = new JLabel("");
        spacer.setMinimumSize(dCheck);
        spacer.setMaximumSize(dCheck);
        spacer.setPreferredSize(dCheck);
        if (dataTypeP == 2) {
            hybColLabel = new JLabel("For each chip, denote whether it is Treated or Control");
            cy3Label = new JLabel("Treated");
            cy5Label = new JLabel("Control");
        } else {
            hybColLabel = new JLabel("For each slide, mark Control Sample's dye color");
            cy3Label = new JLabel("Cy3");
            cy5Label = new JLabel("Cy5");
        }
        hybColLabel.setFont(font);
        hybColLabel.setForeground(Color.gray);
        hybColLabel.setMinimumSize(dLabel);
        hybColLabel.setMaximumSize(dLabel);
        hybColLabel.setPreferredSize(dLabel);
        cy3Label.setFont(font);
        cy3Label.setForeground(Color.gray);
        cy3Label.setMinimumSize(dCheck);
        cy3Label.setMaximumSize(dCheck);
        cy3Label.setPreferredSize(dCheck);
        cy5Label.setFont(font);
        cy5Label.setForeground(Color.gray);
        cy5Label.setMinimumSize(dCheck);
        cy5Label.setMaximumSize(dCheck);
        cy5Label.setPreferredSize(dCheck);
        JPanel titlePanel = new JPanel();
        titlePanel.add(hybColLabel);
        titlePanel.add(cy3Label);
        titlePanel.add(cy5Label);
        listPanel.add(titlePanel);
        int iHyb = hybNames.length;
        int iHalf = iHyb / 2;
        for (int h = 0; h < iHyb; ++h) {
            JLabel spaceLabel = new JLabel("");
            spaceLabel.setMinimumSize(dCheck);
            spaceLabel.setMaximumSize(dCheck);
            spaceLabel.setPreferredSize(dCheck);
            JLabel hybLabel = new JLabel(hybNames[h]);
            hybLabel.setMinimumSize(dLabel);
            hybLabel.setMaximumSize(dLabel);
            hybLabel.setPreferredSize(dLabel);
            JRadioButton cy3Button = new JRadioButton();
            JRadioButton cy5Button = new JRadioButton();
            cy3Button.setMinimumSize(dCheck);
            cy3Button.setMaximumSize(dCheck);
            cy3Button.setPreferredSize(dCheck);
            cy5Button.setMinimumSize(dCheck);
            cy5Button.setMaximumSize(dCheck);
            cy5Button.setPreferredSize(dCheck);
            ButtonGroup sampleGroup = new ButtonGroup();
            sampleGroup.add(cy3Button);
            sampleGroup.add(cy5Button);
            if (h < iHalf) {
                cy3Button.setSelected(false);
                cy5Button.setSelected(true);
            } else {
                cy3Button.setSelected(true);
                cy5Button.setSelected(false);
            }
            JPanel rowPanel = new JPanel();
            rowPanel.add(hybLabel);
            rowPanel.add(cy3Button);
            rowPanel.add(cy5Button);
            rowPanel.setMaximumSize(dRow);
            rowPanel.setMinimumSize(dRow);
            rowPanel.setPreferredSize(dRow);
            if (h % 2 == 0) {
                rowPanel.setBackground(Color.LIGHT_GRAY);
                cy3Button.setBackground(Color.LIGHT_GRAY);
                cy5Button.setBackground(Color.LIGHT_GRAY);
            }
            RHyb hyb = dataTypeP == 2 ? new RHyb(h, hybNames[h], cy3Button, 2) : new RHyb(h, hybNames[h], cy3Button, 0);
            this.ramaHybs[h] = hyb;
            this.vRamaHyb.add(hyb);
            listPanel.add(rowPanel);
        }
        JScrollPane comboScroll = new JScrollPane(listPanel);
        comboScroll.setPreferredSize(new Dimension(450, 280));
        comboScroll.setHorizontalScrollBarPolicy(30);
        comboScroll.setVerticalScrollBarPolicy(20);
        listPanel.add(Box.createVerticalGlue());
        listPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        return comboScroll;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public void error(String message) {
        JOptionPane.showMessageDialog((Component)((Object)this), message, "Input Error", 0);
    }

    private void onAdvancedClicked() {
        if (this.advCheckBox.isSelected()) {
            this.burnInSpinner.setEnabled(true);
            this.numIterSpinner.setEnabled(true);
            this.allOutBox.setEnabled(true);
            this.burnInLabel.setForeground(Color.BLACK);
            this.numIterLabel.setForeground(Color.BLACK);
            this.allOutLabel.setForeground(Color.BLACK);
        } else {
            this.burnInSpinner.setEnabled(false);
            this.numIterSpinner.setEnabled(false);
            this.allOutBox.setEnabled(false);
            this.burnInLabel.setForeground(Color.LIGHT_GRAY);
            this.numIterLabel.setForeground(Color.LIGHT_GRAY);
            this.allOutLabel.setForeground(Color.LIGHT_GRAY);
        }
    }

    private boolean verifyHybs() {
        RHybSet rhs = this.getRamaHybSet();
        if (this.dataType == 0) {
            if (rhs.isFlip()) {
                return this.atLeastTwo(rhs);
            }
            return true;
        }
        return this.isBalanced(rhs);
    }

    private boolean atLeastTwo(RHybSet rhs) {
        Vector vRamaHyb = rhs.getVRHyb();
        int iOne = 0;
        int iTwo = 0;
        for (int r = 0; r < vRamaHyb.size(); ++r) {
            RHyb hyb = (RHyb)vRamaHyb.elementAt(r);
            if (hyb.controlCy3()) {
                ++iOne;
                continue;
            }
            ++iTwo;
        }
        if (iOne > 1 && iTwo > 1) {
            return true;
        }
        this.error("For dye-swap experiments, there must be at least 2 hybs of each color state");
        return false;
    }

    private boolean isBalanced(RHybSet rhs) {
        Vector vRamaHyb = rhs.getVRHyb();
        int iTreated = 0;
        int iControl = 0;
        for (int r = 0; r < vRamaHyb.size(); ++r) {
            RHyb hyb = (RHyb)vRamaHyb.elementAt(r);
            if (hyb.oneIsTreated()) {
                ++iTreated;
                continue;
            }
            ++iControl;
        }
        if (iTreated == iControl) {
            return true;
        }
        this.error("For affy data, you must have the same # of Treated and Control Chips");
        return false;
    }

    private String[] getConnString() {
        String rPath = TMEV.getRPath();
        StringTokenizer st = new StringTokenizer(rPath, ";");
        int tokenKount = st.countTokens();
        String[] toReturn = new String[tokenKount];
        for (int i = 0; i < tokenKount; ++i) {
            String token;
            toReturn[i] = token = st.nextToken();
        }
        return toReturn;
    }

    public boolean getAllOut() {
        return this.allOutBox.isSelected();
    }

    public int getBurnIn() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.burnInSpinner.getModel();
        return model.getNumber().intValue();
    }

    public int getNumIter() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.numIterSpinner.getModel();
        return model.getNumber().intValue();
    }

    public RHybSet getRamaHybSet() {
        return new RHybSet(this.vRamaHyb);
    }

    public String getSelectedConnString() {
        return (String)this.connCombo.getSelectedItem();
    }

    public String getRPathToWrite() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.connCombo.getItemCount(); ++i) {
            String s = (String)this.connCombo.getItemAt(i);
            if (i > 0) {
                sb.append(";");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public boolean connAdded() {
        return this.connAdded;
    }

    public static void main(String[] args) {
        System.out.println("RamaInitDialog invoked by main");
        String[] names = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight"};
        RamaInitDialog uid = new RamaInitDialog(new Frame(), names, 2);
        uid.showModal();
    }

    private class Listener
    extends DialogListener
    implements ItemListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                if (RamaInitDialog.this.verifyHybs()) {
                    RamaInitDialog.this.result = 0;
                    RamaInitDialog.this.dispose();
                }
            } else if (command.equals("cancel-command")) {
                RamaInitDialog.this.result = 2;
                RamaInitDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    RamaInitDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser((Window)((Object)RamaInitDialog.this), (String)"RAMA Initialization Dialog");
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            RamaInitDialog.this.result = -1;
            RamaInitDialog.this.dispose();
        }
    }

    private class AdvListener
    implements ActionListener {
        private AdvListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s;
            Object source = e.getSource();
            if (source == RamaInitDialog.this.advCheckBox) {
                RamaInitDialog.this.onAdvancedClicked();
            }
            if (source == RamaInitDialog.this.addConnButton && !(s = RamaInitDialog.this.newConn.getText().trim()).equals(DEFAULT_ADD_TEXT) && !s.equals("")) {
                int itemKount = RamaInitDialog.this.connCombo.getItemCount();
                boolean alreadyThere = false;
                for (int i = 0; i < itemKount; ++i) {
                    String item = (String)RamaInitDialog.this.connCombo.getItemAt(i);
                    if (!s.equals(item)) continue;
                    alreadyThere = true;
                    break;
                }
                if (!alreadyThere) {
                    RamaInitDialog.this.connAdded = true;
                    RamaInitDialog.this.connCombo.insertItemAt(s, 0);
                    RamaInitDialog.this.connCombo.setSelectedIndex(0);
                }
            }
        }
    }
}

