/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.r;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.Manager;
import org.tigr.microarray.mev.MultipleArrayMenubar;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.r.RDataFormatter;
import org.tigr.microarray.mev.r.RHyb;
import org.tigr.microarray.mev.r.RHybSet;
import org.tigr.microarray.mev.r.RProgress;
import org.tigr.microarray.mev.r.RSwingWorker;
import org.tigr.microarray.mev.r.RamaInitDialog;
import org.tigr.microarray.mev.r.RamaResult;
import org.tigr.microarray.mev.r.RamaSummaryViewer;
import org.tigr.microarray.mev.r.RamaTextFileFilter;
import org.tigr.microarray.mev.r.Rconnection;
import org.tigr.microarray.mev.r.RconnectionManager;

public class Rama {
    public static String COMMA = ",";
    public static String END_LINE = "\r\n";
    public static String TAB = "\t";
    public static String R_VECTOR_NAME = "ramaData";
    private MultipleArrayViewer mav;
    private MultipleArrayMenubar menuBar;
    private IData data;
    private RamaInitDialog initDialog;
    private int B;
    private int minIter;
    private int iGene;
    private RconnectionManager rcMan;
    private Rconnection rc;

    public Rama(MultipleArrayViewer mavP, MultipleArrayMenubar menuBarP) {
        this.mav = mavP;
        this.menuBar = menuBarP;
        this.data = this.mav.getData();
        if (this.data.getFeaturesCount() < 2) {
            this.error("The loaded dataset doesn't appear to be \"Ramalizable\"\r\nYou must have at least 2 replicates of each sample");
        } else if (this.data.getDataType() == 1) {
            this.error("Rama does not work on Ratio data.\nIt only works with Intensity data.");
        } else if (this.data.getDataType() == 4) {
            this.error("Rama does not work on Ratio data.\nIt only works with Intensity data.");
        } else if (this.data.getDataType() == 5) {
            this.error("Rama does not work on Ratio data.\nIt only works with Intensity data.");
        } else if (this.data.getDataType() == 3) {
            this.error("Rama does not work on Ratio data.\nIt only works with Intensity data.");
        } else if (this.data.getDataType() == 2) {
            this.ramify(this.data, true);
        } else {
            this.ramify(this.data, false);
        }
    }

    private void ramify(IData data, boolean isAffy) {
        String[] hybNames = this.gatherHybNames(data);
        this.initDialog = isAffy ? new RamaInitDialog(this.mav.getFrame(), hybNames, 2) : new RamaInitDialog(this.mav.getFrame(), hybNames, 0);
        if (this.initDialog.showModal() == 0) {
            int iTwo;
            int iColorKount;
            int iHybKount;
            int nbCol1;
            String sData;
            this.B = this.initDialog.getNumIter();
            this.minIter = this.initDialog.getBurnIn();
            boolean allOut = this.initDialog.getAllOut();
            String sConnPort = this.initDialog.getSelectedConnString();
            String sConn = this.parseSPort(sConnPort);
            int iPort = this.parseIPort(sConnPort);
            RDataFormatter rDataFormatter = new RDataFormatter(data);
            RHybSet rhs = this.initDialog.getRamaHybSet();
            if (isAffy) {
                sData = rDataFormatter.rNonSwapString(R_VECTOR_NAME, rhs.getVRHyb());
                this.iGene = data.getExperiment().getNumberOfGenes();
                nbCol1 = 0;
                iHybKount = rhs.getVRHyb().size();
                iColorKount = iHybKount * 2;
                iTwo = iHybKount + 1;
            } else if (rhs.isFlip()) {
                Vector vTreatCy3 = this.getVRamaHybTreatCy3(rhs.getVRHyb());
                Vector vTreatCy5 = this.getVRamaHybTreatCy5(rhs.getVRHyb());
                sData = rDataFormatter.rSwapString(R_VECTOR_NAME, vTreatCy3, vTreatCy5);
                this.iGene = data.getExperiment().getNumberOfGenes();
                nbCol1 = vTreatCy3.size();
                iHybKount = vTreatCy3.size() + vTreatCy5.size();
                iColorKount = iHybKount * 2;
                iTwo = iHybKount + 1;
            } else {
                sData = rDataFormatter.rNonSwapString(R_VECTOR_NAME, rhs.getVRHyb());
                this.iGene = data.getExperiment().getNumberOfGenes();
                nbCol1 = 0;
                iHybKount = rhs.getVRHyb().size();
                iColorKount = iHybKount * 2;
                iTwo = iHybKount + 1;
            }
            String message = "As a reference, 4 arrays (640 genes) takes about half an hour";
            RProgress progress = new RProgress(this.mav.getFrame(), message);
            this.rcMan = new RconnectionManager(this.mav.getFrame(), sConn, iPort);
            this.rc = this.rcMan.getConnection();
            if (this.rc != null) {
                String sClear = "rm( " + R_VECTOR_NAME + " )";
                String sLibrary = "library(rama)";
                String sReform = "dim(" + R_VECTOR_NAME + ") <- c(" + this.iGene + "," + iColorKount + ")";
                String sMcmc = rhs.isFlip() ? this.createMcMc(allOut, this.iGene, iHybKount, iTwo, iColorKount, this.B, this.minIter, nbCol1, true) : this.createMcMc(allOut, this.iGene, iHybKount, iTwo, iColorKount, this.B, this.minIter, nbCol1, false);
                String sAvgGamma1 = "gamma1<-mat.mean(mcmc." + R_VECTOR_NAME + "$gamma1)[,1]";
                String sAvgGamma2 = "gamma2<-mat.mean(mcmc." + R_VECTOR_NAME + "$gamma2)[,1]";
                String sQLo = "mcmc." + R_VECTOR_NAME + "$q.low";
                String sQUp = "mcmc." + R_VECTOR_NAME + "$q.up";
                String sShift = "mcmc." + R_VECTOR_NAME + "$shift";
                RSwingWorker rThread = new RSwingWorker(this.rc, sClear, sLibrary, sData, sReform, sMcmc, allOut, sAvgGamma1, sAvgGamma2, sQLo, sQUp, sShift, progress, this);
                rThread.start();
            } else {
                progress.kill();
                this.error("MeV could not establish a connection with Rserve");
                System.out.println("MeV could not establish a connection with Rserve");
            }
        }
    }

    public void fireThreadFinished(RSwingWorker worker, RamaResult result) {
        if (worker.isOk()) {
            String[] geneNames = new String[this.iGene];
            for (int g = 0; g < this.iGene; ++g) {
                geneNames[g] = this.data.getGeneName(g);
            }
            for (int i = 0; i < geneNames.length; ++i) {
                if (geneNames[i].equalsIgnoreCase("")) continue;
                result.setGenes(geneNames);
            }
            result.setB(this.B);
            result.setMinIter(this.minIter);
            result.saveRamaResult(this.mav.getFrame());
            if (this.initDialog.connAdded()) {
                TMEV.updateRPath(this.initDialog.getRPathToWrite());
            }
            MultipleArrayViewer newMav = this.spawnNewMav(this.data, result.getGamma1(), result.getGamma2(), result.getGenes(), result.getShift());
            RamaSummaryViewer sumViewer = new RamaSummaryViewer(result);
            LeafInfo li = new LeafInfo("Rama Summary", (IViewer)sumViewer);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode("Rama");
            node.add(new DefaultMutableTreeNode(li));
            newMav.addAnalysisResult(node);
        }
    }

    private String createMcMc(boolean allOut, int iGene, int iHybKount, int iTwo, int iColorKount, int B, int minIter, int nbCol1, boolean isDyeSwap) {
        StringBuffer sb = new StringBuffer();
        sb.append("mcmc." + R_VECTOR_NAME + " <- fit.model( " + R_VECTOR_NAME + "[ 1:");
        sb.append(iGene);
        sb.append(" , c( 1:");
        sb.append(iHybKount);
        sb.append(" )], " + R_VECTOR_NAME + "[ 1:");
        sb.append(iGene);
        sb.append(", c( ");
        sb.append(iTwo);
        sb.append(":");
        sb.append(iColorKount);
        sb.append(" )], B = ");
        sb.append(B);
        sb.append(", min.iter = ");
        sb.append(minIter);
        sb.append(", batch = 1, shift = NULL, mcmc.obj = NULL, dye.swap = ");
        if (isDyeSwap) {
            sb.append("TRUE");
            sb.append(", nb.col1 = ");
            sb.append(nbCol1);
        } else {
            sb.append("FALSE");
        }
        if (allOut) {
            sb.append(", all.out = TRUE");
        } else {
            sb.append(", all.out = TRUE");
        }
        sb.append(")");
        return sb.toString();
    }

    private String[] gatherHybNames(IData data) {
        String[] hybNames = new String[data.getFeaturesCount()];
        for (int h = 0; h < hybNames.length; ++h) {
            hybNames[h] = data.getFullSampleName(h);
        }
        return hybNames;
    }

    private JProgressBar createProgress() {
        JProgressBar bar = new JProgressBar();
        bar.setString("");
        bar.setIndeterminate(true);
        bar.repaint();
        JPanel barPanel = new JPanel();
        barPanel.add(bar);
        barPanel.setSize(200, 100);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        JFrame frame = new JFrame("Talking to R");
        frame.setSize(300, 200);
        frame.setDefaultCloseOperation(3);
        frame.setLocation((screenSize.width - frame.getSize().width) / 2, (screenSize.height - frame.getSize().height) / 2);
        frame.setContentPane(barPanel);
        frame.setVisible(true);
        return bar;
    }

    private MultipleArrayViewer spawnNewMav(IData data, double[] gamma1, double[] gamma2, String[] genes, double shift) {
        String[] currentFieldNames = data.getFieldNames();
        Manager.createNewMultipleArrayViewer(20, 20);
        double[] norm1 = this.unLogify(gamma1, 2);
        double[] norm2 = this.unLogify(gamma2, 2);
        ISlideData[] features = new ISlideData[1];
        SlideData slideData = new SlideData(gamma1.length, 1);
        slideData.setFieldNames(currentFieldNames);
        for (int i = 0; i < norm1.length; ++i) {
            int[] rows = new int[3];
            int[] cols = new int[3];
            float[] intensities = new float[2];
            rows[0] = i + 1;
            rows[1] = 1;
            rows[2] = 0;
            cols[0] = 1;
            cols[1] = 1;
            cols[2] = 0;
            intensities[0] = (float)norm1[i];
            intensities[1] = (float)norm2[i];
            String[] extraFields = new String[currentFieldNames.length];
            SlideDataElement loadedSDE = (SlideDataElement)data.getSlideDataElement(0, i);
            ISlideDataElement sde = loadedSDE.clone();
            slideData.add(sde);
        }
        features[0] = slideData;
        features[0].setSlideFileName("Rama Intensities");
        features[0].setSlideDataName("Rama Intensities");
        MultipleArrayViewer newMav = (MultipleArrayViewer)Manager.getLastComponent();
        newMav.fireDataLoaded(features, null, 0);
        this.mav.getFrame().dispose();
        return newMav;
    }

    private int parseIPort(String connPort) {
        if (connPort == null) {
            return 6311;
        }
        int iColon = connPort.indexOf(":");
        if (iColon == -1) {
            return 6311;
        }
        int toReturn = Integer.parseInt(connPort.substring(iColon + 1));
        return toReturn;
    }

    private String parseSPort(String connPort) {
        if (connPort == null) {
            return "127.0.0.1";
        }
        int iColon = connPort.indexOf(":");
        if (iColon == -1) {
            return "127.0.0.1";
        }
        return connPort.substring(0, iColon);
    }

    private Vector getVRamaHybTreatCy3(Vector ramaHybs) {
        Vector<RHyb> vReturn = new Vector<RHyb>();
        for (int h = 0; h < ramaHybs.size(); ++h) {
            RHyb hyb = (RHyb)ramaHybs.elementAt(h);
            if (hyb.controlCy3()) continue;
            vReturn.add(hyb);
        }
        return vReturn;
    }

    private Vector getVRamaHybTreatCy5(Vector ramaHybs) {
        Vector<RHyb> vReturn = new Vector<RHyb>();
        for (int h = 0; h < ramaHybs.size(); ++h) {
            RHyb hyb = (RHyb)ramaHybs.elementAt(h);
            if (!hyb.controlCy3()) continue;
            vReturn.add(hyb);
        }
        return vReturn;
    }

    private double[] unLogify(double[] log, int base) {
        double[] toReturn = new double[log.length];
        for (int i = 0; i < log.length; ++i) {
            double y;
            double d = log[i];
            toReturn[i] = y = Math.pow(2.0, d);
        }
        return toReturn;
    }

    private void onSave(double[] gamma1, double[] gamma2, double[] qLo, double[] qUp, boolean allOut, String[] genes) {
        String currentPath = TMEV.getDataPath();
        RamaTextFileFilter textFilter = new RamaTextFileFilter();
        JFileChooser chooser = new JFileChooser(currentPath);
        chooser.addChoosableFileFilter(textFilter);
        if (chooser.showSaveDialog(this.mav.getFrame()) == 0) {
            File saveFile;
            if (chooser.getFileFilter() == textFilter) {
                String path = chooser.getSelectedFile().getPath();
                if (path.toLowerCase().endsWith("txt")) {
                    saveFile = new File(path);
                } else {
                    int period = path.lastIndexOf(".txt");
                    String subPath = period != -1 ? path.substring(0, period) : path;
                    String newPath = subPath + ".txt";
                    saveFile = new File(newPath);
                }
            } else {
                saveFile = chooser.getSelectedFile();
            }
            StringBuffer sb = new StringBuffer();
            sb.append("GeneName");
            sb.append(TAB);
            sb.append("IntensityA");
            sb.append(TAB);
            sb.append("IntensityB");
            if (allOut) {
                sb.append(TAB);
                sb.append("qLow");
                sb.append(TAB);
                sb.append("qUp");
            }
            sb.append(END_LINE);
            for (int i = 0; i < genes.length; ++i) {
                sb.append(genes[i]);
                sb.append(TAB);
                sb.append(gamma1[i]);
                sb.append(TAB);
                sb.append(gamma2[i]);
                if (allOut) {
                    sb.append(TAB);
                    sb.append(qLo[i]);
                    sb.append(TAB);
                    sb.append(qUp[i]);
                }
                sb.append(END_LINE);
            }
            this.writeFile(saveFile, sb.toString());
        }
    }

    private void writeFile(File f, String s) {
        try {
            FileWriter fw = new FileWriter(f);
            fw.write(s);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private float[][] transpose(float[][] m) {
        float[][] toReturn = new float[m[0].length][m.length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                toReturn[j][i] = m[i][j];
            }
        }
        return toReturn;
    }

    static double[][] castFloatToDoubleArray(float[][] floatMatrix) {
        double[][] toReturn = new double[floatMatrix.length][floatMatrix[0].length];
        for (int i = 0; i < floatMatrix.length; ++i) {
            for (int j = 0; j < floatMatrix[i].length; ++j) {
                toReturn[i][j] = floatMatrix[i][j];
            }
        }
        return toReturn;
    }

    public void error(String message) {
        JOptionPane.showMessageDialog(this.mav.getFrame(), message, "Input Error", 0);
    }
}

