/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.r;

import java.util.GregorianCalendar;
import org.tigr.microarray.mev.r.RProgress;
import org.tigr.microarray.mev.r.RSrvException;
import org.tigr.microarray.mev.r.Rama;
import org.tigr.microarray.mev.r.RamaResult;
import org.tigr.microarray.mev.r.Rconnection;
import org.tigr.microarray.mev.r.SwingWorker;

public class RSwingWorker
extends SwingWorker {
    private Rconnection rc;
    private RamaResult ramaResult;
    private String sClear;
    private String sLibrary;
    private String sData;
    private String sReform;
    private String sMcmc;
    private String sAvgGamma1;
    private String sAvgGamma2;
    private String sQLo;
    private String sQUp;
    private String sShift;
    private boolean allOut;
    private boolean ok;
    private boolean done;
    private RProgress progress;
    private Rama rama;

    public RSwingWorker(Rconnection rcP, String sClearP, String sLibraryP, String sDataP, String sReformP, String sMcmcP, boolean allOutP, String sAvgGamma1P, String sAvgGamma2P, String sQLoP, String sQUpP, String sShiftP, RProgress progressP, Rama ramaP) {
        this.rc = rcP;
        this.sClear = sClearP;
        this.sLibrary = sLibraryP;
        this.sData = sDataP;
        this.sReform = sReformP;
        this.sMcmc = sMcmcP;
        this.sQLo = sQLoP;
        this.sQUp = sQUpP;
        this.sShift = sShiftP;
        this.allOut = allOutP;
        this.sAvgGamma1 = sAvgGamma1P;
        this.sAvgGamma2 = sAvgGamma2P;
        this.progress = progressP;
        this.rama = ramaP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object construct() {
        this.done = false;
        GregorianCalendar startCal = new GregorianCalendar();
        int startHour = startCal.get(11);
        int startMin = startCal.get(12);
        String startTime = startHour + ":" + startMin;
        try {
            this.rc.voidEval(this.sClear);
            this.rc.voidEval(this.sLibrary);
            this.rc.voidEval(this.sData);
            this.rc.voidEval(this.sReform);
            this.rc.voidEval(this.sMcmc);
            double shift = this.rc.eval(this.sShift).asDouble();
            GregorianCalendar endCal = new GregorianCalendar();
            int endHour = endCal.get(11);
            int endMin = endCal.get(12);
            String endTime = endHour + ":" + endMin;
            if (this.allOut) {
                this.rc.voidEval(this.sAvgGamma1);
                this.rc.voidEval(this.sAvgGamma2);
                double[] gamma1 = this.rc.eval("gamma1").asDoubleArray();
                double[] gamma2 = this.rc.eval("gamma2").asDoubleArray();
                double[] qLo = this.rc.eval(this.sQLo).asDoubleArray();
                double[] qUp = this.rc.eval(this.sQUp).asDoubleArray();
                this.ramaResult = new RamaResult(gamma1, gamma2, qLo, qUp, shift, startTime, endTime);
            } else {
                double[] gamma1 = this.rc.eval("gamma1").asDoubleArray();
                double[] gamma2 = this.rc.eval("gamma2").asDoubleArray();
                this.ramaResult = new RamaResult(gamma1, gamma2, shift, startTime, endTime);
            }
            this.ok = true;
            this.done = true;
        }
        catch (RSrvException e) {
            e.printStackTrace();
            this.rama.error(e.getMessage());
            this.ok = false;
            this.done = false;
        }
        finally {
            this.progress.kill();
        }
        return null;
    }

    @Override
    public void finished() {
        this.rama.fireThreadFinished(this, this.ramaResult);
    }

    public boolean isOk() {
        return this.ok;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isAllOut() {
        return this.allOut;
    }
}

