/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.r;

import java.util.Vector;
import org.tigr.microarray.mev.r.REXP;

public class RList {
    public REXP head;
    public REXP body;
    public REXP tag;
    Vector h;
    Vector b;

    public RList() {
        this.tag = null;
        this.body = null;
        this.head = null;
    }

    public RList(REXP h, REXP b) {
        this.head = h;
        this.body = b;
        this.tag = null;
    }

    public REXP getHead() {
        return this.head;
    }

    public REXP getBody() {
        return this.body;
    }

    public REXP getTag() {
        return this.tag;
    }

    boolean updateVec() {
        if (this.head == null || this.body == null || this.head.Xt != 16 || this.body.Xt != 16) {
            return false;
        }
        this.h = (Vector)this.head.cont;
        this.b = (Vector)this.body.cont;
        return this.h.size() == this.b.size();
    }

    public REXP at(String v) {
        if (!this.updateVec()) {
            return null;
        }
        for (int i = 0; i < this.h.size(); ++i) {
            REXP r = (REXP)this.h.elementAt(i);
            if (r == null || r.Xt != 3 || ((String)r.cont).compareTo(v) != 0) continue;
            return (REXP)this.b.elementAt(i);
        }
        return null;
    }

    public REXP at(int i) {
        if (!this.updateVec()) {
            return null;
        }
        return i >= 0 && i < this.b.size() ? (REXP)this.b.elementAt(i) : null;
    }

    public String[] keys() {
        if (!this.updateVec()) {
            return null;
        }
        String[] k = new String[this.h.size()];
        for (int i = 0; i < this.h.size(); ++i) {
            REXP r = (REXP)this.h.elementAt(i);
            k[i] = r == null || r.Xt != 3 ? null : (String)r.cont;
        }
        return k;
    }
}

