/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.r;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.file.FileTreePane;
import org.tigr.microarray.mev.file.FileTreePaneEvent;
import org.tigr.microarray.mev.file.FileTreePaneListener;
import org.tigr.microarray.mev.file.GBA;

public class GenericFileDialog
extends AlgorithmDialog {
    private GBA gba;
    private int result;
    private FileTreePane fileTreePane;
    private JPanel fileSelectionPanel;
    private JPanel fileListPanel;
    private JLabel fileAvailableLabel;
    private JLabel fileSelectedLabel;
    private JList fileAvailableList;
    private JList fileSelectedList;
    private JScrollPane fileAvailableScrollPane;
    private JScrollPane fileSelectedScrollPane;
    private JButton fileAddButton;
    private JButton fileRemoveButton;
    private JPanel fileButtonPanel;
    private JPanel selectionPanel;
    private JSplitPane splitPane;

    public GenericFileDialog(Frame parent, String title) {
        super(new JFrame(), title, true);
        this.setResizable(true);
        this.setSize(1000, 750);
        this.gba = new GBA();
        this.getContentPane().setLayout(new GridLayout());
        String dataPath = "/" + TMEV.getDataPath();
        this.fileTreePane = new FileTreePane(dataPath);
        this.fileTreePane.addFileTreePaneListener(new FileTreePaneEventHandler());
        this.fileTreePane.setPreferredSize(new Dimension(250, 50));
        this.fileSelectionPanel = new JPanel();
        this.fileSelectionPanel.setLayout(new GridBagLayout());
        this.fileSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "Training Data Sets"));
        this.fileAvailableLabel = new JLabel("Available files");
        this.fileSelectedLabel = new JLabel("Selected file");
        this.fileAvailableList = new JList(new DefaultListModel());
        this.fileAvailableList.setCellRenderer(new ListRenderer());
        this.fileSelectedList = new JList(new DefaultListModel());
        this.fileSelectedList.setCellRenderer(new ListRenderer());
        this.fileAvailableScrollPane = new JScrollPane(this.fileAvailableList);
        this.fileSelectedScrollPane = new JScrollPane(this.fileSelectedList);
        this.fileAddButton = new JButton("Add");
        this.fileAddButton.addActionListener(new EventHandler());
        this.fileRemoveButton = new JButton("Remove");
        this.fileRemoveButton.addActionListener(new EventHandler());
        Dimension largestfileButtonSize = this.fileRemoveButton.getPreferredSize();
        this.fileAddButton.setPreferredSize(largestfileButtonSize);
        this.fileRemoveButton.setPreferredSize(largestfileButtonSize);
        this.fileButtonPanel = new JPanel();
        this.fileButtonPanel.setLayout(new GridBagLayout());
        this.gba.add(this.fileButtonPanel, this.fileAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.fileButtonPanel, this.fileRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.fileListPanel = new JPanel();
        this.fileListPanel.setLayout(new GridBagLayout());
        this.gba.add(this.fileListPanel, this.fileAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.fileListPanel, this.fileSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.fileListPanel, this.fileAvailableScrollPane, 0, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.fileListPanel, this.fileButtonPanel, 1, 1, 1, 4, 0, 1, 3, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.fileListPanel, this.fileSelectedScrollPane, 2, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.fileSelectionPanel, this.fileListPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.fileAddButton.setFocusPainted(false);
        this.fileRemoveButton.setFocusPainted(false);
        this.selectionPanel = new JPanel();
        this.selectionPanel.setLayout(new GridBagLayout());
        this.gba.add(this.selectionPanel, this.fileSelectionPanel, 0, 1, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.splitPane = new JSplitPane(1, this.fileTreePane, this.selectionPanel);
        Listener listener = new Listener();
        super.addWindowListener((WindowListener)((Object)listener));
        super.setActionListeners((ActionListener)((Object)listener));
        this.addContent(this.splitPane);
        this.fileTreePane.openDataPath();
    }

    public File getSelectedFile() {
        DefaultListModel selModel = (DefaultListModel)this.fileSelectedList.getModel();
        Object[] selFiles = selModel.toArray();
        File f = (File)selFiles[0];
        return f;
    }

    public boolean fileSelected() {
        DefaultListModel selModel = (DefaultListModel)this.fileSelectedList.getModel();
        Object[] selFiles = selModel.toArray();
        boolean toReturn = selFiles.length == 1;
        return toReturn;
    }

    public Vector getSelectedFiles() {
        Vector<File> toReturn = new Vector<File>();
        DefaultListModel selModel = (DefaultListModel)this.fileSelectedList.getModel();
        Object[] selFiles = selModel.toArray();
        for (int i = 0; i < selFiles.length; ++i) {
            File f = (File)selFiles[i];
            toReturn.add(f);
        }
        return toReturn;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public void processFileList(String filePath, Vector vFileName) {
        DefaultListModel model = (DefaultListModel)this.fileAvailableList.getModel();
        model.clear();
        if (vFileName.size() > 0) {
            for (int i = 0; i < vFileName.size(); ++i) {
                String sFileName = (String)vFileName.elementAt(i);
                if (!this.acceptFile(sFileName)) continue;
                File f = new File(sFileName);
                model.addElement(f);
            }
        }
    }

    public void addFile(File fAdd) {
        DefaultListModel selModel = (DefaultListModel)this.fileSelectedList.getModel();
        Object[] selFiles = selModel.toArray();
        if (selFiles.length == 0) {
            selModel.addElement(fAdd);
        }
    }

    public void onAdd() {
        int[] chosenIndices = this.fileAvailableList.getSelectedIndices();
        DefaultListModel availModel = (DefaultListModel)this.fileAvailableList.getModel();
        for (int i = 0; i < chosenIndices.length; ++i) {
            File addFile = (File)availModel.getElementAt(chosenIndices[i]);
            this.addFile(addFile);
        }
    }

    public void onAddAll() {
        DefaultListModel availModel = (DefaultListModel)this.fileAvailableList.getModel();
        int kount = availModel.size();
        for (int i = 0; i < kount; ++i) {
            File addFile = (File)availModel.getElementAt(i);
            this.addFile(addFile);
        }
    }

    public void onRemove() {
        int[] chosenIndices = this.fileSelectedList.getSelectedIndices();
        DefaultListModel selModel = (DefaultListModel)this.fileSelectedList.getModel();
        for (int i = chosenIndices.length - 1; i >= 0; --i) {
            selModel.remove(chosenIndices[i]);
        }
    }

    public void onRemoveAll() {
        DefaultListModel selModel = (DefaultListModel)this.fileSelectedList.getModel();
        selModel.removeAllElements();
    }

    public boolean acceptFile(String fileName) {
        return fileName.toLowerCase().endsWith(".txt");
    }

    public static void main(String[] args) {
        GenericFileDialog fd = new GenericFileDialog(new Frame(), "TestTitle");
        fd.showModal();
    }

    private class Listener
    extends DialogListener
    implements ItemListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                if (GenericFileDialog.this.fileSelected()) {
                    GenericFileDialog.this.result = 0;
                    GenericFileDialog.this.dispose();
                } else {
                    System.out.println("No File Selected");
                }
            } else if (command.equals("cancel-command")) {
                GenericFileDialog.this.result = 2;
                GenericFileDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    GenericFileDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser((Window)((Object)GenericFileDialog.this), (String)"GenericFileDialog");
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            System.out.println("windowClosing()");
            GenericFileDialog.this.result = -1;
            GenericFileDialog.this.dispose();
        }
    }

    private class EventHandler
    implements ActionListener {
        private EventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == GenericFileDialog.this.fileAddButton) {
                GenericFileDialog.this.onAdd();
            } else if (source == GenericFileDialog.this.fileRemoveButton) {
                GenericFileDialog.this.onRemove();
            }
        }
    }

    private class ListRenderer
    extends DefaultListCellRenderer {
        private ListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            this.setText(file.getName());
            return this;
        }
    }

    private class FileTreePaneEventHandler
    implements FileTreePaneListener {
        private FileTreePaneEventHandler() {
        }

        @Override
        public void nodeSelected(FileTreePaneEvent event) {
            String filePath = (String)event.getValue("Path");
            Vector fileNames = (Vector)event.getValue("Filenames");
            GenericFileDialog.this.processFileList(filePath, fileNames);
        }

        @Override
        public void nodeCollapsed(FileTreePaneEvent event) {
        }

        @Override
        public void nodeExpanded(FileTreePaneEvent event) {
        }
    }
}

