/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.r;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.usc.Reader;

public class ClassAssigner {
    private boolean requireAllLabelsAssigned = true;
    private int minNumAssignsPerLabel = 3;
    private String[] rowNames;
    private String[] comboNames;
    private Vector vComboBox;
    private String borderTitle;
    private String message;
    private JPanel mainPanel;
    private JScrollPane jsp;
    public static String TEST_CLASS_STRING = "Unknown (Test)";

    public ClassAssigner(String[] rowNamesP, String[] comboNamesP) {
        this.rowNames = rowNamesP;
        this.comboNames = comboNamesP;
        this.createAssigner();
    }

    public ClassAssigner(String[] rowNamesP, String[] comboNamesP, String borderTitleP, String messageP) {
        this.rowNames = rowNamesP;
        this.comboNames = comboNamesP;
        this.borderTitle = borderTitleP;
        this.message = messageP;
        this.createAssigner();
    }

    public ClassAssigner(String[] rowNamesP, String[] comboNamesP, boolean requireAllLabelsAssignedP) {
        this.rowNames = rowNamesP;
        this.comboNames = comboNamesP;
        this.requireAllLabelsAssigned = requireAllLabelsAssignedP;
        this.createAssigner();
    }

    public ClassAssigner(String[] rowNamesP, String[] comboNamesP, boolean requireAllLabelsAssignedP, int minNumAssignsPerLabelP) {
        this.rowNames = rowNamesP;
        this.comboNames = comboNamesP;
        this.requireAllLabelsAssigned = requireAllLabelsAssignedP;
        this.minNumAssignsPerLabel = minNumAssignsPerLabelP;
        this.createAssigner();
    }

    public ClassAssigner(String[] rowNamesP, String[] comboNamesP, String borderTitleP, String messageP, boolean requireAllLabelsAssignedP, int minNumAssignsPerLabelP) {
        this.rowNames = rowNamesP;
        this.comboNames = comboNamesP;
        this.borderTitle = borderTitleP;
        this.message = messageP;
        this.requireAllLabelsAssigned = requireAllLabelsAssignedP;
        this.minNumAssignsPerLabel = minNumAssignsPerLabelP;
        this.createAssigner();
    }

    private void createAssigner() {
        this.mainPanel = new JPanel();
        this.vComboBox = new Vector();
        int rowKount = this.rowNames.length;
        int colKount = this.comboNames.length;
        Dimension dRowNameLabel = new Dimension(250, 24);
        Dimension dCombo = new Dimension(150, 24);
        Dimension dGap = new Dimension(5, 24);
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        if (this.message != null) {
            JLabel label = new JLabel(this.message);
            c.insets = new Insets(25, 25, 25, 25);
            c.gridy = 0;
            this.mainPanel.add((Component)label, c);
        }
        c.insets = new Insets(0, 0, 0, 4);
        for (int r = 0; r < rowKount; ++r) {
            JLabel rowLabel = new JLabel(this.rowNames[r]);
            rowLabel.setPreferredSize(dRowNameLabel);
            rowLabel.setHorizontalAlignment(4);
            JComboBox<String> rowCombo = new JComboBox<String>(this.comboNames);
            rowCombo.setPreferredSize(dCombo);
            JPanel rowPanel = new JPanel();
            rowPanel.setLayout(new BoxLayout(rowPanel, 0));
            rowPanel.add(rowLabel);
            rowPanel.add(Box.createRigidArea(dGap));
            rowPanel.add(rowCombo);
            if (r % 2 == 0) {
                rowPanel.setBackground(Color.LIGHT_GRAY);
            }
            c.gridy = r + 1;
            this.mainPanel.add((Component)rowPanel, c);
            this.vComboBox.add(rowCombo);
        }
        if (this.borderTitle != null) {
            Border greyLine = BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1);
            Font font11 = new Font("Arial", 0, 11);
            TitledBorder border = BorderFactory.createTitledBorder(greyLine, this.borderTitle, 4, 2, font11);
            this.mainPanel.setBorder(border);
        }
        this.jsp = new JScrollPane(this.mainPanel);
        this.jsp.setPreferredSize(new Dimension(450, 350));
    }

    public boolean verifyLabeling() {
        boolean toReturn = true;
        if (this.requireAllLabelsAssigned) {
            for (int i = 0; i < this.comboNames.length; ++i) {
                if (this.comboNames[i].equalsIgnoreCase(TEST_CLASS_STRING)) continue;
                int occurKount = 0;
                for (int j = 0; j < this.vComboBox.size(); ++j) {
                    JComboBox box = (JComboBox)this.vComboBox.elementAt(j);
                    int iSelected = box.getSelectedIndex();
                    if (iSelected != i) continue;
                    ++occurKount;
                }
                if (occurKount >= this.minNumAssignsPerLabel) continue;
                String sErr = "Class " + this.comboNames[i] + " has been assigned " + occurKount + " times.\r\nIt must be assigned at least " + this.minNumAssignsPerLabel + " times";
                this.error(sErr);
                toReturn = false;
                break;
            }
        } else {
            toReturn = true;
        }
        return toReturn;
    }

    public void onSaveAssignments() {
        int numGroups = this.comboNames.length;
        JFileChooser fileChooser = new JFileChooser(TMEV.getSettingForOption("current-data-path", "./data"));
        if (fileChooser.showSaveDialog(null) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(file));
                Date currDate = new Date(System.currentTimeMillis());
                String dateString = currDate.toString();
                String userName = System.getProperty("user.name");
                pw.println("# Assignment File");
                pw.println("# User: " + userName + " Save Date: " + dateString);
                pw.println("#");
                pw.print("Module:\t");
                pw.println("USC");
                for (int i = 0; i < numGroups - 1; ++i) {
                    pw.print("Group " + (i + 1) + " Label:\t");
                    pw.println(this.comboNames[i]);
                }
                pw.println("#");
                pw.println("Sample Index\tSample Name\tGroup Assignment");
                for (int sample = 0; sample < this.vComboBox.size(); ++sample) {
                    JComboBox box = (JComboBox)this.vComboBox.elementAt(sample);
                    pw.print(String.valueOf(sample + 1) + "\t");
                    pw.print(this.rowNames[sample] + "\t");
                    try {
                        pw.println(this.comboNames[box.getSelectedIndex()]);
                        continue;
                    }
                    catch (Exception e) {
                        pw.println("Exclude");
                    }
                }
                pw.flush();
                pw.close();
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void onLoadAssignments() {
        JFileChooser fileChooser = new JFileChooser(TMEV.getSettingForOption("current-data-path", "./data"));
        if (fileChooser.showOpenDialog(null) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                Object[] optionst;
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                Vector<String> data = new Vector<String>();
                while ((line = br.readLine()) != null) {
                    data.add(line.trim());
                }
                br.close();
                Vector<String> groupNames = new Vector<String>();
                Vector<Integer> sampleIndices = new Vector<Integer>();
                Vector<String> sampleNames = new Vector<String>();
                Vector<String> groupAssignments = new Vector<String>();
                for (int row = 0; row < data.size(); ++row) {
                    line = (String)data.get(row);
                    if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                    String[] lineArray = line.split("\t");
                    if (lineArray[0].startsWith("Module:")) {
                        if (lineArray[1].equals("USC")) continue;
                        optionst = new Object[]{"Continue", "Cancel"};
                        if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                        return;
                    }
                    if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                        groupNames.add(lineArray[1]);
                        continue;
                    }
                    try {
                        Integer.parseInt(lineArray[0]);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                    sampleIndices.add(new Integer(lineArray[0]));
                    sampleNames.add(lineArray[1]);
                    groupAssignments.add(lineArray[2]);
                }
                if (this.rowNames.length != sampleNames.size()) {
                    System.out.println(this.rowNames.length + "  " + sampleNames.size());
                    System.out.println(this.rowNames.length + " s length " + sampleNames.size());
                    JOptionPane.showMessageDialog(null, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + this.rowNames.length + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                    return;
                }
                for (int i = 0; i < groupNames.size(); ++i) {
                    int j;
                    if (((String)groupNames.get(i)).equals(this.comboNames[i])) continue;
                    optionst = new Object[]{"Use Current Labels", "Use Saved Labels"};
                    if (JOptionPane.showOptionDialog(null, "The saved file was saved using different group labels. \n Which labels should MeV use?", "Unmatched label warning", 1, 3, null, optionst, optionst[0]) == 0) break;
                    if (!((String)groupNames.get(groupNames.size() - 1)).equals(TEST_CLASS_STRING)) {
                        groupNames.add(TEST_CLASS_STRING);
                    }
                    this.comboNames = new String[groupNames.size()];
                    for (j = 0; j < this.comboNames.length; ++j) {
                        this.comboNames[j] = groupNames.get(j);
                    }
                    for (j = 0; j < this.vComboBox.size(); ++j) {
                        JComboBox box = (JComboBox)this.vComboBox.get(j);
                        box.removeAllItems();
                        for (int k = 0; k < groupNames.size(); ++k) {
                            box.addItem(groupNames.get(k));
                        }
                    }
                    this.mainPanel.updateUI();
                    break;
                }
                Vector<String> currSampleVector = new Vector<String>();
                for (int i = 0; i < this.rowNames.length; ++i) {
                    currSampleVector.add(this.rowNames[i]);
                }
                int fileSampleIndex = 0;
                int groupIndex = 0;
                for (int sample = 0; sample < this.rowNames.length; ++sample) {
                    boolean doIndex = false;
                    for (int i = 0; i < this.rowNames.length; ++i) {
                        if (i == sample || !this.rowNames[i].equals(this.rowNames[sample])) continue;
                        doIndex = true;
                    }
                    fileSampleIndex = sampleNames.indexOf(this.rowNames[sample]);
                    if (fileSampleIndex == -1) {
                        doIndex = true;
                    }
                    if (doIndex) {
                        this.setStateBasedOnIndex(groupAssignments, groupNames);
                        break;
                    }
                    String groupName = (String)groupAssignments.get(fileSampleIndex);
                    groupIndex = groupNames.indexOf(groupName);
                    try {
                        JComboBox box = (JComboBox)this.vComboBox.elementAt(sample);
                        box.setSelectedIndex(groupIndex);
                        if (groupIndex != -1) continue;
                        box.setSelectedIndex(box.getItemCount() - 1);
                        continue;
                    }
                    catch (Exception e) {
                        JComboBox box = (JComboBox)this.vComboBox.elementAt(sample);
                        box.setSelectedIndex(box.getItemCount() - 1);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
            }
        }
    }

    private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
        Object[] optionst = new Object[]{"Continue", "Cancel"};
        if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
            return;
        }
        for (int sample = 0; sample < this.rowNames.length; ++sample) {
            try {
                JComboBox box = (JComboBox)this.vComboBox.elementAt(sample);
                box.setSelectedIndex(groupNames.indexOf(groupAssignments.get(sample)));
                continue;
            }
            catch (Exception e) {
                JComboBox box = (JComboBox)this.vComboBox.elementAt(sample);
                box.setSelectedIndex(groupNames.size() - 1);
            }
        }
    }

    private void readClassFile(File fLoaded) throws Exception {
        Reader r = new Reader();
        r.readFile(fLoaded);
        Vector vLine = r.getVNullLine("MOTHRA");
        if (vLine.size() == this.rowNames.length) {
            for (int l = 0; l < vLine.size(); ++l) {
                String line = (String)vLine.elementAt(l);
                if (line.equals(TEST_CLASS_STRING)) {
                    this.setClassAsTest(l);
                    continue;
                }
                int i = Integer.parseInt(line);
                this.setSelectedClass(l, i);
            }
        } else {
            throw new Exception("Your Assignments File and loaded data don't appear to match");
        }
    }

    public void setSelectedClass(int iHyb, int iSelectedIndex) {
        JComboBox box = (JComboBox)this.vComboBox.elementAt(iHyb);
        box.setSelectedIndex(iSelectedIndex);
        this.mainPanel.repaint();
    }

    public void setClassAsTest(int iHyb) {
        JComboBox box = (JComboBox)this.vComboBox.elementAt(iHyb);
        int iTest = this.comboNames.length - 1;
        box.setSelectedIndex(iTest);
        this.mainPanel.repaint();
    }

    public void setRequireAllLabelsAssigned(boolean b) {
        this.requireAllLabelsAssigned = b;
    }

    public boolean getRequireAllLabelsAssigned() {
        return this.requireAllLabelsAssigned;
    }

    public void setMinAssignsPerLabel(int i) {
        this.minNumAssignsPerLabel = i;
    }

    public int getMinNumAssignsPerLabel() {
        return this.minNumAssignsPerLabel;
    }

    public Vector getVComboBox() {
        return this.vComboBox;
    }

    public int getSelectedIndex(int rowIndex) {
        int toReturn = -1;
        JComboBox box = (JComboBox)this.vComboBox.elementAt(rowIndex);
        toReturn = box.getSelectedIndex();
        return toReturn;
    }

    public String getSelectedString(int rowIndex) {
        String toReturn = null;
        JComboBox box = (JComboBox)this.vComboBox.elementAt(rowIndex);
        toReturn = (String)box.getSelectedItem();
        return toReturn;
    }

    public boolean hasTest() {
        boolean toReturn = false;
        for (int i = 0; i < this.vComboBox.size(); ++i) {
            JComboBox box = (JComboBox)this.vComboBox.elementAt(i);
            String selectedString = (String)box.getSelectedItem();
            if (!selectedString.equals(TEST_CLASS_STRING)) continue;
            toReturn = true;
            break;
        }
        return toReturn;
    }

    public JScrollPane getScrollPane() {
        return this.jsp;
    }

    public void error(String message) {
        JOptionPane.showMessageDialog(new JFrame(), message, "Input Error", 0);
    }

    public static void main(String[] args) {
        String[] rows = new String[25];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = "Slide:" + Integer.toString(i);
        }
        String[] combos = new String[]{"Test", "Tumor", "Normal"};
        JFrame jf = new JFrame();
        jf.setSize(400, 600);
        ClassAssigner ca = new ClassAssigner(rows, combos);
        System.out.println(ca.getSelectedString(0));
        jf.setContentPane(ca.getScrollPane());
        jf.show();
    }
}

