/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.persistence;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.tigr.microarray.mev.MultipleArrayViewer;

public class StateSavingProgressPanel
extends JFrame
implements ActionListener {
    public JProgressBar progressBar;
    private JButton cancelButton;
    private MultipleArrayViewer mav;
    JPanel progressPanel;

    public StateSavingProgressPanel(String initialMessage, MultipleArrayViewer mav) {
        this.setTitle(initialMessage);
        this.mav = mav;
        this.progressPanel = new JPanel(new BorderLayout());
        this.progressPanel.setPreferredSize(new Dimension(350, 120));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(310, 30));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setPreferredSize(new Dimension(50, 30));
        this.cancelButton.setFocusPainted(false);
        this.progressPanel.add((Component)this.progressBar, "First");
        this.progressPanel.add((Component)this.cancelButton, "Center");
        this.progressPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.setContentPane(this.progressPanel);
        this.progressPanel.setOpaque(true);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setVisible(true);
    }

    public void update(String message) {
        this.progressBar.setString(message);
        this.progressBar.setValue(this.progressBar.getMinimum());
    }

    public void increment() {
        this.progressBar.setValue(this.progressBar.getValue() + 1);
    }

    public void setMaximum(int i) {
        this.progressBar.setMaximum(i);
    }

    public int getMaximum() {
        return this.progressBar.getMaximum();
    }

    public void setValue(int i) {
        this.progressBar.setValue(i);
    }

    public void setIndeterminate(boolean b) {
        this.progressBar.setIndeterminate(b);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals("cancel")) {
            this.mav.cancelLoadState();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.progressBar.setIndeterminate(true);
            this.progressBar.setString("Cleaning Up...");
        }
    }

    @Override
    public void dispose() {
        this.mav.cancelLoadState();
        super.dispose();
    }

    public void onClose() {
        this.mav.cancelLoadState();
    }

    public MultipleArrayViewer getMav() {
        return this.mav;
    }
}

